/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.BaseKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.DimensionsKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.metadata.expressions.LiteralKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.RecordTypeKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.AndComponent;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComparison;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComponent;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.QueryKeyExpressionWithComparison;
import com.apple.foundationdb.record.query.expressions.RecordTypeKeyComparison;
import com.apple.foundationdb.record.query.plan.planning.FilterSatisfiedMask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class QueryToKeyMatcher {
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryToKeyMatcher.class);
    @Nonnull
    private static final List<Class<? extends KeyExpression>> KNOWN_KEY_EXPRESSIONS = ImmutableList.of(FieldKeyExpression.class, ThenKeyExpression.class, NestingKeyExpression.class, GroupingKeyExpression.class, KeyWithValueExpression.class, FunctionKeyExpression.class, LiteralKeyExpression.class, EmptyKeyExpression.class, RecordTypeKeyExpression.class, DimensionsKeyExpression.class);
    @Nonnull
    private final QueryComponent rootQuery;

    public QueryToKeyMatcher(@Nonnull QueryComponent rootQuery) {
        this.rootQuery = rootQuery;
    }

    @Nonnull
    public Match matchesCoveringKey(@Nonnull KeyExpression expression) {
        return this.matchesCoveringKey(expression, null);
    }

    @Nonnull
    public Match matchesCoveringKey(@Nonnull KeyExpression expression, @Nullable FilterSatisfiedMask filterMask) {
        return this.matches(this.rootQuery, expression, MatchingMode.COVER_KEY, filterMask);
    }

    @Nonnull
    public Match matchesSatisfyingQuery(@Nonnull KeyExpression expression) {
        return this.matchesSatisfyingQuery(expression, null);
    }

    @Nonnull
    public Match matchesSatisfyingQuery(@Nonnull KeyExpression expression, @Nullable FilterSatisfiedMask filterMask) {
        return this.matches(this.rootQuery, expression, MatchingMode.SATISFY_QUERY, filterMask);
    }

    @Nonnull
    private Match matches(@Nonnull QueryComponent query, @Nonnull KeyExpression key, @Nonnull MatchingMode matchingMode, @Nullable FilterSatisfiedMask filterMask) {
        if (key instanceof GroupingKeyExpression) {
            KeyExpression group = this.extractGroupingKey((GroupingKeyExpression)key, matchingMode);
            return group == null ? Match.none() : this.matches(query, group, matchingMode, filterMask);
        }
        if (key instanceof DimensionsKeyExpression) {
            KeyExpression group = this.extractPrefixKey((DimensionsKeyExpression)key, matchingMode);
            return group == null ? Match.none() : this.matches(query, group, matchingMode, filterMask);
        }
        if (key instanceof KeyWithValueExpression) {
            KeyExpression onlyKey = this.extractKeyFromKeyWithValue((KeyWithValueExpression)key, matchingMode);
            return onlyKey == null ? Match.none() : this.matches(query, onlyKey, matchingMode, filterMask);
        }
        if (query instanceof NestedField) {
            return this.matches((NestedField)query, key, matchingMode, filterMask);
        }
        if (query instanceof FieldWithComparison) {
            return this.matches((FieldWithComparison)query, key, matchingMode, filterMask);
        }
        if (query instanceof OneOfThemWithComparison) {
            return this.matches((OneOfThemWithComparison)query, key, matchingMode, filterMask);
        }
        if (query instanceof OneOfThemWithComponent) {
            return this.matches((OneOfThemWithComponent)query, key, matchingMode, filterMask);
        }
        if (query instanceof AndComponent) {
            return this.matches((AndComponent)query, key, matchingMode, filterMask);
        }
        if (query instanceof RecordTypeKeyComparison) {
            return this.matches((RecordTypeKeyComparison)query, key, matchingMode, filterMask);
        }
        if (query instanceof QueryKeyExpressionWithComparison) {
            return this.matches((QueryKeyExpressionWithComparison)query, key, filterMask);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(KeyValueLogMessage.of("unable to match query filter type", new Object[]{LogMessageKeys.KEY_EXPRESSION, key, LogMessageKeys.FILTER, query}));
        }
        return Match.none();
    }

    @Nonnull
    private Match matches(@Nonnull AndComponent query, @Nonnull KeyExpression key, @Nonnull MatchingMode matchingMode, @Nullable FilterSatisfiedMask filterMask) {
        Iterator<KeyExpression> keyChildIterator;
        List listOfQueries = query.getChildren();
        int keyChildSize = key.getColumnSize();
        if (key instanceof ThenKeyExpression) {
            List<KeyExpression> children = ((ThenKeyExpression)key).getChildren();
            keyChildIterator = children.iterator();
        } else {
            keyChildIterator = Iterators.singletonIterator(key);
        }
        FilterSatisfiedMask localMask = FilterSatisfiedMask.of(query);
        localMask.setExpression(key);
        ArrayList<Comparisons.Comparison> comparisons = new ArrayList<Comparisons.Comparison>(keyChildSize);
        while (keyChildIterator.hasNext()) {
            KeyExpression exp = keyChildIterator.next();
            boolean found = false;
            boolean foundInequality = false;
            Iterator<FilterSatisfiedMask> childMaskIterator = localMask.getChildren().iterator();
            for (QueryComponent querySegment : listOfQueries) {
                Match match = this.matches(querySegment, exp, matchingMode, childMaskIterator.next());
                if (match.getType() == MatchType.NO_MATCH) continue;
                found = true;
                comparisons.addAll(match.getComparisons());
                if (match.getType() != MatchType.INEQUALITY) break;
                foundInequality = true;
                break;
            }
            if (!found) {
                return Match.none();
            }
            if (!localMask.allSatisfied() && !foundInequality) continue;
            break;
        }
        if (matchingMode.equals((Object)MatchingMode.SATISFY_QUERY) && !localMask.allSatisfied() || matchingMode.equals((Object)MatchingMode.COVER_KEY) && comparisons.size() < keyChildSize) {
            return Match.none();
        }
        if (filterMask != null) {
            filterMask.mergeWith(localMask);
        }
        return new Match(comparisons);
    }

    @Nonnull
    private Match matches(@Nonnull NestedField query, @Nonnull KeyExpression key, @Nonnull MatchingMode matchingMode, @Nullable FilterSatisfiedMask filterMask) {
        if (key instanceof NestingKeyExpression) {
            return this.matches(query, (NestingKeyExpression)key, matchingMode, filterMask);
        }
        if (key instanceof ThenKeyExpression) {
            List<KeyExpression> children = ((ThenKeyExpression)key).getChildren();
            if (children.isEmpty() || matchingMode.equals((Object)MatchingMode.COVER_KEY)) {
                return Match.none();
            }
            return this.matches(query, children.get(0), matchingMode, filterMask);
        }
        return this.noMatchOrUnexpected(key);
    }

    @Nonnull
    private Match matches(@Nonnull FieldWithComparison query, @Nonnull KeyExpression key, @Nonnull MatchingMode matchingMode, @Nullable FilterSatisfiedMask filterMask) {
        if (key instanceof ThenKeyExpression) {
            List<KeyExpression> children = ((ThenKeyExpression)key).getChildren();
            if (children.isEmpty() || matchingMode.equals((Object)MatchingMode.COVER_KEY)) {
                return Match.none();
            }
            return this.matches(query, children.get(0), matchingMode, filterMask);
        }
        if (key instanceof FieldKeyExpression) {
            return this.matches(query, (FieldKeyExpression)key, filterMask);
        }
        return this.noMatchOrUnexpected(key);
    }

    @Nonnull
    private Match matches(@Nonnull OneOfThemWithComparison query, @Nonnull KeyExpression key, @Nonnull MatchingMode matchingMode, @Nullable FilterSatisfiedMask filterMask) {
        if (key instanceof ThenKeyExpression) {
            List<KeyExpression> children = ((ThenKeyExpression)key).getChildren();
            if (children.isEmpty() || matchingMode.equals((Object)MatchingMode.COVER_KEY)) {
                return Match.none();
            }
            return this.matches(query, children.get(0), matchingMode, filterMask);
        }
        if (key instanceof FieldKeyExpression) {
            return this.matches(query, (FieldKeyExpression)key, filterMask);
        }
        return this.noMatchOrUnexpected(key);
    }

    @Nonnull
    private Match matches(@Nonnull OneOfThemWithComponent query, @Nonnull KeyExpression key, @Nonnull MatchingMode matchingMode, @Nullable FilterSatisfiedMask filterMask) {
        if (key instanceof NestingKeyExpression) {
            return this.matches(query, (NestingKeyExpression)key, matchingMode, filterMask);
        }
        return this.noMatchOrUnexpected(key);
    }

    @Nonnull
    private Match matches(@Nonnull NestedField query, @Nonnull NestingKeyExpression key, @Nonnull MatchingMode matchingMode, @Nullable FilterSatisfiedMask filterMask) {
        if (key.getParent().getFanType() != KeyExpression.FanType.None) {
            return Match.none();
        }
        if (Objects.equals(query.getFieldName(), key.getParent().getFieldName())) {
            FilterSatisfiedMask childMask = filterMask != null ? filterMask.getChild(query.getChild()) : null;
            Match childMatch = this.matches(query.getChild(), key.getChild(), matchingMode, childMask);
            if (childMask != null && childMask.isSatisfied() && filterMask.getExpression() == null) {
                filterMask.setExpression(key);
            }
            return childMatch;
        }
        return Match.none();
    }

    @Nonnull
    private Match matches(@Nonnull OneOfThemWithComponent query, @Nonnull NestingKeyExpression key, @Nonnull MatchingMode matchingMode, @Nullable FilterSatisfiedMask filterMask) {
        if (key.getParent().getFanType() != KeyExpression.FanType.FanOut) {
            return Match.none();
        }
        if (Objects.equals(query.getFieldName(), key.getParent().getFieldName())) {
            FilterSatisfiedMask childMask = filterMask != null ? filterMask.getChild(query.getChild()) : null;
            Match childMatch = this.matches(query.getChild(), key.getChild(), matchingMode, childMask);
            if (childMask != null && childMask.isSatisfied() && filterMask.getExpression() == null) {
                filterMask.setExpression(key);
            }
            return childMatch;
        }
        return Match.none();
    }

    @Nonnull
    private Match matches(@Nonnull FieldWithComparison query, @Nonnull FieldKeyExpression key, @Nullable FilterSatisfiedMask filterMask) {
        if (!Objects.equals(query.getFieldName(), key.getFieldName())) {
            return Match.none();
        }
        if (key.getFanType() != KeyExpression.FanType.None) {
            return Match.none();
        }
        if (filterMask != null) {
            filterMask.setSatisfied(true);
            filterMask.setExpression(key);
        }
        return new Match(query.getComparison());
    }

    @Nonnull
    private Match matches(@Nonnull OneOfThemWithComparison query, @Nonnull FieldKeyExpression key, @Nullable FilterSatisfiedMask filterMask) {
        if (!Objects.equals(query.getFieldName(), key.getFieldName())) {
            return Match.none();
        }
        if (key.getFanType() != KeyExpression.FanType.FanOut) {
            return Match.none();
        }
        if (filterMask != null) {
            filterMask.setSatisfied(true);
            filterMask.setExpression(key);
        }
        return new Match(query.getComparison());
    }

    @Nonnull
    private Match matches(@Nonnull RecordTypeKeyComparison query, @Nonnull KeyExpression key, @Nonnull MatchingMode matchingMode, @Nullable FilterSatisfiedMask filterMask) {
        if (!(key instanceof RecordTypeKeyExpression || matchingMode.equals((Object)MatchingMode.SATISFY_QUERY) && key instanceof ThenKeyExpression && ((ThenKeyExpression)key).getChildren().get(0) instanceof RecordTypeKeyExpression)) {
            return this.noMatchOrUnexpected(key);
        }
        if (filterMask != null) {
            filterMask.setSatisfied(true);
            filterMask.setExpression(key);
        }
        return new Match(query.getComparison());
    }

    @Nonnull
    private Match matches(@Nonnull QueryKeyExpressionWithComparison query, @Nonnull KeyExpression key, @Nullable FilterSatisfiedMask filterMask) {
        if (!Objects.equals(query.getKeyExpression(), key)) {
            return Match.none();
        }
        if (filterMask != null) {
            filterMask.setSatisfied(true);
            filterMask.setExpression(key);
        }
        return new Match(query.getComparison());
    }

    @Nonnull
    private Match noMatchOrUnexpected(@Nonnull KeyExpression key) {
        if (KNOWN_KEY_EXPRESSIONS.stream().anyMatch(expressionClass -> expressionClass.isInstance(key))) {
            return Match.none();
        }
        return this.unexpected(key);
    }

    @Nonnull
    private Match unexpected(@Nonnull KeyExpression key) {
        throw new KeyExpression.InvalidExpressionException("Unexpected Key Expression type " + String.valueOf(key.getClass()));
    }

    private KeyExpression extractGroupingKey(GroupingKeyExpression grouping, MatchingMode matchingMode) {
        try {
            return grouping.getGroupingSubKey();
        }
        catch (BaseKeyExpression.UnsplittableKeyExpressionException err) {
            if (matchingMode == MatchingMode.SATISFY_QUERY) {
                return this.extractPrefixUntilSplittable(grouping.getWholeKey(), grouping.getGroupingCount());
            }
            return null;
        }
    }

    private KeyExpression extractPrefixKey(DimensionsKeyExpression dimensionsKeyExpression, MatchingMode matchingMode) {
        try {
            return dimensionsKeyExpression.getPrefixSubKey();
        }
        catch (BaseKeyExpression.UnsplittableKeyExpressionException err) {
            if (matchingMode == MatchingMode.SATISFY_QUERY) {
                return this.extractPrefixUntilSplittable(dimensionsKeyExpression.getWholeKey(), dimensionsKeyExpression.getPrefixSize());
            }
            return null;
        }
    }

    @Nullable
    private KeyExpression extractKeyFromKeyWithValue(KeyWithValueExpression keyWithValue, MatchingMode matchingMode) {
        try {
            return keyWithValue.getKeyExpression();
        }
        catch (BaseKeyExpression.UnsplittableKeyExpressionException err) {
            if (matchingMode == MatchingMode.SATISFY_QUERY) {
                return this.extractPrefixUntilSplittable(keyWithValue.getInnerKey(), keyWithValue.getSplitPoint());
            }
            return null;
        }
    }

    @Nonnull
    private KeyExpression extractPrefixUntilSplittable(KeyExpression wholeKeyExpression, int originalSplitPoint) {
        for (int adjustedSplitPoint = originalSplitPoint - 1; adjustedSplitPoint >= 0; --adjustedSplitPoint) {
            try {
                return wholeKeyExpression.getSubKey(0, adjustedSplitPoint);
            }
            catch (BaseKeyExpression.UnsplittableKeyExpressionException innerErr) {
                continue;
            }
        }
        throw new RecordCoreException("unable to extract splittable prefix from key expression", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.KEY_EXPRESSION, wholeKeyExpression}).addLogInfo(new Object[]{LogMessageKeys.COLUMN_SIZE, originalSplitPoint});
    }

    public static class Match {
        @Nonnull
        private final List<Comparisons.Comparison> comparisons;
        @Nonnull
        private final MatchType type;

        private Match(@Nonnull MatchType type) {
            this.comparisons = Collections.emptyList();
            this.type = type;
        }

        public Match(@Nonnull List<Comparisons.Comparison> inComparisons) {
            this.comparisons = new ArrayList<Comparisons.Comparison>();
            this.comparisons.addAll(inComparisons);
            this.type = inComparisons.get(inComparisons.size() - 1).getType().isEquality() ? MatchType.EQUALITY : MatchType.INEQUALITY;
        }

        public Match(@Nonnull Comparisons.Comparison comparison) {
            this.comparisons = Collections.singletonList(comparison);
            this.type = comparison.getType().isEquality() ? MatchType.EQUALITY : MatchType.INEQUALITY;
        }

        @Nonnull
        private static Match none() {
            return new Match(MatchType.NO_MATCH);
        }

        @Nonnull
        public Key.Evaluated getEquality() {
            return this.getEquality(null, null);
        }

        @Nonnull
        public Key.Evaluated getEquality(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            ArrayList<Object> evaluated = new ArrayList<Object>();
            for (Comparisons.Comparison comparison : this.comparisons) {
                if (comparison.getType().isEquality()) {
                    evaluated.add(comparison.getComparand(store, context));
                    continue;
                }
                throw new RecordCoreException("Match is not equal, has comparison of type " + String.valueOf((Object)comparison.getType()), new Object[0]);
            }
            return Key.Evaluated.concatenate(evaluated);
        }

        @Nonnull
        public List<Comparisons.Comparison> getEqualityComparisons() {
            if (this.comparisons.isEmpty() || this.comparisons.get(this.comparisons.size() - 1).getType().isEquality()) {
                return this.comparisons;
            }
            return this.comparisons.subList(0, this.comparisons.size() - 1);
        }

        @Nonnull
        public List<Comparisons.Comparison> getComparisons() {
            return this.comparisons;
        }

        @Nonnull
        public Comparisons.Comparison getFirstComparison() {
            return this.comparisons.get(0);
        }

        @Nonnull
        public MatchType getType() {
            return this.type;
        }
    }

    private static enum MatchingMode {
        SATISFY_QUERY,
        COVER_KEY;

    }

    public static enum MatchType {
        EQUALITY,
        INEQUALITY,
        NO_MATCH;

    }
}

