/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.query.BoundRecordQuery;
import com.apple.foundationdb.record.query.IndexQueryabilityFilter;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.google.protobuf.Descriptors;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordQuery {
    public static final Collection<String> ALL_TYPES = Collections.emptyList();
    @Nonnull
    private final Collection<String> recordTypes;
    @Nullable
    private final Collection<String> allowedIndexes;
    @Nonnull
    private final IndexQueryabilityFilter queryabilityFilter;
    @Nullable
    private final QueryComponent filter;
    @Nullable
    private final KeyExpression sort;
    private final boolean sortReverse;
    private final boolean removeDuplicates;
    @Nullable
    private final List<KeyExpression> requiredResults;

    private RecordQuery(@Nonnull Collection<String> recordTypes, @Nullable Collection<String> allowedIndexes, @Nonnull IndexQueryabilityFilter queryabilityFilter, @Nullable QueryComponent filter, @Nullable KeyExpression sort, boolean sortReverse, boolean removeDuplicates, @Nullable List<KeyExpression> requiredResults) {
        this.recordTypes = recordTypes;
        this.allowedIndexes = allowedIndexes;
        this.queryabilityFilter = queryabilityFilter;
        this.filter = filter;
        this.sort = sort;
        this.sortReverse = sortReverse;
        this.removeDuplicates = removeDuplicates;
        this.requiredResults = requiredResults;
    }

    @Nonnull
    public Collection<String> getRecordTypes() {
        return this.recordTypes;
    }

    public boolean hasAllowedIndexes() {
        return this.allowedIndexes != null;
    }

    @Nullable
    public Collection<String> getAllowedIndexes() {
        return this.allowedIndexes;
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public IndexQueryabilityFilter getIndexQueryabilityFilter() {
        return this.queryabilityFilter;
    }

    @Nullable
    public QueryComponent getFilter() {
        return this.filter;
    }

    @Nullable
    public KeyExpression getSort() {
        return this.sort;
    }

    public boolean isSortReverse() {
        return this.sortReverse;
    }

    public boolean removesDuplicates() {
        return this.removeDuplicates;
    }

    @Nullable
    public List<KeyExpression> getRequiredResults() {
        return this.requiredResults;
    }

    public void validate(@Nonnull RecordMetaData metaData) {
        for (String recordTypeName : this.recordTypes) {
            RecordType recordType = metaData.getQueryableRecordType(recordTypeName);
            Descriptors.Descriptor descriptor = recordType.getDescriptor();
            if (this.filter != null) {
                this.filter.validate(descriptor);
            }
            if (this.sort != null) {
                this.sort.validate(descriptor);
            }
            if (this.requiredResults == null) continue;
            for (KeyExpression result : this.requiredResults) {
                result.validate(descriptor);
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.recordTypes);
        if (this.filter != null) {
            str.append(" | ").append(this.filter);
        }
        return str.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordQuery)) {
            return false;
        }
        RecordQuery that = (RecordQuery)o;
        return this.isSortReverse() == that.isSortReverse() && this.removeDuplicates == that.removeDuplicates && this.getRecordTypes().equals(that.getRecordTypes()) && Objects.equals(this.getAllowedIndexes(), that.getAllowedIndexes()) && this.queryabilityFilter.equals(that.queryabilityFilter) && Objects.equals(this.getFilter(), that.getFilter()) && Objects.equals(this.getSort(), that.getSort()) && Objects.equals(this.getRequiredResults(), that.getRequiredResults());
    }

    public int hashCode() {
        return Objects.hash(this.getRecordTypes(), this.getAllowedIndexes(), this.queryabilityFilter, this.getFilter(), this.getSort(), this.isSortReverse(), this.removeDuplicates, this.getRequiredResults());
    }

    public BoundRecordQuery bind(@Nonnull FDBRecordStore store, @Nonnull Bindings preBoundParameters) {
        return new BoundRecordQuery(store.getRecordStoreState(), this, preBoundParameters);
    }

    public BoundRecordQuery bind(@Nonnull FDBRecordStore store) {
        return new BoundRecordQuery(store.getRecordStoreState(), this);
    }

    public static class Builder {
        @Nonnull
        private Collection<String> recordTypes = ALL_TYPES;
        @Nullable
        private Collection<String> allowedIndexes = null;
        @Nonnull
        private IndexQueryabilityFilter queryabilityFilter = IndexQueryabilityFilter.DEFAULT;
        @Nullable
        private QueryComponent filter = null;
        @Nullable
        private KeyExpression sort = null;
        private boolean sortReverse;
        private boolean removeDuplicates = true;
        @Nullable
        private List<KeyExpression> requiredResults = null;

        protected Builder() {
        }

        protected Builder(RecordQuery query) {
            this.recordTypes = query.recordTypes;
            this.allowedIndexes = query.allowedIndexes;
            this.queryabilityFilter = query.queryabilityFilter;
            this.filter = query.filter;
            this.sort = query.sort;
            this.sortReverse = query.sortReverse;
            this.removeDuplicates = query.removeDuplicates;
            this.requiredResults = query.requiredResults;
        }

        public RecordQuery build() {
            return new RecordQuery(this.recordTypes, this.allowedIndexes, this.queryabilityFilter, this.filter, this.sort, this.sortReverse, this.removeDuplicates, this.requiredResults);
        }

        public BoundRecordQuery buildAndBind(@Nonnull FDBRecordStore store, @Nonnull Bindings preBoundParameters) {
            return new RecordQuery(this.recordTypes, this.allowedIndexes, this.queryabilityFilter, this.filter, this.sort, this.sortReverse, this.removeDuplicates, this.requiredResults).bind(store, preBoundParameters);
        }

        public BoundRecordQuery buildAndBind(@Nonnull FDBRecordStore store) {
            return new RecordQuery(this.recordTypes, this.allowedIndexes, this.queryabilityFilter, this.filter, this.sort, this.sortReverse, this.removeDuplicates, this.requiredResults).bind(store);
        }

        @Nonnull
        public Collection<String> getRecordTypes() {
            return this.recordTypes;
        }

        public Builder setRecordTypes(@Nonnull Collection<String> recordTypes) {
            this.recordTypes = recordTypes;
            return this;
        }

        public Builder setRecordType(@Nonnull String recordType) {
            return this.setRecordTypes(Collections.singleton(recordType));
        }

        @Nullable
        public Collection<String> getAllowedIndexes() {
            return this.allowedIndexes;
        }

        public Builder setAllowedIndexes(@Nullable Collection<String> allowedIndexes) {
            this.allowedIndexes = allowedIndexes;
            return this;
        }

        public Builder setAllowedIndex(@Nullable String allowedIndex) {
            return this.setAllowedIndexes(Collections.singleton(allowedIndex));
        }

        public Builder setIndexQueryabilityFilter(@Nonnull IndexQueryabilityFilter queryabilityFilter) {
            this.queryabilityFilter = queryabilityFilter;
            return this;
        }

        @Nullable
        public QueryComponent getFilter() {
            return this.filter;
        }

        public Builder setFilter(@Nullable QueryComponent filter) {
            this.filter = filter;
            return this;
        }

        @Nullable
        public KeyExpression getSort() {
            return this.sort;
        }

        public boolean isSortReverse() {
            return this.sortReverse;
        }

        public Builder setSort(@Nullable KeyExpression sort, boolean sortReverse) {
            this.sort = sort;
            this.sortReverse = sortReverse;
            return this;
        }

        public Builder setSort(@Nullable KeyExpression sort) {
            return this.setSort(sort, false);
        }

        public Builder setRemoveDuplicates(boolean removeDuplicates) {
            this.removeDuplicates = removeDuplicates;
            return this;
        }

        @Nullable
        public List<KeyExpression> getRequiredResults() {
            return this.requiredResults;
        }

        public Builder setRequiredResults(@Nullable List<KeyExpression> requiredResults) {
            this.requiredResults = requiredResults;
            return this;
        }
    }
}

