/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.combinatorics;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterator;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ChooseK {
    private ChooseK() {
    }

    public static <T> EnumeratingIterable<T> chooseK(@Nonnull Collection<? extends T> elements, int numberOfElementsToChoose) {
        Preconditions.checkArgument(numberOfElementsToChoose >= 0 && numberOfElementsToChoose <= elements.size());
        EnumeratingIterable<? extends T> maybeSimpleIterable = ChooseK.trySimpleIterable(elements, numberOfElementsToChoose);
        if (maybeSimpleIterable != null) {
            return maybeSimpleIterable;
        }
        return new ComplexIterable<T>(elements, numberOfElementsToChoose);
    }

    public static <T> Iterable<List<T>> chooseK(@Nonnull Collection<T> elements, int startInclusive, int endExclusive) {
        Preconditions.checkArgument(startInclusive >= 0 && startInclusive <= elements.size());
        Preconditions.checkArgument(endExclusive >= startInclusive && endExclusive - 1 <= elements.size());
        if (startInclusive == endExclusive) {
            return EnumeratingIterable.emptyIterable();
        }
        ImmutableList elementsAsList = ImmutableList.copyOf(elements);
        return () -> IntStream.range(startInclusive, endExclusive).boxed().flatMap(index -> Streams.stream(ChooseK.chooseK(elementsAsList, index))).iterator();
    }

    @Nullable
    private static <T> EnumeratingIterable<T> trySimpleIterable(@Nonnull Collection<? extends T> elements, int numberOfElementsToChoose) {
        if (elements.isEmpty() || numberOfElementsToChoose == 0) {
            return new SingleIterable(ImmutableList.of());
        }
        if (elements.size() == 1) {
            T onlyElement = Iterables.getOnlyElement(elements);
            return new SingleIterable<T>(ImmutableList.of(onlyElement));
        }
        return null;
    }

    private static class ComplexIterable<T>
    implements EnumeratingIterable<T> {
        @Nonnull
        private final List<T> elements;
        private final int numberOfElementsToChoose;

        private ComplexIterable(@Nonnull Iterable<? extends T> elements, int numberOfElementsToChoose) {
            this.elements = ImmutableList.copyOf(elements);
            this.numberOfElementsToChoose = numberOfElementsToChoose;
        }

        @Override
        @Nonnull
        public EnumeratingIterator<T> iterator() {
            return new ComplexIterator();
        }

        private class ComplexIterator
        extends AbstractIterator<List<T>>
        implements EnumeratingIterator<T> {
            private int bound = 0;
            private final List<LevelState> state;
            int currentOffset;

            private ComplexIterator() {
                this.state = Lists.newArrayListWithCapacity(ComplexIterable.this.numberOfElementsToChoose);
                for (int i = 0; i < ComplexIterable.this.numberOfElementsToChoose; ++i) {
                    this.state.add(new LevelState());
                }
                this.currentOffset = 0;
            }

            @Override
            @Nullable
            protected List<T> computeNext() {
                int currentLevel;
                if (ComplexIterable.this.elements.isEmpty()) {
                    return (List)this.endOfData();
                }
                int n = currentLevel = this.bound == 0 ? 0 : this.bound - 1;
                do {
                    int lastOffset;
                    LevelState currentState;
                    if ((currentState = this.state.get(currentLevel)).isBound()) {
                        this.unbind(currentLevel);
                        lastOffset = currentState.offset++;
                    } else {
                        currentState.bind(1, ComplexIterable.this.elements.size() - this.currentOffset + 1);
                        lastOffset = 0;
                    }
                    if (currentState.hasMore()) {
                        ++this.bound;
                        ++this.currentOffset;
                        ++currentLevel;
                    } else {
                        currentState.unbind();
                        this.currentOffset -= lastOffset;
                        --currentLevel;
                    }
                    if (currentLevel != -1) continue;
                    return (List)this.endOfData();
                } while (this.bound < ComplexIterable.this.numberOfElementsToChoose);
                ImmutableList.Builder resultBuilder = ImmutableList.builder();
                int resultOffset = 0;
                for (LevelState position : this.state) {
                    resultBuilder.add(ComplexIterable.this.elements.get((resultOffset += position.offset) - 1));
                }
                return resultBuilder.build();
            }

            private void unbind(int level) {
                LevelState currentPosition;
                for (int i = level; i < ComplexIterable.this.numberOfElementsToChoose && (currentPosition = this.state.get(i)).isBound(); ++i) {
                    --this.bound;
                    if (i <= level) continue;
                    currentPosition.unbind();
                }
            }

            @Override
            public void skip(int level) {
                LevelState levelState;
                if (level >= ComplexIterable.this.numberOfElementsToChoose) {
                    throw new IndexOutOfBoundsException();
                }
                if (!this.state.get(level).isBound()) {
                    throw new UnsupportedOperationException("cannot skip/unbind as level is not bound at all");
                }
                for (int i = level + 1; i < ComplexIterable.this.numberOfElementsToChoose && (levelState = this.state.get(i)).isBound(); ++i) {
                    --this.bound;
                    this.currentOffset -= levelState.offset;
                    levelState.unbind();
                }
            }
        }

        private static final class LevelState {
            private static final int UNBOUND = -1;
            private int offset = -1;
            private int maxOffset = -1;

            private LevelState() {
            }

            public boolean isBound() {
                return this.offset != -1;
            }

            public void bind(int offset, int maxOffset) {
                Verify.verify(offset >= 1, "Position must be bound to an offset of at least 1", new Object[0]);
                this.offset = offset;
                this.maxOffset = maxOffset;
            }

            public void unbind() {
                this.offset = -1;
                this.maxOffset = -1;
            }

            public boolean hasMore() {
                return this.offset < this.maxOffset;
            }
        }
    }

    private static class SingleIterable<T>
    implements EnumeratingIterable<T> {
        @Nonnull
        private final List<T> singleElement;

        private SingleIterable(@Nonnull List<T> singleElement) {
            this.singleElement = singleElement;
        }

        @Override
        @Nonnull
        public EnumeratingIterator<T> iterator() {
            return new SingleIterator();
        }

        private class SingleIterator
        extends AbstractIterator<List<T>>
        implements EnumeratingIterator<T> {
            boolean atFirst = true;

            private SingleIterator() {
            }

            @Override
            public void skip(int level) {
                if (this.atFirst) {
                    throw new UnsupportedOperationException("cannot skip on before first element");
                }
            }

            @Override
            protected List<T> computeNext() {
                if (this.atFirst) {
                    this.atFirst = false;
                    return SingleIterable.this.singleElement;
                }
                return (List)this.endOfData();
            }
        }
    }
}

