/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.combinatorics;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterator;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class CrossProduct {
    private CrossProduct() {
    }

    public static <T> EnumeratingIterable<T> crossProduct(@Nonnull Collection<? extends Iterable<T>> sources) {
        EnumeratingIterable<T> maybeSimpleIterable = CrossProduct.trySimpleIterable(sources);
        if (maybeSimpleIterable != null) {
            return maybeSimpleIterable;
        }
        return new ComplexIterable(sources);
    }

    @Nullable
    private static <T> EnumeratingIterable<T> trySimpleIterable(@Nonnull Collection<? extends Iterable<T>> sources) {
        if (sources.isEmpty()) {
            return EnumeratingIterable.emptyIterable();
        }
        if (sources.size() == 1) {
            return new SingleIterable<T>(Iterables.getOnlyElement(sources));
        }
        return null;
    }

    private static class ComplexIterable<T>
    implements EnumeratingIterable<T> {
        @Nonnull
        private final List<Iterable<T>> sources;

        private ComplexIterable(@Nonnull Collection<? extends Iterable<T>> sources) {
            Verify.verify(sources.size() > 1);
            this.sources = ImmutableList.copyOf(sources);
        }

        @Override
        @Nonnull
        public EnumeratingIterator<T> iterator() {
            return new ComplexIterator();
        }

        private class ComplexIterator
        extends AbstractIterator<List<T>>
        implements EnumeratingIterator<T> {
            private int bound = 0;
            private final List<PeekingIterator<T>> state;

            private ComplexIterator() {
                this.state = Lists.newArrayListWithCapacity(ComplexIterable.this.sources.size());
                ComplexIterable.this.sources.forEach(source -> this.state.add(null));
            }

            @Override
            @Nullable
            protected List<T> computeNext() {
                int currentLevel;
                if (ComplexIterable.this.sources.isEmpty()) {
                    return (List)this.endOfData();
                }
                int n = currentLevel = this.bound == 0 ? 0 : this.bound - 1;
                do {
                    PeekingIterator currentIterator;
                    if (this.state.get(currentLevel) == null) {
                        currentIterator = Iterators.peekingIterator(ComplexIterable.this.sources.get(currentLevel).iterator());
                        this.state.set(currentLevel, currentIterator);
                    } else {
                        currentIterator = this.state.get(currentLevel);
                        this.unbind(currentLevel);
                        currentIterator.next();
                    }
                    boolean isDown = currentIterator.hasNext();
                    if (isDown) {
                        ++this.bound;
                    } else {
                        this.state.set(currentLevel, null);
                    }
                    int n2 = currentLevel = isDown ? currentLevel + 1 : currentLevel - 1;
                    if (currentLevel != -1) continue;
                    return (List)this.endOfData();
                } while (this.bound < ComplexIterable.this.sources.size());
                return this.state.stream().map(PeekingIterator::peek).collect(ImmutableList.toImmutableList());
            }

            private void unbind(int level) {
                for (int i = level; i < ComplexIterable.this.sources.size() && this.state.get(i) != null; ++i) {
                    --this.bound;
                }
            }

            @Override
            public void skip(int level) {
                if (level >= ComplexIterable.this.sources.size()) {
                    throw new IndexOutOfBoundsException();
                }
                if (this.state.get(level) == null) {
                    throw new UnsupportedOperationException("cannot skip/unbind as level is not bound at all");
                }
                for (int i = level + 1; i < ComplexIterable.this.sources.size() && this.state.get(i) != null; ++i) {
                    --this.bound;
                    this.state.set(i, null);
                }
            }
        }
    }

    private static class SingleIterable<T>
    implements EnumeratingIterable<T> {
        @Nonnull
        private final Iterable<T> singleCollection;

        private SingleIterable(@Nonnull Iterable<T> singleCollection) {
            this.singleCollection = singleCollection;
        }

        @Override
        @Nonnull
        public EnumeratingIterator<T> iterator() {
            return new SingleIterator();
        }

        private class SingleIterator
        extends AbstractIterator<List<T>>
        implements EnumeratingIterator<T> {
            boolean atFirst = true;
            final Iterator<T> nestedIterator;

            private SingleIterator() {
                this.nestedIterator = SingleIterable.this.singleCollection.iterator();
            }

            @Override
            public void skip(int level) {
                if (this.atFirst) {
                    throw new UnsupportedOperationException("cannot skip on before first element");
                }
            }

            @Override
            protected List<T> computeNext() {
                this.atFirst = false;
                if (this.nestedIterator.hasNext()) {
                    return ImmutableList.of(this.nestedIterator.next());
                }
                return (List)this.endOfData();
            }
        }
    }
}

