/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.combinatorics;

import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface EnumeratingIterable<T>
extends Iterable<List<T>> {
    @Override
    @Nonnull
    public EnumeratingIterator<T> iterator();

    public static <T> EnumeratingIterable<T> emptyIterable() {
        return new EmptyIterable();
    }

    public static <T> EnumeratingIterable<T> singleIterable(@Nonnull T singleElement) {
        return new SingleIterable<T>(singleElement);
    }

    public static <T> EnumeratingIterable<T> emptyOnEmptyIterable() {
        return new SingleIterable();
    }

    public static class EmptyIterable<T>
    implements EnumeratingIterable<T> {
        private EmptyIterable() {
        }

        @Override
        @Nonnull
        public EnumeratingIterator<T> iterator() {
            return new EmptyIterator();
        }

        private class EmptyIterator
        extends AbstractIterator<List<T>>
        implements EnumeratingIterator<T> {
            private EmptyIterator() {
            }

            @Override
            public void skip(int level) {
                throw new UnsupportedOperationException("cannot skip on empty iterator");
            }

            @Override
            @Nullable
            protected List<T> computeNext() {
                return (List)this.endOfData();
            }
        }
    }

    public static class SingleIterable<T>
    implements EnumeratingIterable<T> {
        @Nullable
        private final T singleElement;

        private SingleIterable(@Nonnull T singleElement) {
            this.singleElement = singleElement;
        }

        private SingleIterable() {
            this.singleElement = null;
        }

        @Override
        @Nonnull
        public EnumeratingIterator<T> iterator() {
            return new SingleIterator<T>(this.singleElement);
        }
    }

    public static class SingleIterator<T>
    extends AbstractIterator<List<T>>
    implements EnumeratingIterator<T> {
        @Nullable
        private final T singleElement;
        boolean atFirst = true;

        private SingleIterator(@Nullable T singleElement) {
            this.singleElement = singleElement;
        }

        @Override
        public void skip(int level) {
            if (this.atFirst) {
                throw new UnsupportedOperationException("cannot skip on before first element");
            }
        }

        @Override
        protected List<T> computeNext() {
            if (!this.atFirst) {
                return (List)this.endOfData();
            }
            this.atFirst = false;
            if (this.singleElement == null) {
                return ImmutableList.of();
            }
            return ImmutableList.of(this.singleElement);
        }
    }
}

