/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.combinatorics;

import com.apple.foundationdb.record.query.combinatorics.TransitiveClosure;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class PartiallyOrderedSet<T> {
    @Nonnull
    private final ImmutableSet<T> set;
    @Nonnull
    private final ImmutableSetMultimap<T, T> dependencyMap;
    @Nonnull
    private final Supplier<PartiallyOrderedSet<T>> dualSupplier;
    @Nonnull
    private final Supplier<ImmutableSetMultimap<T, T>> transitiveClosureSupplier;

    private PartiallyOrderedSet(@Nonnull Set<T> set, @Nonnull SetMultimap<T, T> dependencyMap) {
        this.set = ImmutableSet.copyOf(set);
        this.dependencyMap = ImmutableSetMultimap.copyOf(dependencyMap);
        this.dualSupplier = Suppliers.memoize(() -> PartiallyOrderedSet.of(set, this.dependencyMap.inverse()));
        this.transitiveClosureSupplier = Suppliers.memoize(() -> TransitiveClosure.transitiveClosure(set, this.dependencyMap));
    }

    @Nonnull
    public ImmutableSet<T> getSet() {
        return this.set;
    }

    public boolean isEmpty() {
        return this.getSet().isEmpty();
    }

    @Nonnull
    public ImmutableSetMultimap<T, T> getDependencyMap() {
        return this.dependencyMap;
    }

    @Nonnull
    public ImmutableSetMultimap<T, T> getTransitiveClosure() {
        return this.transitiveClosureSupplier.get();
    }

    public int size() {
        return this.set.size();
    }

    @Nonnull
    public PartiallyOrderedSet<T> dualOrder() {
        return this.dualSupplier.get();
    }

    @Nonnull
    public EligibleSet<T> eligibleSet() {
        return new EligibleSet(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartiallyOrderedSet)) {
            return false;
        }
        PartiallyOrderedSet that = (PartiallyOrderedSet)o;
        return this.getSet().equals(that.getSet()) && this.getTransitiveClosure().equals(that.getTransitiveClosure());
    }

    public int hashCode() {
        return Objects.hash(this.getSet(), this.getTransitiveClosure());
    }

    public String toString() {
        return "{" + this.set.stream().map(Object::toString).collect(Collectors.joining(", ")) + (String)(this.dependencyMap.isEmpty() ? "" : "| " + this.dependencyMap.entries().stream().map(entry -> String.valueOf(entry.getValue()) + "\u2190" + String.valueOf(entry.getKey())).collect(Collectors.joining(", "))) + "}";
    }

    @Nonnull
    public <R> PartiallyOrderedSet<R> mapEach(@Nonnull Function<T, R> mapFunction) {
        ImmutableBiMap.Builder resultMapBuilder = ImmutableBiMap.builder();
        for (Object element : this.getSet()) {
            resultMapBuilder.put(element, mapFunction.apply(element));
        }
        ImmutableMap elementsToMappedElementsMap = resultMapBuilder.build();
        ImmutableSetMultimap.Builder resultDependencyMapBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry entry : this.getTransitiveClosure().entries()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Verify.verify(elementsToMappedElementsMap.containsKey(key));
            Verify.verify(elementsToMappedElementsMap.containsKey(value));
            resultDependencyMapBuilder.put(Verify.verifyNotNull(elementsToMappedElementsMap.get(key)), Verify.verifyNotNull(elementsToMappedElementsMap.get(value)));
        }
        return PartiallyOrderedSet.of(((ImmutableBiMap)elementsToMappedElementsMap).values(), resultDependencyMapBuilder.build());
    }

    @Nonnull
    public <R> PartiallyOrderedSet<R> mapAll(@Nonnull Function<Iterable<? extends T>, Map<T, R>> mapFunction) {
        return this.mapAll(mapFunction.apply(this.getSet()));
    }

    @Nonnull
    public <R> PartiallyOrderedSet<R> mapAll(@Nonnull Map<T, R> map) {
        LinkedHashSet<R> mappedElements = Sets.newLinkedHashSet(map.values());
        ImmutableSetMultimap.Builder resultDependencyMapBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry entry : this.getTransitiveClosure().entries()) {
            R mappedKey;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (map.containsKey(key) && map.containsKey(value)) {
                resultDependencyMapBuilder.put(map.get(key), map.get(value));
                continue;
            }
            if (map.containsKey(value) || (mappedKey = map.get(key)) == null) continue;
            mappedElements.remove(mappedKey);
        }
        return PartiallyOrderedSet.of(mappedElements, resultDependencyMapBuilder.build());
    }

    @Nonnull
    public PartiallyOrderedSet<T> filterElements(@Nonnull Predicate<T> predicate) {
        ImmutableMap.Builder translationMap = ImmutableMap.builder();
        for (Object t2 : this.getSet()) {
            if (!predicate.test(t2)) continue;
            translationMap.put(t2, t2);
        }
        return this.mapAll(translationMap.build());
    }

    @Nonnull
    public static <T> PartiallyOrderedSet<T> empty() {
        return new PartiallyOrderedSet(ImmutableSet.of(), ImmutableSetMultimap.of());
    }

    @Nonnull
    private static <T> SetMultimap<T, T> cleanseDependencyMap(@Nonnull Set<T> set, @Nonnull SetMultimap<T, T> dependencyMap) {
        boolean needsCopy = false;
        ImmutableSetMultimap.Builder cleanDependencyMapBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry entry : dependencyMap.entries()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (set.contains(key) && set.contains(value)) {
                cleanDependencyMapBuilder.put(key, entry.getValue());
                continue;
            }
            needsCopy = true;
        }
        if (needsCopy) {
            return cleanDependencyMapBuilder.build();
        }
        return dependencyMap;
    }

    @Nonnull
    static <T> ImmutableSetMultimap<T, T> fromFunctionalDependencies(@Nonnull Set<T> set, @Nonnull Function<T, Set<T>> dependsOnFn) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (T element : set) {
            Set<T> dependsOnElements = dependsOnFn.apply(element);
            for (T dependsOnElement : dependsOnElements) {
                if (!set.contains(dependsOnElement)) continue;
                builder.put(element, dependsOnElement);
            }
        }
        return builder.build();
    }

    @Nonnull
    static <T> ImmutableSetMultimap<T, T> invertFromFunctionalDependencies(@Nonnull Set<T> set, @Nonnull Function<T, Set<T>> dependsOnFn) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (T element : set) {
            Set<T> dependsOnElements = dependsOnFn.apply(element);
            for (T dependsOnElement : dependsOnElements) {
                if (!set.contains(dependsOnElement)) continue;
                builder.put(dependsOnElement, element);
            }
        }
        return builder.build();
    }

    public static <T> PartiallyOrderedSet<T> of(@Nonnull Set<T> set, @Nonnull SetMultimap<T, T> dependencyMap) {
        return new PartiallyOrderedSet<T>(set, PartiallyOrderedSet.cleanseDependencyMap(set, dependencyMap));
    }

    @Nonnull
    public static <T> PartiallyOrderedSet<T> of(@Nonnull Set<T> set, @Nonnull Function<T, Set<T>> dependsOnFn) {
        return PartiallyOrderedSet.of(set, PartiallyOrderedSet.fromFunctionalDependencies(set, dependsOnFn));
    }

    @Nonnull
    public static <T> PartiallyOrderedSet<T> ofInverted(@Nonnull Set<T> set, @Nonnull SetMultimap<T, T> dependencyMap) {
        return PartiallyOrderedSet.ofInverted(set, dependencyMap::get);
    }

    @Nonnull
    public static <T> PartiallyOrderedSet<T> ofInverted(@Nonnull Set<T> set, @Nonnull Function<T, Set<T>> dependsOnFn) {
        return PartiallyOrderedSet.of(set, PartiallyOrderedSet.invertFromFunctionalDependencies(set, dependsOnFn));
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class EligibleSet<T> {
        @Nonnull
        private final PartiallyOrderedSet<T> partiallyOrderedSet;
        @Nonnull
        private final Map<T, Integer> inDegreeMap;
        @Nonnull
        private final Supplier<Set<T>> eligibleElementsSupplier;

        private EligibleSet(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet) {
            this.partiallyOrderedSet = partiallyOrderedSet;
            this.inDegreeMap = EligibleSet.computeInDegreeMap(partiallyOrderedSet);
            this.eligibleElementsSupplier = Suppliers.memoize(this::computeEligibleElements);
        }

        @Nonnull
        public PartiallyOrderedSet<T> getPartialOrder() {
            return this.partiallyOrderedSet;
        }

        public boolean isEmpty() {
            return this.eligibleElements().isEmpty();
        }

        @Nonnull
        public Set<T> eligibleElements() {
            return this.eligibleElementsSupplier.get();
        }

        @Nonnull
        private Set<T> computeEligibleElements() {
            return this.inDegreeMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 0).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
        }

        public EligibleSet<T> removeEligibleElements(@Nonnull Set<T> toBeRemovedEligibleElements) {
            Debugger.sanityCheck(() -> Preconditions.checkArgument(this.eligibleElements().containsAll(toBeRemovedEligibleElements)));
            ImmutableSet<T> set = this.partiallyOrderedSet.getSet();
            ImmutableSet.Builder newSetBuilder = ImmutableSet.builder();
            for (Object element : set) {
                if (toBeRemovedEligibleElements.contains(element)) continue;
                newSetBuilder.add(element);
            }
            ImmutableSetMultimap<T, T> dependencies = this.partiallyOrderedSet.getDependencyMap();
            ImmutableSetMultimap.Builder newDependencies = ImmutableSetMultimap.builder();
            for (Map.Entry entry : dependencies.entries()) {
                Verify.verify(!toBeRemovedEligibleElements.contains(entry.getKey()));
                if (toBeRemovedEligibleElements.contains(entry.getValue())) continue;
                newDependencies.put(entry);
            }
            return new EligibleSet(PartiallyOrderedSet.of(newSetBuilder.build(), newDependencies.build()));
        }

        @Nonnull
        private static <T> Map<T, Integer> computeInDegreeMap(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet) {
            LinkedHashMap<Object, Integer> result = Maps.newLinkedHashMapWithExpectedSize(partiallyOrderedSet.size());
            partiallyOrderedSet.getSet().forEach(element -> result.put(element, 0));
            for (Map.Entry entry : partiallyOrderedSet.getDependencyMap().entries()) {
                result.compute(entry.getKey(), (t2, v) -> Objects.requireNonNull(v) + 1);
            }
            return result;
        }
    }

    public static class Builder<T> {
        @Nonnull
        private final ImmutableSet.Builder<T> setBuilder = ImmutableSet.builder();
        @Nonnull
        private final ImmutableSetMultimap.Builder<T, T> dependencyMapBuilder = ImmutableSetMultimap.builder();

        private Builder() {
        }

        public Builder<T> add(@Nonnull T element) {
            this.setBuilder.add((Object)element);
            return this;
        }

        public Builder<T> addDependency(@Nonnull T targetElement, T sourceElement) {
            this.setBuilder.add((Object)sourceElement);
            this.setBuilder.add((Object)targetElement);
            this.dependencyMapBuilder.put((Object)targetElement, (Object)sourceElement);
            return this;
        }

        public Builder<T> addAll(@Nonnull Iterable<? extends T> additionalElements) {
            this.setBuilder.addAll((Iterable)additionalElements);
            return this;
        }

        public Builder<T> addListWithDependencies(@Nonnull List<? extends T> additionalElements) {
            this.setBuilder.addAll(additionalElements);
            Iterator<T> iterator = additionalElements.iterator();
            if (iterator.hasNext()) {
                T last = iterator.next();
                while (iterator.hasNext()) {
                    T current = iterator.next();
                    this.dependencyMapBuilder.put((Object)current, (Object)last);
                    last = current;
                }
            }
            return this;
        }

        public PartiallyOrderedSet<T> build() {
            return PartiallyOrderedSet.of(this.setBuilder.build(), this.dependencyMapBuilder.build());
        }
    }
}

