/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.combinatorics;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterator;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class TopologicalSort {
    private TopologicalSort() {
    }

    @Nonnull
    public static <T> Iterable<List<T>> satisfyingPermutations(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet, @Nonnull List<T> targetPermutation, @Nonnull Function<List<T>, Integer> satisfiabilityFunction) {
        return TopologicalSort.satisfyingPermutations(partiallyOrderedSet, targetPermutation, Function.identity(), satisfiabilityFunction);
    }

    public static <T, P> Iterable<List<T>> satisfyingPermutations(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet, final @Nonnull List<P> targetPermutation, @Nonnull Function<T, P> domainMapper, @Nonnull Function<List<T>, Integer> satisfiabilityFunction) {
        Iterator enumeratingIterator;
        if (partiallyOrderedSet.size() < targetPermutation.size()) {
            return ImmutableList.of();
        }
        final ImmutableSetMultimap domainMap = partiallyOrderedSet.getSet().stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(domainMapper, Function.identity()));
        if (partiallyOrderedSet.size() > 1) {
            enumeratingIterator = new BacktrackIterator<T>(partiallyOrderedSet){

                @Override
                @Nonnull
                protected Iterator<T> domain(int t2) {
                    if (t2 < targetPermutation.size()) {
                        Object currentPermutedElement = Objects.requireNonNull(targetPermutation.get(t2));
                        ImmutableSet currentElements = (ImmutableSet)Objects.requireNonNull(domainMap.get(currentPermutedElement));
                        return currentElements.iterator();
                    }
                    return super.domain(t2);
                }
            };
        } else if (partiallyOrderedSet.size() == 1) {
            enumeratingIterator = EnumeratingIterable.singleIterable(Iterables.getOnlyElement(partiallyOrderedSet.getSet())).iterator();
        } else {
            Verify.verify(partiallyOrderedSet.isEmpty());
            enumeratingIterator = EnumeratingIterable.emptyOnEmptyIterable().iterator();
        }
        return () -> TopologicalSort.lambda$satisfyingPermutations$0((EnumeratingIterator)enumeratingIterator, satisfiabilityFunction, targetPermutation);
    }

    public static <T> EnumeratingIterable<T> permutations(@Nonnull Set<T> set) {
        return TopologicalSort.topologicalOrderPermutations(set, () -> TopologicalSort.complexIterable(set, ImmutableSetMultimap.of()));
    }

    public static <T> EnumeratingIterable<T> topologicalOrderPermutations(@Nonnull Set<T> set, @Nonnull Function<T, Set<T>> dependsOnFn) {
        return TopologicalSort.topologicalOrderPermutations(set, () -> TopologicalSort.complexIterable(set, PartiallyOrderedSet.fromFunctionalDependencies(set, dependsOnFn)));
    }

    public static <T> EnumeratingIterable<T> topologicalOrderPermutations(@Nonnull PartiallyOrderedSet<T> set) {
        return TopologicalSort.topologicalOrderPermutations(set.getSet(), () -> TopologicalSort.complexIterable(set));
    }

    public static <T> EnumeratingIterable<T> topologicalOrderPermutations(@Nonnull Set<T> set, @Nonnull ImmutableSetMultimap<T, T> dependsOnMap) {
        return TopologicalSort.topologicalOrderPermutations(set, () -> TopologicalSort.complexIterable(set, dependsOnMap));
    }

    private static <T> EnumeratingIterable<T> topologicalOrderPermutations(@Nonnull Set<T> set, @Nonnull Supplier<? extends EnumeratingIterable<T>> complexIterableSupplier) {
        EnumeratingIterable<T> maybeSimpleIterable = TopologicalSort.trySimpleIterable(set);
        if (maybeSimpleIterable != null) {
            return maybeSimpleIterable;
        }
        return complexIterableSupplier.get();
    }

    private static <T> EnumeratingIterable<T> complexIterable(@Nonnull Set<T> set, @Nonnull ImmutableSetMultimap<T, T> dependsOnMap) {
        return TopologicalSort.complexIterable(PartiallyOrderedSet.of(set, dependsOnMap));
    }

    private static <T> EnumeratingIterable<T> complexIterable(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet) {
        ImmutableSet<T> set = partiallyOrderedSet.getSet();
        ImmutableSetMultimap<T, T> dependsOnMap = partiallyOrderedSet.getDependencyMap();
        if ((double)dependsOnMap.size() / (double)set.size() > 0.5) {
            return new KahnIterable<T>(partiallyOrderedSet.dualOrder());
        }
        return new BacktrackIterable<T>(partiallyOrderedSet);
    }

    @Nullable
    private static <T> EnumeratingIterable<T> trySimpleIterable(@Nonnull Set<T> set) {
        if (set.isEmpty()) {
            return EnumeratingIterable.emptyIterable();
        }
        if (set.size() == 1) {
            return EnumeratingIterable.singleIterable(Iterables.getOnlyElement(set));
        }
        return null;
    }

    public static <T> Optional<List<T>> anyTopologicalOrderPermutation(@Nonnull Set<T> set, @Nonnull Function<T, Set<T>> dependsOnFn) {
        return TopologicalSort.anyTopologicalOrderPermutation(set, () -> new KahnIterable(PartiallyOrderedSet.ofInverted(set, dependsOnFn)));
    }

    public static <T> Optional<List<T>> anyTopologicalOrderPermutation(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet) {
        if (partiallyOrderedSet.getDependencyMap().isEmpty()) {
            return Optional.of(ImmutableList.copyOf(partiallyOrderedSet.getSet()));
        }
        return TopologicalSort.anyTopologicalOrderPermutation(partiallyOrderedSet.getSet(), () -> new KahnIterable(PartiallyOrderedSet.of(partiallyOrderedSet.getSet(), partiallyOrderedSet.getDependencyMap().inverse())));
    }

    public static <T> Optional<List<T>> anyTopologicalOrderPermutation(@Nonnull Set<T> set, @Nonnull ImmutableSetMultimap<T, T> dependsOnMap) {
        return TopologicalSort.anyTopologicalOrderPermutation(set, () -> new KahnIterable(PartiallyOrderedSet.of(set, dependsOnMap.inverse())));
    }

    private static <T> Optional<List<T>> anyTopologicalOrderPermutation(@Nonnull Set<T> set, Supplier<? extends EnumeratingIterable<T>> complexIterableSupplier) {
        EnumeratingIterable<T> maybeSimpleIterable = TopologicalSort.trySimpleIterable(set);
        Iterator iterator = maybeSimpleIterable != null ? maybeSimpleIterable.iterator() : complexIterableSupplier.get().iterator();
        if (iterator.hasNext()) {
            return Optional.of((List)iterator.next());
        }
        return Optional.empty();
    }

    private static /* synthetic */ Iterator lambda$satisfyingPermutations$0(final EnumeratingIterator enumeratingIterator, final Function satisfiabilityFunction, final List targetPermutation) {
        return new AbstractIterator<List<T>>(){

            @Override
            protected List<T> computeNext() {
                while (enumeratingIterator.hasNext()) {
                    List ordered = (List)enumeratingIterator.next();
                    int index = (Integer)satisfiabilityFunction.apply(ordered);
                    if (index == targetPermutation.size()) {
                        return ordered;
                    }
                    enumeratingIterator.skip(index);
                }
                return (List)this.endOfData();
            }
        };
    }

    private static class KahnIterable<T>
    implements EnumeratingIterable<T> {
        @Nonnull
        private final PartiallyOrderedSet<T> partiallyOrderedSet;

        private KahnIterable(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet) {
            Verify.verify(partiallyOrderedSet.size() > 1);
            this.partiallyOrderedSet = partiallyOrderedSet;
        }

        @Nonnull
        public PartiallyOrderedSet<T> getPartialOrder() {
            return this.partiallyOrderedSet;
        }

        @Override
        @Nonnull
        public EnumeratingIterator<T> iterator() {
            return new KahnIterator<T>(this.partiallyOrderedSet);
        }
    }

    private static class BacktrackIterable<T>
    implements EnumeratingIterable<T> {
        @Nonnull
        private final PartiallyOrderedSet<T> partiallyOrderedSet;

        private BacktrackIterable(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet) {
            this.partiallyOrderedSet = partiallyOrderedSet;
        }

        @Nonnull
        protected PartiallyOrderedSet<T> getPartialOrder() {
            return this.partiallyOrderedSet;
        }

        @Override
        @Nonnull
        public EnumeratingIterator<T> iterator() {
            return new BacktrackIterator<T>(this.partiallyOrderedSet);
        }
    }

    private static class KahnIterator<T>
    extends AbstractIterator<List<T>>
    implements EnumeratingIterator<T> {
        @Nonnull
        private final PartiallyOrderedSet<T> partiallyOrderedSet;
        private final Set<T> bound;
        private final Map<T, Integer> inDegreeMap;
        private final List<Set<T>> eligibleElementSets;
        private final List<PeekingIterator<T>> iterators;

        private KahnIterator(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet) {
            int i;
            this.partiallyOrderedSet = partiallyOrderedSet;
            this.bound = Sets.newHashSetWithExpectedSize(partiallyOrderedSet.size());
            this.inDegreeMap = KahnIterator.computeInDegreeMap(partiallyOrderedSet);
            this.eligibleElementSets = Lists.newArrayListWithCapacity(partiallyOrderedSet.size());
            this.eligibleElementSets.add(this.inDegreeMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 0).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet()));
            for (i = 1; i < partiallyOrderedSet.size(); ++i) {
                this.eligibleElementSets.add(null);
            }
            this.iterators = Lists.newArrayListWithCapacity(partiallyOrderedSet.size());
            for (i = 0; i < partiallyOrderedSet.size(); ++i) {
                this.iterators.add(null);
            }
        }

        @Override
        @Nullable
        protected List<T> computeNext() {
            int currentLevel;
            int n = currentLevel = this.bound.isEmpty() ? 0 : this.bound.size() - 1;
            do {
                PeekingIterator<T> currentIterator;
                if (this.iterators.get(currentLevel) == null) {
                    currentIterator = Iterators.peekingIterator(this.eligibleElementSets.get(currentLevel).iterator());
                    this.iterators.set(currentLevel, currentIterator);
                } else {
                    currentIterator = this.iterators.get(currentLevel);
                    this.unbindTail(currentLevel);
                    currentIterator.next();
                }
                boolean foundOnLevel = this.nextOnLevel(currentIterator);
                if (!foundOnLevel) {
                    this.iterators.set(currentLevel, null);
                }
                int n2 = currentLevel = foundOnLevel ? currentLevel + 1 : currentLevel - 1;
                if (currentLevel != -1) continue;
                return (List)this.endOfData();
            } while (this.bound.size() < this.partiallyOrderedSet.size());
            return this.iterators.stream().map(PeekingIterator::peek).collect(ImmutableList.toImmutableList());
        }

        private boolean nextOnLevel(PeekingIterator<T> currentIterator) {
            ImmutableSetMultimap<T, T> usedByMap = this.partiallyOrderedSet.getDependencyMap();
            while (currentIterator.hasNext()) {
                T next = currentIterator.peek();
                if (this.bound.contains(next)) {
                    currentIterator.next();
                    continue;
                }
                this.bound.add(next);
                ImmutableCollection targets = usedByMap.get((Object)next);
                ImmutableSet.Builder newlyEligibleElementsBuilder = ImmutableSet.builderWithExpectedSize(targets.size());
                for (Object target : targets) {
                    int newInDegree = this.inDegreeMap.compute(target, (k, v) -> Objects.requireNonNull(v) - 1);
                    Verify.verify(newInDegree >= 0);
                    if (newInDegree != 0) continue;
                    newlyEligibleElementsBuilder.add(target);
                }
                if (this.bound.size() < this.partiallyOrderedSet.size()) {
                    ((ImmutableSet.Builder)newlyEligibleElementsBuilder.addAll(this.eligibleElementSets.get(this.bound.size() - 1))).build();
                    this.eligibleElementSets.set(this.bound.size(), (Set<T>)((Object)newlyEligibleElementsBuilder.build()));
                } else {
                    Verify.verify(newlyEligibleElementsBuilder.build().isEmpty());
                }
                return true;
            }
            return false;
        }

        private void unbindTail(int level) {
            for (int i = level; i < this.partiallyOrderedSet.size() && this.iterators.get(i) != null; ++i) {
                this.unbindAt(i);
            }
        }

        private void unbindAt(int level) {
            T toUnbind = this.iterators.get(level).peek();
            this.bound.remove(toUnbind);
            ImmutableCollection targets = this.partiallyOrderedSet.getDependencyMap().get((Object)toUnbind);
            for (Object target : targets) {
                int newInDegree = this.inDegreeMap.compute(target, (k, v) -> Objects.requireNonNull(v) + 1);
                Verify.verify(newInDegree > 0);
            }
        }

        @Override
        public void skip(int level) {
            if (level >= this.partiallyOrderedSet.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (this.iterators.get(level) == null) {
                throw new UnsupportedOperationException("cannot skip/unbind as level is not bound at all");
            }
            for (int i = level + 1; i < this.partiallyOrderedSet.size() && this.iterators.get(i) != null; ++i) {
                this.unbindAt(i);
                this.iterators.set(i, null);
            }
        }

        @Nonnull
        private static <T> Map<T, Integer> computeInDegreeMap(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet) {
            LinkedHashMap<Object, Integer> result = Maps.newLinkedHashMapWithExpectedSize(partiallyOrderedSet.size());
            partiallyOrderedSet.getSet().forEach(element -> result.put(element, 0));
            for (Map.Entry entry : partiallyOrderedSet.getDependencyMap().entries()) {
                result.compute(entry.getValue(), (t2, v) -> Objects.requireNonNull(v) + 1);
            }
            return result;
        }
    }

    private static class BacktrackIterator<T>
    extends AbstractIterator<List<T>>
    implements EnumeratingIterator<T> {
        @Nonnull
        private final PartiallyOrderedSet<T> partiallyOrderedSet;
        @Nonnull
        private final Set<T> bound;
        @Nonnull
        private final List<PeekingIterator<T>> state;

        private BacktrackIterator(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet) {
            Verify.verify(partiallyOrderedSet.size() > 1);
            this.partiallyOrderedSet = partiallyOrderedSet;
            this.bound = Sets.newHashSetWithExpectedSize(partiallyOrderedSet.size());
            this.state = Lists.newArrayListWithCapacity(partiallyOrderedSet.size());
            for (int i = 0; i < partiallyOrderedSet.size(); ++i) {
                this.state.add(null);
            }
        }

        @Override
        @Nullable
        protected List<T> computeNext() {
            int currentLevel;
            int n = currentLevel = this.bound.isEmpty() ? 0 : this.bound.size() - 1;
            do {
                PeekingIterator<T> currentIterator;
                if (this.state.get(currentLevel) == null) {
                    currentIterator = Iterators.peekingIterator(this.domain(currentLevel));
                    this.state.set(currentLevel, currentIterator);
                } else {
                    currentIterator = this.state.get(currentLevel);
                    this.unbind(currentLevel);
                    currentIterator.next();
                }
                boolean isDown = this.searchLevel(currentIterator);
                if (!isDown) {
                    this.state.set(currentLevel, null);
                }
                int n2 = currentLevel = isDown ? currentLevel + 1 : currentLevel - 1;
                if (currentLevel != -1) continue;
                return (List)this.endOfData();
            } while (this.bound.size() < this.partiallyOrderedSet.size());
            return this.state.stream().map(PeekingIterator::peek).collect(ImmutableList.toImmutableList());
        }

        @Nonnull
        protected Iterator<T> domain(int t2) {
            return this.partiallyOrderedSet.getSet().iterator();
        }

        private boolean searchLevel(PeekingIterator<T> currentIterator) {
            ImmutableSet<T> set = this.partiallyOrderedSet.getSet();
            ImmutableSetMultimap<T, T> dependsOnMap = this.partiallyOrderedSet.getDependencyMap();
            while (currentIterator.hasNext()) {
                T next = currentIterator.peek();
                if (this.bound.contains(next)) {
                    currentIterator.next();
                    continue;
                }
                Sets.SetView<T> dependsOn = Sets.intersection(set, dependsOnMap.get((Object)next));
                if (!this.bound.containsAll(dependsOn)) {
                    currentIterator.next();
                    continue;
                }
                this.bound.add(next);
                return true;
            }
            return false;
        }

        private void unbind(int level) {
            for (int i = level; i < this.partiallyOrderedSet.size() && this.state.get(i) != null; ++i) {
                this.bound.remove(this.state.get(i).peek());
            }
        }

        @Override
        public void skip(int level) {
            if (level >= this.partiallyOrderedSet.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (this.state.get(level) == null) {
                throw new UnsupportedOperationException("cannot skip/unbind as level is not bound at all");
            }
            for (int i = level + 1; i < this.partiallyOrderedSet.size() && this.state.get(i) != null; ++i) {
                this.bound.remove(this.state.get(i).peek());
                this.state.set(i, null);
            }
        }
    }
}

