/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.combinatorics;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class TransitiveClosure {
    private TransitiveClosure() {
    }

    public static <T> ImmutableSetMultimap<T, T> transitiveClosure(@Nonnull Set<T> set, @Nonnull SetMultimap<T, T> dependsOnMap) {
        return TransitiveClosure.transitiveClosure(PartiallyOrderedSet.of(set, dependsOnMap));
    }

    public static <T> ImmutableSetMultimap<T, T> transitiveClosure(@Nonnull PartiallyOrderedSet<T> partiallyOrderedSet) {
        ImmutableSet<T> set = partiallyOrderedSet.getSet();
        ImmutableSetMultimap<T, T> dependsOnMap = partiallyOrderedSet.getDependencyMap();
        ImmutableMultimap usedByMap = dependsOnMap.inverse();
        Map<T, Integer> inDegreeMap = TransitiveClosure.computeInDegreeMap(set, usedByMap);
        HashSet processed = Sets.newHashSetWithExpectedSize(partiallyOrderedSet.size());
        ArrayDeque deque = new ArrayDeque(partiallyOrderedSet.size());
        for (Object current : set) {
            if (inDegreeMap.get(current) != 0) continue;
            deque.add(current);
        }
        HashMultimap resultMap = HashMultimap.create();
        while (!deque.isEmpty()) {
            Object current;
            current = deque.pop();
            processed.add(current);
            ImmutableCollection usingEntities = ((ImmutableSetMultimap)usedByMap).get(current);
            for (Object using : usingEntities) {
                Integer newInDegree = inDegreeMap.compute(using, (uE, inDegree) -> {
                    Objects.requireNonNull(inDegree);
                    Verify.verify(inDegree > 0);
                    return inDegree - 1;
                });
                if (newInDegree != 0) continue;
                deque.add(using);
                ImmutableCollection dependsOnSet = dependsOnMap.get(using);
                for (Object dependsOn : dependsOnSet) {
                    resultMap.put(using, dependsOn);
                    resultMap.get(dependsOn).forEach(ancestor -> resultMap.put(using, ancestor));
                }
            }
        }
        Preconditions.checkArgument(processed.size() == partiallyOrderedSet.size(), "circular dependency");
        return ImmutableSetMultimap.copyOf(resultMap);
    }

    @Nonnull
    private static <T> Map<T, Integer> computeInDegreeMap(@Nonnull Set<T> set, @Nonnull SetMultimap<T, T> usedByMap) {
        HashMap<Object, Integer> result = Maps.newHashMapWithExpectedSize(set.size());
        set.forEach(element -> result.put(element, 0));
        for (Map.Entry entry : usedByMap.entries()) {
            result.compute(entry.getValue(), (t2, v) -> Objects.requireNonNull(v) + 1);
        }
        return result;
    }
}

