/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.AsyncBoolean;
import com.apple.foundationdb.record.query.expressions.BooleanComponent;
import com.apple.foundationdb.record.query.expressions.ComponentWithChildren;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.SimpleComponentWithChildren;
import com.google.protobuf.Message;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public abstract class AndOrComponent
extends SimpleComponentWithChildren
implements ComponentWithChildren,
BooleanComponent {
    protected abstract boolean isOr();

    public AndOrComponent(@Nonnull List<QueryComponent> operands) {
        super(operands);
    }

    @Nullable
    private Boolean evalInternal(@Nonnull Function<QueryComponent, Boolean> evalChildFunction) {
        Boolean retVal = !this.isOr();
        for (QueryComponent child : this.getChildren()) {
            Boolean val = evalChildFunction.apply(child);
            if (val == null) {
                retVal = null;
                continue;
            }
            if (val.booleanValue()) {
                if (!this.isOr()) continue;
                return true;
            }
            if (this.isOr()) continue;
            return false;
        }
        return retVal;
    }

    @Override
    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        return this.evalInternal(child -> child.evalMessage(store, context, rec, message));
    }

    @Override
    @Nonnull
    public <M extends Message> CompletableFuture<Boolean> evalMessageAsync(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        return new AsyncBoolean<M, QueryComponent>(this.isOr(), this.getChildren(), queryComponent -> queryComponent.evalMessageAsync(store, context, rec, message), store).eval();
    }

    @Override
    public boolean isAsync() {
        return this.getChildren().stream().anyMatch(QueryComponent::isAsync);
    }
}

