/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AsyncBoolean<M extends Message, Q> {
    private final boolean isOr;
    @Nonnull
    private final Iterator<Q> operands;
    @Nonnull
    private final Function<Q, CompletableFuture<Boolean>> evaluateFunction;
    @Nonnull
    private final FDBRecordStoreBase<M> store;
    @Nullable
    private Boolean retVal;

    public AsyncBoolean(boolean isOr, @Nonnull List<Q> operands, @Nonnull Function<Q, CompletableFuture<Boolean>> evaluateFunction, @Nonnull FDBRecordStoreBase<M> store) {
        this.isOr = isOr;
        this.operands = operands.iterator();
        this.evaluateFunction = evaluateFunction;
        this.store = store;
        this.retVal = !isOr;
    }

    public CompletableFuture<Boolean> eval() {
        return AsyncUtil.whileTrue(() -> {
            if (!this.operands.hasNext()) {
                return AsyncUtil.READY_FALSE;
            }
            return this.evaluateFunction.apply(this.operands.next()).thenApply(val -> {
                if (val == null) {
                    this.retVal = null;
                } else if (val.booleanValue()) {
                    if (this.isOr) {
                        this.retVal = true;
                        return false;
                    }
                } else if (!this.isOr) {
                    this.retVal = false;
                    return true;
                }
                return true;
            });
        }, this.store.getExecutor()).thenApply(vignore -> this.retVal);
    }
}

