/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.metadata.expressions.TupleFieldsHelper;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.cascades.values.MessageHelpers;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public abstract class BaseField
implements PlanHashable,
QueryComponent {
    @Nonnull
    private final String fieldName;

    protected BaseField(@Nonnull String fieldName) {
        this.fieldName = fieldName;
    }

    @Nonnull
    protected Descriptors.FieldDescriptor findFieldDescriptor(@Nonnull MessageOrBuilder message) {
        return MessageHelpers.findFieldDescriptorOnMessage(message, this.fieldName);
    }

    @Nullable
    protected Object getFieldValue(@Nullable MessageOrBuilder message) {
        if (message == null) {
            return null;
        }
        return MessageHelpers.getFieldOnMessage(message, this.fieldName);
    }

    @Nonnull
    protected Descriptors.FieldDescriptor validateFieldExistence(@Nonnull Descriptors.Descriptor descriptor) {
        Descriptors.FieldDescriptor field = descriptor.findFieldByName(this.fieldName);
        if (field == null) {
            throw new Query.InvalidExpressionException("Missing field " + this.fieldName);
        }
        return field;
    }

    protected void requirePrimitiveField(@Nonnull Descriptors.FieldDescriptor field) {
        if (field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !TupleFieldsHelper.isTupleField(field.getMessageType())) {
            throw new Query.InvalidExpressionException("Required primitive field, but got message " + this.fieldName);
        }
    }

    protected void requireMessageField(@Nonnull Descriptors.FieldDescriptor field) {
        if (field.getType() != Descriptors.FieldDescriptor.Type.MESSAGE || TupleFieldsHelper.isTupleField(field.getMessageType())) {
            throw new Query.InvalidExpressionException("Required nested field, but got primitive field " + this.fieldName);
        }
    }

    protected void requireScalarField(@Nonnull Descriptors.FieldDescriptor field) {
        if (field.isRepeated()) {
            throw new Query.InvalidExpressionException("Required scalar field, but got repeated field " + this.fieldName);
        }
    }

    @Nonnull
    public String getName() {
        return this.getFieldName();
    }

    @Nonnull
    public String getFieldName() {
        return this.fieldName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseField)) {
            return false;
        }
        BaseField baseField = (BaseField)o;
        return Objects.equals(this.fieldName, baseField.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName);
    }

    protected int basePlanHash(@Nonnull PlanHashable.PlanHashMode mode, ObjectPlanHash baseHash, Object ... hashables) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.fieldName.hashCode();
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, baseHash, this.fieldName, hashables);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

