/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.query.expressions.BaseField;
import com.apple.foundationdb.record.query.expressions.Field;
import com.apple.foundationdb.record.query.expressions.Query;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class BaseRepeatedField
extends BaseField {
    @Nonnull
    private final Field.OneOfThemEmptyMode emptyMode;

    public BaseRepeatedField(@Nonnull String fieldName, Field.OneOfThemEmptyMode emptyMode) {
        super(fieldName);
        this.emptyMode = emptyMode;
    }

    @Nonnull
    public Field.OneOfThemEmptyMode getEmptyMode() {
        return this.emptyMode;
    }

    @Nullable
    protected List<Object> getValues(@Nonnull MessageOrBuilder message) {
        Descriptors.FieldDescriptor field = this.findFieldDescriptor(message);
        if (this.emptyMode == Field.OneOfThemEmptyMode.EMPTY_UNKNOWN && message.getRepeatedFieldCount(field) == 0) {
            return null;
        }
        return (List)message.getField(field);
    }

    @Nonnull
    protected Descriptors.FieldDescriptor validateRepeatedField(@Nonnull Descriptors.Descriptor descriptor) {
        Descriptors.FieldDescriptor field = this.validateFieldExistence(descriptor);
        if (!field.isRepeated()) {
            throw new Query.InvalidExpressionException("Expected repeated field, but it was scalar " + this.getFieldName());
        }
        return field;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseRepeatedField)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseRepeatedField baseRepeatedField = (BaseRepeatedField)o;
        return this.emptyMode == baseRepeatedField.emptyMode;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.emptyMode.hashCode();
    }

    @Override
    protected int basePlanHash(@Nonnull PlanHashable.PlanHashMode mode, ObjectPlanHash baseHash, Object ... hashables) {
        switch (mode.getKind()) {
            case LEGACY: {
                return super.basePlanHash(mode, baseHash, new Object[0]) + this.emptyMode.ordinal();
            }
            case FOR_CONTINUATION: {
                return super.basePlanHash(mode, baseHash, new Object[]{this.emptyMode, hashables});
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

