/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithChildren;
import com.apple.foundationdb.record.query.expressions.ComponentWithComparison;
import com.apple.foundationdb.record.query.expressions.ComponentWithSingleChild;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public interface BooleanComponent
extends QueryComponent {
    @Nonnull
    default public Stream<QueryComponent> nonBooleanSubComponents() {
        if (this instanceof ComponentWithChildren) {
            ComponentWithChildren componentWithChildren = (ComponentWithChildren)((Object)this);
            return componentWithChildren.getChildren().stream().flatMap(child -> {
                if (child instanceof BooleanComponent) {
                    return ((BooleanComponent)child).nonBooleanSubComponents();
                }
                return Stream.of(child);
            });
        }
        if (this instanceof ComponentWithSingleChild) {
            ComponentWithSingleChild componentWithSingleChild = (ComponentWithSingleChild)((Object)this);
            QueryComponent child2 = componentWithSingleChild.getChild();
            if (child2 instanceof BooleanComponent) {
                return ((BooleanComponent)child2).nonBooleanSubComponents();
            }
            return Stream.of(child2);
        }
        return Stream.empty();
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public static Stream<Pair<String, List<Comparisons.ComparisonWithParameter>>> groupedComparisons(@Nonnull QueryComponent queryComponent) {
        Stream<BooleanComponent> booleanComponents = BooleanComponent.topBooleanComponents(queryComponent);
        return booleanComponents.flatMap(booleanComponent -> {
            List nonBooleanSubComponents = booleanComponent.nonBooleanSubComponents().collect(ImmutableList.toImmutableList());
            Stream nestedGroupedComparisons = BooleanComponent.nestedComponents(nonBooleanSubComponents.stream()).flatMap(BooleanComponent::groupedComparisons);
            Stream<ComponentWithComparison> comparisons = BooleanComponent.comparisons(nonBooleanSubComponents.stream());
            Map<String, ImmutableList<Comparisons.ComparisonWithParameter>> partitionedComparisonsMap = BooleanComponent.groupedComparisonsMap(comparisons);
            Stream<Pair> dependentComparisons = partitionedComparisonsMap.entrySet().stream().map(entry -> Pair.of((String)entry.getKey(), (List)entry.getValue()));
            return Streams.concat(nestedGroupedComparisons, dependentComparisons);
        });
    }

    @Nonnull
    public static Map<String, ImmutableList<Comparisons.ComparisonWithParameter>> groupedComparisonsMap(Stream<ComponentWithComparison> comparisons) {
        return comparisons.filter(componentWithComparison -> componentWithComparison.getComparison() instanceof Comparisons.ComparisonWithParameter).collect(Collectors.groupingBy(ComponentWithComparison::getName, Maps::newLinkedHashMap, Collectors.mapping(componentWithComparison -> (Comparisons.ComparisonWithParameter)componentWithComparison.getComparison(), ImmutableList.toImmutableList())));
    }

    @Nonnull
    public static Stream<ComponentWithComparison> comparisons(@Nonnull Stream<QueryComponent> nonBooleanSubComponents) {
        return nonBooleanSubComponents.filter(queryComponent -> queryComponent instanceof ComponentWithComparison).map(queryComponent -> (ComponentWithComparison)queryComponent);
    }

    @Nonnull
    public static Stream<QueryComponent> nestedComponents(@Nonnull Stream<QueryComponent> nonBooleanSubComponents) {
        return nonBooleanSubComponents.filter(queryComponent -> !(queryComponent instanceof ComponentWithComparison));
    }

    @Nonnull
    public static Stream<BooleanComponent> topBooleanComponents(@Nonnull QueryComponent queryComponent) {
        if (queryComponent instanceof BooleanComponent) {
            return Stream.of((BooleanComponent)queryComponent);
        }
        if (queryComponent instanceof ComponentWithChildren) {
            ComponentWithChildren componentWithChildren = (ComponentWithChildren)queryComponent;
            return componentWithChildren.getChildren().stream().flatMap(BooleanComponent::topBooleanComponents);
        }
        if (queryComponent instanceof ComponentWithSingleChild) {
            ComponentWithSingleChild componentWithSingleChild = (ComponentWithSingleChild)queryComponent;
            QueryComponent child = componentWithSingleChild.getChild();
            return BooleanComponent.topBooleanComponents(child);
        }
        return Stream.empty();
    }
}

