/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.TupleFieldsProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.InvertibleFunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.TupleFieldsHelper;
import com.apple.foundationdb.record.planprotos.PComparison;
import com.apple.foundationdb.record.planprotos.PInvertedFunctionComparison;
import com.apple.foundationdb.record.planprotos.PListComparison;
import com.apple.foundationdb.record.planprotos.PMultiColumnComparison;
import com.apple.foundationdb.record.planprotos.PNullComparison;
import com.apple.foundationdb.record.planprotos.POpaqueEqualityComparison;
import com.apple.foundationdb.record.planprotos.PParameterComparison;
import com.apple.foundationdb.record.planprotos.PSimpleComparison;
import com.apple.foundationdb.record.planprotos.PValueComparison;
import com.apple.foundationdb.record.provider.common.text.TextTokenizer;
import com.apple.foundationdb.record.provider.common.text.TextTokenizerRegistry;
import com.apple.foundationdb.record.provider.common.text.TextTokenizerRegistryImpl;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.ParameterRelationshipGraph;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.UsesValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.WithValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LikeOperatorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.MessageHelpers;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.record.util.ProtoUtils;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class Comparisons {
    public static final Comparison LIST_EMPTY = new ListComparison(Type.EQUALS, Collections.emptyList());
    public static final Object COMPARISON_SKIPPED_BINDING = new Object(){

        public String toString() {
            return "SKIP_COMPARISON";
        }
    };

    private Comparisons() {
    }

    private static Comparable toComparable(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ByteString) {
            return new UnsignedBytes(((ByteString)obj).toByteArray());
        }
        if (obj instanceof byte[]) {
            return new UnsignedBytes((byte[])obj);
        }
        if (obj instanceof UUID) {
            UUID uuid = (UUID)obj;
            return new UnsignedUUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        }
        if (obj instanceof Internal.EnumLite) {
            return Integer.valueOf(((Internal.EnumLite)obj).getNumber());
        }
        if (obj instanceof Comparable) {
            return (Comparable)obj;
        }
        throw new RecordCoreException("Tried to compare non-comparable object " + String.valueOf(obj.getClass()), new Object[0]);
    }

    @Nonnull
    public static Object toClassWithRealEquals(@Nonnull Object obj) {
        if (obj instanceof ByteString) {
            return obj;
        }
        if (obj instanceof byte[]) {
            return ByteString.copyFrom((byte[])obj);
        }
        if (obj instanceof Internal.EnumLite) {
            return ((Internal.EnumLite)obj).getNumber();
        }
        if (obj instanceof Comparable) {
            return obj;
        }
        if (obj instanceof List) {
            return obj;
        }
        throw new RecordCoreException("Tried to compare non-comparable object " + String.valueOf(obj.getClass()), new Object[0]);
    }

    public static int compare(@Nonnull Object fieldValue, @Nonnull Object comparand) {
        return Comparisons.toComparable(fieldValue).compareTo(Comparisons.toComparable(comparand));
    }

    @SpotBugsSuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private static boolean compareEquals(@Nonnull Object value, @Nonnull Object comparand) {
        if (value instanceof Message) {
            return MessageHelpers.compareMessageEquals(value, comparand);
        }
        return Comparisons.toClassWithRealEquals(value).equals(Comparisons.toClassWithRealEquals(comparand));
    }

    @SpotBugsSuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private static boolean compareNotDistinctFrom(@Nullable Object value, @Nullable Object comparand) {
        if (value == null && comparand == null) {
            return true;
        }
        if (value == null || comparand == null) {
            return false;
        }
        if (value instanceof Message) {
            return MessageHelpers.compareMessageEquals(value, comparand);
        }
        return Comparisons.toClassWithRealEquals(Objects.requireNonNull(value)).equals(Comparisons.toClassWithRealEquals(Objects.requireNonNull(comparand)));
    }

    @Nullable
    @SpotBugsSuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private static Boolean compareStartsWith(@Nullable Object value, @Nullable Object comparand) {
        if (value == null || comparand == null) {
            return null;
        }
        if (comparand instanceof String) {
            return ((String)value).startsWith((String)comparand);
        }
        if (comparand instanceof ByteString || comparand instanceof byte[]) {
            byte[] bcomp = comparand instanceof byte[] ? (byte[])comparand : ((ByteString)comparand).toByteArray();
            byte[] bval = value instanceof byte[] ? (byte[])value : ((ByteString)value).toByteArray();
            return bval.length >= bcomp.length && Arrays.equals(Arrays.copyOfRange(bval, 0, bcomp.length), bcomp);
        }
        if (comparand instanceof List) {
            return Comparisons.compareListStartsWith(value, (List)comparand);
        }
        throw new RecordCoreException("Illegal comparand value type: " + String.valueOf(comparand), new Object[0]);
    }

    @Nullable
    @SpotBugsSuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private static Boolean compareLike(@Nullable Object value, @Nullable Object pattern) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new RecordCoreException("Illegal comparand value type: " + String.valueOf(value), new Object[0]);
        }
        if (!(pattern instanceof String)) {
            throw new RecordCoreException("Illegal pattern value type: " + String.valueOf(pattern), new Object[0]);
        }
        return LikeOperatorValue.likeOperation((String)value, (String)pattern);
    }

    public static Boolean compareListEquals(@Nullable Object value, @Nonnull List<?> comparand) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() != comparand.size()) {
                return false;
            }
            return Comparisons.compareListStartsWith(value, comparand);
        }
        throw new RecordCoreException("value from record did not match comparand", new Object[0]);
    }

    private static Boolean compareListStartsWith(@Nullable Object value, @Nonnull List<?> comparand) {
        if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < comparand.size(); ++i) {
                if (i > list.size()) {
                    return false;
                }
                if (comparand.get(i) == null && list.get(i) == null) continue;
                if (comparand.get(i) == null || list.get(i) == null) {
                    return false;
                }
                if (Comparisons.toClassWithRealEquals(comparand.get(i)).equals(Comparisons.toClassWithRealEquals(list.get(i)))) continue;
                return false;
            }
            return true;
        }
        throw new RecordCoreException("value from record did not match comparand", new Object[0]);
    }

    @Nullable
    @SpotBugsSuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private static Boolean compareIn(@Nullable Object value, @Nullable Object comparand) {
        if (value == null || comparand == null) {
            return null;
        }
        if (comparand instanceof List) {
            boolean hasNull = false;
            value = value instanceof Message ? value : Comparisons.toClassWithRealEquals(value);
            for (Object comparandItem : (List)comparand) {
                if (value instanceof Message) {
                    if (!MessageHelpers.compareMessageEquals(value, comparandItem)) continue;
                    return true;
                }
                if (comparandItem == null) {
                    hasNull = true;
                    continue;
                }
                if (!Comparisons.toClassWithRealEquals(value).equals(Comparisons.toClassWithRealEquals(comparandItem))) continue;
                return true;
            }
            return hasNull ? null : Boolean.valueOf(false);
        }
        throw new RecordCoreException("IN comparison with a non-list type" + String.valueOf(comparand.getClass()), new Object[0]);
    }

    @Nullable
    private static Boolean compareTextContainsSingle(@Nonnull Iterator<? extends CharSequence> valueIterator, @Nonnull String comparandToken) {
        if (comparandToken.isEmpty()) {
            return null;
        }
        while (valueIterator.hasNext()) {
            String nextToken = valueIterator.next().toString();
            if (nextToken.isEmpty() || !nextToken.equals(comparandToken)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Nullable
    private static Boolean compareTextContainsPrefix(@Nonnull Iterator<? extends CharSequence> valueIterator, @Nonnull String comparandToken) {
        if (comparandToken.isEmpty()) {
            return null;
        }
        while (valueIterator.hasNext()) {
            String nextToken = valueIterator.next().toString();
            if (nextToken.isEmpty() || !nextToken.startsWith(comparandToken)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Nonnull
    private static Set<String> getComparandSet(@Nonnull List<String> comparandList) {
        if (comparandList.isEmpty()) {
            return Collections.emptySet();
        }
        if (comparandList.size() == 1) {
            String comparand = comparandList.get(0);
            if (comparand.isEmpty()) {
                return Collections.emptySet();
            }
            return Collections.singleton(comparand);
        }
        HashSet<String> comparandSet = new HashSet<String>(comparandList);
        comparandSet.remove("");
        return comparandSet;
    }

    @Nullable
    private static Boolean compareTextContainsAll(@Nonnull Iterator<? extends CharSequence> valueIterator, @Nonnull List<String> comparand) {
        Set<String> comparandSet = Comparisons.getComparandSet(comparand);
        if (comparandSet.isEmpty()) {
            return null;
        }
        if (comparandSet.size() == 1) {
            return Comparisons.compareTextContainsSingle(valueIterator, comparandSet.iterator().next());
        }
        HashSet<String> matchedSet = new HashSet<String>((int)((double)comparandSet.size() * 1.5));
        while (valueIterator.hasNext()) {
            String nextToken = valueIterator.next().toString();
            if (nextToken.isEmpty() || !comparandSet.contains(nextToken)) continue;
            matchedSet.add(nextToken);
            if (matchedSet.size() != comparandSet.size()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Nullable
    private static Boolean compareTextContainsAllWithin(@Nonnull Iterator<? extends CharSequence> valueIterator, @Nonnull List<String> comparand, int maxDistance) {
        Set<String> comparandSet = Comparisons.getComparandSet(comparand);
        if (comparandSet.isEmpty()) {
            return null;
        }
        if (comparandSet.size() == 1) {
            return Comparisons.compareTextContainsSingle(valueIterator, comparandSet.iterator().next());
        }
        HashMap<String, Integer> seenMap = new HashMap<String, Integer>(comparandSet.size());
        ArrayDeque<String> lastTokensQueue = new ArrayDeque<String>(maxDistance);
        while (valueIterator.hasNext()) {
            String nextToken = valueIterator.next().toString();
            if (!nextToken.isEmpty() && comparandSet.contains(nextToken)) {
                seenMap.merge(nextToken, 1, Integer::sum);
                if (seenMap.size() == comparandSet.size()) {
                    return Boolean.TRUE;
                }
            }
            if (lastTokensQueue.size() == maxDistance) {
                String lastToken = (String)lastTokensQueue.poll();
                seenMap.computeIfPresent(lastToken, (ignore, currentCount) -> {
                    if (currentCount > 1) {
                        return currentCount - 1;
                    }
                    return null;
                });
            }
            lastTokensQueue.offer(nextToken);
        }
        return Boolean.FALSE;
    }

    @Nullable
    private static Boolean compareTextContainsAny(@Nonnull Iterator<? extends CharSequence> valueIterator, @Nonnull List<String> comparand) {
        Set<String> comparandSet = Comparisons.getComparandSet(comparand);
        if (comparandSet.isEmpty()) {
            return null;
        }
        if (comparandSet.size() == 1) {
            return Comparisons.compareTextContainsSingle(valueIterator, comparandSet.iterator().next());
        }
        while (valueIterator.hasNext()) {
            String nextToken = valueIterator.next().toString();
            if (nextToken.isEmpty() || !comparandSet.contains(nextToken)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Nullable
    private static Boolean compareTextContainsAllPrefixes(@Nonnull Iterator<? extends CharSequence> valueIterator, @Nonnull List<String> comparand) {
        Set<String> comparandSet = Comparisons.getComparandSet(comparand);
        if (comparandSet.isEmpty()) {
            return null;
        }
        if (comparandSet.size() == 1) {
            return Comparisons.compareTextContainsPrefix(valueIterator, comparandSet.iterator().next());
        }
        HashSet<String> matchedSet = new HashSet<String>((int)((double)comparandSet.size() * 1.5));
        while (valueIterator.hasNext()) {
            String nextToken = valueIterator.next().toString();
            if (nextToken.isEmpty()) continue;
            for (String comparandElement : comparandSet) {
                if (!nextToken.startsWith(comparandElement)) continue;
                matchedSet.add(comparandElement);
            }
            if (matchedSet.size() != comparandSet.size()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Nullable
    private static Boolean compareTextContainsAnyPrefix(@Nonnull Iterator<? extends CharSequence> valueIterator, @Nonnull List<String> comparand) {
        Set<String> comparandSet = Comparisons.getComparandSet(comparand);
        if (comparandSet.isEmpty()) {
            return null;
        }
        if (comparandSet.size() == 1) {
            return Comparisons.compareTextContainsPrefix(valueIterator, comparandSet.iterator().next());
        }
        while (valueIterator.hasNext()) {
            String nextToken = valueIterator.next().toString();
            if (nextToken.isEmpty()) continue;
            for (String comparandElement : comparandSet) {
                if (!nextToken.startsWith(comparandElement)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Nullable
    private static Boolean compareTextContainsPhrase(@Nonnull Iterator<? extends CharSequence> valueIterator, @Nonnull List<String> comparand) {
        int lastNonStopWord;
        int firstNonStopWord;
        for (firstNonStopWord = 0; firstNonStopWord < comparand.size() && comparand.get(firstNonStopWord).isEmpty(); ++firstNonStopWord) {
        }
        if (firstNonStopWord == comparand.size()) {
            return null;
        }
        for (lastNonStopWord = comparand.size(); lastNonStopWord > firstNonStopWord && comparand.get(lastNonStopWord - 1).isEmpty(); --lastNonStopWord) {
        }
        if ((comparand = comparand.subList(firstNonStopWord, lastNonStopWord)).isEmpty()) {
            return null;
        }
        if (comparand.size() == 1) {
            return Comparisons.compareTextContainsSingle(valueIterator, comparand.get(0));
        }
        ArrayDeque<Iterator<String>> positions = new ArrayDeque<Iterator<String>>(comparand.size());
        String firstComparand = comparand.get(0);
        while (valueIterator.hasNext()) {
            String nextToken = valueIterator.next().toString();
            int currPositionSize = positions.size();
            for (int i = 0; i < currPositionSize; ++i) {
                Iterator comparandIterator = (Iterator)positions.poll();
                String comparandToken = (String)comparandIterator.next();
                if (!comparandToken.isEmpty() && !comparandToken.equals(nextToken)) continue;
                if (comparandIterator.hasNext()) {
                    positions.offer(comparandIterator);
                    continue;
                }
                return Boolean.TRUE;
            }
            if (!nextToken.equals(firstComparand)) continue;
            Iterator<String> newIterator = comparand.iterator();
            newIterator.next();
            positions.offer(newIterator);
        }
        return Boolean.FALSE;
    }

    @Nullable
    public static Type invertComparisonType(@Nonnull Type type) {
        if (type.isUnary()) {
            return null;
        }
        switch (type) {
            case EQUALS: {
                return Type.NOT_EQUALS;
            }
            case LESS_THAN: {
                return Type.GREATER_THAN_OR_EQUALS;
            }
            case LESS_THAN_OR_EQUALS: {
                return Type.GREATER_THAN;
            }
            case GREATER_THAN: {
                return Type.LESS_THAN_OR_EQUALS;
            }
            case GREATER_THAN_OR_EQUALS: {
                return Type.LESS_THAN;
            }
        }
        return null;
    }

    @Nullable
    @SpotBugsSuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public static Boolean evalComparison(@Nonnull Type type, @Nullable Object value, @Nullable Object comparand) {
        switch (type) {
            case STARTS_WITH: {
                return Comparisons.compareStartsWith(value, comparand);
            }
            case IN: {
                return Comparisons.compareIn(value, comparand);
            }
            case EQUALS: {
                if (value == null || comparand == null) {
                    return null;
                }
                return Comparisons.compareEquals(value, comparand);
            }
            case NOT_EQUALS: {
                if (value == null || comparand == null) {
                    return null;
                }
                return !Comparisons.compareEquals(value, comparand);
            }
            case IS_DISTINCT_FROM: {
                return !Comparisons.compareNotDistinctFrom(value, comparand);
            }
            case NOT_DISTINCT_FROM: {
                return Comparisons.compareNotDistinctFrom(value, comparand);
            }
            case LESS_THAN: {
                if (value == null || comparand == null) {
                    return null;
                }
                return Comparisons.compare(value, comparand) < 0;
            }
            case LESS_THAN_OR_EQUALS: {
                if (value == null || comparand == null) {
                    return null;
                }
                return Comparisons.compare(value, comparand) <= 0;
            }
            case GREATER_THAN: {
                if (value == null || comparand == null) {
                    return null;
                }
                return Comparisons.compare(value, comparand) > 0;
            }
            case GREATER_THAN_OR_EQUALS: {
                if (value == null || comparand == null) {
                    return null;
                }
                return Comparisons.compare(value, comparand) >= 0;
            }
            case LIKE: {
                return Comparisons.compareLike(value, comparand);
            }
        }
        throw new RecordCoreException("Unsupported comparison type: " + String.valueOf((Object)type), new Object[0]);
    }

    @Nullable
    @SpotBugsSuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public static Boolean evalListComparison(@Nonnull Type type, @Nullable Object value, @Nullable List comparand) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case EQUALS: {
                return Comparisons.compareListEquals(value, Objects.requireNonNull(comparand));
            }
            case NOT_EQUALS: {
                return Comparisons.compareListEquals(value, Objects.requireNonNull(comparand)) == false;
            }
            case STARTS_WITH: {
                return Comparisons.compareListStartsWith(value, Objects.requireNonNull(comparand));
            }
            case IN: {
                return Comparisons.compareIn(value, Objects.requireNonNull(comparand));
            }
        }
        throw new RecordCoreException("Only equals/not equals/starts with are supported for lists", new Object[0]);
    }

    public static String toPrintable(@Nullable Object value) {
        if (value instanceof ByteString) {
            return Comparisons.toPrintable(((ByteString)value).toByteArray());
        }
        if (value instanceof byte[]) {
            return ByteArrayUtil2.loggable((byte[])value);
        }
        return Objects.toString(value);
    }

    private static class UnsignedBytes
    implements Comparable<UnsignedBytes> {
        @Nonnull
        private byte[] data;

        public UnsignedBytes(@Nonnull byte[] data) {
            this.data = data;
        }

        @Override
        public int compareTo(@Nonnull UnsignedBytes other) {
            return ByteArrayUtil.compareUnsigned(this.data, other.data);
        }

        public boolean equals(Object o) {
            return o instanceof UnsignedBytes && this.compareTo((UnsignedBytes)o) == 0;
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }

    private static class UnsignedUUID
    implements Comparable<UnsignedUUID> {
        private final long mostSignificantBits;
        private final long leastSignificantBits;

        private UnsignedUUID(long mostSignificantBits, long leastSignificantBits) {
            this.mostSignificantBits = mostSignificantBits;
            this.leastSignificantBits = leastSignificantBits;
        }

        public long getMostSignificantBits() {
            return this.mostSignificantBits;
        }

        public long getLeastSignificantBits() {
            return this.leastSignificantBits;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnsignedUUID that = (UnsignedUUID)o;
            return this.mostSignificantBits == that.mostSignificantBits && this.leastSignificantBits == that.leastSignificantBits;
        }

        public int hashCode() {
            return Objects.hash(this.mostSignificantBits, this.leastSignificantBits);
        }

        @Override
        public int compareTo(@Nonnull UnsignedUUID that) {
            int msbCompare = Long.compareUnsigned(this.mostSignificantBits, that.mostSignificantBits);
            if (msbCompare != 0) {
                return msbCompare;
            }
            return Long.compareUnsigned(this.leastSignificantBits, that.leastSignificantBits);
        }
    }

    public static enum Type {
        EQUALS(true),
        NOT_EQUALS,
        LESS_THAN,
        LESS_THAN_OR_EQUALS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUALS,
        STARTS_WITH,
        NOT_NULL(false, true),
        IS_NULL(true, true),
        IN,
        TEXT_CONTAINS_ALL(true),
        TEXT_CONTAINS_ALL_WITHIN(true),
        TEXT_CONTAINS_ANY(true),
        TEXT_CONTAINS_PHRASE(true),
        TEXT_CONTAINS_PREFIX,
        TEXT_CONTAINS_ALL_PREFIXES,
        TEXT_CONTAINS_ANY_PREFIX,
        SORT(false),
        LIKE,
        IS_DISTINCT_FROM(false),
        NOT_DISTINCT_FROM(true);

        @Nonnull
        private static final Supplier<BiMap<Type, PComparison.PComparisonType>> protoEnumBiMapSupplier;
        private final boolean isEquality;
        private final boolean isUnary;

        private Type() {
            this(false);
        }

        private Type(boolean isEquality) {
            this(isEquality, false);
        }

        private Type(boolean isEquality, boolean isUnary) {
            this.isEquality = isEquality;
            this.isUnary = isUnary;
        }

        public boolean isEquality() {
            return this.isEquality;
        }

        public boolean isUnary() {
            return this.isUnary;
        }

        @Nonnull
        public PComparison.PComparisonType toProto(@Nonnull PlanSerializationContext serializationContext) {
            return Objects.requireNonNull((PComparison.PComparisonType)Type.getProtoEnumBiMap().get((Object)this));
        }

        @Nonnull
        public static Type fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PComparison.PComparisonType physicalOperatorProto) {
            return Objects.requireNonNull((Type)((Object)Type.getProtoEnumBiMap().inverse().get(physicalOperatorProto)));
        }

        @Nonnull
        private static BiMap<Type, PComparison.PComparisonType> getProtoEnumBiMap() {
            return protoEnumBiMapSupplier.get();
        }

        static {
            protoEnumBiMapSupplier = Suppliers.memoize(() -> PlanSerialization.protoEnumBiMap(Type.class, PComparison.PComparisonType.class));
        }
    }

    public static class ListComparison
    implements Comparison {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("List-Comparison");
        @Nonnull
        private final Type type;
        @Nonnull
        private final List comparand;
        @Nullable
        private final Descriptors.FieldDescriptor.JavaType javaType;
        @Nonnull
        private final Supplier<List> comparandListWithEqualsSupplier;

        public ListComparison(@Nonnull Type type, @Nonnull List comparand) {
            this.type = type;
            switch (this.type) {
                case EQUALS: 
                case STARTS_WITH: 
                case IN: 
                case NOT_EQUALS: {
                    break;
                }
                default: {
                    throw new RecordCoreException("ListComparison only supports EQUALS, NOT_EQUALS, STARTS_WITH and IN", new Object[0]);
                }
            }
            if (this.type == Type.IN && comparand.stream().anyMatch(o -> o == null)) {
                throw new NullPointerException("List comparand contains null");
            }
            if (comparand.isEmpty()) {
                this.javaType = null;
            } else {
                this.javaType = ListComparison.getJavaType(comparand.get(0));
                for (Object o2 : comparand) {
                    if (ListComparison.getJavaType(o2) == this.javaType) continue;
                    throw new RecordCoreException("all comparand values must have the same type, first was " + String.valueOf((Object)this.javaType) + " found another of type " + String.valueOf((Object)ListComparison.getJavaType(o2)), new Object[0]);
                }
            }
            this.comparand = comparand;
            this.comparandListWithEqualsSupplier = Suppliers.memoize(() -> Lists.transform(comparand, obj -> obj != null ? Comparisons.toClassWithRealEquals(obj) : null));
        }

        private static Descriptors.FieldDescriptor.JavaType getJavaType(@Nonnull Object o) {
            if (o instanceof Boolean) {
                return Descriptors.FieldDescriptor.JavaType.BOOLEAN;
            }
            if (o instanceof ByteString || o instanceof byte[]) {
                return Descriptors.FieldDescriptor.JavaType.BYTE_STRING;
            }
            if (o instanceof Double) {
                return Descriptors.FieldDescriptor.JavaType.DOUBLE;
            }
            if (o instanceof Float) {
                return Descriptors.FieldDescriptor.JavaType.FLOAT;
            }
            if (o instanceof Long) {
                return Descriptors.FieldDescriptor.JavaType.LONG;
            }
            if (o instanceof Integer) {
                return Descriptors.FieldDescriptor.JavaType.INT;
            }
            if (o instanceof String) {
                return Descriptors.FieldDescriptor.JavaType.STRING;
            }
            if (o instanceof Internal.EnumLite) {
                return Descriptors.FieldDescriptor.JavaType.ENUM;
            }
            throw new RecordCoreException(String.valueOf(o.getClass()) + " is an invalid type for a comparand", new Object[0]);
        }

        @Override
        public void validate(@Nonnull Descriptors.FieldDescriptor fieldDescriptor, boolean fannedOut) {
            if (this.type.equals((Object)Type.IN)) {
                if (!fannedOut && fieldDescriptor.isRepeated()) {
                    throw new RecordCoreException("In comparison with non-scalar field " + fieldDescriptor.getName(), new Object[0]);
                }
            } else if (!fieldDescriptor.isRepeated() || fannedOut) {
                throw new RecordCoreException("Invalid list comparison on scalar field " + fieldDescriptor.getName(), new Object[0]);
            }
            if (this.javaType != null && this.javaType != fieldDescriptor.getJavaType()) {
                throw new RecordCoreException("Value " + String.valueOf(this.comparand) + " not of correct type for " + fieldDescriptor.getFullName(), new Object[0]);
            }
        }

        @Override
        @Nonnull
        public List getComparand(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            return this.comparand;
        }

        @Nonnull
        public List getComparandWithRealEquals() {
            return this.comparandListWithEqualsSupplier.get();
        }

        @Override
        @Nonnull
        public Optional<Comparison> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> replacementFunction) {
            return Optional.of(this);
        }

        @Override
        @Nonnull
        public Comparison translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
            return this;
        }

        @Override
        @Nonnull
        public Type getType() {
            return this.type;
        }

        @Override
        @Nonnull
        public Comparison withType(@Nonnull Type newType) {
            if (this.type == newType) {
                return this;
            }
            return new ListComparison(newType, this.comparand);
        }

        @Override
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, @Nullable Object value) {
            return Comparisons.evalListComparison(this.type, value, (List)this.getComparand((FDBRecordStoreBase)store, context));
        }

        @Override
        @Nonnull
        public String typelessString() {
            return this.comparand.toString();
        }

        public String toString() {
            return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword(this.type.name()).addWhitespace().addIdentifier(this.typelessString()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListComparison that = (ListComparison)o;
            return this.type == that.type && Objects.equals(this.getComparandWithRealEquals(), that.getComparandWithRealEquals()) && this.javaType == that.javaType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.getComparandWithRealEquals(), this.javaType});
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.type.name().hashCode() + PlanHashable.iterablePlanHash(mode, this.comparand) + PlanHashable.objectPlanHash(mode, (Object)this.javaType);
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.type, this.comparand, this.javaType});
                }
            }
            throw new UnsupportedOperationException("Hash Kind " + mode.name() + " is not supported");
        }

        @Override
        @Nonnull
        public PListComparison toProto(@Nonnull PlanSerializationContext serializationContext) {
            PListComparison.Builder builder = PListComparison.newBuilder().setType(this.type.toProto(serializationContext));
            for (Object element : this.comparand) {
                builder.addComparand(PlanSerialization.valueObjectToProto(element));
            }
            return builder.build();
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            return PComparison.newBuilder().setListComparison(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static ListComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PListComparison listComparisonProto) {
            ArrayList<Object> comparand = Lists.newArrayList();
            for (int i = 0; i < listComparisonProto.getComparandCount(); ++i) {
                comparand.add(PlanSerialization.protoToValueObject(listComparisonProto.getComparand(i)));
            }
            return new ListComparison(Type.fromProto(serializationContext, Objects.requireNonNull(listComparisonProto.getType())), comparand);
        }

        public static class Deserializer
        implements PlanDeserializer<PListComparison, ListComparison> {
            @Override
            @Nonnull
            public Class<PListComparison> getProtoMessageClass() {
                return PListComparison.class;
            }

            @Override
            @Nonnull
            public ListComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PListComparison listComparisonProto) {
                return ListComparison.fromProto(serializationContext, listComparisonProto);
            }
        }
    }

    public static interface Comparison
    extends WithValue<Comparison>,
    PlanHashable,
    Correlated<Comparison>,
    UsesValueEquivalence<Comparison>,
    PlanSerializable {
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> var1, @Nonnull EvaluationContext var2, @Nullable Object var3);

        public void validate(@Nonnull Descriptors.FieldDescriptor var1, boolean var2);

        @Nonnull
        public Type getType();

        @Nonnull
        public Comparison withType(@Nonnull Type var1);

        @Override
        @Nullable
        default public Value getValue() {
            return null;
        }

        @Override
        @Nonnull
        default public Comparison withValue(@Nonnull Value value) {
            throw new RecordCoreException("withValue is not implemented", new Object[0]);
        }

        @Nonnull
        public Optional<Comparison> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> var1);

        @Nullable
        default public Object getComparand() {
            return this.getComparand(null, null);
        }

        @Nullable
        public Object getComparand(@Nullable FDBRecordStoreBase<?> var1, @Nullable EvaluationContext var2);

        default public boolean hasMultiColumnComparand() {
            return false;
        }

        @Nonnull
        public String typelessString();

        @Nonnull
        default public Comparison withParameterRelationshipMap(@Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
            return this;
        }

        @Override
        @Nonnull
        default public Set<CorrelationIdentifier> getCorrelatedTo() {
            return ImmutableSet.of();
        }

        @Override
        @Nonnull
        default public Comparison rebase(@Nonnull AliasMap translationMap) {
            return this.translateCorrelations(TranslationMap.rebaseWithAliasMap(translationMap), false);
        }

        @Nonnull
        public Comparison translateCorrelations(@Nonnull TranslationMap var1, boolean var2);

        @Override
        default public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
            return this.semanticEquals(other, ValueEquivalence.fromAliasMap(aliasMap)).isTrue();
        }

        @Override
        @Nonnull
        default public ConstrainedBoolean semanticEqualsTyped(@Nonnull Comparison other, @Nonnull ValueEquivalence valueEquivalence) {
            return this.equals(other) ? ConstrainedBoolean.alwaysTrue() : ConstrainedBoolean.falseValue();
        }

        @Override
        default public int semanticHashCode() {
            return this.hashCode();
        }

        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext var1);

        @Nonnull
        public static Comparison fromComparisonProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PComparison comparisonProto) {
            return (Comparison)PlanSerialization.dispatchFromProtoContainer(serializationContext, comparisonProto);
        }

        @Nonnull
        public ExplainTokensWithPrecedence explain();
    }

    @API(value=API.Status.INTERNAL)
    public static class InvertedFunctionComparison
    implements Comparison {
        @Nonnull
        private final InvertibleFunctionKeyExpression function;
        @Nonnull
        private final Comparison originalComparison;
        @Nonnull
        private final Type type;

        private InvertedFunctionComparison(@Nonnull InvertibleFunctionKeyExpression function, @Nonnull Comparison originalComparison, @Nonnull Type type) {
            this.function = function;
            this.originalComparison = originalComparison;
            this.type = type;
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            return PlanHashable.planHash(mode, this.function, this.originalComparison);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvertedFunctionComparison that = (InvertedFunctionComparison)o;
            return Objects.equals(this.function, that.function) && Objects.equals(this.originalComparison, that.originalComparison);
        }

        public int hashCode() {
            return Objects.hash(this.function, this.originalComparison);
        }

        @Override
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, @Nullable Object value) {
            Object comparand = this.getComparand(store, context);
            return Comparisons.evalComparison(this.type, value, comparand);
        }

        @Override
        public void validate(@Nonnull Descriptors.FieldDescriptor descriptor, boolean fannedOut) {
            this.originalComparison.validate(descriptor, fannedOut);
        }

        @Override
        @Nonnull
        public Type getType() {
            return this.type;
        }

        @Override
        @Nonnull
        public Comparison withType(@Nonnull Type newType) {
            return InvertedFunctionComparison.from(this.function, this.originalComparison.withType(newType));
        }

        @Override
        @Nonnull
        public Comparison withValue(@Nonnull Value value) {
            Comparison newComparison = this.originalComparison.withValue(value);
            if (newComparison == this.originalComparison) {
                return this;
            }
            return InvertedFunctionComparison.from(this.function, newComparison);
        }

        @Override
        @Nullable
        public Object getComparand(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            Object originalComparandValue = this.originalComparison.getComparand(store, context);
            if (this.originalComparison.getType() == Type.IN) {
                if (!(originalComparandValue instanceof List)) {
                    throw new RecordCoreException("cannot evaluate IN comparison on non-list type", new Object[0]);
                }
                List underlyingList = (List)originalComparandValue;
                ArrayList finalValues = new ArrayList(underlyingList.size());
                for (Object obj : underlyingList) {
                    Key.Evaluated evaluated = Key.Evaluated.scalar(obj);
                    List<Key.Evaluated> inverse = this.function.evaluateInverse(evaluated);
                    inverse.stream().map(this::getSingletonPreImage).forEach(finalValues::add);
                }
                return finalValues;
            }
            Key.Evaluated evaluated = Key.Evaluated.scalar(originalComparandValue);
            List<Key.Evaluated> inverse = this.function.evaluateInverse(evaluated);
            if (this.getType() == Type.IN) {
                return inverse.stream().map(this::getSingletonPreImage).collect(Collectors.toList());
            }
            Key.Evaluated preImage = inverse.get(0);
            return this.getSingletonPreImage(preImage);
        }

        private Object getSingletonPreImage(Key.Evaluated preImage) {
            if (preImage.size() != 1) {
                throw new RecordCoreException("unable to get singleton pre-image for function", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FUNCTION, this.function.getName()});
            }
            return preImage.getObject(0);
        }

        @Override
        @Nonnull
        public String typelessString() {
            return this.function.getName() + "^-1(" + this.originalComparison.typelessString() + ")";
        }

        public String toString() {
            return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword(this.type.name()).addWhitespace().addIdentifier(this.typelessString()));
        }

        @Override
        @Nonnull
        public Optional<Comparison> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> replacementFunction) {
            return this.originalComparison.replaceValuesMaybe(replacementFunction).map(translatedOriginalComparison -> {
                if (translatedOriginalComparison == this.originalComparison) {
                    return this;
                }
                return new InvertedFunctionComparison(this.function, (Comparison)translatedOriginalComparison, this.type);
            });
        }

        @Override
        @Nonnull
        public Comparison translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
            Comparison translated = this.originalComparison.translateCorrelations(translationMap, shouldSimplifyValues);
            if (translated == this.originalComparison) {
                return this;
            }
            return new InvertedFunctionComparison(this.function, translated, this.type);
        }

        @Override
        @Nonnull
        public PInvertedFunctionComparison toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PInvertedFunctionComparison.newBuilder().setFunction(this.function.toProto()).setOriginalComparison(this.originalComparison.toComparisonProto(serializationContext)).setType(this.type.toProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            return PComparison.newBuilder().setInvertedFunctionComparison(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static InvertedFunctionComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInvertedFunctionComparison invertedFunctionComparisonProto) {
            return new InvertedFunctionComparison((InvertibleFunctionKeyExpression)InvertibleFunctionKeyExpression.fromProto(Objects.requireNonNull(invertedFunctionComparisonProto.getFunction())), Comparison.fromComparisonProto(serializationContext, Objects.requireNonNull(invertedFunctionComparisonProto.getOriginalComparison())), Type.fromProto(serializationContext, Objects.requireNonNull(invertedFunctionComparisonProto.getType())));
        }

        public static InvertedFunctionComparison from(@Nonnull InvertibleFunctionKeyExpression function, @Nonnull Comparison originalComparison) {
            if (function.getMinArguments() != 1 || function.getMaxArguments() != 1 || function.getColumnSize() != 1) {
                throw new RecordCoreArgumentException("only unary functions can be inverted", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FUNCTION, function.getName()});
            }
            Type underlyingType = originalComparison.getType();
            if (underlyingType != Type.IN && underlyingType != Type.EQUALS) {
                throw new RecordCoreArgumentException("cannot create inverted function comparison of given comparison type", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.FUNCTION, function.getName()}).addLogInfo(new Object[]{LogMessageKeys.COMPARISON_TYPE, underlyingType});
            }
            Type newType = function.isInjective() ? underlyingType : Type.IN;
            return new InvertedFunctionComparison(function, originalComparison, newType);
        }

        public static class Deserializer
        implements PlanDeserializer<PInvertedFunctionComparison, InvertedFunctionComparison> {
            @Override
            @Nonnull
            public Class<PInvertedFunctionComparison> getProtoMessageClass() {
                return PInvertedFunctionComparison.class;
            }

            @Override
            @Nonnull
            public InvertedFunctionComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PInvertedFunctionComparison invertedFunctionComparisonProto) {
                return InvertedFunctionComparison.fromProto(serializationContext, invertedFunctionComparisonProto);
            }
        }
    }

    public static class MultiColumnComparison
    implements Comparison {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Multi-Column-Comparison");
        @Nonnull
        private final Comparison inner;

        public MultiColumnComparison(@Nonnull Comparison inner) {
            this.inner = inner;
        }

        @Override
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, @Nullable Object value) {
            return this.inner.eval(store, context, value);
        }

        @Override
        public void validate(@Nonnull Descriptors.FieldDescriptor descriptor, boolean fannedOut) {
            this.inner.validate(descriptor, fannedOut);
        }

        @Override
        @Nonnull
        public Type getType() {
            return this.inner.getType();
        }

        @Override
        @Nonnull
        public Comparison withType(@Nonnull Type newType) {
            Comparison newInner = this.inner.withType(newType);
            if (newInner == this.inner) {
                return this;
            }
            return new MultiColumnComparison(newInner);
        }

        @Override
        @Nonnull
        public Comparison withValue(@Nonnull Value value) {
            Comparison newInner = this.inner.withValue(value);
            if (newInner == this.inner) {
                return this;
            }
            return new MultiColumnComparison(newInner);
        }

        @Override
        @Nonnull
        public Optional<Comparison> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> replacementFunction) {
            return this.inner.replaceValuesMaybe(replacementFunction).map(replacedInner -> {
                if (replacedInner == this.inner) {
                    return this;
                }
                return new MultiColumnComparison((Comparison)replacedInner);
            });
        }

        @Override
        @Nonnull
        public Comparison translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
            Comparison translatedInner = this.inner.translateCorrelations(translationMap, shouldSimplifyValues);
            if (this.inner == translatedInner) {
                return this;
            }
            return new MultiColumnComparison(translatedInner);
        }

        @Override
        @Nonnull
        public Set<CorrelationIdentifier> getCorrelatedTo() {
            return this.inner.getCorrelatedTo();
        }

        @Override
        @Nonnull
        public ConstrainedBoolean semanticEqualsTyped(@Nonnull Comparison other, @Nonnull ValueEquivalence valueEquivalence) {
            MultiColumnComparison that = (MultiColumnComparison)other;
            return this.inner.semanticEquals((Object)that.inner, valueEquivalence);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.inner.planHash(mode);
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.inner);
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }

        @Override
        @Nullable
        public Object getComparand() {
            return this.inner.getComparand();
        }

        @Override
        @Nullable
        public Object getComparand(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            return this.inner.getComparand(store, context);
        }

        @Override
        public boolean hasMultiColumnComparand() {
            return true;
        }

        @Override
        @Nonnull
        public String typelessString() {
            return this.inner.typelessString();
        }

        public int hashCode() {
            return this.inner.hashCode();
        }

        @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
        public boolean equals(Object o) {
            return this.semanticEquals(o, AliasMap.emptyMap());
        }

        public String toString() {
            return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return this.inner.explain();
        }

        @Override
        @Nonnull
        public PMultiColumnComparison toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PMultiColumnComparison.newBuilder().setInner(this.inner.toComparisonProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            return PComparison.newBuilder().setMultiColumnComparison(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static MultiColumnComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMultiColumnComparison multiColumnComparisonProto) {
            return new MultiColumnComparison(Comparison.fromComparisonProto(serializationContext, Objects.requireNonNull(multiColumnComparisonProto.getInner())));
        }

        public static class Deserializer
        implements PlanDeserializer<PMultiColumnComparison, MultiColumnComparison> {
            @Override
            @Nonnull
            public Class<PMultiColumnComparison> getProtoMessageClass() {
                return PMultiColumnComparison.class;
            }

            @Override
            @Nonnull
            public MultiColumnComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PMultiColumnComparison multiColumnComparisonProto) {
                return MultiColumnComparison.fromProto(serializationContext, multiColumnComparisonProto);
            }
        }
    }

    @API(value=API.Status.EXPERIMENTAL)
    public static class TextContainsAllPrefixesComparison
    extends TextComparison {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Text-Contains-All-Prefixes-Comparison");
        private final boolean strict;
        private final long expectedRecords;
        private final double falsePositivePercentage;

        public TextContainsAllPrefixesComparison(@Nonnull String tokenPrefixes, boolean strict, @Nullable String tokenizerName, @Nonnull String fallbackTokenizerName) {
            this(tokenPrefixes, strict, 500L, 0.01, tokenizerName, fallbackTokenizerName);
        }

        public TextContainsAllPrefixesComparison(@Nonnull String tokenPrefixes, boolean strict, long expectedRecords, double falsePositivePercentage, @Nullable String tokenizerName, @Nonnull String fallbackTokenizerName) {
            super(Type.TEXT_CONTAINS_ALL_PREFIXES, tokenPrefixes, tokenizerName, fallbackTokenizerName);
            this.strict = strict;
            this.expectedRecords = expectedRecords;
            this.falsePositivePercentage = falsePositivePercentage;
        }

        public TextContainsAllPrefixesComparison(@Nonnull List<String> tokenPrefixes, boolean strict, @Nullable String tokenizerName, @Nonnull String fallbackTokenizerName) {
            this(tokenPrefixes, strict, 500L, 0.01, tokenizerName, fallbackTokenizerName);
        }

        public TextContainsAllPrefixesComparison(@Nonnull List<String> tokenPrefixes, boolean strict, long expectedRecords, double falsePositivePercentage, @Nullable String tokenizerName, @Nonnull String fallbackTokenizerName) {
            super(Type.TEXT_CONTAINS_ALL_PREFIXES, tokenPrefixes, tokenizerName, fallbackTokenizerName);
            this.strict = strict;
            this.expectedRecords = expectedRecords;
            this.falsePositivePercentage = falsePositivePercentage;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public long getExpectedRecords() {
            return this.expectedRecords;
        }

        public double getFalsePositivePercentage() {
            return this.falsePositivePercentage;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextContainsAllPrefixesComparison that = (TextContainsAllPrefixesComparison)o;
            return super.equals(that) && this.strict == that.strict;
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return super.planHash(mode) * (this.strict ? -1 : 1);
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, super.planHash(mode), this.strict);
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }

        @Override
        public int hashCode() {
            return super.hashCode() * (this.strict ? -1 : 1);
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            ExplainTokens resultExplainTokens = new ExplainTokens().addKeyword(this.getType().name()).addOptionalWhitespace().addOpeningParen().addOpeningParen();
            if (this.strict) {
                resultExplainTokens.addKeyword("STRICTLY");
            } else {
                resultExplainTokens.addKeyword("APPROXIMATELY");
            }
            resultExplainTokens.addOptionalWhitespace().addClosingParen().addWhitespace().addIdentifier(this.typelessString());
            return ExplainTokensWithPrecedence.of(resultExplainTokens);
        }
    }

    public static class TextWithMaxDistanceComparison
    extends TextComparison {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Text-With-Max-Distance-Comparison");
        private final int maxDistance;

        public TextWithMaxDistanceComparison(@Nonnull String tokens, int maxDistance, @Nullable String tokenizerName, @Nonnull String fallbackTokenizerName) {
            super(Type.TEXT_CONTAINS_ALL_WITHIN, tokens, tokenizerName, fallbackTokenizerName);
            this.maxDistance = maxDistance;
        }

        public TextWithMaxDistanceComparison(@Nonnull List<String> tokens, int maxDistance, @Nullable String tokenizerName, @Nonnull String fallbackTokenizerName) {
            super(Type.TEXT_CONTAINS_ALL_WITHIN, tokens, tokenizerName, fallbackTokenizerName);
            this.maxDistance = maxDistance;
        }

        @Override
        Boolean evalComparison(@Nonnull Iterator<? extends CharSequence> textIterator, @Nonnull List<String> comparand) {
            if (this.getType() != Type.TEXT_CONTAINS_ALL_WITHIN) {
                throw new RecordCoreException("Cannot evaluate text comparison of type: " + String.valueOf((Object)this.getType()), new Object[0]);
            }
            return Comparisons.compareTextContainsAllWithin(textIterator, comparand, this.maxDistance);
        }

        public int getMaxDistance() {
            return this.maxDistance;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextWithMaxDistanceComparison that = (TextWithMaxDistanceComparison)o;
            return super.equals(that) && this.maxDistance == that.maxDistance;
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return super.planHash(mode) * 31 + this.maxDistance;
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, super.planHash(mode), this.maxDistance);
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.maxDistance;
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword(this.getType().name()).addOptionalWhitespace().addOpeningParen().addOptionalWhitespace().addToString(this.maxDistance).addOptionalWhitespace().addClosingParen().addWhitespace().addIdentifier(this.typelessString()));
        }
    }

    public static class TextComparison
    implements Comparison {
        private static final TextTokenizerRegistry TOKENIZER_REGISTRY = TextTokenizerRegistryImpl.instance();
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Text-Comparison");
        @Nonnull
        private final Type type;
        @Nullable
        private final List<String> tokenList;
        @Nullable
        private final String tokenStr;
        @Nullable
        private final String tokenizerName;
        @Nonnull
        private final String fallbackTokenizerName;

        public TextComparison(@Nonnull Type type, @Nonnull String tokens, @Nullable String tokenizerName, @Nonnull String fallbackTokenizerName) {
            this.type = type;
            this.tokenList = null;
            this.tokenStr = tokens;
            this.tokenizerName = tokenizerName;
            this.fallbackTokenizerName = fallbackTokenizerName;
        }

        public TextComparison(@Nonnull Type type, @Nonnull List<String> tokens, @Nullable String tokenizerName, @Nonnull String fallbackTokenizerName) {
            this.type = type;
            this.tokenList = tokens;
            this.tokenStr = null;
            this.tokenizerName = tokenizerName;
            this.fallbackTokenizerName = fallbackTokenizerName;
        }

        @Override
        @Nonnull
        public Optional<Comparison> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> replacementFunction) {
            return Optional.of(this);
        }

        @Override
        @Nonnull
        public Comparison translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
            return this;
        }

        @Nonnull
        private Iterator<? extends CharSequence> tokenize(@Nonnull String text, @Nonnull TextTokenizer.TokenizerMode tokenizerMode) {
            TextTokenizer tokenizer = TOKENIZER_REGISTRY.getTokenizer(this.tokenizerName == null ? this.fallbackTokenizerName : this.tokenizerName);
            return tokenizer.tokenize(text, tokenizer.getMaxVersion(), tokenizerMode);
        }

        @Nullable
        Boolean evalComparison(@Nonnull Iterator<? extends CharSequence> textIterator, @Nonnull List<String> comparand) {
            switch (this.type) {
                case TEXT_CONTAINS_ALL: {
                    return Comparisons.compareTextContainsAll(textIterator, comparand);
                }
                case TEXT_CONTAINS_ANY: {
                    return Comparisons.compareTextContainsAny(textIterator, comparand);
                }
                case TEXT_CONTAINS_PHRASE: {
                    return Comparisons.compareTextContainsPhrase(textIterator, comparand);
                }
                case TEXT_CONTAINS_PREFIX: {
                    if (comparand.size() != 1) {
                        throw new RecordCoreArgumentException("Cannot evaluate prefix comparison with multiple tokens", new Object[0]);
                    }
                    return Comparisons.compareTextContainsPrefix(textIterator, comparand.get(0));
                }
                case TEXT_CONTAINS_ANY_PREFIX: {
                    return Comparisons.compareTextContainsAnyPrefix(textIterator, comparand);
                }
                case TEXT_CONTAINS_ALL_PREFIXES: {
                    return Comparisons.compareTextContainsAllPrefixes(textIterator, comparand);
                }
            }
            throw new RecordCoreException("Cannot evaluate text comparison of type: " + String.valueOf((Object)this.type), new Object[0]);
        }

        @Override
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, @Nullable Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof String)) {
                throw new RecordCoreArgumentException("Text comparison applied against non-string value", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.COMPARISON_VALUE, value});
            }
            List<String> comparandTokens = this.getComparandTokens();
            if (comparandTokens == null) {
                return null;
            }
            String text = (String)value;
            Iterator<? extends CharSequence> textIterator = this.tokenize(text, TextTokenizer.TokenizerMode.INDEX);
            return this.evalComparison(textIterator, comparandTokens);
        }

        @Override
        public void validate(@Nonnull Descriptors.FieldDescriptor descriptor, boolean fannedOut) {
            if (descriptor.getType() != Descriptors.FieldDescriptor.Type.STRING) {
                throw new RecordCoreException("Text comparison on non-string field", new Object[0]);
            }
            if (!fannedOut && descriptor.isRepeated()) {
                throw new RecordCoreException("Text comparison on repeated field without fan out", new Object[0]);
            }
        }

        @Nullable
        public String getTokenizerName() {
            return this.tokenizerName;
        }

        @Nonnull
        public String getFallbackTokenizerName() {
            return this.fallbackTokenizerName;
        }

        @Override
        @Nonnull
        public Type getType() {
            return this.type;
        }

        @Override
        @Nonnull
        public Comparison withType(@Nonnull Type newType) {
            if (this.type == newType) {
                return this;
            }
            if (this.tokenList == null) {
                return new TextComparison(newType, Objects.requireNonNull(this.tokenStr), this.tokenizerName, this.fallbackTokenizerName);
            }
            return new TextComparison(newType, this.tokenList, this.tokenizerName, this.fallbackTokenizerName);
        }

        @Nullable
        private List<String> getComparandTokens() {
            if (this.tokenList != null) {
                return this.tokenList;
            }
            if (this.tokenStr != null) {
                return Lists.newArrayList(Iterators.transform(this.tokenize(this.tokenStr, TextTokenizer.TokenizerMode.QUERY), CharSequence::toString));
            }
            return null;
        }

        @Override
        @Nullable
        public Object getComparand(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            if (this.tokenList != null) {
                return this.tokenList;
            }
            return this.tokenStr;
        }

        @Override
        @Nonnull
        public String typelessString() {
            Object comparand = this.getComparand(null, EvaluationContext.EMPTY);
            if (comparand == null) {
                return "null";
            }
            return comparand.toString();
        }

        public String toString() {
            return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword(this.type.name()).addWhitespace().addIdentifier(this.typelessString()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextComparison that = (TextComparison)o;
            return this.type == that.type && Objects.equals(this.getComparand(), that.getComparand()) && Objects.equals(this.tokenizerName, that.tokenizerName) && Objects.equals(this.fallbackTokenizerName, that.fallbackTokenizerName);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return PlanHashable.objectsPlanHash(mode, new Object[]{this.type, this.getComparand(), this.tokenizerName, this.fallbackTokenizerName});
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.type, this.getComparand(), this.tokenizerName, this.fallbackTokenizerName});
                }
            }
            throw new UnsupportedOperationException("Hash Kind " + mode.name() + " is not supported");
        }

        public int hashCode() {
            return Objects.hash(this.type.name(), this.getComparand(), this.tokenizerName, this.fallbackTokenizerName);
        }

        @Override
        @Nonnull
        public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
            throw new RecordCoreException("serialization of comparison of this kind is not supported", new Object[0]);
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            throw new RecordCoreException("serialization of comparison of this kind is not supported", new Object[0]);
        }
    }

    public static class OpaqueEqualityComparison
    implements Comparison {
        @Override
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, @Nullable Object value) {
            return false;
        }

        @Override
        public void validate(@Nonnull Descriptors.FieldDescriptor descriptor, boolean fannedOut) {
            throw new UnsupportedOperationException("comparison should not be used in a plan");
        }

        @Override
        @Nonnull
        public Type getType() {
            return Type.EQUALS;
        }

        @Override
        @Nonnull
        public Comparison withType(@Nonnull Type newType) {
            return this;
        }

        @Override
        @Nullable
        public Object getComparand(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            return null;
        }

        @Override
        @Nonnull
        public Optional<Comparison> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> replacementFunction) {
            return Optional.of(this);
        }

        @Override
        @Nonnull
        public Comparison translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
            return this;
        }

        @Override
        @Nonnull
        public String typelessString() {
            return ":?:";
        }

        public String toString() {
            return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword(Type.EQUALS.name()).addWhitespace().addIdentifier(this.typelessString()));
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            throw new UnsupportedOperationException("Hash Kind " + mode.name() + " is not supported");
        }

        @Override
        @Nonnull
        public POpaqueEqualityComparison toProto(@Nonnull PlanSerializationContext serializationContext) {
            return POpaqueEqualityComparison.newBuilder().build();
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            return PComparison.newBuilder().setOpaqueEqualityComparison(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static OpaqueEqualityComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull POpaqueEqualityComparison opaqueEqualityComparisonProto) {
            return new OpaqueEqualityComparison();
        }

        public static class Deserializer
        implements PlanDeserializer<POpaqueEqualityComparison, OpaqueEqualityComparison> {
            @Override
            @Nonnull
            public Class<POpaqueEqualityComparison> getProtoMessageClass() {
                return POpaqueEqualityComparison.class;
            }

            @Override
            @Nonnull
            public OpaqueEqualityComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull POpaqueEqualityComparison opaqueEqualityComparisonProto) {
                return OpaqueEqualityComparison.fromProto(serializationContext, opaqueEqualityComparisonProto);
            }
        }
    }

    public static class NullComparison
    implements Comparison {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Null-Comparison");
        @Nonnull
        private final Type type;

        public NullComparison(@Nonnull Type type) {
            this.type = type;
        }

        @Override
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, @Nullable Object value) {
            if (this.type == Type.IS_NULL) {
                return value == null;
            }
            return value != null;
        }

        @Override
        public void validate(@Nonnull Descriptors.FieldDescriptor descriptor, boolean fannedOut) {
            if (!fannedOut && descriptor.isRepeated()) {
                throw new RecordCoreException("Nullability comparison on repeated field " + descriptor.getName(), new Object[0]);
            }
        }

        @Override
        @Nonnull
        public Type getType() {
            return this.type;
        }

        @Override
        @Nonnull
        public Comparison withType(@Nonnull Type newType) {
            if (this.type == newType) {
                return this;
            }
            return new NullComparison(newType);
        }

        @Override
        @Nullable
        public Object getComparand(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            return null;
        }

        @Override
        @Nonnull
        public Optional<Comparison> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> replacementFunction) {
            return Optional.of(this);
        }

        @Override
        @Nonnull
        public Comparison translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
            return this;
        }

        @Override
        @Nonnull
        public String typelessString() {
            return "NULL";
        }

        public String toString() {
            return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword(this.type.name()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NullComparison that = (NullComparison)o;
            return this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(this.type.name());
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.type.name().hashCode();
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.type});
                }
            }
            throw new UnsupportedOperationException("Hash Kind " + mode.name() + " is not supported");
        }

        @Override
        @Nonnull
        public PNullComparison toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PNullComparison.newBuilder().setType(this.type.toProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            return PComparison.newBuilder().setNullComparison(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static NullComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNullComparison nullComparisonProto) {
            return new NullComparison(Type.fromProto(serializationContext, Objects.requireNonNull(nullComparisonProto.getType())));
        }

        public static class Deserializer
        implements PlanDeserializer<PNullComparison, NullComparison> {
            @Override
            @Nonnull
            public Class<PNullComparison> getProtoMessageClass() {
                return PNullComparison.class;
            }

            @Override
            @Nonnull
            public NullComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PNullComparison nullComparisonProto) {
                return NullComparison.fromProto(serializationContext, nullComparisonProto);
            }
        }
    }

    public static class ValueComparison
    implements Comparison {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Value-Comparison");
        @Nonnull
        private final Type type;
        @Nonnull
        private final Value comparandValue;
        @Nonnull
        protected final ParameterRelationshipGraph parameterRelationshipGraph;
        @Nonnull
        private final Supplier<Integer> hashCodeSupplier;

        public ValueComparison(@Nonnull Type type, @Nonnull Value comparandValue) {
            this(type, comparandValue, ParameterRelationshipGraph.unbound());
        }

        public ValueComparison(@Nonnull Type type, @Nonnull Value comparandValue, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
            this.type = type;
            this.comparandValue = comparandValue;
            if (type.isUnary()) {
                throw new RecordCoreException("Unary comparison type " + String.valueOf((Object)type) + " cannot be bound to a value", new Object[0]);
            }
            this.parameterRelationshipGraph = parameterRelationshipGraph;
            this.hashCodeSupplier = Suppliers.memoize(this::computeHashCode);
        }

        @Override
        public void validate(@Nonnull Descriptors.FieldDescriptor descriptor, boolean fannedOut) {
        }

        @Override
        @Nonnull
        public Type getType() {
            return this.type;
        }

        @Override
        @Nonnull
        public Comparison withType(@Nonnull Type newType) {
            if (this.type == newType) {
                return this;
            }
            return new ValueComparison(newType, this.comparandValue, this.parameterRelationshipGraph);
        }

        @Override
        @Nonnull
        public ValueComparison withValue(@Nonnull Value value) {
            if (this.comparandValue == value) {
                return this;
            }
            return new ValueComparison(this.getType(), value);
        }

        @Nonnull
        public Value getComparandValue() {
            return this.comparandValue;
        }

        @Override
        @Nonnull
        public Optional<Comparison> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> replacementFunction) {
            return replacementFunction.apply(this.getValue()).map(replacedComparandValue -> {
                if (replacedComparandValue == this.getValue()) {
                    return this;
                }
                return this.withValue((Value)replacedComparandValue);
            });
        }

        @Override
        @Nullable
        public Object getComparand(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            if (context == null) {
                throw EvaluationContextRequiredException.instance();
            }
            return this.comparandValue.eval(store, context);
        }

        @Override
        @Nonnull
        public Comparison translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
            if (this.comparandValue.getCorrelatedTo().stream().noneMatch(translationMap::containsSourceAlias)) {
                return this;
            }
            return new ValueComparison(this.type, this.comparandValue.translateCorrelations(translationMap, shouldSimplifyValues), this.parameterRelationshipGraph);
        }

        @Override
        @Nonnull
        public Set<CorrelationIdentifier> getCorrelatedTo() {
            return this.comparandValue.getCorrelatedTo();
        }

        @Override
        @Nonnull
        public Value getValue() {
            return this.getComparandValue();
        }

        @Override
        @Nonnull
        public ConstrainedBoolean semanticEqualsTyped(@Nonnull Comparison other, @Nonnull ValueEquivalence valueEquivalence) {
            ValueComparison that = (ValueComparison)other;
            if (this.type != that.type) {
                return ConstrainedBoolean.falseValue();
            }
            return this.comparandValue.semanticEquals((Object)that.comparandValue, valueEquivalence);
        }

        @Override
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, @Nullable Object v) {
            Object comparand = this.getComparand(store, context);
            if (comparand == COMPARISON_SKIPPED_BINDING) {
                return Boolean.TRUE;
            }
            return Comparisons.evalComparison(this.type, v, comparand);
        }

        @Override
        @Nonnull
        public String typelessString() {
            return this.comparandValue.toString();
        }

        public String toString() {
            return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword(this.type.name()).addWhitespace().addNested(this.comparandValue.explain().getExplainTokens()));
        }

        @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
        public boolean equals(Object o) {
            return this.semanticEquals(o, AliasMap.emptyMap());
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public int computeHashCode() {
            return Objects.hash(this.type.name(), this.relatedByEquality());
        }

        private Set<String> relatedByEquality() {
            return ImmutableSet.of();
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: 
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.type});
                }
            }
            throw new UnsupportedOperationException("Hash Kind " + mode.name() + " is not supported");
        }

        @Override
        @Nonnull
        public Comparison withParameterRelationshipMap(@Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
            Verify.verify(this.parameterRelationshipGraph.isUnbound());
            return new ValueComparison(this.type, this.comparandValue, parameterRelationshipGraph);
        }

        @Override
        @Nonnull
        public PValueComparison toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PValueComparison.newBuilder().setType(this.type.toProto(serializationContext)).setComparandValue(this.comparandValue.toValueProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            return PComparison.newBuilder().setValueComparison(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static ValueComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PValueComparison valueComparisonProto) {
            return new ValueComparison(Type.fromProto(serializationContext, Objects.requireNonNull(valueComparisonProto.getType())), Value.fromValueProto(serializationContext, Objects.requireNonNull(valueComparisonProto.getComparandValue())));
        }

        public static class Deserializer
        implements PlanDeserializer<PValueComparison, ValueComparison> {
            @Override
            @Nonnull
            public Class<PValueComparison> getProtoMessageClass() {
                return PValueComparison.class;
            }

            @Override
            @Nonnull
            public ValueComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PValueComparison valueComparisonProto) {
                return ValueComparison.fromProto(serializationContext, valueComparisonProto);
            }
        }
    }

    public static class ParameterComparison
    extends ParameterComparisonBase {
        protected ParameterComparison(@Nonnull Type type, @Nonnull String parameter, @Nullable Bindings.Internal internal, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
            super(type, parameter, internal, parameterRelationshipGraph);
        }

        public ParameterComparison(@Nonnull Type type, @Nonnull String parameter) {
            this(type, parameter, null, ParameterRelationshipGraph.unbound());
        }

        public ParameterComparison(@Nonnull Type type, @Nonnull String parameter, @Nullable Bindings.Internal internal) {
            this(type, parameter, internal, ParameterRelationshipGraph.unbound());
        }

        @Override
        @Nonnull
        public Comparison withType(@Nonnull Type newType) {
            if (this.type == newType) {
                return this;
            }
            return new ParameterComparison(newType, this.parameter, this.internal, this.parameterRelationshipGraph);
        }

        @Override
        @Nonnull
        protected ParameterComparisonBase withTranslatedCorrelation(@Nonnull CorrelationIdentifier translatedAlias) {
            return new ParameterComparison(this.type, Bindings.Internal.CORRELATION.bindingName(translatedAlias.getId()), Bindings.Internal.CORRELATION, this.parameterRelationshipGraph);
        }

        @Override
        @Nonnull
        public Comparison withParameterRelationshipMap(@Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
            Verify.verify(this.parameterRelationshipGraph.isUnbound());
            return new ParameterComparison(this.type, this.parameter, this.internal, parameterRelationshipGraph);
        }

        @Override
        @Nonnull
        public PParameterComparison toProto(@Nonnull PlanSerializationContext serializationContext) {
            PParameterComparison.Builder builder = PParameterComparison.newBuilder().setType(this.type.toProto(serializationContext)).setParameter(this.parameter);
            if (this.internal != null) {
                builder.setInternal(this.internal.toProto(serializationContext));
            }
            return builder.build();
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            return PComparison.newBuilder().setParameterComparison(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static ParameterComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PParameterComparison parameterComparisonProto) {
            Bindings.Internal internal = parameterComparisonProto.hasInternal() ? Bindings.Internal.fromProto(serializationContext, Objects.requireNonNull(parameterComparisonProto.getInternal())) : null;
            return new ParameterComparison(Type.fromProto(serializationContext, Objects.requireNonNull(parameterComparisonProto.getType())), Objects.requireNonNull(parameterComparisonProto.getParameter()), internal);
        }

        public static class Deserializer
        implements PlanDeserializer<PParameterComparison, ParameterComparison> {
            @Override
            @Nonnull
            public Class<PParameterComparison> getProtoMessageClass() {
                return PParameterComparison.class;
            }

            @Override
            @Nonnull
            public ParameterComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PParameterComparison parameterComparisonProto) {
                return ParameterComparison.fromProto(serializationContext, parameterComparisonProto);
            }
        }
    }

    public static abstract class ParameterComparisonBase
    implements ComparisonWithParameter {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Parameter-Comparison");
        @Nonnull
        protected final Type type;
        @Nonnull
        protected final String parameter;
        @Nullable
        protected final Bindings.Internal internal;
        @Nonnull
        protected final ParameterRelationshipGraph parameterRelationshipGraph;
        @Nonnull
        protected final Supplier<Integer> hashCodeSupplier;

        protected ParameterComparisonBase(@Nonnull Type type, @Nonnull String parameter, @Nullable Bindings.Internal internal, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
            ParameterComparisonBase.checkInternalBinding(parameter, internal);
            this.type = type;
            this.parameter = parameter;
            this.internal = internal;
            if (type.isUnary()) {
                throw new RecordCoreException("Unary comparison type " + String.valueOf((Object)type) + " cannot be bound to a parameter", new Object[0]);
            }
            this.parameterRelationshipGraph = parameterRelationshipGraph;
            this.hashCodeSupplier = Suppliers.memoize(this::computeHashCode);
        }

        @Override
        public void validate(@Nonnull Descriptors.FieldDescriptor descriptor, boolean fannedOut) {
        }

        @Override
        @Nonnull
        public Type getType() {
            return this.type;
        }

        public boolean isCorrelation() {
            return this.internal == Bindings.Internal.CORRELATION;
        }

        @Override
        public boolean isCorrelatedTo(@Nonnull CorrelationIdentifier alias) {
            if (!this.isCorrelation()) {
                return false;
            }
            return Bindings.Internal.CORRELATION.identifier(this.getParameter()).equals(alias.getId());
        }

        @Override
        @Nullable
        public Object getComparand(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            if (context == null) {
                throw EvaluationContextRequiredException.instance();
            }
            if (this.isCorrelation()) {
                return Objects.requireNonNull((QueryResult)context.getBinding(this.parameter)).getDatum();
            }
            return context.getBinding(this.parameter);
        }

        @Override
        @Nonnull
        public Optional<Comparison> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> replacementFunction) {
            if (this.isCorrelation()) {
                return Optional.empty();
            }
            return Optional.of(this);
        }

        @Override
        @Nonnull
        public Comparison translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
            if (this.isCorrelation()) {
                QuantifiedObjectValue translatedQuantifiedObjectValue;
                CorrelationIdentifier alias = CorrelationIdentifier.of(Bindings.Internal.CORRELATION.identifier(this.parameter));
                QuantifiedObjectValue quantifiedObjectValue = QuantifiedObjectValue.of(alias, com.apple.foundationdb.record.query.plan.cascades.typing.Type.any());
                if (quantifiedObjectValue == (translatedQuantifiedObjectValue = (QuantifiedObjectValue)quantifiedObjectValue.translateCorrelations(translationMap, shouldSimplifyValues))) {
                    return this;
                }
                return this.withTranslatedCorrelation(translatedQuantifiedObjectValue.getAlias());
            }
            return this;
        }

        @Nonnull
        protected abstract ParameterComparisonBase withTranslatedCorrelation(@Nonnull CorrelationIdentifier var1);

        @Override
        @Nonnull
        public Set<CorrelationIdentifier> getCorrelatedTo() {
            if (!this.isCorrelation()) {
                return ImmutableSet.of();
            }
            return ImmutableSet.of(this.getAlias());
        }

        @Override
        @Nonnull
        public ConstrainedBoolean semanticEqualsTyped(@Nonnull Comparison other, @Nonnull ValueEquivalence valueEquivalence) {
            ParameterComparisonBase that = (ParameterComparisonBase)other;
            if (this.type != that.type) {
                return ConstrainedBoolean.falseValue();
            }
            if (this.isCorrelation() && that.isCorrelation()) {
                if (this.getAlias().equals(that.getAlias())) {
                    return ConstrainedBoolean.alwaysTrue();
                }
                return valueEquivalence.isDefinedEqual(this.getAlias(), that.getAlias());
            }
            if (!this.getParameter().equals(that.getParameter())) {
                return ConstrainedBoolean.falseValue();
            }
            return Objects.equals(this.relatedByEquality(), that.relatedByEquality()) ? ConstrainedBoolean.alwaysTrue() : ConstrainedBoolean.falseValue();
        }

        @Override
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, @Nullable Object value) {
            Object comparand = this.getComparand(store, context);
            if (comparand == COMPARISON_SKIPPED_BINDING) {
                return Boolean.TRUE;
            }
            return Comparisons.evalComparison(this.type, value, comparand);
        }

        @Override
        @Nonnull
        public String typelessString() {
            return "$" + this.parameter;
        }

        public String toString() {
            return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword(this.type.name()).addWhitespace().addIdentifier(this.typelessString()));
        }

        @Override
        @Nonnull
        public String getParameter() {
            return this.parameter;
        }

        @Nonnull
        public CorrelationIdentifier getAlias() {
            if (!this.isCorrelation()) {
                throw new IllegalStateException("caller should check for type of binding before calling this method");
            }
            return CorrelationIdentifier.of(Bindings.Internal.CORRELATION.identifier(this.parameter));
        }

        @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
        public boolean equals(Object o) {
            return this.semanticEquals(o, AliasMap.emptyMap());
        }

        public int hashCode() {
            return this.hashCodeSupplier.get();
        }

        public int computeHashCode() {
            return Objects.hash(new Object[]{this.type, this.relatedByEquality()});
        }

        private Set<String> relatedByEquality() {
            if (!this.parameterRelationshipGraph.isUnbound() && this.parameterRelationshipGraph.containsParameter(this.parameter)) {
                return this.parameterRelationshipGraph.getRelatedParameters(this.parameter, ParameterRelationshipGraph.RelationshipType.EQUALS);
            }
            return ImmutableSet.of(this.getParameter());
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.type.name().hashCode() + (this.isCorrelation() ? 0 : this.parameter.hashCode());
                }
                case FOR_CONTINUATION: {
                    if (this.isCorrelation()) {
                        return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.type});
                    }
                    return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.type, this.parameter});
                }
            }
            throw new UnsupportedOperationException("Hash Kind " + mode.name() + " is not supported");
        }

        @Nonnull
        private static String checkInternalBinding(@Nonnull String parameter, @Nullable Bindings.Internal internal) {
            if (internal == null && Bindings.Internal.isInternal(parameter)) {
                throw new RecordCoreException("Parameter is internal, parameters cannot start with \"__\"", new Object[0]);
            }
            return parameter;
        }
    }

    public static interface ComparisonWithParameter
    extends Comparison {
        @Nonnull
        public String getParameter();
    }

    public static class EvaluationContextRequiredException
    extends RecordCoreException {
        private static final Supplier<EvaluationContextRequiredException> INSTANCE_SUPPLIER = Suppliers.memoize(() -> new EvaluationContextRequiredException("unable to evaluate comparison without context and/or store"));

        private EvaluationContextRequiredException(String msg) {
            super(msg, null, false, false);
        }

        @Nonnull
        public static EvaluationContextRequiredException instance() {
            return INSTANCE_SUPPLIER.get();
        }
    }

    public static class SimpleComparison
    extends SimpleComparisonBase {
        public SimpleComparison(@Nonnull Type type, @Nonnull Object comparand) {
            super(type, comparand);
        }

        @Override
        @Nonnull
        public Comparison withType(@Nonnull Type newType) {
            if (this.type == newType) {
                return this;
            }
            return new SimpleComparison(newType, this.comparand);
        }

        @Override
        @Nonnull
        public PSimpleComparison toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PSimpleComparison.newBuilder().setType(this.type.toProto(serializationContext)).setObject(PlanSerialization.valueObjectToProto(this.comparand)).build();
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            return PComparison.newBuilder().setSimpleComparison(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static SimpleComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSimpleComparison simpleComparisonProto) {
            return new SimpleComparison(Type.fromProto(serializationContext, Objects.requireNonNull(simpleComparisonProto.getType())), Objects.requireNonNull(PlanSerialization.protoToValueObject(Objects.requireNonNull(simpleComparisonProto.getObject()))));
        }

        public static class Deserializer
        implements PlanDeserializer<PSimpleComparison, SimpleComparison> {
            @Override
            @Nonnull
            public Class<PSimpleComparison> getProtoMessageClass() {
                return PSimpleComparison.class;
            }

            @Override
            @Nonnull
            public SimpleComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PSimpleComparison simpleComparisonProto) {
                return SimpleComparison.fromProto(serializationContext, simpleComparisonProto);
            }
        }
    }

    public static abstract class SimpleComparisonBase
    implements Comparison {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Simple-Comparison");
        @Nonnull
        protected final Type type;
        @Nonnull
        protected final Object comparand;

        protected SimpleComparisonBase(@Nonnull Type type, @Nonnull Object comparand) {
            this.type = type;
            this.comparand = comparand;
        }

        @Override
        public void validate(@Nonnull Descriptors.FieldDescriptor fieldDescriptor, boolean fannedOut) {
            if (!fannedOut && fieldDescriptor.isRepeated()) {
                throw new RecordCoreException("Scalar comparison on repeated field", "fieldName", fieldDescriptor.getFullName(), "comparandType", this.comparand.getClass());
            }
            if (!this.validForComparand(fieldDescriptor)) {
                throw new RecordCoreException("Comparison value of incorrect type", new Object[]{"fieldName", fieldDescriptor.getFullName(), "fieldType", fieldDescriptor.getJavaType(), "comparandType", this.comparand.getClass()});
            }
        }

        private boolean validForComparand(@Nonnull Descriptors.FieldDescriptor fieldDescriptor) {
            switch (fieldDescriptor.getJavaType()) {
                case BOOLEAN: {
                    return this.comparand instanceof Boolean;
                }
                case BYTE_STRING: {
                    return this.comparand instanceof ByteString || this.comparand instanceof byte[];
                }
                case DOUBLE: {
                    return this.comparand instanceof Double;
                }
                case FLOAT: {
                    return this.comparand instanceof Float;
                }
                case INT: {
                    return this.comparand instanceof Integer;
                }
                case LONG: {
                    return this.comparand instanceof Long;
                }
                case STRING: {
                    return this.comparand instanceof String;
                }
                case ENUM: {
                    if (this.comparand instanceof ProtocolMessageEnum) {
                        return fieldDescriptor.getEnumType().equals(((ProtocolMessageEnum)this.comparand).getDescriptorForType());
                    }
                    return this.comparand instanceof ProtoUtils.DynamicEnum;
                }
                case MESSAGE: {
                    Descriptors.Descriptor descriptor = fieldDescriptor.getMessageType();
                    if (!TupleFieldsHelper.isTupleField(descriptor)) {
                        return false;
                    }
                    if (descriptor == TupleFieldsProto.UUID.getDescriptor()) {
                        return this.comparand instanceof UUID;
                    }
                    return this.validForComparand(descriptor.findFieldByName("value"));
                }
            }
            return false;
        }

        @Override
        @Nonnull
        public Object getComparand(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            return this.comparand;
        }

        @Override
        @Nonnull
        public Type getType() {
            return this.type;
        }

        @Override
        @Nullable
        public Value getValue() {
            return LiteralValue.ofScalar(this.getComparand());
        }

        @Override
        @Nonnull
        public Comparison withValue(@Nonnull Value value) {
            if (value instanceof LiteralValue) {
                return new SimpleComparison(this.getType(), Objects.requireNonNull(((LiteralValue)value).getLiteralValue()));
            }
            return new ValueComparison(this.getType(), value);
        }

        @Override
        @Nonnull
        public Optional<Comparison> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> replacementFunction) {
            return Optional.of(this);
        }

        @Override
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, @Nullable Object value) {
            return Comparisons.evalComparison(this.type, value, this.getComparand(store, context));
        }

        @Override
        @Nonnull
        public String typelessString() {
            return Comparisons.toPrintable(this.comparand);
        }

        public String toString() {
            return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword(this.type.name()).addWhitespace().addIdentifier(this.typelessString()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleComparisonBase that = (SimpleComparisonBase)o;
            return this.type == that.type && Objects.equals(Comparisons.toClassWithRealEquals(this.comparand), Comparisons.toClassWithRealEquals(that.comparand));
        }

        public int hashCode() {
            return Objects.hash(this.type.name(), Comparisons.toClassWithRealEquals(this.comparand));
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.type.name().hashCode() + PlanHashable.objectPlanHash(mode, this.comparand);
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, new Object[]{BASE_HASH, this.type, this.comparand});
                }
            }
            throw new UnsupportedOperationException("Hash Kind " + mode.name() + " is not supported");
        }

        @Override
        @Nonnull
        public Comparison translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
            return this;
        }
    }
}

