/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.BaseRepeatedField;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithNoChildren;
import com.apple.foundationdb.record.query.expressions.Field;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class EmptyComparison
extends BaseRepeatedField
implements ComponentWithNoChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Empty-Comparison");
    private final boolean isEmpty;

    public EmptyComparison(@Nonnull String fieldName, boolean isEmpty) {
        super(fieldName, Field.OneOfThemEmptyMode.EMPTY_NO_MATCHES);
        this.isEmpty = isEmpty;
    }

    @Override
    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        if (message == null) {
            return null;
        }
        int count = message.getRepeatedFieldCount(this.findFieldDescriptor(message));
        if (this.isEmpty) {
            return count == 0;
        }
        return count > 0;
    }

    @Override
    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        this.validateRepeatedField(descriptor);
    }

    public String toString() {
        return this.getFieldName() + (this.isEmpty ? " IS_EMPTY" : " IS_NOT_EMPTY");
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        ImmutableCollection fieldNames = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fieldNamePrefix)).add(this.getFieldName())).build();
        return GraphExpansion.ofPredicate(FieldValue.ofFieldNames(baseQuantifier.getFlowedObjectValue(), (List<String>)((Object)fieldNames)).withComparison(Comparisons.LIST_EMPTY));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmptyComparison that = (EmptyComparison)o;
        return this.isEmpty == that.isEmpty;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isEmpty);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.isEmpty ? 1 : 0;
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.isEmpty);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

