/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.EmptyComparison;
import com.apple.foundationdb.record.query.expressions.FieldText;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.OneOfThem;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.Text;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class Field {
    @Nonnull
    private final String fieldName;

    public Field(@Nonnull String fieldName) {
        this.fieldName = fieldName;
    }

    @Nonnull
    public QueryComponent matches(@Nonnull QueryComponent child) {
        return new NestedField(this.fieldName, child);
    }

    @Nonnull
    public OneOfThem oneOfThem() {
        return new OneOfThem(this.fieldName);
    }

    @Nonnull
    public OneOfThem oneOfThem(OneOfThemEmptyMode emptyMode) {
        return new OneOfThem(this.fieldName, emptyMode);
    }

    @Nonnull
    public QueryComponent equalsValue(@Nonnull Object comparand) {
        return this.fieldWithComparison(this.fieldName, Comparisons.Type.EQUALS, comparand);
    }

    @Nonnull
    public QueryComponent notEquals(@Nonnull Object comparand) {
        return this.fieldWithComparison(this.fieldName, Comparisons.Type.NOT_EQUALS, comparand);
    }

    @Nonnull
    public QueryComponent greaterThan(@Nonnull Object comparand) {
        return new FieldWithComparison(this.fieldName, new Comparisons.SimpleComparison(Comparisons.Type.GREATER_THAN, comparand));
    }

    @Nonnull
    public QueryComponent greaterThanOrEquals(@Nonnull Object comparand) {
        return new FieldWithComparison(this.fieldName, new Comparisons.SimpleComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, comparand));
    }

    @Nonnull
    public QueryComponent lessThan(@Nonnull Object comparand) {
        return new FieldWithComparison(this.fieldName, new Comparisons.SimpleComparison(Comparisons.Type.LESS_THAN, comparand));
    }

    @Nonnull
    public QueryComponent lessThanOrEquals(@Nonnull Object comparand) {
        return new FieldWithComparison(this.fieldName, new Comparisons.SimpleComparison(Comparisons.Type.LESS_THAN_OR_EQUALS, comparand));
    }

    @Nonnull
    public QueryComponent startsWith(@Nonnull String comparand) {
        return this.fieldWithComparison(this.fieldName, Comparisons.Type.STARTS_WITH, comparand);
    }

    @Nonnull
    public QueryComponent startsWith(@Nonnull ByteString comparand) {
        return this.fieldWithComparison(this.fieldName, Comparisons.Type.STARTS_WITH, comparand);
    }

    @Nonnull
    public QueryComponent isNull() {
        return new FieldWithComparison(this.fieldName, new Comparisons.NullComparison(Comparisons.Type.IS_NULL));
    }

    @Nonnull
    public QueryComponent notNull() {
        return new FieldWithComparison(this.fieldName, new Comparisons.NullComparison(Comparisons.Type.NOT_NULL));
    }

    @Nonnull
    public QueryComponent isEmpty() {
        return new EmptyComparison(this.fieldName, true);
    }

    @Nonnull
    public QueryComponent notEmpty() {
        return new EmptyComparison(this.fieldName, false);
    }

    @Nonnull
    public QueryComponent in(@Nonnull List<?> comparand) {
        return new FieldWithComparison(this.fieldName, new Comparisons.ListComparison(Comparisons.Type.IN, comparand));
    }

    @Nonnull
    public QueryComponent in(@Nonnull String param) {
        return new FieldWithComparison(this.fieldName, new Comparisons.ParameterComparison(Comparisons.Type.IN, param));
    }

    @Nonnull
    private QueryComponent fieldWithComparison(@Nonnull String fieldName, @Nonnull Comparisons.Type type, @Nonnull Object comparand) {
        if (comparand instanceof List) {
            List list = (List)comparand;
            if (!list.isEmpty()) {
                return new FieldWithComparison(fieldName, new Comparisons.ListComparison(type, list));
            }
            throw new RecordCoreException("List comparand must have at least one element", new Object[0]);
        }
        return new FieldWithComparison(fieldName, new Comparisons.SimpleComparison(type, comparand));
    }

    @Nonnull
    public Text text() {
        return new FieldText(this.fieldName);
    }

    @Nonnull
    public Text text(@Nullable String tokenizerName) {
        return new FieldText(this.fieldName, tokenizerName);
    }

    @Nonnull
    public Text text(@Nullable String tokenizerName, @Nullable String defaultTokenizerName) {
        return new FieldText(this.fieldName, tokenizerName, defaultTokenizerName);
    }

    @Nonnull
    public QueryComponent equalsParameter(@Nonnull String param) {
        return new FieldWithComparison(this.fieldName, new Comparisons.ParameterComparison(Comparisons.Type.EQUALS, param));
    }

    @Nonnull
    public QueryComponent mapMatches(@Nullable Function<Field, QueryComponent> keyMatcher, @Nullable Function<Field, QueryComponent> valueMatcher) {
        QueryComponent component;
        if (keyMatcher != null) {
            component = valueMatcher != null ? Query.and(keyMatcher.apply(new Field("key")), valueMatcher.apply(new Field("value")), new QueryComponent[0]) : keyMatcher.apply(new Field("key"));
        } else if (valueMatcher != null) {
            component = valueMatcher.apply(new Field("value"));
        } else {
            throw new Query.InvalidExpressionException("must match the key or the value or both");
        }
        return this.oneOfThem().matches(component);
    }

    public static enum OneOfThemEmptyMode {
        EMPTY_UNKNOWN,
        EMPTY_NO_MATCHES;

    }
}

