/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.BaseField;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithComparison;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class FieldWithComparison
extends BaseField
implements ComponentWithComparison {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Field-With-Comparison");
    @Nonnull
    private final Comparisons.Comparison comparison;

    public FieldWithComparison(@Nonnull String fieldName, @Nonnull Comparisons.Comparison comparison) {
        super(fieldName);
        this.comparison = comparison;
    }

    @Override
    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        Object value;
        if (message == null) {
            this.getComparison().eval(store, context, null);
        }
        if ((value = this.getFieldValue(message)) == null) {
            return this.getComparison().eval(store, context, null);
        }
        if (value instanceof MessageOrBuilder && !this.allowWholeMessage()) {
            throw new Query.InvalidExpressionException("Expression requiring primitive found a message value");
        }
        return this.getComparison().eval(store, context, value);
    }

    @Override
    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        Descriptors.FieldDescriptor field = super.validateFieldExistence(descriptor);
        if (!this.allowWholeMessage()) {
            this.requirePrimitiveField(field);
        }
        this.getComparison().validate(field, false);
    }

    private boolean allowWholeMessage() {
        return this.getComparison().getType() == Comparisons.Type.IS_NULL || this.getComparison().getType() == Comparisons.Type.NOT_NULL;
    }

    @Override
    @Nonnull
    public Comparisons.Comparison getComparison() {
        return this.comparison;
    }

    public String toString() {
        return this.getFieldName() + " " + String.valueOf(this.getComparison());
    }

    @Override
    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        ImmutableCollection fieldNames = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fieldNamePrefix)).add(this.getFieldName())).build();
        return GraphExpansion.ofPredicate(FieldValue.ofFieldNames(baseQuantifier.getFlowedObjectValue(), (List<String>)((Object)fieldNames)).withComparison(this.comparison));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FieldWithComparison that = (FieldWithComparison)o;
        return Objects.equals(this.getComparison(), that.getComparison());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getComparison());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return super.basePlanHash(mode, BASE_HASH, new Object[0]) + this.getComparison().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return super.basePlanHash(mode, BASE_HASH, this.getComparison());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public QueryComponent withOtherComparison(Comparisons.Comparison comparison) {
        return new FieldWithComparison(this.getFieldName(), comparison);
    }
}

