/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.BaseNestedField;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class NestedField
extends BaseNestedField {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Nested-Field");

    public NestedField(@Nonnull String fieldName, @Nonnull QueryComponent childComponent) {
        super(fieldName, childComponent);
    }

    @Override
    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        QueryComponent component = this.getChild();
        if (message == null) {
            return component.evalMessage(store, context, rec, null);
        }
        Object value = this.getFieldValue(message);
        if (value == null) {
            return component.evalMessage(store, context, rec, null);
        }
        if (value instanceof Message) {
            return component.evalMessage(store, context, rec, (Message)value);
        }
        throw new Query.InvalidExpressionException("Expression requiring nesting found a non-message value");
    }

    @Override
    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        Descriptors.FieldDescriptor field = super.validateFieldExistence(descriptor);
        QueryComponent child = this.getChild();
        this.requireMessageField(field);
        this.requireScalarField(field);
        child.validate(field.getMessageType());
    }

    @Override
    public QueryComponent withOtherChild(QueryComponent newChild) {
        if (newChild == this.getChild()) {
            return this;
        }
        return new NestedField(this.getFieldName(), newChild);
    }

    public String toString() {
        return this.getFieldName() + "/{" + String.valueOf(this.getChild()) + "}";
    }

    @Override
    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        ImmutableCollection fieldNames = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fieldNamePrefix)).add(this.getFieldName())).build();
        return this.childComponent.expand(baseQuantifier, outerQuantifierSupplier, (List<String>)((Object)fieldNames));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NestedField that = (NestedField)o;
        return Objects.equals(this.getChild(), that.getChild());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getChild());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return super.basePlanHash(mode, BASE_HASH, new Object[0]) + this.getChild().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return super.basePlanHash(mode, BASE_HASH, this.getChild());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

