/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.BooleanComponent;
import com.apple.foundationdb.record.query.expressions.ComponentWithSingleChild;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.predicates.NotPredicate;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class NotComponent
implements ComponentWithSingleChild,
BooleanComponent {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Not-Component");
    @Nonnull
    private final QueryComponent child;

    public NotComponent(@Nonnull QueryComponent child) {
        this.child = child;
    }

    @Nullable
    private Boolean invert(@Nullable Boolean v) {
        if (v == null) {
            return null;
        }
        return v == false;
    }

    @Override
    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        return this.invert(this.getChild().evalMessage(store, context, rec, message));
    }

    @Override
    @Nonnull
    public <M extends Message> CompletableFuture<Boolean> evalMessageAsync(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        return this.getChild().evalMessageAsync(store, context, rec, message).thenApply(this::invert);
    }

    @Override
    public boolean isAsync() {
        return this.getChild().isAsync();
    }

    @Override
    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        this.getChild().validate(descriptor);
    }

    public String toString() {
        return "Not(" + String.valueOf(this.getChild()) + ")";
    }

    @Override
    @Nonnull
    public QueryComponent getChild() {
        return this.child;
    }

    @Override
    public QueryComponent withOtherChild(QueryComponent newChild) {
        if (newChild == this.getChild()) {
            return this;
        }
        return new NotComponent(newChild);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotComponent not = (NotComponent)o;
        return Objects.equals(this.getChild(), not.getChild());
    }

    public int hashCode() {
        return Objects.hash(this.getChild());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getChild().planHash(mode) + 1;
            }
            case FOR_CONTINUATION: {
                return PlanHashable.planHash(mode, BASE_HASH, this.getChild());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        GraphExpansion childGraphExpansion = this.child.expand(baseQuantifier, outerQuantifierSupplier, fieldNamePrefix);
        return childGraphExpansion.withPredicate(NotPredicate.not(childGraphExpansion.asAndPredicate()));
    }
}

