/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.Field;
import com.apple.foundationdb.record.query.expressions.OneOfThemText;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComparison;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComponent;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.Text;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class OneOfThem {
    @Nonnull
    private final String fieldName;
    private final Field.OneOfThemEmptyMode emptyMode;

    public OneOfThem(@Nonnull String fieldName) {
        this(fieldName, Field.OneOfThemEmptyMode.EMPTY_UNKNOWN);
    }

    public OneOfThem(@Nonnull String fieldName, Field.OneOfThemEmptyMode emptyMode) {
        this.fieldName = fieldName;
        this.emptyMode = emptyMode;
    }

    @Nonnull
    public QueryComponent matches(@Nonnull QueryComponent child) {
        return new OneOfThemWithComponent(this.fieldName, this.emptyMode, child);
    }

    @Nonnull
    public QueryComponent equalsValue(@Nonnull Object comparand) {
        return new OneOfThemWithComparison(this.fieldName, this.emptyMode, new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, comparand));
    }

    @Nonnull
    public QueryComponent notEquals(@Nonnull Object comparand) {
        return new OneOfThemWithComparison(this.fieldName, this.emptyMode, new Comparisons.SimpleComparison(Comparisons.Type.NOT_EQUALS, comparand));
    }

    @Nonnull
    public QueryComponent greaterThan(@Nonnull Object comparand) {
        return new OneOfThemWithComparison(this.fieldName, this.emptyMode, new Comparisons.SimpleComparison(Comparisons.Type.GREATER_THAN, comparand));
    }

    @Nonnull
    public QueryComponent greaterThanOrEquals(@Nonnull Object comparand) {
        return new OneOfThemWithComparison(this.fieldName, this.emptyMode, new Comparisons.SimpleComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, comparand));
    }

    @Nonnull
    public QueryComponent lessThan(@Nonnull Object comparand) {
        return new OneOfThemWithComparison(this.fieldName, this.emptyMode, new Comparisons.SimpleComparison(Comparisons.Type.LESS_THAN, comparand));
    }

    @Nonnull
    public QueryComponent lessThanOrEquals(@Nonnull Object comparand) {
        return new OneOfThemWithComparison(this.fieldName, this.emptyMode, new Comparisons.SimpleComparison(Comparisons.Type.LESS_THAN_OR_EQUALS, comparand));
    }

    @Nonnull
    public QueryComponent startsWith(@Nonnull String comparand) {
        return new OneOfThemWithComparison(this.fieldName, this.emptyMode, new Comparisons.SimpleComparison(Comparisons.Type.STARTS_WITH, comparand));
    }

    @Nonnull
    public QueryComponent in(@Nonnull List<?> comparand) {
        return new OneOfThemWithComparison(this.fieldName, this.emptyMode, new Comparisons.ListComparison(Comparisons.Type.IN, comparand));
    }

    @Nonnull
    public QueryComponent in(@Nonnull String param) {
        return new OneOfThemWithComparison(this.fieldName, this.emptyMode, new Comparisons.ParameterComparison(Comparisons.Type.IN, param));
    }

    @Nonnull
    public Text text() {
        return new OneOfThemText(this.fieldName, this.emptyMode);
    }

    @Nonnull
    public Text text(@Nullable String tokenizerName) {
        return new OneOfThemText(this.fieldName, this.emptyMode, tokenizerName);
    }

    @Nonnull
    public Text text(@Nullable String tokenizerName, @Nullable String defaultTokenizerName) {
        return new OneOfThemText(this.fieldName, this.emptyMode, tokenizerName, defaultTokenizerName);
    }
}

