/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.BaseRepeatedField;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithComparison;
import com.apple.foundationdb.record.query.expressions.Field;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class OneOfThemWithComparison
extends BaseRepeatedField
implements ComponentWithComparison {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("One-Of-Them-With-Comparison");
    @Nonnull
    private final Comparisons.Comparison comparison;

    public OneOfThemWithComparison(@Nonnull String fieldName, @Nonnull Comparisons.Comparison comparison) {
        this(fieldName, Field.OneOfThemEmptyMode.EMPTY_UNKNOWN, comparison);
    }

    public OneOfThemWithComparison(@Nonnull String fieldName, Field.OneOfThemEmptyMode emptyMode, @Nonnull Comparisons.Comparison comparison) {
        super(fieldName, emptyMode);
        this.comparison = comparison;
    }

    @Override
    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        if (message == null) {
            return this.getComparison().eval(store, context, null);
        }
        List<Object> values = this.getValues(message);
        if (values == null) {
            return null;
        }
        for (Object value : values) {
            Boolean val = this.getComparison().eval(store, context, value);
            if (val == null || !val.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        Descriptors.FieldDescriptor field = this.validateRepeatedField(descriptor);
        this.requirePrimitiveField(field);
        this.getComparison().validate(field, true);
    }

    @Override
    @Nonnull
    public Comparisons.Comparison getComparison() {
        return this.comparison;
    }

    @Override
    public QueryComponent withOtherComparison(Comparisons.Comparison comparison) {
        return new OneOfThemWithComparison(this.getFieldName(), this.getEmptyMode(), comparison);
    }

    @Override
    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        ImmutableCollection fieldNames = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fieldNamePrefix)).add(this.getFieldName())).build();
        Quantifier.ForEach childBase = Quantifier.forEach(Reference.initialOf((RelationalExpression)ExplodeExpression.explodeField(baseQuantifier, (List<String>)((Object)fieldNames))));
        SelectExpression selectExpression = GraphExpansion.builder().addQuantifier(childBase).addPredicate(childBase.getFlowedObjectValue().withComparison(this.comparison)).build().buildSimpleSelectOverQuantifier(childBase);
        Quantifier.Existential childQuantifier = Quantifier.existential(Reference.initialOf((RelationalExpression)selectExpression));
        QueryComponent withPrefix = this;
        for (int i = fieldNamePrefix.size() - 1; i >= 0; --i) {
            String fieldName = (String)fieldNames.get(i);
            withPrefix = Query.field(fieldName).matches(withPrefix);
        }
        return GraphExpansion.ofExists(childQuantifier);
    }

    public String toString() {
        return "one of " + this.getFieldName() + " " + String.valueOf(this.getComparison());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OneOfThemWithComparison that = (OneOfThemWithComparison)o;
        return Objects.equals(this.getComparison(), that.getComparison());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getComparison());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getComparison().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return super.basePlanHash(mode, BASE_HASH, this.comparison);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

