/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.BaseRepeatedField;
import com.apple.foundationdb.record.query.expressions.ComponentWithSingleChild;
import com.apple.foundationdb.record.query.expressions.Field;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.ExplodeExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class OneOfThemWithComponent
extends BaseRepeatedField
implements ComponentWithSingleChild {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("One-Of-Them-With-Component");
    @Nonnull
    private final QueryComponent child;

    public OneOfThemWithComponent(@Nonnull String fieldName, @Nonnull QueryComponent child) {
        this(fieldName, Field.OneOfThemEmptyMode.EMPTY_UNKNOWN, child);
    }

    public OneOfThemWithComponent(@Nonnull String fieldName, Field.OneOfThemEmptyMode emptyMode, @Nonnull QueryComponent child) {
        super(fieldName, emptyMode);
        this.child = child;
    }

    @Override
    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        if (message == null) {
            return null;
        }
        List<Object> values = this.getValues(message);
        if (values == null) {
            return null;
        }
        for (Object value : values) {
            Boolean val;
            if (value == null || !(value instanceof Message) || (val = this.getChild().evalMessage(store, context, rec, (Message)value)) == null || !val.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        Descriptors.FieldDescriptor field = this.validateRepeatedField(descriptor);
        QueryComponent component = this.getChild();
        this.requireMessageField(field);
        component.validate(field.getMessageType());
    }

    @Override
    @Nonnull
    public QueryComponent getChild() {
        return this.child;
    }

    @Override
    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        ImmutableCollection fieldNames = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fieldNamePrefix)).add(this.getFieldName())).build();
        Quantifier.ForEach childBase = Quantifier.forEach(Reference.initialOf((RelationalExpression)ExplodeExpression.explodeField(baseQuantifier, (List<String>)((Object)fieldNames))));
        GraphExpansion graphExpansion = this.getChild().expand(childBase, outerQuantifierSupplier, Collections.emptyList());
        SelectExpression selectExpression = GraphExpansion.ofOthers(GraphExpansion.builder().addQuantifier(childBase).build(), graphExpansion).buildSimpleSelectOverQuantifier(childBase);
        Quantifier.Existential childQuantifier = Quantifier.existential(Reference.initialOf((RelationalExpression)selectExpression));
        QueryComponent withPrefix = this;
        for (int i = fieldNamePrefix.size() - 1; i >= 0; --i) {
            String fieldName = (String)fieldNames.get(i);
            withPrefix = Query.field(fieldName).matches(withPrefix);
        }
        return GraphExpansion.ofExists(childQuantifier);
    }

    @Override
    public QueryComponent withOtherChild(QueryComponent newChild) {
        if (newChild == this.getChild()) {
            return this;
        }
        return new OneOfThemWithComponent(this.getFieldName(), this.getEmptyMode(), newChild);
    }

    public String toString() {
        return "one of " + this.getFieldName() + "/{" + String.valueOf(this.getChild()) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OneOfThemWithComponent that = (OneOfThemWithComponent)o;
        return Objects.equals(this.getChild(), that.getChild());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getChild());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return super.basePlanHash(mode, BASE_HASH, new Object[0]) + this.getChild().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return super.basePlanHash(mode, BASE_HASH, this.getChild());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

