/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.query.expressions.AndOrComponent;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.UNSTABLE)
public class OrComponent
extends AndOrComponent {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Or-Component");

    public OrComponent(List<QueryComponent> operands) {
        super(operands);
    }

    public static OrComponent from(@Nonnull List<QueryComponent> operands) {
        return new OrComponent(operands);
    }

    @Override
    public boolean isOr() {
        return true;
    }

    public String toString() {
        return "Or(" + String.valueOf(this.getChildren()) + ")";
    }

    @Override
    public QueryComponent withOtherChildren(List<QueryComponent> newChildren) {
        return OrComponent.from(newChildren);
    }

    @Override
    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        GraphExpansion childrenGraphExpansion = GraphExpansion.ofOthers(this.getChildren().stream().map(child -> child.expand(baseQuantifier, outerQuantifierSupplier, fieldNamePrefix)).map(expanded -> expanded.withPredicate(expanded.asAndPredicate())).collect(ImmutableList.toImmutableList()));
        return childrenGraphExpansion.withPredicate(OrPredicate.or(childrenGraphExpansion.getPredicates()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        OrComponent that = (OrComponent)o;
        return Objects.equals(this.getChildren(), that.getChildren());
    }

    public int hashCode() {
        return Objects.hash(this.getChildren());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.planHash(mode, (Iterable<? extends PlanHashable>)this.getChildren());
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getChildren());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

