/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.metadata.expressions.OrderFunctionKeyExpression;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.QueryKeyExpression;
import com.apple.foundationdb.record.query.expressions.QueryKeyExpressionWithComparison;
import com.apple.foundationdb.record.util.pair.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class OrderQueryKeyExpression
extends QueryKeyExpression {
    public OrderQueryKeyExpression(@Nonnull OrderFunctionKeyExpression keyExpression) {
        super(keyExpression);
    }

    @Nullable
    public Pair<Comparisons.Comparison, Comparisons.Comparison> adjustComparison(@Nonnull Comparisons.Comparison comparison) {
        boolean inverted = ((OrderFunctionKeyExpression)this.keyExpression).getDirection().isInverted();
        Comparisons.Type type = comparison.getType();
        switch (type) {
            case EQUALS: 
            case NOT_EQUALS: {
                break;
            }
            case LESS_THAN: {
                if (!inverted) break;
                type = Comparisons.Type.GREATER_THAN;
                break;
            }
            case LESS_THAN_OR_EQUALS: {
                if (!inverted) break;
                type = Comparisons.Type.GREATER_THAN_OR_EQUALS;
                break;
            }
            case GREATER_THAN: {
                if (!inverted) break;
                type = Comparisons.Type.LESS_THAN;
                break;
            }
            case GREATER_THAN_OR_EQUALS: {
                if (!inverted) break;
                type = Comparisons.Type.LESS_THAN_OR_EQUALS;
                break;
            }
            case IS_NULL: {
                return Pair.of(this.adjustedNullComparison(Comparisons.Type.EQUALS), null);
            }
            case NOT_NULL: {
                return Pair.of(this.adjustedNullComparison(Comparisons.Type.NOT_EQUALS), null);
            }
            default: {
                return null;
            }
        }
        QueryKeyExpressionWithComparison adjustedComponent = comparison instanceof Comparisons.ComparisonWithParameter ? this.parameterComparison(type, ((Comparisons.ComparisonWithParameter)comparison).getParameter()) : this.simpleComparison(type, comparison.getComparand());
        Comparisons.Comparison adjustedComparison = adjustedComponent.getComparison();
        Comparisons.SimpleComparison nullComparison = null;
        switch (type) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUALS: {
                if (!((OrderFunctionKeyExpression)this.keyExpression).getDirection().isNullsFirst()) break;
                nullComparison = this.adjustedNullComparison(Comparisons.Type.GREATER_THAN);
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUALS: {
                if (!((OrderFunctionKeyExpression)this.keyExpression).getDirection().isNullsLast()) break;
                nullComparison = this.adjustedNullComparison(Comparisons.Type.LESS_THAN);
                break;
            }
        }
        return Pair.of(adjustedComparison, nullComparison);
    }

    @Nonnull
    private Comparisons.SimpleComparison adjustedNullComparison(@Nonnull Comparisons.Type type) {
        return new Comparisons.SimpleComparison(type, this.keyExpression.getComparandConversionFunction().apply(null));
    }
}

