/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.StoreRecordFunction;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.QueryableKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowForFunction;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowRecordFunction;
import com.apple.foundationdb.record.query.expressions.AndComponent;
import com.apple.foundationdb.record.query.expressions.Field;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.NotComponent;
import com.apple.foundationdb.record.query.expressions.OrComponent;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.QueryKeyExpression;
import com.apple.foundationdb.record.query.expressions.QueryRecordFunction;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class Query {
    @Nonnull
    public static Field field(@Nonnull String name) {
        return new Field(name);
    }

    @Nonnull
    public static QueryComponent and(@Nonnull QueryComponent first, @Nonnull QueryComponent second, QueryComponent ... operands) {
        return AndComponent.from(Query.toList(first, second, operands));
    }

    @Nonnull
    public static QueryComponent and(@Nonnull List<? extends QueryComponent> operands) {
        return AndComponent.from(operands);
    }

    @Nonnull
    public static QueryComponent or(@Nonnull QueryComponent first, @Nonnull QueryComponent second, QueryComponent ... operands) {
        return OrComponent.from(Query.toList(first, second, operands));
    }

    @Nonnull
    public static QueryComponent or(@Nonnull List<QueryComponent> operands) {
        return OrComponent.from(operands);
    }

    @Nonnull
    public static QueryComponent not(@Nonnull QueryComponent operand) {
        return new NotComponent(operand);
    }

    @Nonnull
    public static QueryRecordFunction<Long> rank(@Nonnull GroupingKeyExpression operand) {
        return new QueryRecordFunction<Long>(new IndexRecordFunction("rank", operand, null));
    }

    @Nonnull
    public static QueryRecordFunction<Long> rank(@Nonnull String fieldName) {
        return Query.rank(Key.Expressions.field(fieldName).ungrouped());
    }

    @Nonnull
    public static QueryRecordFunction<Long> timeWindowRank(@Nonnull TimeWindowForFunction timeWindow, @Nonnull GroupingKeyExpression operand) {
        return new QueryRecordFunction<Long>(new TimeWindowRecordFunction("time_window_rank", operand, null, timeWindow));
    }

    @Nonnull
    public static QueryRecordFunction<Long> timeWindowRank(int type, long timestamp, @Nullable String typeParameter, @Nullable String timestampParameter, @Nonnull GroupingKeyExpression operand) {
        return Query.timeWindowRank(new TimeWindowForFunction(type, timestamp, typeParameter, timestampParameter), operand);
    }

    @Nonnull
    public static QueryRecordFunction<Long> timeWindowRank(int type, long timestamp, @Nonnull GroupingKeyExpression operand) {
        return Query.timeWindowRank(type, timestamp, null, null, operand);
    }

    @Nonnull
    public static QueryRecordFunction<Long> timeWindowRank(@Nonnull String typeParameter, @Nonnull String timestampParameter, @Nonnull GroupingKeyExpression operand) {
        return Query.timeWindowRank(0, 0L, typeParameter, timestampParameter, operand);
    }

    @Nonnull
    public static QueryRecordFunction<Tuple> timeWindowRankAndEntry(@Nonnull TimeWindowForFunction timeWindow, @Nonnull GroupingKeyExpression operand) {
        return new QueryRecordFunction<Tuple>(new TimeWindowRecordFunction("time_window_rank_and_entry", operand, null, timeWindow));
    }

    @Nonnull
    public static QueryRecordFunction<Tuple> timeWindowRankAndEntry(int type, long timestamp, @Nullable String typeParameter, @Nullable String timestampParameter, @Nonnull GroupingKeyExpression operand) {
        return Query.timeWindowRankAndEntry(new TimeWindowForFunction(type, timestamp, typeParameter, timestampParameter), operand);
    }

    @Nonnull
    public static QueryRecordFunction<Tuple> timeWindowRankAndEntry(int type, long timestamp, @Nonnull GroupingKeyExpression operand) {
        return Query.timeWindowRankAndEntry(type, timestamp, null, null, operand);
    }

    @Nonnull
    public static QueryRecordFunction<Tuple> timeWindowRankAndEntry(@Nonnull String typeParameter, @Nonnull String timestampParameter, @Nonnull GroupingKeyExpression operand) {
        return Query.timeWindowRankAndEntry(0, 0L, typeParameter, timestampParameter, operand);
    }

    @Nonnull
    public static QueryRecordFunction<FDBRecordVersion> version() {
        return new QueryRecordFunction<FDBRecordVersion>(new StoreRecordFunction("version"));
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public static QueryKeyExpression keyExpression(@Nonnull KeyExpression keyExpression) {
        if (!(keyExpression instanceof QueryableKeyExpression)) {
            throw new MetaDataException("query key expression must be queryable", new Object[0]);
        }
        return new QueryKeyExpression((QueryableKeyExpression)keyExpression);
    }

    private static List<QueryComponent> toList(@Nonnull QueryComponent first, @Nonnull QueryComponent second, QueryComponent ... operands) {
        ArrayList<QueryComponent> children = new ArrayList<QueryComponent>(operands.length + 2);
        children.add(first);
        children.add(second);
        Collections.addAll(children, operands);
        return children;
    }

    public static boolean isSingleFieldComparison(@Nonnull QueryComponent component) {
        return component instanceof FieldWithComparison || component instanceof NestedField && ((NestedField)component).getChild() instanceof FieldWithComparison;
    }

    private Query() {
    }

    public static class InvalidExpressionException
    extends IllegalStateException {
        public InvalidExpressionException(String message) {
            super(message);
        }
    }
}

