/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.ParameterRelationshipGraph;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public interface QueryComponent
extends PlanHashable {
    @Nullable
    default public <M extends Message> Boolean eval(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec) {
        return this.evalMessage(store, context, rec, rec == null ? null : (Message)rec.getRecord());
    }

    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> var1, @Nonnull EvaluationContext var2, @Nullable FDBRecord<M> var3, @Nullable Message var4);

    @Nonnull
    default public <M extends Message> CompletableFuture<Boolean> evalAsync(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec) {
        return this.evalMessageAsync(store, context, rec, rec == null ? null : (Message)rec.getRecord());
    }

    @Nonnull
    default public <M extends Message> CompletableFuture<Boolean> evalMessageAsync(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        return CompletableFuture.completedFuture(this.evalMessage(store, context, rec, message));
    }

    default public boolean isAsync() {
        return false;
    }

    public void validate(@Nonnull Descriptors.Descriptor var1);

    @API(value=API.Status.EXPERIMENTAL)
    default public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier) {
        return this.expand(baseQuantifier, outerQuantifierSupplier, Collections.emptyList());
    }

    @Nonnull
    @API(value=API.Status.EXPERIMENTAL)
    public GraphExpansion expand(@Nonnull Quantifier.ForEach var1, @Nonnull Supplier<Quantifier.ForEach> var2, @Nonnull List<String> var3);

    @Nonnull
    default public QueryComponent withParameterRelationshipMap(@Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
        return this;
    }
}

