/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.QueryableKeyExpression;
import com.apple.foundationdb.record.planprotos.PComparison;
import com.apple.foundationdb.record.planprotos.PConversionParameterComparison;
import com.apple.foundationdb.record.planprotos.PConversionSimpleComparison;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.ParameterRelationshipGraph;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.QueryKeyExpressionWithComparison;
import com.apple.foundationdb.record.query.expressions.QueryKeyExpressionWithOneOfComparison;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.google.common.base.Verify;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class QueryKeyExpression {
    @Nonnull
    protected final QueryableKeyExpression keyExpression;

    public QueryKeyExpression(@Nonnull QueryableKeyExpression keyExpression) {
        this.keyExpression = keyExpression;
    }

    @Nonnull
    public QueryComponent equalsValue(@Nonnull Object comparand) {
        return this.simpleComparison(Comparisons.Type.EQUALS, comparand);
    }

    @Nonnull
    public QueryComponent notEquals(@Nonnull Object comparand) {
        return this.simpleComparison(Comparisons.Type.NOT_EQUALS, comparand);
    }

    @Nonnull
    public QueryComponent greaterThan(@Nonnull Object comparand) {
        return this.simpleComparison(Comparisons.Type.GREATER_THAN, comparand);
    }

    @Nonnull
    public QueryComponent greaterThanOrEquals(@Nonnull Object comparand) {
        return this.simpleComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, comparand);
    }

    @Nonnull
    public QueryComponent lessThan(@Nonnull Object comparand) {
        return this.simpleComparison(Comparisons.Type.LESS_THAN, comparand);
    }

    @Nonnull
    public QueryComponent lessThanOrEquals(@Nonnull Object comparand) {
        return this.simpleComparison(Comparisons.Type.LESS_THAN_OR_EQUALS, comparand);
    }

    @Nonnull
    public QueryComponent startsWith(@Nonnull String comparand) {
        return this.simpleComparison(Comparisons.Type.STARTS_WITH, comparand);
    }

    @Nonnull
    public QueryComponent isNull() {
        return this.nullComparison(Comparisons.Type.IS_NULL);
    }

    @Nonnull
    public QueryComponent notNull() {
        return this.nullComparison(Comparisons.Type.NOT_NULL);
    }

    @Nonnull
    public QueryComponent equalsParameter(@Nonnull String param) {
        return this.parameterComparison(Comparisons.Type.EQUALS, param);
    }

    @Nonnull
    public OneOfThem oneOfThem() {
        return new OneOfThem();
    }

    @Nonnull
    protected QueryKeyExpressionWithComparison simpleComparison(@Nonnull Comparisons.Type type, @Nonnull Object comparand) {
        if (this.keyExpression.getComparandConversionFunction() != null) {
            return new QueryKeyExpressionWithComparison(this.keyExpression, new ConversionSimpleComparison(type, comparand, this.keyExpression));
        }
        return new QueryKeyExpressionWithComparison(this.keyExpression, new Comparisons.SimpleComparison(type, comparand));
    }

    @Nonnull
    private QueryKeyExpressionWithComparison nullComparison(@Nonnull Comparisons.Type type) {
        return new QueryKeyExpressionWithComparison(this.keyExpression, new Comparisons.NullComparison(type));
    }

    @Nonnull
    protected QueryKeyExpressionWithComparison parameterComparison(@Nonnull Comparisons.Type type, @Nonnull String param) {
        if (this.keyExpression.getComparandConversionFunction() != null) {
            return new QueryKeyExpressionWithComparison(this.keyExpression, new ConversionParameterComparison(type, param, this.keyExpression));
        }
        return new QueryKeyExpressionWithComparison(this.keyExpression, new Comparisons.ParameterComparison(type, param));
    }

    public class OneOfThem {
        private OneOfThem() {
        }

        @Nonnull
        public QueryComponent equalsValue(@Nonnull Object comparand) {
            return this.simpleComparison(Comparisons.Type.EQUALS, comparand);
        }

        @Nonnull
        public QueryComponent notEquals(@Nonnull Object comparand) {
            return this.simpleComparison(Comparisons.Type.NOT_EQUALS, comparand);
        }

        @Nonnull
        public QueryComponent greaterThan(@Nonnull Object comparand) {
            return this.simpleComparison(Comparisons.Type.GREATER_THAN, comparand);
        }

        @Nonnull
        public QueryComponent greaterThanOrEquals(@Nonnull Object comparand) {
            return this.simpleComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, comparand);
        }

        @Nonnull
        public QueryComponent lessThan(@Nonnull Object comparand) {
            return this.simpleComparison(Comparisons.Type.LESS_THAN, comparand);
        }

        @Nonnull
        public QueryComponent lessThanOrEquals(@Nonnull Object comparand) {
            return this.simpleComparison(Comparisons.Type.LESS_THAN_OR_EQUALS, comparand);
        }

        @Nonnull
        public QueryComponent startsWith(@Nonnull String comparand) {
            return this.simpleComparison(Comparisons.Type.STARTS_WITH, comparand);
        }

        @Nonnull
        public QueryComponent isNull() {
            return this.nullComparison(Comparisons.Type.IS_NULL);
        }

        @Nonnull
        public QueryComponent notNull() {
            return this.nullComparison(Comparisons.Type.NOT_NULL);
        }

        @Nonnull
        public QueryComponent equalsParameter(@Nonnull String param) {
            return this.parameterComparison(Comparisons.Type.EQUALS, param);
        }

        @Nonnull
        private QueryKeyExpressionWithOneOfComparison simpleComparison(@Nonnull Comparisons.Type type, @Nonnull Object comparand) {
            if (QueryKeyExpression.this.keyExpression.getComparandConversionFunction() != null) {
                return new QueryKeyExpressionWithOneOfComparison(QueryKeyExpression.this.keyExpression, new ConversionSimpleComparison(type, comparand, QueryKeyExpression.this.keyExpression));
            }
            return new QueryKeyExpressionWithOneOfComparison(QueryKeyExpression.this.keyExpression, new Comparisons.SimpleComparison(type, comparand));
        }

        @Nonnull
        private QueryKeyExpressionWithOneOfComparison nullComparison(@Nonnull Comparisons.Type type) {
            return new QueryKeyExpressionWithOneOfComparison(QueryKeyExpression.this.keyExpression, new Comparisons.NullComparison(type));
        }

        @Nonnull
        private QueryKeyExpressionWithOneOfComparison parameterComparison(@Nonnull Comparisons.Type type, @Nonnull String param) {
            if (QueryKeyExpression.this.keyExpression.getComparandConversionFunction() != null) {
                return new QueryKeyExpressionWithOneOfComparison(QueryKeyExpression.this.keyExpression, new ConversionParameterComparison(type, param, QueryKeyExpression.this.keyExpression));
            }
            return new QueryKeyExpressionWithOneOfComparison(QueryKeyExpression.this.keyExpression, new Comparisons.ParameterComparison(type, param));
        }
    }

    private static final class ConversionSimpleComparison
    extends Comparisons.SimpleComparisonBase {
        private static final ObjectPlanHash CONVERSION_SIMPLE_COMPARISON_BASE_HASH = new ObjectPlanHash("Conversion-Simple-Comparison");
        @Nonnull
        private final QueryableKeyExpression keyExpression;
        @Nonnull
        private final Object unconvertedComparand;

        public ConversionSimpleComparison(@Nonnull Comparisons.Type type, @Nonnull Object comparand, @Nonnull QueryableKeyExpression keyExpression) {
            super(type, keyExpression.getComparandConversionFunction().apply(comparand));
            this.keyExpression = keyExpression;
            this.unconvertedComparand = comparand;
        }

        @Nonnull
        private QueryableKeyExpression getKeyExpression() {
            return this.keyExpression;
        }

        @Override
        @Nonnull
        public String typelessString() {
            return this.getKeyExpression().getName() + "(" + Comparisons.toPrintable(this.unconvertedComparand) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConversionSimpleComparison that = (ConversionSimpleComparison)o;
            return this.getKeyExpression().equals(that.getKeyExpression());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getKeyExpression());
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return super.planHash(mode) + this.getKeyExpression().planHash(mode);
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, CONVERSION_SIMPLE_COMPARISON_BASE_HASH, super.planHash(mode), this.getKeyExpression());
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }

        @Override
        @Nonnull
        public Comparisons.Comparison withType(@Nonnull Comparisons.Type newType) {
            if (this.type == newType) {
                return this;
            }
            return new ConversionSimpleComparison(newType, this.unconvertedComparand, this.keyExpression);
        }

        @Override
        @Nonnull
        public PConversionSimpleComparison toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PConversionSimpleComparison.newBuilder().setType(this.type.toProto(serializationContext)).setObject(PlanSerialization.valueObjectToProto(this.unconvertedComparand)).setConversion(this.keyExpression.toKeyExpression()).build();
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            return PComparison.newBuilder().setConversionSimpleComparison(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static ConversionSimpleComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConversionSimpleComparison simpleComparisonProto) {
            return new ConversionSimpleComparison(Comparisons.Type.fromProto(serializationContext, Objects.requireNonNull(simpleComparisonProto.getType())), Objects.requireNonNull(PlanSerialization.protoToValueObject(Objects.requireNonNull(simpleComparisonProto.getObject()))), (QueryableKeyExpression)KeyExpression.fromProto(simpleComparisonProto.getConversion()));
        }

        public static class Deserializer
        implements PlanDeserializer<PConversionSimpleComparison, ConversionSimpleComparison> {
            @Override
            @Nonnull
            public Class<PConversionSimpleComparison> getProtoMessageClass() {
                return PConversionSimpleComparison.class;
            }

            @Override
            @Nonnull
            public ConversionSimpleComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConversionSimpleComparison conversionSimpleComparisonProto) {
                return ConversionSimpleComparison.fromProto(serializationContext, conversionSimpleComparisonProto);
            }
        }
    }

    private static final class ConversionParameterComparison
    extends Comparisons.ParameterComparisonBase {
        private static final ObjectPlanHash CONVERSION_PARAMETER_COMPARISON_BASE_HASH = new ObjectPlanHash("Conversion-Parameter-Comparison");
        @Nonnull
        private final QueryableKeyExpression keyExpression;
        @Nonnull
        private final Function<Object, Object> conversion;

        protected ConversionParameterComparison(@Nonnull Comparisons.Type type, @Nonnull String parameter, @Nullable Bindings.Internal internal, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph, @Nonnull QueryableKeyExpression keyExpression) {
            super(type, parameter, internal, parameterRelationshipGraph);
            this.keyExpression = keyExpression;
            this.conversion = Objects.requireNonNull(keyExpression.getComparandConversionFunction());
        }

        public ConversionParameterComparison(@Nonnull Comparisons.Type type, @Nonnull String param, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph, @Nonnull QueryableKeyExpression keyExpression) {
            this(type, param, null, parameterRelationshipGraph, keyExpression);
        }

        public ConversionParameterComparison(@Nonnull Comparisons.Type type, @Nonnull String param, @Nonnull QueryableKeyExpression keyExpression) {
            this(type, param, ParameterRelationshipGraph.unbound(), keyExpression);
        }

        @Override
        @Nonnull
        public Object getComparand(@Nonnull FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context) {
            return this.conversion.apply(super.getComparand(store, context));
        }

        @Override
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, @Nullable Object value) {
            Object comparand = context.getBinding(this.parameter);
            if (comparand == null) {
                return null;
            }
            return Comparisons.evalComparison(this.getType(), value, this.conversion.apply(comparand));
        }

        @Nonnull
        private QueryableKeyExpression getKeyExpression() {
            return this.keyExpression;
        }

        @Override
        @Nonnull
        public String typelessString() {
            return this.getKeyExpression().getName() + "(" + super.typelessString() + ")";
        }

        @Override
        @Nonnull
        public Comparisons.Comparison withType(@Nonnull Comparisons.Type newType) {
            if (this.type == newType) {
                return this;
            }
            return new ConversionParameterComparison(newType, this.parameter, this.internal, this.parameterRelationshipGraph, this.keyExpression);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConversionParameterComparison that = (ConversionParameterComparison)o;
            return this.getKeyExpression().equals(that.getKeyExpression());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getKeyExpression());
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return super.planHash(mode) + this.getKeyExpression().planHash(mode);
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, CONVERSION_PARAMETER_COMPARISON_BASE_HASH, super.planHash(mode), this.getKeyExpression());
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }

        @Override
        @Nonnull
        protected Comparisons.ParameterComparisonBase withTranslatedCorrelation(@Nonnull CorrelationIdentifier translatedAlias) {
            return new ConversionParameterComparison(this.type, Bindings.Internal.CORRELATION.bindingName(translatedAlias.getId()), Bindings.Internal.CORRELATION, this.parameterRelationshipGraph, this.keyExpression);
        }

        @Override
        @Nonnull
        public Comparisons.Comparison withParameterRelationshipMap(@Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
            Verify.verify(this.parameterRelationshipGraph.isUnbound());
            return new ConversionParameterComparison(this.type, this.parameter, this.internal, parameterRelationshipGraph, this.keyExpression);
        }

        @Override
        @Nonnull
        public PConversionParameterComparison toProto(@Nonnull PlanSerializationContext serializationContext) {
            PConversionParameterComparison.Builder builder = PConversionParameterComparison.newBuilder().setType(this.type.toProto(serializationContext)).setParameter(this.parameter).setConversion(this.keyExpression.toKeyExpression());
            if (this.internal != null) {
                builder.setInternal(this.internal.toProto(serializationContext));
            }
            return builder.build();
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            return PComparison.newBuilder().setConversionParameterComparison(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static ConversionParameterComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConversionParameterComparison conversionParameterComparisonProto) {
            Bindings.Internal internal = conversionParameterComparisonProto.hasInternal() ? Bindings.Internal.fromProto(serializationContext, Objects.requireNonNull(conversionParameterComparisonProto.getInternal())) : null;
            QueryableKeyExpression keyExpression = (QueryableKeyExpression)KeyExpression.fromProto(conversionParameterComparisonProto.getConversion());
            return new ConversionParameterComparison(Comparisons.Type.fromProto(serializationContext, Objects.requireNonNull(conversionParameterComparisonProto.getType())), Objects.requireNonNull(conversionParameterComparisonProto.getParameter()), internal, ParameterRelationshipGraph.unbound(), keyExpression);
        }

        public static class Deserializer
        implements PlanDeserializer<PConversionParameterComparison, ConversionParameterComparison> {
            @Override
            @Nonnull
            public Class<PConversionParameterComparison> getProtoMessageClass() {
                return PConversionParameterComparison.class;
            }

            @Override
            @Nonnull
            public ConversionParameterComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PConversionParameterComparison conversionParameterComparisonProto) {
                return ConversionParameterComparison.fromProto(serializationContext, conversionParameterComparisonProto);
            }
        }
    }
}

