/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.metadata.expressions.QueryableKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithComparison;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.ScalarTranslationVisitor;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class QueryKeyExpressionWithComparison
implements ComponentWithComparison {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Query-Key-Expression-With-Comparison");
    @Nonnull
    private final QueryableKeyExpression keyExpression;
    @Nonnull
    private final Comparisons.Comparison comparison;

    public QueryKeyExpressionWithComparison(@Nonnull QueryableKeyExpression keyExpression, @Nonnull Comparisons.Comparison comparison) {
        this.keyExpression = keyExpression;
        this.comparison = keyExpression.evalForQueryAsTuple() ? new Comparisons.MultiColumnComparison(comparison) : comparison;
    }

    @Nonnull
    public QueryableKeyExpression getKeyExpression() {
        return this.keyExpression;
    }

    @Override
    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        return this.getComparison().eval(store, context, this.keyExpression.evalForQuery(store, context, rec, message));
    }

    @Override
    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        this.keyExpression.validate(descriptor);
    }

    @Override
    @Nonnull
    public Comparisons.Comparison getComparison() {
        return this.comparison;
    }

    @Override
    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        Value value = new ScalarTranslationVisitor(this.keyExpression).toResultValue(baseQuantifier.getAlias(), baseQuantifier.getFlowedObjectType(), fieldNamePrefix);
        return GraphExpansion.ofPredicate(value.withComparison(this.comparison));
    }

    public String toString() {
        return String.valueOf(this.keyExpression) + " " + String.valueOf(this.getComparison());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryKeyExpressionWithComparison that = (QueryKeyExpressionWithComparison)o;
        return Objects.equals(this.keyExpression, that.keyExpression) && Objects.equals(this.getComparison(), that.getComparison());
    }

    public int hashCode() {
        return Objects.hash(this.keyExpression, this.getComparison());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.keyExpression.planHash(mode) + this.getComparison().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.planHash(mode, BASE_HASH, this.keyExpression, this.getComparison());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public QueryComponent withOtherComparison(Comparisons.Comparison comparison) {
        return new QueryKeyExpressionWithComparison(this.keyExpression, comparison);
    }

    @Override
    public String getName() {
        return this.keyExpression.getName();
    }
}

