/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordFunction;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexFunctionHelper;
import com.apple.foundationdb.record.query.expressions.AndComponent;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.QueryRecordFunctionWithComparison;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class QueryRecordFunction<T>
implements PlanHashable {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Query-Record-Function");
    @Nonnull
    private final RecordFunction<T> function;
    @Nullable
    private final QueryComponent additionalCondition;
    @Nullable
    private RecordFunction<T> evalFunction;

    public QueryRecordFunction(@Nonnull RecordFunction<T> function, @Nullable QueryComponent additionalCondition) {
        this.function = function;
        this.additionalCondition = additionalCondition;
    }

    public QueryRecordFunction(@Nonnull RecordFunction<T> function) {
        this(function, null);
    }

    @Nonnull
    public RecordFunction<T> getFunction() {
        return this.function;
    }

    @Nonnull
    public QueryRecordFunction<T> withFunction(@Nonnull RecordFunction<T> function) {
        return new QueryRecordFunction<T>(function, this.additionalCondition);
    }

    @Nullable
    public QueryComponent getAdditionalCondition() {
        return this.additionalCondition;
    }

    @Nonnull
    public QueryRecordFunction<T> withAdditionalCondition(@Nonnull QueryComponent additionalCondition) {
        return new QueryRecordFunction<T>(this.function, this.and(additionalCondition));
    }

    @Nonnull
    private QueryComponent and(@Nonnull QueryComponent condition) {
        if (this.additionalCondition == null) {
            return condition;
        }
        if (this.additionalCondition instanceof AndComponent) {
            ArrayList<QueryComponent> children = new ArrayList<QueryComponent>(((AndComponent)this.additionalCondition).getChildren());
            children.add(condition);
            return Query.and(children);
        }
        return Query.and(this.additionalCondition, condition, new QueryComponent[0]);
    }

    @Nonnull
    public QueryComponent equalsValue(@Nonnull Object comparand) {
        return this.withComparison(Comparisons.Type.EQUALS, comparand);
    }

    @Nonnull
    public QueryComponent notEquals(@Nonnull Object comparand) {
        return this.withComparison(Comparisons.Type.NOT_EQUALS, comparand);
    }

    @Nonnull
    public QueryComponent greaterThan(@Nonnull Object comparand) {
        return this.withComparison(Comparisons.Type.GREATER_THAN, comparand);
    }

    @Nonnull
    public QueryComponent greaterThanOrEquals(@Nonnull Object comparand) {
        return this.withComparison(Comparisons.Type.GREATER_THAN_OR_EQUALS, comparand);
    }

    @Nonnull
    public QueryComponent lessThan(@Nonnull Object comparand) {
        return this.withComparison(Comparisons.Type.LESS_THAN, comparand);
    }

    @Nonnull
    public QueryComponent lessThanOrEquals(@Nonnull Object comparand) {
        return this.withComparison(Comparisons.Type.LESS_THAN_OR_EQUALS, comparand);
    }

    @Nonnull
    public QueryComponent in(@Nonnull List<?> comparand) {
        return this.withComparison(new Comparisons.ListComparison(Comparisons.Type.IN, comparand));
    }

    @Nonnull
    public QueryComponent in(@Nonnull String param) {
        return this.withParameterComparison(Comparisons.Type.IN, param);
    }

    @Nonnull
    public QueryComponent withComparison(@Nonnull Comparisons.Comparison comparison) {
        return this.and(new QueryRecordFunctionWithComparison(this.function, comparison));
    }

    @Nonnull
    public QueryComponent withComparison(@Nonnull Comparisons.Type type, @Nonnull Object comparand) {
        return this.withComparison(new Comparisons.SimpleComparison(type, comparand));
    }

    @Nonnull
    public QueryComponent withParameterComparison(@Nonnull Comparisons.Type type, String parameter) {
        return this.withComparison(new Comparisons.ParameterComparison(type, parameter));
    }

    public <M extends Message> CompletableFuture<T> eval(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBStoredRecord<M> record) {
        if (record == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.additionalCondition == null) {
            return store.evaluateRecordFunction(context, this.function, record);
        }
        if (this.evalFunction == null) {
            this.evalFunction = IndexFunctionHelper.recordFunctionWithSubrecordCondition(store.getUntypedRecordStore(), (IndexRecordFunction)this.function, record, this.additionalCondition);
        }
        return store.evaluateRecordFunction(context, this.evalFunction, record);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryRecordFunction that = (QueryRecordFunction)obj;
        return this.function.equals(that.function) && Objects.equals(this.additionalCondition, that.additionalCondition);
    }

    public int hashCode() {
        return this.function.hashCode();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.function.planHash(mode);
            }
            case FOR_CONTINUATION: {
                if (this.additionalCondition == null) {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.function);
                }
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.function, this.additionalCondition);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    public String toString() {
        if (this.additionalCondition == null) {
            return this.function.toString();
        }
        return String.valueOf(this.function) + " | " + String.valueOf(this.additionalCondition);
    }
}

