/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordFunction;
import com.apple.foundationdb.record.metadata.IndexRecordFunction;
import com.apple.foundationdb.record.metadata.StoreRecordFunction;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithComparison;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedRecordValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RankValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.VersionValue;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class QueryRecordFunctionWithComparison
implements ComponentWithComparison {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Query-Record-Function-With-Comparison");
    @Nonnull
    private final RecordFunction<?> function;
    @Nonnull
    private final Comparisons.Comparison comparison;

    public QueryRecordFunctionWithComparison(@Nonnull RecordFunction<?> function, @Nonnull Comparisons.Comparison comparison) {
        this.function = function;
        this.comparison = comparison;
    }

    @Nonnull
    public RecordFunction<?> getFunction() {
        return this.function;
    }

    @Override
    @Nonnull
    public Comparisons.Comparison getComparison() {
        return this.comparison;
    }

    @Override
    public QueryComponent withOtherComparison(Comparisons.Comparison comparison) {
        return new QueryRecordFunctionWithComparison(this.function, comparison);
    }

    @Override
    public String getName() {
        return this.function.getName();
    }

    @Override
    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        return store.getContext().join(this.evalMessageAsync(store, context, rec, message));
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    @Nonnull
    public <M extends Message> CompletableFuture<Boolean> evalMessageAsync(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        if (rec == null) {
            return CompletableFuture.completedFuture(this.getComparison().eval(store, context, null));
        }
        return store.evaluateRecordFunction(context, this.function, rec).thenApply(value -> this.getComparison().eval(store, context, value));
    }

    @Override
    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        this.function.validate(descriptor);
    }

    @Override
    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        if (this.function instanceof IndexRecordFunction && "rank".equals(this.function.getName())) {
            GroupingKeyExpression groupingKeyExpression = ((IndexRecordFunction)this.function).getOperand();
            KeyExpression wholeKeyExpression = groupingKeyExpression.getWholeKey();
            KeyExpressionExpansionVisitor expansionVisitor = new KeyExpressionExpansionVisitor();
            Quantifier.ForEach innerBaseQuantifier = outerQuantifierSupplier.get();
            GraphExpansion partitioningAndArgumentExpansion = wholeKeyExpression.expand(expansionVisitor.push(KeyExpressionExpansionVisitor.VisitorState.forQueries(Lists.newArrayList(), innerBaseQuantifier, fieldNamePrefix)));
            GraphExpansion.Sealed sealedPartitioningAndArgumentExpansion = partitioningAndArgumentExpansion.seal();
            int partitioningSize = groupingKeyExpression.getGroupingCount();
            List<Value> partitioningExpressions = sealedPartitioningAndArgumentExpansion.getResultValues().subList(0, partitioningSize);
            List<Value> argumentExpressions = sealedPartitioningAndArgumentExpansion.getResultValues().subList(partitioningSize, groupingKeyExpression.getColumnSize());
            RankValue rankValue = new RankValue(partitioningExpressions, argumentExpressions);
            ValuePredicate rankPredicate = new ValuePredicate(rankValue, this.comparison);
            ValuePredicate selfJoinPredicate = innerBaseQuantifier.getFlowedObjectValue().withComparison(new Comparisons.ValueComparison(Comparisons.Type.EQUALS, QuantifiedObjectValue.of(baseQuantifier.getAlias(), baseQuantifier.getFlowedObjectType())));
            GraphExpansion.Builder rankExpansionBuilder = partitioningAndArgumentExpansion.toBuilder().removeAllResultColumns().addPredicate(rankPredicate).addPredicate(selfJoinPredicate);
            rankExpansionBuilder.pullUpQuantifier(innerBaseQuantifier);
            partitioningAndArgumentExpansion.getQuantifiers().forEach(quantifier -> rankExpansionBuilder.addAllResultColumns(quantifier.getFlowedColumns()));
            SelectExpression rankSelectExpression = rankExpansionBuilder.build().buildSelect();
            Quantifier.Existential rankComparisonQuantifier = Quantifier.existential(Reference.initialOf((RelationalExpression)rankSelectExpression));
            return GraphExpansion.ofExists(rankComparisonQuantifier);
        }
        if (this.function instanceof StoreRecordFunction && "version".equals(this.function.getName())) {
            VersionValue versionValue = new VersionValue(QuantifiedRecordValue.of(baseQuantifier));
            return GraphExpansion.builder().addPredicate(new ValuePredicate(versionValue, this.comparison)).build();
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.valueOf(this.function) + " " + String.valueOf(this.getComparison());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRecordFunctionWithComparison that = (QueryRecordFunctionWithComparison)o;
        return Objects.equals(this.function, that.function) && Objects.equals(this.getComparison(), that.getComparison());
    }

    public int hashCode() {
        return Objects.hash(this.function, this.getComparison());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.function.planHash(mode) + this.getComparison().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.planHash(mode, BASE_HASH, this.function, this.getComparison());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

