/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.planprotos.PComparison;
import com.apple.foundationdb.record.planprotos.PRecordTypeComparison;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithComparison;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordTypeValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordTypeKeyComparison
implements ComponentWithComparison {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Type-Key-Comparison");
    @Nonnull
    private final RecordTypeComparison comparison;

    public RecordTypeKeyComparison(@Nonnull String recordTypeName) {
        this.comparison = new RecordTypeComparison(recordTypeName);
    }

    public static boolean hasRecordTypeKeyComparison(@Nonnull ScanComparisons scanComparisons) {
        return scanComparisons.getEqualitySize() > 0 && scanComparisons.getEqualityComparisons().get(0) instanceof RecordTypeComparison;
    }

    public static Set<String> recordTypeKeyComparisonTypes(@Nonnull ScanComparisons scanComparisons) {
        return Collections.singleton(((RecordTypeComparison)scanComparisons.getEqualityComparisons().get((int)0)).recordTypeName);
    }

    @Override
    public String getName() {
        return this.getComparison().typelessString();
    }

    @Override
    @Nullable
    public <M extends Message> Boolean evalMessage(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable FDBRecord<M> rec, @Nullable Message message) {
        return this.getComparison().eval(store, context, message);
    }

    @Override
    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
    }

    @Override
    @Nonnull
    public Comparisons.Comparison getComparison() {
        return this.comparison;
    }

    @Override
    @Nonnull
    public GraphExpansion expand(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Supplier<Quantifier.ForEach> outerQuantifierSupplier, @Nonnull List<String> fieldNamePrefix) {
        return GraphExpansion.ofPredicate(new RecordTypeValue(QuantifiedObjectValue.of(baseQuantifier)).withComparison(new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, Objects.requireNonNull(this.comparison.getComparand()))));
    }

    public String toString() {
        return this.getComparison().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RecordTypeKeyComparison that = (RecordTypeKeyComparison)o;
        return Objects.equals(this.getComparison(), that.getComparison());
    }

    public int hashCode() {
        return Objects.hash(this.getComparison());
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return this.getComparison().planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.getComparison());
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    public QueryComponent withOtherComparison(Comparisons.Comparison comparison) {
        throw new UnsupportedOperationException("Cannot change comparison");
    }

    public static class RecordTypeComparison
    implements Comparisons.Comparison {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Record-Type-Comparison");
        @Nonnull
        private final String recordTypeName;

        RecordTypeComparison(@Nonnull String recordTypeName) {
            this.recordTypeName = recordTypeName;
        }

        @Override
        @Nullable
        public Boolean eval(@Nullable FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, @Nullable Object value) {
            if (value == null) {
                return null;
            }
            return ((Message)value).getDescriptorForType().getName().equals(this.recordTypeName);
        }

        @Override
        public void validate(@Nonnull Descriptors.FieldDescriptor descriptor, boolean fannedOut) {
        }

        @Override
        @Nonnull
        public Optional<Comparisons.Comparison> replaceValuesMaybe(@Nonnull Function<Value, Optional<Value>> replacementFunction) {
            return Optional.of(this);
        }

        @Override
        @Nonnull
        public Comparisons.Comparison translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
            return this;
        }

        @Override
        @Nonnull
        public Comparisons.Type getType() {
            return Comparisons.Type.EQUALS;
        }

        @Override
        @Nonnull
        public Comparisons.Comparison withType(@Nonnull Comparisons.Type newType) {
            if (newType == Comparisons.Type.EQUALS) {
                return this;
            }
            throw new RecordCoreException("'" + RecordTypeKeyComparison.class.getSimpleName() + "' expects '" + Comparisons.Type.EQUALS.name() + "' comparison only", new Object[0]);
        }

        @Override
        @Nullable
        public Object getComparand(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
            if (store == null) {
                throw Comparisons.EvaluationContextRequiredException.instance();
            }
            return store.getRecordMetaData().getIndexableRecordType(this.recordTypeName).getRecordTypeKey();
        }

        @Override
        @Nonnull
        public String typelessString() {
            return this.recordTypeName;
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return PlanHashable.objectPlanHash(mode, (Object)this.recordTypeName);
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.recordTypeName);
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }

        public String toString() {
            return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain() {
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addKeyword("IS").addWhitespace().addIdentifier(this.typelessString()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecordTypeComparison that = (RecordTypeComparison)o;
            return Objects.equals(this.recordTypeName, that.recordTypeName);
        }

        public int hashCode() {
            return Objects.hash(this.recordTypeName);
        }

        @Override
        @Nonnull
        public PRecordTypeComparison toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PRecordTypeComparison.newBuilder().setRecordTypeName(this.recordTypeName).build();
        }

        @Override
        @Nonnull
        public PComparison toComparisonProto(@Nonnull PlanSerializationContext serializationContext) {
            return PComparison.newBuilder().setRecordTypeComparison(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static RecordTypeComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordTypeComparison recordTypeComparisonProto) {
            return new RecordTypeComparison(Objects.requireNonNull(recordTypeComparisonProto.getRecordTypeName()));
        }

        public static class Deserializer
        implements PlanDeserializer<PRecordTypeComparison, RecordTypeComparison> {
            @Override
            @Nonnull
            public Class<PRecordTypeComparison> getProtoMessageClass() {
                return PRecordTypeComparison.class;
            }

            @Override
            @Nonnull
            public RecordTypeComparison fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PRecordTypeComparison recordTypeComparisonProto) {
                return RecordTypeComparison.fromProto(serializationContext, recordTypeComparisonProto);
            }
        }
    }
}

