/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.google.protobuf.Descriptors;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.INTERNAL)
class SimpleComponentWithChildren {
    @Nonnull
    private final List<QueryComponent> children;

    protected SimpleComponentWithChildren(@Nonnull List<QueryComponent> children) {
        if (children.size() < 2) {
            throw new RecordCoreException(this.getClass().getSimpleName() + " must have at least two children", new Object[0]);
        }
        this.children = children;
    }

    public void validate(@Nonnull Descriptors.Descriptor descriptor) {
        for (QueryComponent child : this.getChildren()) {
            child.validate(descriptor);
        }
    }

    @Nonnull
    public List<QueryComponent> getChildren() {
        return this.children;
    }
}

