/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithComparison;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class Text {
    @Nullable
    private final String tokenizerName;
    @Nonnull
    private final String defaultTokenizerName;

    Text(@Nullable String tokenizerName, @Nullable String defaultTokenizerName) {
        this.tokenizerName = tokenizerName;
        this.defaultTokenizerName = defaultTokenizerName == null ? "default" : defaultTokenizerName;
    }

    @Nonnull
    public QueryComponent contains(@Nonnull String token) {
        return this.getComponent(Comparisons.Type.TEXT_CONTAINS_ALL, Collections.singletonList(token));
    }

    @Nonnull
    public QueryComponent containsPrefix(@Nonnull String prefix) {
        return this.getComponent(Comparisons.Type.TEXT_CONTAINS_PREFIX, Collections.singletonList(prefix));
    }

    @Nonnull
    public QueryComponent containsAll(@Nonnull String tokens) {
        return this.getComponent(Comparisons.Type.TEXT_CONTAINS_ALL, tokens);
    }

    @Nonnull
    public QueryComponent containsAll(@Nonnull List<String> tokens) {
        return this.getComponent(Comparisons.Type.TEXT_CONTAINS_ALL, tokens);
    }

    @Nonnull
    public QueryComponent containsAll(@Nonnull String tokens, int maxDistance) {
        Comparisons.TextWithMaxDistanceComparison comparison = new Comparisons.TextWithMaxDistanceComparison(tokens, maxDistance, this.tokenizerName, this.defaultTokenizerName);
        return this.getComponent(comparison);
    }

    @Nonnull
    public QueryComponent containsAll(@Nonnull List<String> tokens, int maxDistance) {
        Comparisons.TextWithMaxDistanceComparison comparison = new Comparisons.TextWithMaxDistanceComparison(tokens, maxDistance, this.tokenizerName, this.defaultTokenizerName);
        return this.getComponent(comparison);
    }

    @Nonnull
    public QueryComponent containsAllPrefixes(@Nonnull String tokenPrefixes) {
        return this.containsAllPrefixes(tokenPrefixes, true);
    }

    @Nonnull
    public QueryComponent containsAllPrefixes(@Nonnull String tokenPrefixes, boolean strict) {
        Comparisons.TextContainsAllPrefixesComparison comparison = new Comparisons.TextContainsAllPrefixesComparison(tokenPrefixes, strict, this.tokenizerName, this.defaultTokenizerName);
        return this.getComponent(comparison);
    }

    @Nonnull
    public QueryComponent containsAllPrefixes(@Nonnull String tokenPrefixes, boolean strict, long expectedRecords, double falsePositivePercentage) {
        Comparisons.TextContainsAllPrefixesComparison comparison = new Comparisons.TextContainsAllPrefixesComparison(tokenPrefixes, strict, expectedRecords, falsePositivePercentage, this.tokenizerName, this.defaultTokenizerName);
        return this.getComponent(comparison);
    }

    @Nonnull
    public QueryComponent containsAllPrefixes(@Nonnull List<String> tokenPrefixes) {
        return this.containsAllPrefixes(tokenPrefixes, true);
    }

    @Nonnull
    public QueryComponent containsAllPrefixes(@Nonnull List<String> tokenPrefixes, boolean strict) {
        Comparisons.TextContainsAllPrefixesComparison comparison = new Comparisons.TextContainsAllPrefixesComparison(tokenPrefixes, strict, this.tokenizerName, this.defaultTokenizerName);
        return this.getComponent(comparison);
    }

    @Nonnull
    public QueryComponent containsAllPrefixes(@Nonnull List<String> tokenPrefixes, boolean strict, long expectedRecords, double falsePositivePercentage) {
        Comparisons.TextContainsAllPrefixesComparison comparison = new Comparisons.TextContainsAllPrefixesComparison(tokenPrefixes, strict, expectedRecords, falsePositivePercentage, this.tokenizerName, this.defaultTokenizerName);
        return this.getComponent(comparison);
    }

    @Nonnull
    public QueryComponent containsPhrase(@Nonnull String phrase) {
        return this.getComponent(Comparisons.Type.TEXT_CONTAINS_PHRASE, phrase);
    }

    @Nonnull
    public QueryComponent containsPhrase(@Nonnull List<String> phraseTokens) {
        return this.getComponent(Comparisons.Type.TEXT_CONTAINS_PHRASE, phraseTokens);
    }

    @Nonnull
    public QueryComponent containsAny(@Nonnull String tokens) {
        return this.getComponent(Comparisons.Type.TEXT_CONTAINS_ANY, tokens);
    }

    @Nonnull
    public QueryComponent containsAny(@Nonnull List<String> tokens) {
        return this.getComponent(Comparisons.Type.TEXT_CONTAINS_ANY, tokens);
    }

    @Nonnull
    public QueryComponent containsAnyPrefix(@Nonnull String tokenPrefixes) {
        return this.getComponent(Comparisons.Type.TEXT_CONTAINS_ANY_PREFIX, tokenPrefixes);
    }

    @Nonnull
    public QueryComponent containsAnyPrefix(@Nonnull List<String> tokenPrefixes) {
        return this.getComponent(Comparisons.Type.TEXT_CONTAINS_ANY_PREFIX, tokenPrefixes);
    }

    @Nonnull
    private ComponentWithComparison getComponent(@Nonnull Comparisons.Type type, @Nonnull String tokens) {
        Comparisons.TextComparison comparison = new Comparisons.TextComparison(type, tokens, this.tokenizerName, this.defaultTokenizerName);
        return this.getComponent(comparison);
    }

    @Nonnull
    private ComponentWithComparison getComponent(@Nonnull Comparisons.Type type, @Nonnull List<String> tokens) {
        Comparisons.TextComparison comparison = new Comparisons.TextComparison(type, tokens, this.tokenizerName, this.defaultTokenizerName);
        return this.getComponent(comparison);
    }

    @Nonnull
    abstract ComponentWithComparison getComponent(@Nonnull Comparisons.Comparison var1);
}

