/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.SyntheticRecordType;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.InvertibleFunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.planprotos.PIndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.ExpressionToTuplePathVisitor;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.PlanWithStoredFields;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.planning.TextScanPlanner;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AvailableFields {
    @Nonnull
    public static final AvailableFields ALL_FIELDS = new AvailableFields(null);
    @Nonnull
    public static final AvailableFields NO_FIELDS = new AvailableFields(Collections.emptyMap());
    @Nullable
    private final Map<KeyExpression, FieldData> fields;

    private AvailableFields(@Nullable Map<KeyExpression, FieldData> fields) {
        this.fields = fields;
    }

    public boolean hasAllFields() {
        return this.fields == null;
    }

    public boolean containsAll(@Nonnull Collection<KeyExpression> requiredFields) {
        if (this.fields == null) {
            return true;
        }
        return this.fields.keySet().containsAll(requiredFields);
    }

    @Nullable
    public IndexKeyValueToPartialRecord.Builder buildIndexKeyValueToPartialRecord(@Nonnull RecordType recordType) {
        if (this.fields == null) {
            return null;
        }
        IndexKeyValueToPartialRecord.Builder builder = IndexKeyValueToPartialRecord.newBuilder(recordType);
        for (Map.Entry<KeyExpression, FieldData> entry : this.fields.entrySet()) {
            if (AvailableFields.addCoveringField(entry.getKey(), entry.getValue(), builder)) continue;
            return null;
        }
        if (!builder.isValid()) {
            return null;
        }
        return builder;
    }

    @Nonnull
    public static AvailableFields fromIndex(@Nonnull RecordType recordType, @Nonnull Index index, @Nonnull PlannableIndexTypes indexTypes, @Nullable KeyExpression commonPrimaryKey, @Nonnull RecordQueryPlanWithIndex indexPlan) {
        FieldData fieldData;
        KeyExpression valueField;
        int i;
        KeyExpression rootExpression = index.getRootExpression();
        ArrayList<KeyExpression> keyFields = new ArrayList<KeyExpression>();
        ArrayList<KeyExpression> valueFields = new ArrayList<KeyExpression>();
        ArrayList<KeyExpression> nonStoredFields = new ArrayList<KeyExpression>();
        ArrayList<KeyExpression> otherFields = new ArrayList<KeyExpression>();
        AvailableFields.partitionFields(recordType, index, indexTypes, indexPlan, rootExpression, keyFields, valueFields, nonStoredFields, otherFields);
        HashMap<KeyExpression, FieldData> fields = new HashMap<KeyExpression, FieldData>();
        ImmutableMap<String, ImmutableIntArray> constituentNameToPathMap = commonPrimaryKey == null ? ImmutableMap.of() : AvailableFields.getConstituentToPathMap(recordType, keyFields.size());
        IndexKeyValueToPartialRecord.Builder builder = IndexKeyValueToPartialRecord.newBuilder(recordType);
        int keyPosition = 0;
        Iterator iterator = keyFields.iterator();
        while (iterator.hasNext()) {
            InvertibleFunctionKeyExpression invertibleExpression;
            KeyExpression keyField;
            KeyExpression keyFieldToAdd = keyField = (KeyExpression)iterator.next();
            FieldData fieldData2 = AvailableFields.constrainFieldData(recordType, constituentNameToPathMap, keyFieldToAdd, ImmutableIntArray.of(keyPosition));
            if (keyFieldToAdd instanceof InvertibleFunctionKeyExpression && (invertibleExpression = (InvertibleFunctionKeyExpression)keyFieldToAdd).isInjective()) {
                keyFieldToAdd = invertibleExpression.getChild();
                String invertibleFunction = invertibleExpression.getName();
                fieldData2 = fieldData2.withInvertibleFunction(invertibleFunction);
            }
            if (!nonStoredFields.contains(keyFieldToAdd) && !keyFieldToAdd.createsDuplicates() && AvailableFields.addCoveringField(keyFieldToAdd, fieldData2, builder)) {
                fields.put(keyFieldToAdd, fieldData2);
            }
            keyPosition += keyFieldToAdd.getColumnSize();
        }
        if (commonPrimaryKey != null) {
            fields.putAll(AvailableFields.getPrimaryKeyFieldMap(recordType, index, commonPrimaryKey, keyPosition, nonStoredFields, constituentNameToPathMap, builder));
        }
        for (i = 0; i < valueFields.size(); ++i) {
            valueField = (KeyExpression)valueFields.get(i);
            fieldData = FieldData.ofUnconditional(IndexKeyValueToPartialRecord.TupleSource.VALUE, ImmutableIntArray.of(i));
            if (nonStoredFields.contains(valueField) || valueField.createsDuplicates() || !AvailableFields.addCoveringField(valueField, fieldData, builder)) continue;
            fields.put(valueField, fieldData);
        }
        for (i = 0; i < otherFields.size(); ++i) {
            valueField = (KeyExpression)otherFields.get(i);
            fieldData = FieldData.ofUnconditional(IndexKeyValueToPartialRecord.TupleSource.OTHER, ImmutableIntArray.of(i));
            fields.put(valueField, fieldData);
        }
        if (!builder.isValid()) {
            return NO_FIELDS;
        }
        return new AvailableFields(fields);
    }

    @Nonnull
    public static ImmutableMap<String, ImmutableIntArray> getConstituentToPathMap(@Nonnull RecordType recordType, int startPrimaryKey) {
        if (!recordType.isSynthetic()) {
            return ImmutableMap.of();
        }
        Verify.verify(recordType instanceof SyntheticRecordType);
        SyntheticRecordType syntheticRecordType = (SyntheticRecordType)recordType;
        List constituents = syntheticRecordType.getConstituents();
        int startConstituents = startPrimaryKey + 1;
        ImmutableMap.Builder<String, ImmutableIntArray> constituentNameToPathMapBuilder = ImmutableMap.builder();
        for (int i = 0; i < constituents.size(); ++i) {
            SyntheticRecordType.Constituent constituent = (SyntheticRecordType.Constituent)constituents.get(i);
            constituentNameToPathMapBuilder.put(constituent.getName(), ImmutableIntArray.of(startConstituents + i));
        }
        return constituentNameToPathMapBuilder.build();
    }

    private static void partitionFields(@Nonnull RecordType recordType, @Nonnull Index index, @Nonnull PlannableIndexTypes indexTypes, @Nonnull RecordQueryPlanWithIndex indexPlan, @Nonnull KeyExpression rootExpression, @Nonnull List<KeyExpression> keyFields, @Nonnull List<KeyExpression> valueFields, @Nonnull List<KeyExpression> nonStoredFields, @Nonnull List<KeyExpression> otherFields) {
        if (indexTypes.getTextTypes().contains(index.getType())) {
            keyFields.addAll(TextScanPlanner.getOtherFields(rootExpression));
        } else if (indexTypes.getValueTypes().contains(index.getType()) || indexTypes.getRankTypes().contains(index.getType())) {
            keyFields.addAll(KeyExpression.getKeyFields(rootExpression));
            valueFields.addAll(KeyExpression.getValueFields(rootExpression));
        } else if (indexTypes.getUnstoredNonPrimaryKeyTypes().contains(index.getType())) {
            keyFields.addAll(rootExpression.normalizeKeyForPositions());
            nonStoredFields.addAll(keyFields);
            nonStoredFields.removeAll(recordType.getPrimaryKey().normalizeKeyForPositions());
            if (rootExpression instanceof GroupingKeyExpression) {
                GroupingKeyExpression groupingKeyExpression = (GroupingKeyExpression)rootExpression;
                nonStoredFields.removeAll(groupingKeyExpression.getGroupingSubKey().normalizeKeyForPositions());
            }
            if (indexPlan instanceof PlanWithStoredFields) {
                ((PlanWithStoredFields)((Object)indexPlan)).getStoredFields(keyFields, nonStoredFields, otherFields);
            }
        } else if (rootExpression instanceof GroupingKeyExpression) {
            GroupingKeyExpression groupingKeyExpression = (GroupingKeyExpression)rootExpression;
            keyFields.addAll(groupingKeyExpression.getGroupingSubKey().normalizeKeyForPositions());
        }
    }

    public static Map<KeyExpression, FieldData> getPrimaryKeyFieldMap(@Nonnull RecordType recordType, @Nonnull Index index, @Nonnull KeyExpression commonPrimaryKey, @Nonnull int primaryKeyStartOrdinal, @Nonnull List<KeyExpression> nonStoredFields, @Nonnull ImmutableMap<String, ImmutableIntArray> constituentNameToPathMap, @Nonnull IndexKeyValueToPartialRecord.Builder builder) {
        ListMultimap<Object, Object> primaryKeyPartsToTuplePathMap;
        if (commonPrimaryKey != null) {
            BitSet coveredPrimaryKeyPositions = index.getCoveredPrimaryKeyPositions();
            ExpressionToTuplePathVisitor expressionToTuplePathVisitor = new ExpressionToTuplePathVisitor(commonPrimaryKey, IndexKeyValueToPartialRecord.TupleSource.KEY, primaryKeyStartOrdinal, coveredPrimaryKeyPositions);
            primaryKeyPartsToTuplePathMap = expressionToTuplePathVisitor.compute();
        } else {
            primaryKeyPartsToTuplePathMap = ImmutableListMultimap.of();
        }
        ImmutableMap.Builder<KeyExpression, FieldData> resultFieldMapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : primaryKeyPartsToTuplePathMap.entries()) {
            KeyExpression keyField = (KeyExpression)entry.getKey();
            FieldData fieldData = (FieldData)entry.getValue();
            fieldData = AvailableFields.constrainFieldData(recordType, constituentNameToPathMap, keyField, fieldData.getOrdinalPath());
            if (nonStoredFields.contains(keyField) || keyField.createsDuplicates() || !AvailableFields.addCoveringField(keyField, fieldData, builder)) continue;
            resultFieldMapBuilder.put(keyField, fieldData);
        }
        return resultFieldMapBuilder.build();
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static FieldData constrainFieldData(@Nonnull RecordType recordType, @Nonnull ImmutableMap<String, ImmutableIntArray> constituentNameToPathMap, @Nonnull KeyExpression keyField, @Nonnull ImmutableIntArray path) {
        String constituentName = recordType.isSynthetic() ? (keyField instanceof FieldKeyExpression ? ((FieldKeyExpression)keyField).getFieldName() : (keyField instanceof NestingKeyExpression ? ((NestingKeyExpression)keyField).getParent().getFieldName() : null)) : null;
        if (constituentName != null && constituentNameToPathMap.containsKey(constituentName)) {
            ImmutableIntArray conditionalPath = Objects.requireNonNull(constituentNameToPathMap.get(constituentName));
            return FieldData.ofConditional(IndexKeyValueToPartialRecord.TupleSource.KEY, path, conditionalPath);
        }
        return FieldData.ofUnconditional(IndexKeyValueToPartialRecord.TupleSource.KEY, path);
    }

    public static boolean addCoveringField(@Nonnull KeyExpression requiredExpr, @Nonnull FieldData fieldData, @Nonnull IndexKeyValueToPartialRecord.Builder builder) {
        if (fieldData.source == IndexKeyValueToPartialRecord.TupleSource.OTHER) {
            return true;
        }
        while (requiredExpr instanceof NestingKeyExpression) {
            NestingKeyExpression nesting = (NestingKeyExpression)requiredExpr;
            String fieldName = nesting.getParent().getFieldName();
            requiredExpr = nesting.getChild();
            builder = builder.getFieldBuilder(fieldName);
        }
        if (requiredExpr instanceof FieldKeyExpression) {
            FieldKeyExpression fieldKeyExpression = (FieldKeyExpression)requiredExpr;
            if (fieldKeyExpression.getNullStandin().equals((Object)Key.Evaluated.NullStandin.NOT_NULL) || fieldKeyExpression.getFanType().equals((Object)KeyExpression.FanType.FanOut)) {
                return false;
            }
            if (!builder.hasField(fieldKeyExpression.getFieldName())) {
                builder.addField(fieldKeyExpression.getFieldName(), fieldData.source, fieldData.copyIfPredicate, fieldData.ordinalPath, fieldData.invertibleFunction);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public static AvailableFields intersection(@Nonnull List<AvailableFields> toIntersect) {
        if (toIntersect.isEmpty()) {
            throw new RecordCoreException("tried to find intersection of an empty list of available fields", new Object[0]);
        }
        HashMap<KeyExpression, FieldData> intersection = null;
        for (AvailableFields fields : toIntersect) {
            if (fields.hasAllFields()) continue;
            Objects.requireNonNull(fields.fields);
            if (intersection == null) {
                intersection = new HashMap<KeyExpression, FieldData>(fields.fields);
                continue;
            }
            intersection.keySet().retainAll(fields.fields.keySet());
        }
        if (intersection == null) {
            return ALL_FIELDS;
        }
        return new AvailableFields(intersection);
    }

    @API(value=API.Status.INTERNAL)
    public static class FieldData {
        @Nonnull
        private final IndexKeyValueToPartialRecord.TupleSource source;
        @Nonnull
        private final ImmutableIntArray ordinalPath;
        @Nonnull
        private final CopyIfPredicate copyIfPredicate;
        @Nullable
        private final String invertibleFunction;

        private FieldData(@Nonnull IndexKeyValueToPartialRecord.TupleSource source, @Nonnull ImmutableIntArray ordinalPath, @Nonnull CopyIfPredicate copyIfPredicate, @Nullable String invertibleFunction) {
            this.source = source;
            this.ordinalPath = ordinalPath;
            this.copyIfPredicate = copyIfPredicate;
            this.invertibleFunction = invertibleFunction;
        }

        @Nonnull
        public IndexKeyValueToPartialRecord.TupleSource getSource() {
            return this.source;
        }

        public ImmutableIntArray getOrdinalPath() {
            return this.ordinalPath;
        }

        public CopyIfPredicate getCopyIfPredicate() {
            return this.copyIfPredicate;
        }

        @Nullable
        public String getInvertibleFunction() {
            return this.invertibleFunction;
        }

        @Nonnull
        public FieldData withInvertibleFunction(@Nullable String invertibleFunction) {
            return new FieldData(this.source, this.ordinalPath, this.copyIfPredicate, invertibleFunction);
        }

        @Nonnull
        public static FieldData ofUnconditional(@Nonnull IndexKeyValueToPartialRecord.TupleSource source, @Nonnull ImmutableIntArray ordinalPath) {
            return new FieldData(source, ordinalPath, new TruePredicate(), null);
        }

        @Nonnull
        public static FieldData ofConditional(@Nonnull IndexKeyValueToPartialRecord.TupleSource source, @Nonnull ImmutableIntArray ordinalPath, @Nonnull ImmutableIntArray conditionalPath) {
            return new FieldData(source, ordinalPath, new ConditionalUponPathPredicate(conditionalPath), null);
        }
    }

    @API(value=API.Status.INTERNAL)
    public static interface CopyIfPredicate
    extends Predicate<Tuple>,
    PlanHashable,
    PlanSerializable {
        @Nonnull
        public PIndexKeyValueToPartialRecord.PCopyIfPredicate toCopyIfPredicateProto(@Nonnull PlanSerializationContext var1);

        @Nonnull
        public static CopyIfPredicate fromCopyIfPredicateProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PCopyIfPredicate copyIfPredicateProto) {
            return (CopyIfPredicate)PlanSerialization.dispatchFromProtoContainer(serializationContext, copyIfPredicateProto);
        }
    }

    public static class ConditionalUponPathPredicate
    implements CopyIfPredicate {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Conditional-Upon-Predicate");
        @Nonnull
        private final ImmutableIntArray conditionalPath;

        public ConditionalUponPathPredicate(@Nonnull ImmutableIntArray conditionalPath) {
            this.conditionalPath = conditionalPath;
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
            return PlanHashable.objectsPlanHash(hashMode, BASE_HASH, this.conditionalPath);
        }

        @Override
        @Nonnull
        public PIndexKeyValueToPartialRecord.PCopyIfPredicate.PConditionalUponPathPredicate toProto(@Nonnull PlanSerializationContext serializationContext) {
            PIndexKeyValueToPartialRecord.PCopyIfPredicate.PConditionalUponPathPredicate.Builder builder = PIndexKeyValueToPartialRecord.PCopyIfPredicate.PConditionalUponPathPredicate.newBuilder();
            this.conditionalPath.forEach(i -> builder.addOrdinalPath(i));
            return builder.build();
        }

        @Override
        @Nonnull
        public PIndexKeyValueToPartialRecord.PCopyIfPredicate toCopyIfPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
            return PIndexKeyValueToPartialRecord.PCopyIfPredicate.newBuilder().setConditionalUponPathPredicate(this.toProto(serializationContext)).build();
        }

        @Override
        public boolean test(Tuple tuple) {
            return IndexKeyValueToPartialRecord.existsSubTupleForOrdinalPath(tuple, this.conditionalPath);
        }

        @Nonnull
        public static ConditionalUponPathPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PCopyIfPredicate.PConditionalUponPathPredicate conditionalUponPredicateProto) {
            ImmutableIntArray.Builder ordinalPathBuilder = ImmutableIntArray.builder();
            for (int i = 0; i < conditionalUponPredicateProto.getOrdinalPathCount(); ++i) {
                ordinalPathBuilder.add(i);
            }
            return new ConditionalUponPathPredicate(ordinalPathBuilder.build());
        }

        public static class Deserializer
        implements PlanDeserializer<PIndexKeyValueToPartialRecord.PCopyIfPredicate.PConditionalUponPathPredicate, ConditionalUponPathPredicate> {
            @Override
            @Nonnull
            public Class<PIndexKeyValueToPartialRecord.PCopyIfPredicate.PConditionalUponPathPredicate> getProtoMessageClass() {
                return PIndexKeyValueToPartialRecord.PCopyIfPredicate.PConditionalUponPathPredicate.class;
            }

            @Override
            @Nonnull
            public ConditionalUponPathPredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PCopyIfPredicate.PConditionalUponPathPredicate conditionalUponPathPredicateProto) {
                return ConditionalUponPathPredicate.fromProto(serializationContext, conditionalUponPathPredicateProto);
            }
        }
    }

    public static class TruePredicate
    implements CopyIfPredicate {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("True-Predicate");

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
            return PlanHashable.objectPlanHash(hashMode, (Object)BASE_HASH);
        }

        @Override
        @Nonnull
        public PIndexKeyValueToPartialRecord.PCopyIfPredicate.PTruePredicate toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PIndexKeyValueToPartialRecord.PCopyIfPredicate.PTruePredicate.newBuilder().build();
        }

        @Override
        @Nonnull
        public PIndexKeyValueToPartialRecord.PCopyIfPredicate toCopyIfPredicateProto(@Nonnull PlanSerializationContext serializationContext) {
            return PIndexKeyValueToPartialRecord.PCopyIfPredicate.newBuilder().setTruePredicate(this.toProto(serializationContext)).build();
        }

        @Override
        public boolean test(Tuple tuple) {
            return true;
        }

        @Nonnull
        public static TruePredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PCopyIfPredicate.PTruePredicate truePredicateProto) {
            return new TruePredicate();
        }

        public static class Deserializer
        implements PlanDeserializer<PIndexKeyValueToPartialRecord.PCopyIfPredicate.PTruePredicate, TruePredicate> {
            @Override
            @Nonnull
            public Class<PIndexKeyValueToPartialRecord.PCopyIfPredicate.PTruePredicate> getProtoMessageClass() {
                return PIndexKeyValueToPartialRecord.PCopyIfPredicate.PTruePredicate.class;
            }

            @Override
            @Nonnull
            public TruePredicate fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PCopyIfPredicate.PTruePredicate truePredicateProto) {
                return TruePredicate.fromProto(serializationContext, truePredicateProto);
            }
        }
    }
}

