/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithValue;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.metadata.expressions.ListKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExpressionToTuplePathVisitor
implements KeyExpressionVisitor<State, Result> {
    @Nonnull
    private final KeyExpression keyExpression;
    @Nonnull
    private final IndexKeyValueToPartialRecord.TupleSource tupleSource;
    private final int startOrdinal;
    @Nonnull
    private final BitSet skipSet;
    private final Deque<State> states;

    public ExpressionToTuplePathVisitor(@Nonnull KeyExpression keyExpression, @Nonnull IndexKeyValueToPartialRecord.TupleSource tupleSource, int startOrdinal, @Nonnull BitSet skipSet) {
        this.keyExpression = keyExpression;
        this.tupleSource = tupleSource;
        this.startOrdinal = startOrdinal;
        this.skipSet = skipSet;
        this.states = new ArrayDeque<State>();
    }

    @Override
    public State getCurrentState() {
        return this.states.peek();
    }

    public ExpressionToTuplePathVisitor push(State newState) {
        this.states.push(newState);
        return this;
    }

    public State pop() {
        return this.states.pop();
    }

    public <T> T pop(T t2) {
        this.pop();
        return t2;
    }

    @Override
    @Nonnull
    public final Result visitExpression(@Nonnull KeyExpression keyExpression) {
        return this.visitDefault(keyExpression);
    }

    @Override
    @Nonnull
    public Result visitExpression(@Nonnull EmptyKeyExpression emptyKeyExpression) {
        return this.visitDefault(emptyKeyExpression);
    }

    @Override
    @Nonnull
    public Result visitExpression(@Nonnull FieldKeyExpression fieldKeyExpression) {
        KeyExpression.FanType fanType = fieldKeyExpression.getFanType();
        if (fanType != KeyExpression.FanType.None) {
            throw new RecordCoreException("cannot handle this expression", new Object[0]);
        }
        return this.visitDefault(fieldKeyExpression);
    }

    @Override
    @Nonnull
    public Result visitExpression(@Nonnull KeyExpressionWithValue keyExpressionWithValue) {
        return this.visitDefault(keyExpressionWithValue);
    }

    @Override
    @Nonnull
    public Result visitExpression(@Nonnull FunctionKeyExpression functionKeyExpression) {
        return this.visitDefault(functionKeyExpression);
    }

    @Override
    @Nonnull
    public Result visitExpression(@Nonnull KeyWithValueExpression keyWithValueExpression) {
        throw new RecordCoreException("cannot handle this expression", new Object[0]);
    }

    @Override
    @Nonnull
    public Result visitExpression(@Nonnull NestingKeyExpression nestingKeyExpression) {
        FieldKeyExpression parent = nestingKeyExpression.getParent();
        KeyExpression.FanType fanType = parent.getFanType();
        if (fanType != KeyExpression.FanType.None) {
            throw new RecordCoreException("cannot handle this expression", new Object[0]);
        }
        Result childResult = this.pop(nestingKeyExpression.getChild().expand(this.push(this.getCurrentState())));
        ListMultimap<KeyExpression, AvailableFields.FieldData> childMap = childResult.getExpressionToFieldDataMap();
        int childNumSkippedMappings = childResult.getNumSkippedMappings();
        ImmutableListMultimap.Builder resultBuilder = ImmutableListMultimap.builder();
        for (Map.Entry entry : childMap.entries()) {
            resultBuilder.put(new NestingKeyExpression(parent, (KeyExpression)entry.getKey()), (AvailableFields.FieldData)entry.getValue());
        }
        return new Result((ListMultimap<KeyExpression, AvailableFields.FieldData>)((Object)resultBuilder.build()), childNumSkippedMappings);
    }

    @Override
    @Nonnull
    public Result visitExpression(@Nonnull ThenKeyExpression thenKeyExpression) {
        State state = this.getCurrentState();
        List<KeyExpression> children = thenKeyExpression.getChildren();
        ImmutableListMultimap.Builder resultBuilder = ImmutableListMultimap.builder();
        int ordinal = this.getCurrentState().getOrdinalWithParent().getOrdinal();
        int numSkippedMappings = 0;
        for (KeyExpression child : children) {
            Result childResult = this.pop(child.expand(this.push(state.withOrdinal(ordinal, numSkippedMappings))));
            ListMultimap<KeyExpression, AvailableFields.FieldData> childMap = childResult.getExpressionToFieldDataMap();
            resultBuilder.putAll(childMap);
            int childNumSkippedMappings = childResult.getNumSkippedMappings();
            numSkippedMappings += childNumSkippedMappings;
            ordinal += childMap.size();
        }
        return new Result((ListMultimap<KeyExpression, AvailableFields.FieldData>)((Object)resultBuilder.build()), numSkippedMappings);
    }

    @Override
    @Nonnull
    public Result visitExpression(@Nonnull ListKeyExpression listKeyExpression) {
        State state = this.getCurrentState();
        List<KeyExpression> children = listKeyExpression.getChildren();
        ImmutableListMultimap.Builder resultMapBuilder = ImmutableListMultimap.builder();
        int ordinal = state.getOrdinalWithParent().getOrdinal();
        for (KeyExpression child : children) {
            Result childResult = this.pop(child.expand(this.push(state.withNestedOrdinal(ordinal))));
            childResult.getExpressionToFieldDataMap().entries().forEach(entry -> {
                KeyExpression keyExpression = (KeyExpression)entry.getKey();
                AvailableFields.FieldData fieldData = (AvailableFields.FieldData)entry.getValue();
                resultMapBuilder.put(keyExpression, AvailableFields.FieldData.ofUnconditional(fieldData.getSource(), fieldData.getOrdinalPath()));
            });
            ++ordinal;
        }
        return new Result((ListMultimap<KeyExpression, AvailableFields.FieldData>)((Object)resultMapBuilder.build()), 0);
    }

    @Nonnull
    public final Result visitDefault(@Nonnull KeyExpression keyExpression) {
        int adjustedIndex;
        State currentState = this.getCurrentState();
        ImmutableIntArray path = currentState.getOrdinalWithParent().toPath();
        if (path.length() == 1 && this.skipSet.get(adjustedIndex = currentState.getOrdinalWithParent().getOrdinal() - this.startOrdinal + currentState.getNumSkippedMappings())) {
            return new Result(ImmutableListMultimap.of(), 1);
        }
        return new Result(ImmutableListMultimap.of(keyExpression, AvailableFields.FieldData.ofUnconditional(this.tupleSource, path)), 0);
    }

    @Nonnull
    public ListMultimap<KeyExpression, AvailableFields.FieldData> compute() {
        return this.pop(this.keyExpression.expand(this.push(State.ofStartingOrdinal(this.startOrdinal)))).getExpressionToFieldDataMap();
    }

    public static class State
    implements KeyExpressionVisitor.State {
        @Nonnull
        private final OrdinalWithParent ordinalWithParent;
        private final int numSkippedMappings;

        private State(@Nonnull OrdinalWithParent ordinalWithParent, int numSkippedMappings) {
            this.ordinalWithParent = ordinalWithParent;
            this.numSkippedMappings = numSkippedMappings;
        }

        @Nonnull
        public OrdinalWithParent getOrdinalWithParent() {
            return this.ordinalWithParent;
        }

        public int getNumSkippedMappings() {
            return this.numSkippedMappings;
        }

        @Nonnull
        public State withOrdinal(int ordinal, int numSkippedMappings) {
            return State.of(new OrdinalWithParent(this.ordinalWithParent.getParent(), ordinal), numSkippedMappings);
        }

        @Nonnull
        public State withNestedOrdinal(int ordinal) {
            return State.of(new OrdinalWithParent(new OrdinalWithParent(this.ordinalWithParent.getParent(), ordinal), 0), 0);
        }

        @Nonnull
        public static State of(@Nonnull OrdinalWithParent ordinalWithParent, int numSkippedMappings) {
            return new State(ordinalWithParent, numSkippedMappings);
        }

        @Nonnull
        public static State ofStartingOrdinal(int startingOrdinal) {
            return new State(new OrdinalWithParent(null, startingOrdinal), 0);
        }
    }

    public static class Result {
        @Nonnull
        private final ListMultimap<KeyExpression, AvailableFields.FieldData> expressionToTuplePathMap;
        private final int numSkippedMappings;

        public Result(@Nonnull ListMultimap<KeyExpression, AvailableFields.FieldData> expressionToTuplePathMap, int numSkippedMappings) {
            this.expressionToTuplePathMap = expressionToTuplePathMap;
            this.numSkippedMappings = numSkippedMappings;
        }

        @Nonnull
        public ListMultimap<KeyExpression, AvailableFields.FieldData> getExpressionToFieldDataMap() {
            return this.expressionToTuplePathMap;
        }

        public int getNumSkippedMappings() {
            return this.numSkippedMappings;
        }
    }

    private static class OrdinalWithParent {
        @Nullable
        private final OrdinalWithParent parent;
        private final int ordinal;

        public OrdinalWithParent(@Nullable OrdinalWithParent parent, int ordinal) {
            this.parent = parent;
            this.ordinal = ordinal;
        }

        @Nullable
        public OrdinalWithParent getParent() {
            return this.parent;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        @Nonnull
        public ImmutableIntArray toPath() {
            ImmutableIntArray.Builder builder = ImmutableIntArray.builder();
            this.buildPath(builder);
            return builder.build();
        }

        private void buildPath(@Nonnull ImmutableIntArray.Builder builder) {
            if (this.parent != null) {
                this.parent.buildPath(builder);
            }
            builder.add(this.ordinal);
        }
    }
}

