/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanDeserializer;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.InvertibleFunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.TupleFieldsHelper;
import com.apple.foundationdb.record.planprotos.PIndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.ImmutableIntArray;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroCopyByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class IndexKeyValueToPartialRecord
implements PlanHashable,
PlanSerializable {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Index-Key-Value-To-Partial-Record");
    @Nonnull
    private final List<Copier> copiers;
    private final boolean isRequired;

    private IndexKeyValueToPartialRecord(@Nonnull List<Copier> copiers, boolean isRequired) {
        this.copiers = copiers;
        this.isRequired = isRequired;
    }

    @Nonnull
    public Message toRecord(@Nonnull Descriptors.Descriptor recordDescriptor, @Nonnull IndexEntry kv) {
        return Verify.verifyNotNull(this.toRecordInternal(recordDescriptor, kv));
    }

    @Nullable
    public Message toRecordInternal(@Nonnull Descriptors.Descriptor recordDescriptor, @Nonnull IndexEntry kv) {
        DynamicMessage.Builder recordBuilder = DynamicMessage.newBuilder(recordDescriptor);
        boolean allCopiersRefused = true;
        for (Copier copier : this.copiers) {
            if (!copier.copy(recordDescriptor, recordBuilder, kv)) continue;
            allCopiersRefused = false;
        }
        if (this.isRequired) {
            return recordBuilder.build();
        }
        return allCopiersRefused ? null : recordBuilder.build();
    }

    public String toString() {
        return this.copiers.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexKeyValueToPartialRecord that = (IndexKeyValueToPartialRecord)o;
        return Objects.equals(this.copiers, that.copiers);
    }

    public int hashCode() {
        return Objects.hash(BASE_HASH, this.copiers, this.isRequired);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
        return PlanHashable.objectsPlanHash(hashMode, BASE_HASH, this.copiers, this.isRequired);
    }

    @Override
    @Nonnull
    public PIndexKeyValueToPartialRecord toProto(@Nonnull PlanSerializationContext serializationContext) {
        PIndexKeyValueToPartialRecord.Builder builder = PIndexKeyValueToPartialRecord.newBuilder();
        for (Copier copier : this.copiers) {
            builder.addCopiers(copier.toCopierProto(serializationContext));
        }
        builder.setIsRequired(this.isRequired);
        return builder.build();
    }

    @Nonnull
    public static IndexKeyValueToPartialRecord fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord indexKeyValueToPartialRecordProto) {
        Verify.verify(indexKeyValueToPartialRecordProto.hasIsRequired());
        ImmutableList.Builder copiersBuilder = ImmutableList.builder();
        for (int i = 0; i < indexKeyValueToPartialRecordProto.getCopiersCount(); ++i) {
            copiersBuilder.add(Copier.fromCopierProto(serializationContext, indexKeyValueToPartialRecordProto.getCopiers(i)));
        }
        return new IndexKeyValueToPartialRecord((List<Copier>)((Object)copiersBuilder.build()), indexKeyValueToPartialRecordProto.getIsRequired());
    }

    @Nullable
    public static Object getForOrdinalPath(@Nonnull Tuple tuple, @Nonnull ImmutableIntArray ordinalPath) {
        Object value = tuple;
        for (int i = 0; i < ordinalPath.length(); ++i) {
            if ((value = value instanceof Tuple ? ((Tuple)value).get(ordinalPath.get(i)) : ((List)value).get(ordinalPath.get(i))) != null) continue;
            return null;
        }
        return value;
    }

    public static boolean existsSubTupleForOrdinalPath(@Nonnull Tuple tuple, @Nonnull ImmutableIntArray ordinalPath) {
        Object value = tuple;
        for (int i = 0; i < ordinalPath.length() && (value = value instanceof Tuple ? ((Tuple)value).get(ordinalPath.get(i)) : ((List)value).get(ordinalPath.get(i))) != null; ++i) {
        }
        return value instanceof Tuple || value instanceof List;
    }

    public static Builder newBuilder(@Nonnull RecordType recordType) {
        return new Builder(recordType, true);
    }

    public static Builder newBuilder(@Nonnull Descriptors.Descriptor recordDescriptor) {
        return new Builder(recordDescriptor, true);
    }

    public static interface Copier
    extends PlanHashable,
    PlanSerializable {
        public boolean copy(@Nonnull Descriptors.Descriptor var1, @Nonnull Message.Builder var2, @Nonnull IndexEntry var3);

        @Nonnull
        public PIndexKeyValueToPartialRecord.PCopier toCopierProto(@Nonnull PlanSerializationContext var1);

        @Nonnull
        public static Copier fromCopierProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PCopier copierProto) {
            return (Copier)PlanSerialization.dispatchFromProtoContainer(serializationContext, copierProto);
        }
    }

    public static class Builder {
        @Nonnull
        private final Descriptors.Descriptor recordDescriptor;
        @Nonnull
        private final Map<String, Copier> fields;
        @Nonnull
        private final Map<String, Builder> nestedBuilders;
        private final List<Copier> regularCopiers = new ArrayList<Copier>();
        private final boolean isRequired;

        private Builder(@Nonnull RecordType recordType, boolean isRequired) {
            this(recordType.getDescriptor(), isRequired);
        }

        private Builder(@Nonnull Descriptors.Descriptor recordDescriptor, boolean isRequired) {
            this.recordDescriptor = recordDescriptor;
            this.fields = new TreeMap<String, Copier>();
            this.nestedBuilders = new TreeMap<String, Builder>();
            this.isRequired = isRequired;
        }

        public boolean hasField(@Nonnull String field) {
            return this.fields.containsKey(field) || this.nestedBuilders.containsKey(field);
        }

        public Builder addField(@Nonnull String field, @Nonnull TupleSource source, @Nonnull AvailableFields.CopyIfPredicate copyIfPredicate, @Nonnull ImmutableIntArray ordinalPath, @Nullable String invertibleFunction) {
            this.validateField(field);
            FieldCopier copier = new FieldCopier(field, source, copyIfPredicate, ordinalPath, invertibleFunction);
            if (this.fields.put(field, copier) != null) {
                throw new RecordCoreException("setting field more than once: " + field, new Object[0]);
            }
            return this;
        }

        public Builder addField(@Nonnull String field, @Nonnull Value extractFromIndexEntryValue) {
            this.validateField(field);
            FieldWithValueCopier copier = new FieldWithValueCopier(Quantifier.current(), ConstantPredicate.TRUE, extractFromIndexEntryValue, field);
            if (this.fields.put(field, copier) != null) {
                throw new RecordCoreException("setting field more than once: " + field, new Object[0]);
            }
            return this;
        }

        private void validateField(@Nonnull String field) {
            Descriptors.FieldDescriptor fieldDescriptor = this.recordDescriptor.findFieldByName(field);
            if (fieldDescriptor == null) {
                throw new MetaDataException("field not found: " + field, new Object[0]);
            }
            if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !TupleFieldsHelper.isTupleField(fieldDescriptor.getMessageType())) {
                throw new RecordCoreException("must set nested message field-by-field: " + field, new Object[0]);
            }
        }

        public Builder getFieldBuilder(@Nonnull String field) {
            Builder builder = this.nestedBuilders.get(field);
            if (builder == null) {
                Descriptors.FieldDescriptor fieldDescriptor = this.recordDescriptor.findFieldByName(field);
                if (fieldDescriptor == null) {
                    throw new MetaDataException("field not found: " + field, new Object[0]);
                }
                if (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) {
                    throw new RecordCoreException("not a nested message: " + field, new Object[0]);
                }
                builder = new Builder(fieldDescriptor.getMessageType(), fieldDescriptor.isRequired());
                this.nestedBuilders.put(field, builder);
            }
            return builder;
        }

        public void addRequiredMessageFields() {
            for (Descriptors.FieldDescriptor fieldDescriptor : this.recordDescriptor.getFields()) {
                if (!fieldDescriptor.isRequired() || fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) continue;
                this.nestedBuilders.putIfAbsent(fieldDescriptor.getName(), new Builder(fieldDescriptor.getMessageType(), true));
            }
            this.nestedBuilders.values().forEach(Builder::addRequiredMessageFields);
        }

        public boolean isValid() {
            return this.isValid(false);
        }

        public boolean isValid(boolean allowRepeated) {
            for (Descriptors.FieldDescriptor fieldDescriptor : this.recordDescriptor.getFields()) {
                Builder builder;
                if (fieldDescriptor.isRequired() && !this.hasField(fieldDescriptor.getName())) {
                    return false;
                }
                if (!allowRepeated && fieldDescriptor.isRepeated() && this.hasField(fieldDescriptor.getName())) {
                    return false;
                }
                if (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE || (builder = this.nestedBuilders.get(fieldDescriptor.getName())) == null || builder.isValid(allowRepeated)) continue;
                return false;
            }
            return true;
        }

        public void addRegularCopier(@Nonnull Copier copier) {
            this.regularCopiers.add(copier);
        }

        public IndexKeyValueToPartialRecord build() {
            ArrayList<Copier> copiers = new ArrayList<Copier>(this.fields.values());
            for (Map.Entry<String, Builder> entry : this.nestedBuilders.entrySet()) {
                copiers.add(new MessageCopier(entry.getKey(), entry.getValue().build()));
            }
            copiers.addAll(this.regularCopiers);
            return new IndexKeyValueToPartialRecord(copiers, this.isRequired);
        }
    }

    public static class MessageCopier
    implements Copier {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Message-Copier");
        @Nonnull
        private final String field;
        @Nonnull
        private final IndexKeyValueToPartialRecord nested;

        private MessageCopier(@Nonnull String field, @Nonnull IndexKeyValueToPartialRecord nested) {
            this.field = field;
            this.nested = nested;
        }

        @Override
        public boolean copy(@Nonnull Descriptors.Descriptor recordDescriptor, @Nonnull Message.Builder recordBuilder, @Nonnull IndexEntry kv) {
            Descriptors.FieldDescriptor fieldDescriptor = recordDescriptor.findFieldByName(this.field);
            switch (fieldDescriptor.getType()) {
                case MESSAGE: {
                    break;
                }
                default: {
                    throw new RecordCoreException("only nested message should be handled by MessageCopier", new Object[0]);
                }
            }
            Message message = this.nested.toRecordInternal(fieldDescriptor.getMessageType(), kv);
            if (message == null) {
                return false;
            }
            if (fieldDescriptor.isRepeated()) {
                recordBuilder.addRepeatedField(fieldDescriptor, message);
            } else {
                recordBuilder.setField(fieldDescriptor, message);
            }
            return true;
        }

        public String toString() {
            return this.field + ": " + String.valueOf(this.nested);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageCopier that = (MessageCopier)o;
            return Objects.equals(this.field, that.field) && Objects.equals(this.nested, that.nested);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.nested);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
            return PlanHashable.objectsPlanHash(hashMode, BASE_HASH, this.field, this.nested);
        }

        @Override
        @Nonnull
        public PIndexKeyValueToPartialRecord.PMessageCopier toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PIndexKeyValueToPartialRecord.PMessageCopier.newBuilder().setField(this.field).setNested(this.nested.toProto(serializationContext)).build();
        }

        @Override
        @Nonnull
        public PIndexKeyValueToPartialRecord.PCopier toCopierProto(@Nonnull PlanSerializationContext serializationContext) {
            return PIndexKeyValueToPartialRecord.PCopier.newBuilder().setMessageCopier(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static MessageCopier fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PMessageCopier messageCopierProto) {
            return new MessageCopier(Objects.requireNonNull(messageCopierProto.getField()), IndexKeyValueToPartialRecord.fromProto(serializationContext, Objects.requireNonNull(messageCopierProto.getNested())));
        }

        public static class Deserializer
        implements PlanDeserializer<PIndexKeyValueToPartialRecord.PMessageCopier, MessageCopier> {
            @Override
            @Nonnull
            public Class<PIndexKeyValueToPartialRecord.PMessageCopier> getProtoMessageClass() {
                return PIndexKeyValueToPartialRecord.PMessageCopier.class;
            }

            @Override
            @Nonnull
            public MessageCopier fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PMessageCopier messageCopierProto) {
                return MessageCopier.fromProto(serializationContext, messageCopierProto);
            }
        }
    }

    public static class FieldWithValueCopier
    implements Copier {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Field-With-Value-Copier");
        @Nonnull
        private final CorrelationIdentifier indexEntryAlias;
        @Nonnull
        private final QueryPredicate copyIfPredicate;
        @Nonnull
        private final Value extractFromIndexEntryValue;
        @Nonnull
        private final String field;
        @Nonnull
        private final Supplier<String> indexEntryBindingNameSupplier;

        private FieldWithValueCopier(@Nonnull CorrelationIdentifier indexEntryAlias, @Nonnull QueryPredicate copyIfPredicate, @Nonnull Value extractFromIndexEntryValue, @Nonnull String field) {
            this.indexEntryAlias = indexEntryAlias;
            this.copyIfPredicate = copyIfPredicate;
            this.extractFromIndexEntryValue = extractFromIndexEntryValue;
            this.field = field;
            this.indexEntryBindingNameSupplier = Suppliers.memoize(this::computeIndexEntryBindingName);
        }

        @Override
        public boolean copy(@Nonnull Descriptors.Descriptor recordDescriptor, @Nonnull Message.Builder recordBuilder, @Nonnull IndexEntry kv) {
            EvaluationContext evaluationContext = EvaluationContext.forBinding(this.getIndexEntryBindingName(), kv);
            Boolean shouldCopy = this.copyIfPredicate.evalWithoutStore(evaluationContext);
            if (shouldCopy == null || !shouldCopy.booleanValue()) {
                return false;
            }
            Descriptors.FieldDescriptor fieldDescriptor = recordDescriptor.findFieldByName(this.field);
            Object value = this.extractFromIndexEntryValue.evalWithoutStore(evaluationContext);
            if (value == null) {
                return !fieldDescriptor.isRequired();
            }
            switch (fieldDescriptor.getType()) {
                case MESSAGE: {
                    value = TupleFieldsHelper.toProto(value, fieldDescriptor.getMessageType());
                    break;
                }
                case ENUM: {
                    value = fieldDescriptor.getEnumType().findValueByNumber(((Internal.EnumLite)value).getNumber());
                    break;
                }
            }
            recordBuilder.setField(fieldDescriptor, value);
            return true;
        }

        @Nonnull
        private String getIndexEntryBindingName() {
            return this.indexEntryBindingNameSupplier.get();
        }

        @Nonnull
        private String computeIndexEntryBindingName() {
            return Bindings.Internal.CORRELATION.bindingName(this.indexEntryAlias.getId());
        }

        public String toString() {
            return this.field + ": " + String.valueOf(this.extractFromIndexEntryValue) + (String)(this.copyIfPredicate.isTautology() ? "" : " if " + String.valueOf(this.copyIfPredicate));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldWithValueCopier)) {
                return false;
            }
            FieldWithValueCopier that = (FieldWithValueCopier)o;
            return Objects.equals(this.field, that.field) && Objects.equals(this.indexEntryAlias, that.indexEntryAlias) && Objects.equals(this.copyIfPredicate, that.copyIfPredicate) && Objects.equals(this.extractFromIndexEntryValue, that.extractFromIndexEntryValue);
        }

        public int hashCode() {
            return Objects.hash(this.indexEntryAlias, this.copyIfPredicate, this.extractFromIndexEntryValue, this.field);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
            return PlanHashable.objectsPlanHash(hashMode, BASE_HASH, this.copyIfPredicate, this.extractFromIndexEntryValue, this.field);
        }

        @Override
        @Nonnull
        public PIndexKeyValueToPartialRecord.PFieldWithValueCopier toProto(@Nonnull PlanSerializationContext serializationContext) {
            return PIndexKeyValueToPartialRecord.PFieldWithValueCopier.newBuilder().setIndexEntryAlias(this.indexEntryAlias.getId()).setCopyIfPredicate(this.copyIfPredicate.toQueryPredicateProto(serializationContext)).setExtractFromIndexEntryValue(this.extractFromIndexEntryValue.toValueProto(serializationContext)).setField(this.field).build();
        }

        @Override
        @Nonnull
        public PIndexKeyValueToPartialRecord.PCopier toCopierProto(@Nonnull PlanSerializationContext serializationContext) {
            return PIndexKeyValueToPartialRecord.PCopier.newBuilder().setFieldWithValueCopier(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static FieldWithValueCopier fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PFieldWithValueCopier fieldWithValueCopierProto) {
            return new FieldWithValueCopier(CorrelationIdentifier.of(Objects.requireNonNull(fieldWithValueCopierProto.getIndexEntryAlias())), QueryPredicate.fromQueryPredicateProto(serializationContext, Objects.requireNonNull(fieldWithValueCopierProto.getCopyIfPredicate())), Value.fromValueProto(serializationContext, Objects.requireNonNull(fieldWithValueCopierProto.getExtractFromIndexEntryValue())), Objects.requireNonNull(fieldWithValueCopierProto.getField()));
        }

        public static class Deserializer
        implements PlanDeserializer<PIndexKeyValueToPartialRecord.PFieldWithValueCopier, FieldWithValueCopier> {
            @Override
            @Nonnull
            public Class<PIndexKeyValueToPartialRecord.PFieldWithValueCopier> getProtoMessageClass() {
                return PIndexKeyValueToPartialRecord.PFieldWithValueCopier.class;
            }

            @Override
            @Nonnull
            public FieldWithValueCopier fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PFieldWithValueCopier fieldWithValueCopierProto) {
                return FieldWithValueCopier.fromProto(serializationContext, fieldWithValueCopierProto);
            }
        }
    }

    public static class FieldCopier
    implements Copier {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Field-Copier");
        @Nonnull
        private final String field;
        @Nonnull
        private final TupleSource source;
        @Nonnull
        private final AvailableFields.CopyIfPredicate copyIfPredicate;
        @Nonnull
        private final ImmutableIntArray ordinalPath;
        @Nullable
        private final String invertibleFunctionName;
        @Nullable
        private Function<Object, Object> invertibleFunction;

        private FieldCopier(@Nonnull String field, @Nonnull TupleSource source, @Nonnull AvailableFields.CopyIfPredicate copyIfPredicate, @Nonnull ImmutableIntArray ordinalPath, @Nullable String invertibleFunctionName) {
            this.field = field;
            this.source = source;
            this.copyIfPredicate = copyIfPredicate;
            this.ordinalPath = ordinalPath;
            this.invertibleFunctionName = invertibleFunctionName;
        }

        @Override
        public boolean copy(@Nonnull Descriptors.Descriptor recordDescriptor, @Nonnull Message.Builder recordBuilder, @Nonnull IndexEntry kv) {
            Tuple tuple;
            Tuple tuple2 = tuple = this.source == TupleSource.KEY ? kv.getKey() : kv.getValue();
            if (!this.copyIfPredicate.test(tuple)) {
                return false;
            }
            Descriptors.FieldDescriptor fieldDescriptor = recordDescriptor.findFieldByName(this.field);
            Object value = IndexKeyValueToPartialRecord.getForOrdinalPath(tuple, this.ordinalPath);
            if (this.invertibleFunctionName != null) {
                value = this.getInvertibleFunction().apply(value);
            }
            if (value == null) {
                return !fieldDescriptor.isRequired();
            }
            switch (fieldDescriptor.getType()) {
                case INT32: {
                    value = ((Long)value).intValue();
                    break;
                }
                case BYTES: {
                    value = ZeroCopyByteString.wrap((byte[])value);
                    break;
                }
                case MESSAGE: {
                    value = TupleFieldsHelper.toProto(value, fieldDescriptor.getMessageType());
                    break;
                }
                case ENUM: {
                    value = fieldDescriptor.getEnumType().findValueByNumber(((Long)value).intValue());
                    break;
                }
            }
            recordBuilder.setField(fieldDescriptor, value);
            return true;
        }

        @Nonnull
        public Function<Object, Object> getInvertibleFunction() {
            if (this.invertibleFunction == null) {
                InvertibleFunctionKeyExpression keyExpression = (InvertibleFunctionKeyExpression)Key.Expressions.function(Objects.requireNonNull(this.invertibleFunctionName), Key.Expressions.field(this.field));
                this.invertibleFunction = obj -> Iterables.getOnlyElement(keyExpression.evaluateInverse(Key.Evaluated.scalar(obj))).getObject(0);
            }
            return this.invertibleFunction;
        }

        public String toString() {
            return this.field + ": " + String.valueOf((Object)this.source) + String.valueOf(this.ordinalPath);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldCopier that = (FieldCopier)o;
            return this.ordinalPath.equals(that.ordinalPath) && Objects.equals(this.field, that.field) && this.source == that.source && Objects.equals(this.invertibleFunctionName, that.invertibleFunctionName);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.source.name(), this.ordinalPath, this.invertibleFunctionName);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
            return PlanHashable.objectsPlanHash(hashMode, new Object[]{BASE_HASH, this.field, this.source, this.copyIfPredicate, this.ordinalPath}) + PlanHashable.objectPlanHash(hashMode, (Object)this.invertibleFunctionName);
        }

        @Override
        @Nonnull
        public PIndexKeyValueToPartialRecord.PFieldCopier toProto(@Nonnull PlanSerializationContext serializationContext) {
            PIndexKeyValueToPartialRecord.PFieldCopier.Builder builder = PIndexKeyValueToPartialRecord.PFieldCopier.newBuilder().setField(this.field).setSource(this.source.toProto(serializationContext)).setCopyIfPredicate(this.copyIfPredicate.toCopyIfPredicateProto(serializationContext));
            this.ordinalPath.forEach(builder::addOrdinalPath);
            if (this.invertibleFunctionName != null) {
                builder.setInvertibleFunction(this.invertibleFunctionName);
            }
            return builder.build();
        }

        @Override
        @Nonnull
        public PIndexKeyValueToPartialRecord.PCopier toCopierProto(@Nonnull PlanSerializationContext serializationContext) {
            return PIndexKeyValueToPartialRecord.PCopier.newBuilder().setFieldCopier(this.toProto(serializationContext)).build();
        }

        @Nonnull
        public static FieldCopier fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PFieldCopier fieldCopierProto) {
            ImmutableIntArray.Builder ordinalPathBuilder = ImmutableIntArray.builder();
            for (int i = 0; i < fieldCopierProto.getOrdinalPathCount(); ++i) {
                ordinalPathBuilder.add(fieldCopierProto.getOrdinalPath(i));
            }
            return new FieldCopier(Objects.requireNonNull(fieldCopierProto.getField()), TupleSource.fromProto(serializationContext, Objects.requireNonNull(fieldCopierProto.getSource())), AvailableFields.CopyIfPredicate.fromCopyIfPredicateProto(serializationContext, Objects.requireNonNull(fieldCopierProto.getCopyIfPredicate())), ordinalPathBuilder.build(), fieldCopierProto.hasInvertibleFunction() ? fieldCopierProto.getInvertibleFunction() : null);
        }

        public static class Deserializer
        implements PlanDeserializer<PIndexKeyValueToPartialRecord.PFieldCopier, FieldCopier> {
            @Override
            @Nonnull
            public Class<PIndexKeyValueToPartialRecord.PFieldCopier> getProtoMessageClass() {
                return PIndexKeyValueToPartialRecord.PFieldCopier.class;
            }

            @Override
            @Nonnull
            public FieldCopier fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PFieldCopier fieldCopierProto) {
                return FieldCopier.fromProto(serializationContext, fieldCopierProto);
            }
        }
    }

    public static enum TupleSource {
        KEY,
        VALUE,
        OTHER;


        @Nonnull
        public PIndexKeyValueToPartialRecord.PTupleSource toProto(@Nonnull PlanSerializationContext serializationContext) {
            switch (this) {
                case KEY: {
                    return PIndexKeyValueToPartialRecord.PTupleSource.KEY;
                }
                case VALUE: {
                    return PIndexKeyValueToPartialRecord.PTupleSource.VALUE;
                }
                case OTHER: {
                    return PIndexKeyValueToPartialRecord.PTupleSource.OTHER;
                }
            }
            throw new RecordCoreException("unknown tuple source mapping. did you forget to add it?", new Object[0]);
        }

        @Nonnull
        public static TupleSource fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PIndexKeyValueToPartialRecord.PTupleSource tupleSourceProto) {
            switch (tupleSourceProto) {
                case KEY: {
                    return KEY;
                }
                case VALUE: {
                    return VALUE;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new RecordCoreException("unknown tuple source mapping. did you forget to add it?", new Object[0]);
        }
    }
}

