/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.metadata.expressions.ListKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.query.plan.PlanWithOrderingKey;
import com.apple.foundationdb.record.query.plan.RecordQueryPlanner;
import com.apple.foundationdb.record.query.plan.TextScan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTextIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnKeyExpressionPlan;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class PlanOrderingKey {
    @Nonnull
    private final List<KeyExpression> keys;
    private final int prefixSize;
    private final int primaryKeyStart;
    private final int primaryKeyTail;
    @Nonnull
    private final Set<Integer> duplicatePositions;

    public PlanOrderingKey(@Nonnull List<KeyExpression> keys, int prefixSize, int primaryKeyStart, int primaryKeyTail) {
        this.keys = keys;
        this.prefixSize = prefixSize;
        this.primaryKeyStart = primaryKeyStart;
        this.primaryKeyTail = primaryKeyTail;
        ImmutableSet.Builder duplicatesBuilder = ImmutableSet.builder();
        for (int pos = 0; pos < keys.size(); ++pos) {
            KeyExpression component = keys.get(pos);
            int firstIndex = keys.indexOf(component);
            if (firstIndex < 0 || firstIndex >= pos) continue;
            duplicatesBuilder.add((Object)pos);
        }
        this.duplicatePositions = duplicatesBuilder.build();
    }

    @Nonnull
    public List<KeyExpression> getKeys() {
        return this.keys;
    }

    public int getPrefixSize() {
        return this.prefixSize;
    }

    public int getSuffixSize() {
        return this.keys.size() - this.prefixSize;
    }

    public int getPrimaryKeyStart() {
        return this.primaryKeyStart;
    }

    public int getPrimaryKeyTail() {
        return this.primaryKeyTail;
    }

    public boolean isPrimaryKeyOrdered() {
        return this.prefixSize >= this.primaryKeyTail;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static PlanOrderingKey forPlan(@Nonnull RecordMetaData metaData, @Nonnull RecordQueryPlan queryPlan, @Nullable KeyExpression primaryKey) {
        if (primaryKey == null) {
            return null;
        }
        while (queryPlan instanceof RecordQueryPlanWithChild && (queryPlan instanceof RecordQueryFilterPlan || queryPlan instanceof RecordQueryTypeFilterPlan)) {
            queryPlan = ((RecordQueryPlanWithChild)queryPlan).getChild();
        }
        if (queryPlan instanceof PlanWithOrderingKey) {
            return ((PlanWithOrderingKey)((Object)queryPlan)).getPlanOrderingKey();
        }
        if (queryPlan instanceof RecordQueryPlanWithIndex) {
            int prefixSize;
            int pkeyStart;
            RecordQueryPlanWithIndex indexPlan = (RecordQueryPlanWithIndex)queryPlan;
            Index index = metaData.getIndex(indexPlan.getIndexName());
            ArrayList<KeyExpression> keys = new ArrayList<KeyExpression>(index.getRootExpression().normalizeKeyForPositions());
            if (index.getRootExpression() instanceof KeyWithValueExpression) {
                int splitPoint = ((KeyWithValueExpression)index.getRootExpression()).getSplitPoint();
                while (keys.size() > splitPoint) {
                    keys.remove(keys.size() - 1);
                }
            }
            int pKeyTail = pkeyStart = keys.size();
            int[] primaryKeyComponentPositions = index.getPrimaryKeyComponentPositions();
            List<KeyExpression> primaryKeyComponents = primaryKey.normalizeKeyForPositions();
            if (primaryKeyComponentPositions == null) {
                keys.addAll(primaryKeyComponents);
            } else {
                for (int i = 0; i < primaryKeyComponentPositions.length; ++i) {
                    int pos = primaryKeyComponentPositions[i];
                    if (pos < 0) {
                        keys.add(primaryKeyComponents.get(i));
                        continue;
                    }
                    if (pkeyStart <= pos) continue;
                    pkeyStart = pos;
                }
            }
            if (indexPlan instanceof RecordQueryIndexPlan) {
                if ("multidimensional".equals(index.getType())) {
                    return null;
                }
                if (!((RecordQueryIndexPlan)indexPlan).hasScanComparisons()) {
                    return null;
                }
                prefixSize = ((RecordQueryIndexPlan)indexPlan).getScanComparisons().getEqualitySize();
                return new PlanOrderingKey(keys, prefixSize, pkeyStart, pKeyTail);
            } else {
                int suffixSize;
                if (!(indexPlan instanceof RecordQueryTextIndexPlan)) return null;
                TextScan textScan = ((RecordQueryTextIndexPlan)indexPlan).getTextScan();
                int groupingSize = textScan.getGroupingComparisons() != null ? textScan.getGroupingComparisons().getEqualitySize() : 0;
                int n = suffixSize = textScan.getSuffixComparisons() != null ? textScan.getSuffixComparisons().getEqualitySize() : 0;
                if (!textScan.getTextComparison().getType().isEquality()) return null;
                prefixSize = groupingSize + suffixSize + 1;
            }
            return new PlanOrderingKey(keys, prefixSize, pkeyStart, pKeyTail);
        }
        if (queryPlan instanceof RecordQueryScanPlan) {
            RecordQueryScanPlan scanPlan = (RecordQueryScanPlan)queryPlan;
            return new PlanOrderingKey(primaryKey.normalizeKeyForPositions(), scanPlan.getScanComparisons().getEqualitySize(), 0, 0);
        }
        if (queryPlan instanceof RecordQueryIntersectionOnKeyExpressionPlan) {
            return PlanOrderingKey.forComparisonKey(((RecordQueryIntersectionOnKeyExpressionPlan)queryPlan).getComparisonKeyExpression(), primaryKey);
        }
        if (!(queryPlan instanceof RecordQueryUnionOnKeyExpressionPlan)) return null;
        return PlanOrderingKey.forComparisonKey(((RecordQueryUnionOnKeyExpressionPlan)queryPlan).getComparisonKeyExpression(), primaryKey);
    }

    @Nonnull
    public static PlanOrderingKey forComparisonKey(@Nonnull KeyExpression comparisonKey, @Nonnull KeyExpression primaryKey) {
        List<KeyExpression> keys = comparisonKey.normalizeKeyForPositions();
        List<KeyExpression> pkeys = primaryKey.normalizeKeyForPositions();
        int firstPrimaryKeyPosition = -1;
        int lastNonPrimaryKeyPosition = -1;
        for (int i = 0; i < keys.size(); ++i) {
            if (pkeys.contains(keys.get(i))) {
                if (firstPrimaryKeyPosition >= 0) continue;
                firstPrimaryKeyPosition = i;
                continue;
            }
            lastNonPrimaryKeyPosition = i;
        }
        return new PlanOrderingKey(keys, 0, firstPrimaryKeyPosition, lastNonPrimaryKeyPosition + 1);
    }

    @Nullable
    public static KeyExpression mergedComparisonKey(@Nonnull List<RecordQueryPlanner.ScoredPlan> plans, @Nullable KeyExpression candidateKey, boolean candidateOnly) {
        if (candidateOnly) {
            if (candidateKey == null) {
                return null;
            }
            for (RecordQueryPlanner.ScoredPlan plan : plans) {
                PlanOrderingKey planOrderingKey = Objects.requireNonNull(plan.planOrderingKey);
                if (PlanOrderingKey.isOrderingCompatible(planOrderingKey, candidateKey)) continue;
                return null;
            }
            return candidateKey;
        }
        List plansDescendingBySuffixSize = plans.stream().sorted((p1, p2) -> -1 * Integer.compare(p1.planOrderingKey.getSuffixSize(), p2.planOrderingKey.getSuffixSize())).collect(Collectors.toList());
        for (RecordQueryPlanner.ScoredPlan plan : plansDescendingBySuffixSize) {
            KeyExpression planKey = PlanOrderingKey.orderingCompatiblePlanKey(Objects.requireNonNull(plan.planOrderingKey), candidateKey);
            if (planKey == null) {
                return null;
            }
            candidateKey = planKey;
        }
        return candidateKey;
    }

    @Nullable
    private static KeyExpression orderingCompatiblePlanKey(@Nonnull PlanOrderingKey planOrderingKey, @Nullable KeyExpression candidateKey) {
        ArrayList<KeyExpression> components = new ArrayList<KeyExpression>(planOrderingKey.getSuffixSize());
        int nextNonPrefix = planOrderingKey.prefixSize;
        if (candidateKey != null) {
            for (KeyExpression component : candidateKey.normalizeKeyForPositions()) {
                int pos = planOrderingKey.keys.indexOf(component);
                if (pos < 0) {
                    return null;
                }
                if (pos < nextNonPrefix) {
                    components.add(component);
                    continue;
                }
                if (pos == nextNonPrefix) {
                    components.add(component);
                    nextNonPrefix = PlanOrderingKey.advanceNextNonPrefix(planOrderingKey, nextNonPrefix);
                    continue;
                }
                return null;
            }
        }
        while (nextNonPrefix < planOrderingKey.getKeys().size()) {
            components.add(planOrderingKey.getKeys().get(nextNonPrefix));
            nextNonPrefix = PlanOrderingKey.advanceNextNonPrefix(planOrderingKey, nextNonPrefix);
        }
        return PlanOrderingKey.combine(components);
    }

    private static boolean isOrderingCompatible(@Nonnull PlanOrderingKey planOrderingKey, @Nonnull KeyExpression candidateKey) {
        int nextNonPrefix = planOrderingKey.prefixSize;
        for (KeyExpression component : candidateKey.normalizeKeyForPositions()) {
            int pos = planOrderingKey.keys.indexOf(component);
            if (pos < 0) {
                return false;
            }
            if (pos < nextNonPrefix) continue;
            if (pos != nextNonPrefix) {
                return false;
            }
            nextNonPrefix = PlanOrderingKey.advanceNextNonPrefix(planOrderingKey, nextNonPrefix);
        }
        return true;
    }

    private static int advanceNextNonPrefix(@Nonnull PlanOrderingKey planOrderingKey, int nonPrefix) {
        int next;
        for (next = nonPrefix + 1; next < planOrderingKey.keys.size() && planOrderingKey.duplicatePositions.contains(next); ++next) {
        }
        return next;
    }

    @Nonnull
    public static KeyExpression candidateContainingPrimaryKey(@Nonnull Collection<RecordQueryPlanner.ScoredPlan> plans, @Nonnull KeyExpression primaryKey) {
        KeyExpression candidateKey = primaryKey;
        for (RecordQueryPlanner.ScoredPlan scoredPlan : plans) {
            PlanOrderingKey planOrderingKey = scoredPlan.planOrderingKey;
            if (PlanOrderingKey.isOrderingCompatible(planOrderingKey, candidateKey)) continue;
            List<KeyExpression> newKeys = planOrderingKey.getKeys().subList(Math.min(planOrderingKey.getPrefixSize(), planOrderingKey.getPrimaryKeyStart()), planOrderingKey.getKeys().size());
            candidateKey = PlanOrderingKey.combine(newKeys);
        }
        return candidateKey;
    }

    @Nonnull
    private static KeyExpression combine(@Nonnull List<KeyExpression> keys) {
        if (keys.isEmpty()) {
            return EmptyKeyExpression.EMPTY;
        }
        if (keys.stream().anyMatch(key -> key.getColumnSize() > 1)) {
            return new ListKeyExpression(keys);
        }
        if (keys.size() == 1) {
            return keys.get(0);
        }
        return new ThenKeyExpression(keys);
    }
}

