/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PQueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ConstantPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanVisitorWithDefaults;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithConstraint;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class QueryPlanConstraint
implements PlanHashable,
PlanSerializable {
    @Nonnull
    private static final QueryPlanConstraint TAUTOLOGY = new QueryPlanConstraint(ConstantPredicate.TRUE);
    @Nonnull
    private final QueryPredicate predicate;

    private QueryPlanConstraint(@Nonnull QueryPredicate predicate) {
        this.predicate = predicate;
    }

    public boolean compileTimeEval(@Nonnull EvaluationContext context) {
        return Boolean.TRUE.equals(this.predicate.compileTimeEval(context));
    }

    @Nonnull
    public QueryPredicate getPredicate() {
        return this.predicate;
    }

    public boolean isTautology() {
        return this.predicate.isTautology();
    }

    public boolean isConstrained() {
        return !this.getPredicate().isTautology();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryPlanConstraint that = (QueryPlanConstraint)o;
        return Objects.equals(this.predicate, that.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.predicate);
    }

    public String toString() {
        return this.predicate.toString();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
        return PlanHashable.objectPlanHash(hashMode, (Object)this.predicate);
    }

    @Nonnull
    public QueryPlanConstraint compose(@Nonnull QueryPlanConstraint otherQueryPlanConstraint) {
        if (this == TAUTOLOGY && otherQueryPlanConstraint == TAUTOLOGY) {
            return QueryPlanConstraint.noConstraint();
        }
        if (this == TAUTOLOGY) {
            return otherQueryPlanConstraint;
        }
        if (otherQueryPlanConstraint == TAUTOLOGY) {
            return this;
        }
        return QueryPlanConstraint.composeConstraints(ImmutableList.of(this, otherQueryPlanConstraint));
    }

    @Override
    @Nonnull
    public PQueryPlanConstraint toProto(@Nonnull PlanSerializationContext serializationContext) {
        return PQueryPlanConstraint.newBuilder().setPredicate(this.predicate.toQueryPredicateProto(serializationContext)).build();
    }

    @Nonnull
    public static QueryPlanConstraint fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PQueryPlanConstraint queryPlanConstraintProto) {
        return new QueryPlanConstraint(QueryPredicate.fromQueryPredicateProto(serializationContext, Objects.requireNonNull(queryPlanConstraintProto.getPredicate())));
    }

    @Nonnull
    public static QueryPlanConstraint composeConstraints(@Nonnull Collection<QueryPlanConstraint> constraints) {
        return new QueryPlanConstraint(AndPredicate.and(constraints.stream().map(QueryPlanConstraint::getPredicate).collect(Collectors.toList())));
    }

    @Nonnull
    public static QueryPlanConstraint ofPredicate(@Nonnull QueryPredicate predicate) {
        return new QueryPlanConstraint(predicate);
    }

    @Nonnull
    public static QueryPlanConstraint ofPredicates(@Nonnull Collection<QueryPredicate> predicates) {
        return new QueryPlanConstraint(AndPredicate.and(predicates));
    }

    @Nonnull
    public static QueryPlanConstraint noConstraint() {
        return TAUTOLOGY;
    }

    @Nonnull
    public static QueryPlanConstraint collectConstraints(@Nonnull RecordQueryPlan plan) {
        QueryPlanConstraintsVisitor collector = new QueryPlanConstraintsVisitor();
        return (QueryPlanConstraint)collector.visit(plan);
    }

    private static class QueryPlanConstraintsVisitor
    implements RecordQueryPlanVisitorWithDefaults<QueryPlanConstraint> {
        private QueryPlanConstraintsVisitor() {
        }

        @Override
        @Nonnull
        public QueryPlanConstraint visitCoveringIndexPlan(@Nonnull RecordQueryCoveringIndexPlan element) {
            return this.visitDefault(element.getIndexPlan());
        }

        @Override
        @Nonnull
        public QueryPlanConstraint visitDefault(@Nonnull RecordQueryPlan element) {
            QueryPlanConstraint constraint = QueryPlanConstraint.noConstraint();
            if (element instanceof RecordQueryPlanWithConstraint) {
                constraint = constraint.compose(((RecordQueryPlanWithConstraint)((Object)element)).getConstraint());
            }
            for (RecordQueryPlan child : element.getChildren()) {
                constraint = constraint.compose((QueryPlanConstraint)this.visit(child));
            }
            return constraint;
        }
    }
}

