/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan;

import com.apple.foundationdb.annotation.API;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class QueryPlanInfo {
    private final Map<QueryPlanInfoKey<?>, Object> info;
    private static final QueryPlanInfo EMPTY = new QueryPlanInfo(Collections.emptyMap());

    private QueryPlanInfo(@Nonnull Map<QueryPlanInfoKey<?>, Object> infoMap) {
        this.info = infoMap;
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    public static QueryPlanInfo empty() {
        return EMPTY;
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public <T> boolean containsKey(@Nonnull QueryPlanInfoKey<T> key) {
        return this.info.containsKey(key);
    }

    @Nullable
    public <T> T get(@Nonnull QueryPlanInfoKey<T> key) {
        return key.narrow(this.info.get(key));
    }

    public boolean isEmpty() {
        return this.info.isEmpty();
    }

    @Nonnull
    public Set<QueryPlanInfoKey<?>> keySet() {
        return Collections.unmodifiableSet(this.info.keySet());
    }

    public static class Builder {
        private final Map<QueryPlanInfoKey<?>, Object> infoMap;

        private Builder() {
            this.infoMap = new HashMap();
        }

        private Builder(@Nonnull QueryPlanInfo source) {
            this.infoMap = new HashMap(source.info);
        }

        @Nonnull
        public <T> Builder put(@Nonnull QueryPlanInfoKey<T> key, @Nullable T value) {
            this.infoMap.put(key, value);
            return this;
        }

        @Nullable
        public <T> T get(@Nonnull QueryPlanInfoKey<T> key) {
            return key.narrow(this.infoMap.get(key));
        }

        public QueryPlanInfo build() {
            return new QueryPlanInfo(this.infoMap);
        }
    }

    public static class QueryPlanInfoKey<T> {
        @Nonnull
        private final String name;

        public QueryPlanInfoKey(@Nonnull String name) {
            this.name = name;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        public T narrow(@Nonnull Object o) {
            return (T)o;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryPlanInfoKey that = (QueryPlanInfoKey)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

