/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.IndexFetchMethod;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.DimensionsKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.OrderFunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.RecordTypeKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.VersionKeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.provider.foundationdb.MultidimensionalIndexScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.indexes.MultidimensionalIndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowRecordFunction;
import com.apple.foundationdb.record.provider.foundationdb.leaderboard.TimeWindowScanComparisons;
import com.apple.foundationdb.record.query.ParameterRelationshipGraph;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.AndComponent;
import com.apple.foundationdb.record.query.expressions.AndOrComponent;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.ComponentWithComparison;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComparison;
import com.apple.foundationdb.record.query.expressions.OneOfThemWithComponent;
import com.apple.foundationdb.record.query.expressions.OrComponent;
import com.apple.foundationdb.record.query.expressions.OrderQueryKeyExpression;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.QueryKeyExpressionWithComparison;
import com.apple.foundationdb.record.query.expressions.QueryKeyExpressionWithOneOfComparison;
import com.apple.foundationdb.record.query.expressions.QueryRecordFunctionWithComparison;
import com.apple.foundationdb.record.query.expressions.RecordTypeKeyComparison;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.PlanOrderingKey;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.QueryPlanResult;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.RecordQueryPlanComplexityException;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.TextScan;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRanges;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.properties.ComparisonsProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.FieldWithComparisonCountProperty;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.planning.BooleanNormalizer;
import com.apple.foundationdb.record.query.plan.planning.FilterSatisfiedMask;
import com.apple.foundationdb.record.query.plan.planning.InExtractor;
import com.apple.foundationdb.record.query.plan.planning.RankComparisons;
import com.apple.foundationdb.record.query.plan.planning.TextScanPlanner;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithChild;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithComparisons;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTextIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedUnionPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQueryPlannerSortConfiguration;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortPlan;
import com.apple.foundationdb.record.query.plan.visitor.FilterVisitor;
import com.apple.foundationdb.record.query.plan.visitor.RecordQueryPlannerSubstitutionVisitor;
import com.apple.foundationdb.record.query.plan.visitor.UnorderedPrimaryKeyDistinctVisitor;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.UNSTABLE)
public class RecordQueryPlanner
implements QueryPlanner {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(RecordQueryPlanner.class);
    public static final int DEFAULT_COMPLEXITY_THRESHOLD = 3000;
    @Nonnull
    private final RecordMetaData metaData;
    @Nonnull
    private final RecordStoreState recordStoreState;
    @Nullable
    private final StoreTimer timer;
    @Nonnull
    private final PlannableIndexTypes indexTypes;
    private boolean primaryKeyHasRecordTypePrefix;
    @Nonnull
    private RecordQueryPlannerConfiguration configuration;

    public RecordQueryPlanner(@Nonnull RecordMetaData metaData, @Nonnull RecordStoreState recordStoreState) {
        this(metaData, recordStoreState, null);
    }

    public RecordQueryPlanner(@Nonnull RecordMetaData metaData, @Nonnull RecordStoreState recordStoreState, @Nullable StoreTimer timer) {
        this(metaData, recordStoreState, PlannableIndexTypes.DEFAULT, timer, 3000);
    }

    public RecordQueryPlanner(@Nonnull RecordMetaData metaData, @Nonnull RecordStoreState recordStoreState, @Nonnull PlannableIndexTypes indexTypes, @Nullable StoreTimer timer) {
        this(metaData, recordStoreState, indexTypes, timer, 3000);
    }

    public RecordQueryPlanner(@Nonnull RecordMetaData metaData, @Nonnull RecordStoreState recordStoreState, @Nullable StoreTimer timer, int complexityThreshold) {
        this(metaData, recordStoreState, PlannableIndexTypes.DEFAULT, timer, complexityThreshold);
    }

    public RecordQueryPlanner(@Nonnull RecordMetaData metaData, @Nonnull RecordStoreState recordStoreState, @Nonnull PlannableIndexTypes indexTypes, @Nullable StoreTimer timer, int complexityThreshold) {
        this.metaData = metaData;
        this.recordStoreState = recordStoreState;
        this.indexTypes = indexTypes;
        this.timer = timer;
        this.primaryKeyHasRecordTypePrefix = metaData.primaryKeyHasRecordTypePrefix();
        this.configuration = RecordQueryPlannerConfiguration.builder().setIndexScanPreference(metaData.getRecordTypes().size() > 1 && !this.primaryKeyHasRecordTypePrefix ? QueryPlanner.IndexScanPreference.PREFER_INDEX : QueryPlanner.IndexScanPreference.PREFER_SCAN).setAttemptFailedInJoinAsOr(true).setComplexityThreshold(complexityThreshold).build();
    }

    @Nonnull
    public QueryPlanner.IndexScanPreference getIndexScanPreference() {
        return this.configuration.getIndexScanPreference();
    }

    @Override
    public void setIndexScanPreference(@Nonnull QueryPlanner.IndexScanPreference indexScanPreference) {
        this.configuration = this.configuration.asBuilder().setIndexScanPreference(indexScanPreference).build();
    }

    @Override
    @Nonnull
    public RecordQueryPlannerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(@Nonnull RecordQueryPlannerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    @Nonnull
    public RecordMetaData getRecordMetaData() {
        return this.metaData;
    }

    @Override
    @Nonnull
    public RecordStoreState getRecordStoreState() {
        return this.recordStoreState;
    }

    @Override
    @Nonnull
    public QueryPlanResult planQuery(@Nonnull RecordQuery query, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
        return new QueryPlanResult(this.plan(query, parameterRelationshipGraph));
    }

    @Override
    @Nonnull
    public RecordQueryPlan plan(@Nonnull RecordQuery query, @Nonnull ParameterRelationshipGraph parameterRelationshipGraph) {
        query.validate(this.metaData);
        PlanContext planContext = this.getPlanContext(query);
        BooleanNormalizer normalizer = BooleanNormalizer.forConfiguration(this.configuration);
        QueryComponent queryFilter = query.getFilter();
        QueryComponent filter = normalizer.normalizeIfPossible(queryFilter == null ? null : queryFilter.withParameterRelationshipMap(parameterRelationshipGraph));
        KeyExpression sort = query.getSort();
        boolean sortReverse = query.isSortReverse();
        RecordQueryPlan plan = this.plan(planContext, filter, sort, sortReverse);
        if (plan == null) {
            if (sort == null) {
                throw new RecordCoreException("Unexpected failure to plan without sort", new Object[0]);
            }
            RecordQueryPlannerSortConfiguration sortConfiguration = this.configuration.getSortConfiguration();
            if (sortConfiguration != null && sortConfiguration.shouldAllowNonIndexSort()) {
                PlanContext withoutSort = new PlanContext(query.toBuilder().setSort(null).build(), planContext.indexes, planContext.commonPrimaryKey);
                plan = this.plan(withoutSort, filter, null, false);
                if (plan == null) {
                    throw new RecordCoreException("Unexpected failure to plan without sort", new Object[0]);
                }
                plan = new RecordQuerySortPlan(plan, sortConfiguration.getSortKey(sort, sortReverse));
            } else {
                throw new RecordCoreException("Cannot sort without appropriate index: " + String.valueOf(sort), new Object[0]);
            }
        }
        if (query.getRequiredResults() != null) {
            plan = this.tryToConvertToCoveringPlan(planContext, plan);
        }
        if (this.timer != null) {
            plan.logPlanStructure(this.timer);
        }
        if (plan.getComplexity() > this.configuration.getComplexityThreshold()) {
            throw new RecordQueryPlanComplexityException(plan).addLogInfo(new Object[]{LogMessageKeys.COMPLEXITY, plan.getComplexity()}).addLogInfo(new Object[]{LogMessageKeys.MAX_COMPLEXITY, this.configuration.getComplexityThreshold()});
        }
        if (logger.isTraceEnabled()) {
            logger.trace(KeyValueLogMessage.of("explain of plan", "explain", PlannerGraphVisitor.explain(plan)));
        }
        return plan;
    }

    @Nullable
    private RecordQueryPlan plan(PlanContext planContext, QueryComponent filter, KeyExpression sort, boolean sortReverse) {
        RecordQueryPlan plan = null;
        if (filter == null) {
            plan = this.planNoFilter(planContext, sort, sortReverse);
        } else {
            ScoredPlan bestPlan;
            if (this.configuration.shouldPlanOtherAttemptWholeFilter()) {
                for (Index index : planContext.indexes) {
                    QueryComponent originalFilter;
                    CandidateScan candidateScan;
                    ScoredPlan wholePlan;
                    if (this.indexTypes.getValueTypes().contains(index.getType()) || this.indexTypes.getRankTypes().contains(index.getType()) || this.indexTypes.getTextTypes().contains(index.getType()) || (wholePlan = this.planOther(candidateScan = new CandidateScan(planContext, index, sortReverse), index, originalFilter = planContext.query.getFilter(), sort, sortReverse, planContext.commonPrimaryKey)) == null || !wholePlan.unsatisfiedFilters.isEmpty()) continue;
                    return wholePlan.getPlan();
                }
            }
            if ((bestPlan = this.planFilter(planContext, filter)) != null) {
                plan = bestPlan.getPlan();
            }
        }
        if (plan == null) {
            if (sort == null) {
                plan = this.valueScan(new CandidateScan(planContext, null, false), null, false);
                if (filter != null) {
                    plan = new RecordQueryFilterPlan(plan, filter);
                }
            } else {
                return null;
            }
        }
        plan = this.configuration.shouldDeferFetchAfterUnionAndIntersection() || this.configuration.shouldDeferFetchAfterInJoinAndInUnion() ? RecordQueryPlannerSubstitutionVisitor.applyRegularVisitors(this.configuration, plan, this.metaData, this.indexTypes, planContext.commonPrimaryKey) : plan.accept(new FilterVisitor(this.metaData, this.indexTypes, planContext.commonPrimaryKey));
        return plan;
    }

    @Nullable
    private RecordQueryPlan planNoFilter(PlanContext planContext, KeyExpression sort, boolean sortReverse) {
        ScoredPlan bestPlan = null;
        Index bestIndex = null;
        if (sort == null) {
            bestPlan = this.planNoFilterNoSort(planContext, null);
        } else if (planContext.commonPrimaryKey != null) {
            bestPlan = this.planSortOnly(new CandidateScan(planContext, null, sortReverse), planContext.commonPrimaryKey, sort);
        }
        for (Index index : planContext.indexes) {
            ScoredPlan p = sort == null ? this.planNoFilterNoSort(planContext, index) : this.planSortOnly(new CandidateScan(planContext, index, sortReverse), this.indexKeyExpressionForPlan(planContext.commonPrimaryKey, index), sort);
            if (p == null) continue;
            p = this.computePlanProperties(planContext, p);
            if (bestPlan != null && p.score <= bestPlan.score && (p.score != bestPlan.score || this.compareIndexes(planContext, index, p.flowsAllRequiredFields, bestIndex, bestPlan.flowsAllRequiredFields) <= 0)) continue;
            bestPlan = p;
            bestIndex = index;
        }
        if (bestPlan != null) {
            if ((bestPlan = this.planRemoveDuplicates(planContext, bestPlan)) == null) {
                throw new RecordCoreException("A common primary key is required to remove duplicates", new Object[0]);
            }
            return bestPlan.getPlan();
        }
        return null;
    }

    @Nullable
    private ScoredPlan planNoFilterNoSort(PlanContext planContext, @Nullable Index index) {
        if (index != null && (!this.indexTypes.getValueTypes().contains(index.getType()) || index.getRootExpression().createsDuplicates())) {
            return null;
        }
        ScanComparisons scanComparisons = null;
        if (index == null && planContext.query.getRecordTypes().size() == 1 && planContext.commonPrimaryKey != null && Key.Expressions.hasRecordTypePrefix(planContext.commonPrimaryKey)) {
            RecordTypeKeyComparison recordTypeKeyComparison = new RecordTypeKeyComparison(planContext.query.getRecordTypes().iterator().next());
            scanComparisons = new ScanComparisons.Builder().addEqualityComparison(recordTypeKeyComparison.getComparison()).build();
        }
        return new ScoredPlan(0, this.valueScan(new CandidateScan(planContext, index, false), scanComparisons, false));
    }

    private int compareIndexes(@Nonnull PlanContext planContext, @Nullable Index index1, boolean flowsAllRequiredResults1, @Nullable Index index2, boolean flowsAllRequiredResults2) {
        if (index1 == null) {
            if (index2 == null) {
                return 0;
            }
            if (flowsAllRequiredResults2) {
                return -1;
            }
            return this.preferIndexToScan(planContext, index2) ? -1 : 1;
        }
        if (index2 == null) {
            if (flowsAllRequiredResults1) {
                return 1;
            }
            return this.preferIndexToScan(planContext, index1) ? 1 : -1;
        }
        if (flowsAllRequiredResults1 == flowsAllRequiredResults2) {
            return Integer.compare(RecordQueryPlanner.indexSizeOverhead(planContext, index2), RecordQueryPlanner.indexSizeOverhead(planContext, index1));
        }
        return flowsAllRequiredResults1 ? 1 : -1;
    }

    private boolean preferIndexToScan(PlanContext planContext, @Nonnull Index index) {
        QueryPlanner.IndexScanPreference indexScanPreference = this.getIndexScanPreference();
        switch (indexScanPreference) {
            case PREFER_INDEX: {
                return true;
            }
            case PREFER_SCAN: {
                return false;
            }
            case PREFER_PRIMARY_KEY_INDEX: {
                return index.getRootExpression().equals(planContext.commonPrimaryKey);
            }
        }
        throw new RecordCoreException("Unknown indexScanPreference: " + String.valueOf((Object)indexScanPreference), new Object[0]);
    }

    private static int indexSizeOverhead(PlanContext planContext, @Nonnull Index index) {
        if (planContext.commonPrimaryKey == null) {
            return index.getColumnSize();
        }
        return index.getEntrySize(planContext.commonPrimaryKey);
    }

    @Nullable
    private ScoredPlan planFilter(@Nonnull PlanContext planContext, @Nonnull QueryComponent filter) {
        ScoredPlan orPlan;
        ScoredPlan asOr;
        QueryComponent normalized;
        if (filter instanceof AndComponent && (normalized = this.normalizeAndOr((AndComponent)filter)) instanceof OrComponent && (asOr = this.planOr(planContext, (OrComponent)normalized)) != null) {
            return asOr;
        }
        if (filter instanceof OrComponent && (orPlan = this.planOr(planContext, (OrComponent)filter)) != null) {
            return orPlan;
        }
        return this.planFilter(planContext, filter, false);
    }

    @Nullable
    private ScoredPlan planFilter(@Nonnull PlanContext planContext, @Nonnull QueryComponent filter, boolean needOrdering) {
        InExtractor inExtractor = InExtractor.fromFilter(filter, (componentWithComparison, inBinding) -> true);
        ScoredPlan withInAsOrUnion = null;
        if (planContext.query.getSort() != null) {
            InExtractor savedExtractor = new InExtractor(inExtractor);
            boolean canSort = inExtractor.setSort(planContext.query.getSort(), planContext.query.isSortReverse());
            if (!canSort) {
                QueryComponent asOr;
                if (this.getConfiguration().shouldAttemptFailedInJoinAsUnion()) {
                    withInAsOrUnion = this.planFilterWithInUnion(planContext, savedExtractor);
                } else if (this.getConfiguration().shouldAttemptFailedInJoinAsOr() && !filter.equals(asOr = this.normalizeAndOrForInAsOr(inExtractor.asOr()))) {
                    withInAsOrUnion = this.planFilter(planContext, asOr);
                }
            }
        } else if (needOrdering) {
            inExtractor.sortByClauses();
        }
        ScoredPlan withInJoin = this.planFilterWithInJoin(planContext, inExtractor, needOrdering);
        if (withInAsOrUnion != null && (withInJoin == null || withInAsOrUnion.score > withInJoin.score || FieldWithComparisonCountProperty.fieldWithComparisonCount().evaluate(withInAsOrUnion.getPlan()) < FieldWithComparisonCountProperty.fieldWithComparisonCount().evaluate(withInJoin.getPlan()))) {
            return withInAsOrUnion;
        }
        return withInJoin;
    }

    @Nullable
    private ScoredPlan planFilterWithInJoin(@Nonnull PlanContext planContext, @Nonnull InExtractor inExtractor, boolean needOrdering) {
        PlanWithInExtractor planWithIn = this.planExtractedInsFilter(planContext, inExtractor, needOrdering, this.getConfiguration().getMaxNumReplansForInToJoin());
        if (planWithIn == null) {
            return null;
        }
        ScoredPlan bestPlan = planWithIn.plan;
        RecordQueryPlan wrapped = planWithIn.inExtractor.wrap(planContext.rankComparisons.wrap(bestPlan.getPlan(), bestPlan.includedRankComparisons, this.metaData));
        ScoredPlan scoredPlan = new ScoredPlan(bestPlan.score, wrapped);
        if (needOrdering) {
            scoredPlan.planOrderingKey = planWithIn.inExtractor.adjustOrdering(bestPlan.planOrderingKey, false);
        }
        return scoredPlan;
    }

    @Nullable
    private ScoredPlan planFilterWithInUnion(@Nonnull PlanContext planContext, @Nonnull InExtractor inExtractor) {
        PlanWithInExtractor planWithIn = this.planExtractedInsFilter(planContext, inExtractor, false, this.getConfiguration().getMaxNumReplansForInUnion());
        if (planWithIn != null) {
            boolean candidateOnly;
            KeyExpression candidateKey;
            ScoredPlan scoredPlan = planWithIn.plan;
            RecordQueryPlan inner = scoredPlan.getPlan();
            boolean distinct = false;
            if (inner instanceof RecordQueryUnorderedPrimaryKeyDistinctPlan || inner instanceof RecordQueryUnorderedDistinctPlan) {
                inner = ((RecordQueryPlanWithChild)inner).getChild();
                distinct = true;
            }
            scoredPlan.planOrderingKey = PlanOrderingKey.forPlan(this.metaData, inner, planContext.commonPrimaryKey);
            scoredPlan.planOrderingKey = planWithIn.inExtractor.adjustOrdering(scoredPlan.planOrderingKey, true);
            if (scoredPlan.planOrderingKey == null) {
                return null;
            }
            if (this.getConfiguration().shouldOmitPrimaryKeyInOrderingKeyForInUnion()) {
                candidateKey = planContext.query.getSort();
                candidateOnly = false;
            } else {
                candidateKey = this.getKeyForMerge(planContext.query.getSort(), planContext.commonPrimaryKey);
                candidateOnly = true;
            }
            KeyExpression comparisonKey = PlanOrderingKey.mergedComparisonKey(Collections.singletonList(scoredPlan), candidateKey, candidateOnly);
            if (comparisonKey == null) {
                return null;
            }
            List<InSource> valuesSources = planWithIn.inExtractor.unionSources();
            RecordQueryInUnionOnKeyExpressionPlan union = RecordQueryInUnionPlan.from(inner, valuesSources, comparisonKey, planContext.query.isSortReverse(), this.getConfiguration().getAttemptFailedInJoinAsUnionMaxSize(), Bindings.Internal.IN);
            if (distinct) {
                AbstractRelationalExpressionWithChildren distinctPlan = scoredPlan.getPlan() instanceof RecordQueryUnorderedPrimaryKeyDistinctPlan ? new RecordQueryUnorderedPrimaryKeyDistinctPlan(union) : new RecordQueryUnorderedDistinctPlan(union, ((RecordQueryUnorderedDistinctPlan)scoredPlan.getPlan()).getComparisonKey());
                return new ScoredPlan(scoredPlan.score, (RecordQueryPlan)((Object)distinctPlan));
            }
            return new ScoredPlan(scoredPlan.score, union);
        }
        return null;
    }

    private boolean isRankInComparison(@Nonnull PlanContext planContext, @Nonnull ComponentWithComparison comparison, @Nonnull String bindingName) {
        if (!(comparison instanceof QueryRecordFunctionWithComparison)) {
            return false;
        }
        QueryRecordFunctionWithComparison asEquals = (QueryRecordFunctionWithComparison)comparison.withOtherComparison(new Comparisons.ParameterComparison(Comparisons.Type.EQUALS, bindingName, Bindings.Internal.IN));
        return planContext.rankComparisons.getPlanComparison(asEquals) != null;
    }

    private PlanWithInExtractor planExtractedInsFilter(@Nonnull PlanContext planContext, @Nonnull InExtractor inExtractor, boolean needOrdering, int maxNumReplansConfig) {
        ScoredPlan nextPlan;
        ScoredPlan currentPlan;
        int numReplan;
        int maxNumReplans = Math.max(maxNumReplansConfig, 0);
        boolean allowNonSargedInBindings = maxNumReplansConfig < 0;
        boolean progress = true;
        PlanWithInExtractor bestPlanAndIn = null;
        for (numReplan = 0; numReplan <= maxNumReplans && (currentPlan = this.planExtractedInsFilterOnce(planContext, inExtractor.subFilter(), needOrdering)) != null; ++numReplan) {
            bestPlanAndIn = new PlanWithInExtractor(currentPlan, inExtractor);
            Set<String> inBindings = inExtractor.getInBindings();
            Set<String> sargedInBindings = currentPlan.getSargedInBindings();
            if (allowNonSargedInBindings || sargedInBindings.containsAll(inBindings)) break;
            inExtractor = inExtractor.filter((componentWithComparison, inBinding) -> {
                if (sargedInBindings.contains(inBinding)) {
                    return true;
                }
                return this.isRankInComparison(planContext, (ComponentWithComparison)componentWithComparison, (String)inBinding);
            });
            if (inBindings.size() != inExtractor.getInBindings().size()) continue;
            progress = false;
            break;
        }
        if (!(progress && numReplan <= maxNumReplans || (nextPlan = this.planExtractedInsFilterOnce(planContext, (inExtractor = inExtractor.filter((componentWithComparison, inBinding) -> this.isRankInComparison(planContext, (ComponentWithComparison)componentWithComparison, (String)inBinding))).subFilter(), needOrdering)) == null)) {
            bestPlanAndIn = new PlanWithInExtractor(nextPlan, inExtractor);
        }
        return bestPlanAndIn;
    }

    @Nullable
    private ScoredPlan planExtractedInsFilterOnce(@Nonnull PlanContext planContext, @Nonnull QueryComponent filter, boolean needOrdering) {
        planContext.rankComparisons = new RankComparisons(filter, planContext.indexes);
        ArrayList<ScoredPlan> intersectionCandidates = new ArrayList<ScoredPlan>();
        ScoredInfo bestPlan = null;
        Index bestIndex = null;
        if (planContext.commonPrimaryKey != null && !this.avoidScanPlan(planContext)) {
            bestPlan = this.planIndex(planContext, filter, null, planContext.commonPrimaryKey, intersectionCandidates);
        }
        for (Index index : planContext.indexes) {
            KeyExpression indexKeyExpression;
            ScoredPlan p = this.planIndex(planContext, filter, index, indexKeyExpression = this.indexKeyExpressionForPlan(planContext.commonPrimaryKey, index), intersectionCandidates);
            if (p == null || !this.isBetterThanOther(planContext, p, index, (ScoredPlan)bestPlan, bestIndex)) continue;
            bestPlan = p;
            bestIndex = index;
        }
        if (bestPlan != null) {
            if (bestPlan.getNumNonSargables() > 0) {
                bestPlan = this.handleNonSargables((ScoredPlan)bestPlan, intersectionCandidates, planContext);
            }
            if (needOrdering) {
                ((ScoredPlan)bestPlan).planOrderingKey = PlanOrderingKey.forPlan(this.metaData, ((ScoredPlan)bestPlan).getPlan(), planContext.commonPrimaryKey);
            }
        }
        return bestPlan;
    }

    private KeyExpression indexKeyExpressionForPlan(@Nullable KeyExpression commonPrimaryKey, @Nonnull Index index) {
        KeyExpression indexKeyExpression = index.getRootExpression();
        if (indexKeyExpression instanceof KeyWithValueExpression) {
            indexKeyExpression = ((KeyWithValueExpression)indexKeyExpression).getKeyExpression();
        }
        if (indexKeyExpression instanceof DimensionsKeyExpression) {
            indexKeyExpression = ((DimensionsKeyExpression)indexKeyExpression).getWholeKey();
        }
        if (commonPrimaryKey != null && this.indexTypes.getValueTypes().contains(index.getType()) && this.configuration.shouldUseFullKeyForValueIndex()) {
            ArrayList<KeyExpression> keys = new ArrayList<KeyExpression>(commonPrimaryKey.normalizeKeyForPositions());
            index.trimPrimaryKey(keys);
            if (!keys.isEmpty()) {
                keys.add(0, indexKeyExpression);
                indexKeyExpression = Key.Expressions.concat(keys);
            }
        }
        return indexKeyExpression;
    }

    public boolean isBetterThanOther(@Nonnull PlanContext planContext, @Nonnull ScoredPlan plan, @Nullable Index index, @Nullable ScoredPlan otherPlan, @Nullable Index otherIndex) {
        if (otherPlan == null) {
            return true;
        }
        if (plan.score > otherPlan.score) {
            return true;
        }
        if (plan.getNumNonSargables() < otherPlan.getNumNonSargables()) {
            return true;
        }
        if (plan.score == otherPlan.score && plan.getNumNonSargables() == otherPlan.getNumNonSargables()) {
            if (plan.getNumIndexFilters() == otherPlan.getNumIndexFilters() && this.compareIndexes(planContext, index, plan.flowsAllRequiredFields, otherIndex, otherPlan.flowsAllRequiredFields) > 0) {
                return true;
            }
            return plan.getNumIndexFilters() > otherPlan.getNumIndexFilters();
        }
        return false;
    }

    @Nullable
    private ScoredPlan planIndex(@Nonnull PlanContext planContext, @Nonnull QueryComponent filter, @Nullable Index index, @Nonnull KeyExpression indexExpr, @Nonnull List<ScoredPlan> intersectionCandidates) {
        PlanOrderingKey planOrderingKey;
        KeyExpression sort = planContext.query.getSort();
        boolean sortReverse = planContext.query.isSortReverse();
        CandidateScan candidateScan = new CandidateScan(planContext, index, sortReverse);
        ScoredPlan p = null;
        if (index != null) {
            if (this.indexTypes.getRankTypes().contains(index.getType())) {
                GroupingKeyExpression grouping = (GroupingKeyExpression)indexExpr;
                p = this.planRank(candidateScan, index, grouping, filter);
                indexExpr = grouping.getWholeKey();
            } else if (!this.indexTypes.getValueTypes().contains(index.getType())) {
                PlanOrderingKey planOrderingKey2;
                p = this.planOther(candidateScan, index, filter, sort, sortReverse, planContext.commonPrimaryKey);
                if (p != null) {
                    p = this.planRemoveDuplicates(planContext, p);
                }
                if (p != null) {
                    p = this.computePlanProperties(planContext, p);
                }
                if (p != null && p.getNumNonSargables() > 0 && (planOrderingKey2 = PlanOrderingKey.forPlan(this.metaData, p.getPlan(), planContext.commonPrimaryKey)) != null && sort != null) {
                    p.planOrderingKey = planOrderingKey2;
                    intersectionCandidates.add(p);
                }
                return p;
            }
        }
        if (p == null) {
            p = this.matchToPlan(candidateScan, this.matchCandidateScan(candidateScan, indexExpr, filter, sort));
        }
        if (p == null && (p = this.planSortOnly(candidateScan, indexExpr, sort)) != null) {
            List unsatisfiedFilters = filter instanceof AndComponent ? ((AndComponent)filter).getChildren() : Collections.singletonList(filter);
            p = new ScoredPlan(0, p.getPlan(), unsatisfiedFilters, p.createsDuplicates, p.isStrictlySorted);
        }
        if (p != null) {
            p = this.getConfiguration().shouldOptimizeForIndexFilters() ? (index == null ? (ScoredPlan)p.withResidualFilterAndSargedComparisons(p.combineNonSargables(), this.computeSargedComparisons(p.getPlan()), true) : this.computePlanProperties(planContext, p)) : (ScoredPlan)p.withSargedComparisons(this.computeSargedComparisons(p.getPlan()));
        }
        if (p != null && (p = this.planRemoveDuplicates(planContext, p)) != null && p.getNumNonSargables() > 0 && (planOrderingKey = PlanOrderingKey.forPlan(this.metaData, p.getPlan(), planContext.commonPrimaryKey)) != null && (sort != null || planOrderingKey.isPrimaryKeyOrdered())) {
            p.planOrderingKey = planOrderingKey;
            intersectionCandidates.add(p);
        }
        return p;
    }

    private ScoredPlan computePlanProperties(@Nonnull PlanContext planContext, @Nonnull ScoredPlan plan) {
        RecordQueryPlanWithIndex planWithIndex;
        Index index;
        Collection<RecordType> recordTypes;
        Set<Comparisons.Comparison> sargedComparisons = this.computeSargedComparisons(plan.getPlan());
        ArrayList<QueryComponent> indexFilters = plan.indexFilters;
        ArrayList<QueryComponent> residualFilters = plan.unsatisfiedFilters;
        boolean flowsAllRequiredFields = plan.flowsAllRequiredFields;
        if (plan.getPlan() instanceof RecordQueryPlanWithIndex && (recordTypes = this.metaData.recordTypesForIndex(index = this.metaData.getIndex((planWithIndex = (RecordQueryPlanWithIndex)plan.getPlan()).getIndexName()))).size() == 1) {
            RecordType recordType = Iterables.getOnlyElement(recordTypes);
            ArrayList<QueryComponent> unsatisfiedFilters = new ArrayList<QueryComponent>(plan.unsatisfiedFilters);
            AvailableFields availableFieldsFromIndex = AvailableFields.fromIndex(recordType, index, this.indexTypes, planContext.commonPrimaryKey, planWithIndex);
            List<KeyExpression> requiredResults = planContext.query.getRequiredResults();
            flowsAllRequiredFields = this.configuration.shouldOptimizeForRequiredResults() && requiredResults != null && availableFieldsFromIndex.containsAll(requiredResults);
            ArrayList<QueryComponent> indexFiltersFromPartitioning = Lists.newArrayListWithCapacity(unsatisfiedFilters.size());
            ArrayList<QueryComponent> residualFiltersFromPartitioning = Lists.newArrayListWithCapacity(unsatisfiedFilters.size());
            FilterVisitor.partitionFilters(unsatisfiedFilters, availableFieldsFromIndex, indexFiltersFromPartitioning, residualFiltersFromPartitioning, null);
            if (!indexFiltersFromPartitioning.isEmpty()) {
                indexFilters = indexFiltersFromPartitioning;
                residualFilters = residualFiltersFromPartitioning;
            }
        }
        return (ScoredPlan)plan.withFiltersAndSargedComparisons((List<QueryComponent>)residualFilters, (List<QueryComponent>)indexFilters, sargedComparisons, flowsAllRequiredFields);
    }

    protected Set<Comparisons.Comparison> computeSargedComparisons(@Nonnull RecordQueryPlan plan) {
        return ComparisonsProperty.comparisons().evaluate(plan);
    }

    @Nullable
    private ScoredMatch matchCandidateScan(@Nonnull CandidateScan candidateScan, @Nonnull KeyExpression indexExpr, @Nonnull QueryComponent filter, @Nullable KeyExpression sort) {
        if ((filter = candidateScan.planContext.rankComparisons.planComparisonSubstitute(filter)) instanceof FieldWithComparison) {
            return this.planFieldWithComparison(candidateScan, indexExpr, (FieldWithComparison)filter, sort, true);
        }
        if (filter instanceof OneOfThemWithComparison) {
            return this.planOneOfThemWithComparison(candidateScan, indexExpr, (OneOfThemWithComparison)filter, sort);
        }
        if (filter instanceof AndComponent) {
            return this.planAnd(candidateScan, indexExpr, (AndComponent)filter, sort);
        }
        if (filter instanceof NestedField) {
            return this.planNestedField(candidateScan, indexExpr, (NestedField)filter, sort);
        }
        if (filter instanceof OneOfThemWithComponent) {
            return this.planOneOfThemWithComponent(candidateScan, indexExpr, (OneOfThemWithComponent)filter, sort);
        }
        if (filter instanceof QueryRecordFunctionWithComparison) {
            if ("version".equals(((QueryRecordFunctionWithComparison)filter).getFunction().getName())) {
                return this.planVersion(candidateScan, indexExpr, (QueryRecordFunctionWithComparison)filter, sort);
            }
        } else {
            if (filter instanceof QueryKeyExpressionWithComparison) {
                return this.planQueryKeyExpressionWithComparison(candidateScan, indexExpr, (QueryKeyExpressionWithComparison)filter, sort);
            }
            if (filter instanceof QueryKeyExpressionWithOneOfComparison) {
                return this.planQueryKeyExpressionWithOneOfComparison(candidateScan, indexExpr, (QueryKeyExpressionWithOneOfComparison)filter, sort);
            }
        }
        return null;
    }

    @Nullable
    private ScoredPlan matchToPlan(@Nonnull CandidateScan candidateScan, @Nullable ScoredMatch scoredMatch) {
        if (scoredMatch == null) {
            return null;
        }
        Index index = candidateScan.getIndex();
        if (index != null && index.getType().equals("multidimensional")) {
            return this.matchToMultidimensionalIndexScan(candidateScan, scoredMatch, index);
        }
        return scoredMatch.asScoredPlan(this.valueScan(candidateScan, scoredMatch.getComparisonRanges().toScanComparisons(), scoredMatch.isStrictlySorted));
    }

    @Nullable
    private ScoredPlan matchToMultidimensionalIndexScan(@Nonnull CandidateScan candidateScan, @Nonnull ScoredMatch scoredMatch, Index index) {
        List<Object> compensationComponentsForSuffix;
        ComparisonRanges comparisonRanges = scoredMatch.getComparisonRanges();
        DimensionsKeyExpression dimensionsKeyExpression = MultidimensionalIndexMaintainer.getDimensionsKeyExpression(index.getRootExpression());
        KeyExpression commonPrimaryKey = candidateScan.getPlanContext().commonPrimaryKey;
        KeyExpression indexKeyExpression = this.indexKeyExpressionForPlan(commonPrimaryKey, index);
        Verify.verify(comparisonRanges.size() == indexKeyExpression.getColumnSize());
        int prefixCount = dimensionsKeyExpression.getPrefixSize();
        int dimensionsCount = dimensionsKeyExpression.getDimensionsSize();
        ComparisonRanges prefixComparisonRanges = new ComparisonRanges(comparisonRanges.subRanges(0, prefixCount));
        if (!prefixComparisonRanges.getRanges().stream().allMatch(ComparisonRange::isEquality)) {
            return null;
        }
        List dimensionsScanComparisons = comparisonRanges.subRanges(prefixCount, prefixCount + dimensionsCount).stream().map(ComparisonRange::toScanComparisons).collect(ImmutableList.toImmutableList());
        if (dimensionsScanComparisons.stream().anyMatch(ScanComparisons::isEmpty)) {
            return null;
        }
        int suffixCount = comparisonRanges.size() - prefixCount - dimensionsCount;
        ComparisonRanges suffixComparisonRanges = new ComparisonRanges(comparisonRanges.subRanges(prefixCount + dimensionsCount, comparisonRanges.size()));
        ScanComparisons suffixScanComparisons = suffixComparisonRanges.toScanComparisons();
        if (suffixScanComparisons.size() < suffixCount) {
            List<KeyExpression> suffixKeyExpressions = indexKeyExpression.normalizeKeyForPositions().subList(prefixCount + dimensionsCount, comparisonRanges.size());
            compensationComponentsForSuffix = suffixComparisonRanges.compensateForScanComparisons(suffixKeyExpressions);
            if (compensationComponentsForSuffix == null) {
                return null;
            }
        } else {
            compensationComponentsForSuffix = Lists.newArrayList();
        }
        MultidimensionalIndexScanComparisons indexScanParameters = MultidimensionalIndexScanComparisons.byValue(prefixComparisonRanges.toScanComparisons(), dimensionsScanComparisons, suffixComparisonRanges.toScanComparisons());
        RecordQueryPlan plan = this.planScan(candidateScan, indexScanParameters, scoredMatch.isStrictlySorted);
        ScoredPlan scoredPlan = scoredMatch.asScoredPlan(plan);
        if (!compensationComponentsForSuffix.isEmpty()) {
            return (ScoredPlan)scoredPlan.withAdditionalIndexFilters(compensationComponentsForSuffix);
        }
        return scoredPlan;
    }

    @Nonnull
    private List<Index> readableOf(@Nonnull List<Index> indexes) {
        if (this.recordStoreState.allIndexesReadable()) {
            return indexes;
        }
        return indexes.stream().filter(this.recordStoreState::isReadable).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private PlanContext getPlanContext(@Nonnull RecordQuery query) {
        KeyExpression commonPrimaryKey;
        ArrayList<Index> indexes = new ArrayList<Index>();
        this.recordStoreState.beginRead();
        try {
            if (query.getRecordTypes().isEmpty()) {
                commonPrimaryKey = RecordMetaData.commonPrimaryKey(this.metaData.getRecordTypes().values());
            } else {
                List<RecordType> recordTypes = query.getRecordTypes().stream().map(this.metaData::getQueryableRecordType).collect(Collectors.toList());
                if (recordTypes.size() == 1) {
                    RecordType recordType = (RecordType)recordTypes.get(0);
                    indexes.addAll(this.readableOf(recordType.getIndexes()));
                    indexes.addAll(this.readableOf(recordType.getMultiTypeIndexes()));
                    commonPrimaryKey = recordType.getPrimaryKey();
                } else {
                    boolean first = true;
                    for (RecordType recordType : recordTypes) {
                        if (first) {
                            indexes.addAll(this.readableOf(recordType.getMultiTypeIndexes()));
                            first = false;
                            continue;
                        }
                        indexes.retainAll(this.readableOf(recordType.getMultiTypeIndexes()));
                    }
                    commonPrimaryKey = RecordMetaData.commonPrimaryKey(recordTypes);
                }
            }
            indexes.addAll(this.readableOf(this.metaData.getUniversalIndexes()));
        }
        finally {
            this.recordStoreState.endRead();
        }
        indexes.removeIf(query.hasAllowedIndexes() ? index -> !query.getAllowedIndexes().contains(index.getName()) : index -> !query.getIndexQueryabilityFilter().isQueryable((Index)index));
        return new PlanContext(query, indexes, commonPrimaryKey);
    }

    @Nullable
    private ScoredPlan planRemoveDuplicates(@Nonnull PlanContext planContext, @Nonnull ScoredPlan plan) {
        if (plan.createsDuplicates && planContext.query.removesDuplicates()) {
            if (planContext.commonPrimaryKey == null) {
                return null;
            }
            return new ScoredPlan(new RecordQueryUnorderedPrimaryKeyDistinctPlan(plan.getPlan()), (List<QueryComponent>)plan.unsatisfiedFilters, (List<QueryComponent>)plan.indexFilters, (Set<Comparisons.Comparison>)plan.sargedComparisons, plan.score, false, plan.isStrictlySorted, plan.flowsAllRequiredFields, (Set<RankComparisons.RankComparison>)plan.includedRankComparisons);
        }
        return plan;
    }

    @Nonnull
    private ScoredPlan handleNonSargables(@Nonnull ScoredPlan bestPlan, @Nonnull List<ScoredPlan> intersectionCandidates, @Nonnull PlanContext planContext) {
        if (planContext.commonPrimaryKey != null && !intersectionCandidates.isEmpty()) {
            KeyExpression comparisonKey = planContext.commonPrimaryKey;
            KeyExpression sort = planContext.query.getSort();
            comparisonKey = this.getKeyForMerge(sort, comparisonKey);
            ScoredPlan intersectionPlan = this.planIntersection(intersectionCandidates, comparisonKey);
            if (intersectionPlan != null) {
                if (intersectionPlan.unsatisfiedFilters.isEmpty()) {
                    return intersectionPlan;
                }
                if (bestPlan.getNumNonSargables() > intersectionPlan.getNumNonSargables()) {
                    bestPlan = intersectionPlan;
                }
            }
        }
        if (bestPlan.getNumNonSargables() > 0) {
            RecordQueryFilterPlan filtered = new RecordQueryFilterPlan(bestPlan.getPlan(), planContext.rankComparisons.planComparisonSubstitutes(bestPlan.combineNonSargables()));
            return new ScoredPlan(filtered, Collections.emptyList(), Collections.emptyList(), (Set<Comparisons.Comparison>)bestPlan.sargedComparisons, bestPlan.score, bestPlan.createsDuplicates, bestPlan.isStrictlySorted, bestPlan.flowsAllRequiredFields, (Set<RankComparisons.RankComparison>)bestPlan.includedRankComparisons);
        }
        return bestPlan;
    }

    @Nullable
    private ScoredPlan planIntersection(@Nonnull List<ScoredPlan> intersectionCandidates, @Nonnull KeyExpression comparisonKey) {
        intersectionCandidates.sort(Comparator.comparingInt(ScoredInfo::getNumNonSargables).thenComparing(Comparator.comparingInt(ScoredInfo::getNumIndexFilters).reversed()).thenComparing(Comparator.comparingInt(p -> p.flowsAllRequiredFields ? 1 : 0).reversed()));
        ScoredPlan plan1 = intersectionCandidates.get(0);
        ArrayList<QueryComponent> nonSargables = new ArrayList<QueryComponent>(plan1.combineNonSargables());
        Set<RankComparisons.RankComparison> includedRankComparisons = this.mergeRankComparisons(null, plan1.includedRankComparisons);
        RecordQueryPlan plan = plan1.getPlan();
        ArrayList<RecordQueryPlan> includedPlans = new ArrayList<RecordQueryPlan>(intersectionCandidates.size());
        includedPlans.add(plan);
        for (int i = 1; i < intersectionCandidates.size(); ++i) {
            ScoredPlan nextPlan = intersectionCandidates.get(i);
            ArrayList<QueryComponent> nextNonSargables = new ArrayList<QueryComponent>(nextPlan.combineNonSargables());
            int oldCount = nonSargables.size();
            nonSargables.retainAll(nextNonSargables);
            if (nonSargables.size() < oldCount) {
                if (plan.isReverse() != nextPlan.getPlan().isReverse()) {
                    return null;
                }
                includedPlans.add(nextPlan.getPlan());
            }
            includedRankComparisons = this.mergeRankComparisons(includedRankComparisons, nextPlan.includedRankComparisons);
        }
        if (includedPlans.size() > 1) {
            RecordQueryIntersectionOnKeyExpressionPlan intersectionPlan = RecordQueryIntersectionPlan.from(includedPlans, comparisonKey);
            if (intersectionPlan.getComplexity() > this.configuration.getComplexityThreshold()) {
                throw new RecordQueryPlanComplexityException(intersectionPlan).addLogInfo(new Object[]{LogMessageKeys.COMPLEXITY, intersectionPlan.getComplexity()}).addLogInfo(new Object[]{LogMessageKeys.MAX_COMPLEXITY, this.configuration.getComplexityThreshold()});
            }
            return new ScoredPlan(intersectionPlan, (List<QueryComponent>)nonSargables, Collections.emptyList(), this.computeSargedComparisons(intersectionPlan), plan1.score, plan1.createsDuplicates, plan1.isStrictlySorted, false, includedRankComparisons);
        }
        return null;
    }

    @Nullable
    private ScoredMatch planOneOfThemWithComponent(@Nonnull CandidateScan candidateScan, @Nonnull KeyExpression indexExpr, @Nonnull OneOfThemWithComponent filter, @Nullable KeyExpression sort) {
        if (indexExpr instanceof FieldKeyExpression) {
            return null;
        }
        if (indexExpr instanceof ThenKeyExpression) {
            ThenKeyExpression then = (ThenKeyExpression)indexExpr;
            return this.planOneOfThemWithComponent(candidateScan, then.getChildren().get(0), filter, sort);
        }
        if (indexExpr instanceof NestingKeyExpression) {
            NestingKeyExpression indexNesting = (NestingKeyExpression)indexExpr;
            ScoredMatch match = null;
            if (sort == null) {
                match = this.planNesting(candidateScan, indexNesting, filter, null);
            } else if (sort instanceof FieldKeyExpression) {
                match = null;
            } else if (sort instanceof ThenKeyExpression) {
                match = null;
            } else if (sort instanceof NestingKeyExpression) {
                NestingKeyExpression sortNesting = (NestingKeyExpression)sort;
                match = this.planNesting(candidateScan, indexNesting, filter, sortNesting);
            }
            if (match != null) {
                List<QueryComponent> unsatisfied = !match.unsatisfiedFilters.isEmpty() ? Collections.singletonList(filter) : Collections.emptyList();
                match = new ScoredMatch(match.score, match.getComparisonRanges(), unsatisfied, true, match.isStrictlySorted);
            }
            return match;
        }
        return null;
    }

    @Nullable
    private ScoredMatch planNesting(@Nonnull CandidateScan candidateScan, @Nonnull NestingKeyExpression indexExpr, @Nonnull OneOfThemWithComponent filter, @Nullable NestingKeyExpression sort) {
        if ((sort == null || Objects.equals(indexExpr.getParent().getFieldName(), sort.getParent().getFieldName())) && Objects.equals(indexExpr.getParent().getFieldName(), filter.getFieldName())) {
            return this.matchCandidateScan(candidateScan, indexExpr.getChild(), filter.getChild(), sort == null ? null : sort.getChild());
        }
        return null;
    }

    @Nullable
    @SpotBugsSuppressWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    private ScoredMatch planNestedField(@Nonnull CandidateScan candidateScan, @Nonnull KeyExpression indexExpr, @Nonnull NestedField filter, @Nullable KeyExpression sort) {
        if (indexExpr instanceof FieldKeyExpression) {
            return null;
        }
        if (indexExpr instanceof ThenKeyExpression) {
            return this.planThenNestedField(candidateScan, (ThenKeyExpression)indexExpr, filter, sort);
        }
        if (indexExpr instanceof NestingKeyExpression) {
            return this.planNestingNestedField(candidateScan, (NestingKeyExpression)indexExpr, filter, sort);
        }
        return null;
    }

    private ScoredMatch planThenNestedField(@Nonnull CandidateScan candidateScan, @Nonnull ThenKeyExpression then, @Nonnull NestedField filter, @Nullable KeyExpression sort) {
        ComparisonRanges sortlessComparisons;
        ScoredMatch sortlessMatch;
        if (sort instanceof ThenKeyExpression || then.createsDuplicates()) {
            return this.planAndWithThen(candidateScan, then, Collections.singletonList(filter), sort);
        }
        ScoredMatch match = this.planNestedField(candidateScan, then.getChildren().get(0), filter, sort);
        if (match == null && sort != null && sort.equals(then.getChildren().get(1)) && (sortlessMatch = this.planNestedField(candidateScan, then.getChildren().get(0), filter, null)) != null && (sortlessComparisons = sortlessMatch.getComparisonRanges()).isEqualities()) {
            return sortlessMatch;
        }
        return match;
    }

    private ScoredMatch planNestingNestedField(@Nonnull CandidateScan candidateScan, @Nonnull NestingKeyExpression nesting, @Nonnull NestedField filter, @Nullable KeyExpression sort) {
        if (Objects.equals(nesting.getParent().getFieldName(), filter.getFieldName())) {
            NestingKeyExpression sortNesting;
            ScoredMatch childMatch = null;
            if (sort == null) {
                childMatch = this.matchCandidateScan(candidateScan, nesting.getChild(), filter.getChild(), null);
            } else if (sort instanceof NestingKeyExpression && Objects.equals((sortNesting = (NestingKeyExpression)sort).getParent().getFieldName(), nesting.getParent().getFieldName())) {
                childMatch = this.matchCandidateScan(candidateScan, nesting.getChild(), filter.getChild(), sortNesting.getChild());
            }
            if (childMatch != null && !childMatch.unsatisfiedFilters.isEmpty()) {
                QueryComponent unsatisfiedFilter = childMatch.unsatisfiedFilters.size() > 1 ? Query.field(filter.getFieldName()).matches(Query.and(childMatch.unsatisfiedFilters)) : Query.field(filter.getFieldName()).matches((QueryComponent)childMatch.unsatisfiedFilters.get(0));
                return (ScoredMatch)childMatch.withUnsatisfiedFilters(Collections.singletonList(unsatisfiedFilter));
            }
            return childMatch;
        }
        return null;
    }

    @Nullable
    private ComparisonRanges getPlanComparisonRanges(@Nonnull RecordQueryPlan plan) {
        RecordQueryPlanWithComparisons planWithComparisons;
        if (plan instanceof RecordQueryTypeFilterPlan) {
            return this.getPlanComparisonRanges(((RecordQueryTypeFilterPlan)plan).getInnerPlan());
        }
        if (plan instanceof RecordQueryPlanWithComparisons && (planWithComparisons = (RecordQueryPlanWithComparisons)plan).hasComparisonRanges()) {
            return planWithComparisons.getComparisonRanges();
        }
        return null;
    }

    @Nullable
    private ScoredMatch planOneOfThemWithComparison(@Nonnull CandidateScan candidateScan, @Nonnull KeyExpression indexExpr, @Nonnull OneOfThemWithComparison oneOfThemWithComparison, @Nullable KeyExpression sort) {
        Comparisons.Comparison comparison = oneOfThemWithComparison.getComparison();
        ComparisonRanges comparisonRanges = ComparisonRanges.tryFrom(comparison);
        if (comparisonRanges == null) {
            ComparisonRanges planComparisonRanges;
            ScoredPlan sortOnlyPlan = this.planSortOnly(candidateScan, indexExpr, sort);
            ComparisonRanges comparisonRanges2 = planComparisonRanges = sortOnlyPlan == null ? null : this.getPlanComparisonRanges(sortOnlyPlan.getPlan());
            if (planComparisonRanges != null) {
                return new ScoredMatch(0, planComparisonRanges, Collections.singletonList(oneOfThemWithComparison), sortOnlyPlan.createsDuplicates, sortOnlyPlan.isStrictlySorted);
            }
            return null;
        }
        if (indexExpr instanceof FieldKeyExpression) {
            FieldKeyExpression field = (FieldKeyExpression)indexExpr;
            if (Objects.equals(oneOfThemWithComparison.getFieldName(), field.getFieldName()) && field.getFanType() == KeyExpression.FanType.FanOut) {
                if (sort != null) {
                    FieldKeyExpression sortField;
                    if (sort instanceof FieldKeyExpression && Objects.equals((sortField = (FieldKeyExpression)sort).getFieldName(), field.getFieldName())) {
                        return new ScoredMatch(1, comparisonRanges, Collections.emptyList(), true, true);
                    }
                } else {
                    return new ScoredMatch(1, comparisonRanges, Collections.emptyList(), true, false);
                }
            }
            return null;
        }
        if (indexExpr instanceof ThenKeyExpression) {
            ThenKeyExpression then = (ThenKeyExpression)indexExpr;
            return this.planAndWithThen(candidateScan, then, Collections.singletonList(oneOfThemWithComparison), sort);
        }
        if (indexExpr instanceof NestingKeyExpression) {
            return null;
        }
        return null;
    }

    @Nullable
    private ScoredMatch planAnd(@Nonnull CandidateScan candidateScan, @Nonnull KeyExpression indexExpr, @Nonnull AndComponent filter, @Nullable KeyExpression sort) {
        if (indexExpr instanceof NestingKeyExpression) {
            return this.planAndWithNesting(candidateScan, (NestingKeyExpression)indexExpr, filter, sort);
        }
        if (indexExpr instanceof ThenKeyExpression) {
            return this.planAndWithThen(candidateScan, (ThenKeyExpression)indexExpr, filter.getChildren(), sort);
        }
        return this.planAndWithThen(candidateScan, null, Collections.singletonList(indexExpr), filter.getChildren(), sort);
    }

    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="maybe https://github.com/spotbugs/spotbugs/issues/616?")
    private ScoredMatch planAndWithThen(@Nonnull CandidateScan candidateScan, @Nonnull ThenKeyExpression indexExpr, @Nonnull List<QueryComponent> filters, @Nullable KeyExpression sort) {
        return this.planAndWithThen(candidateScan, indexExpr, indexExpr.getChildren(), filters, sort);
    }

    private ScoredMatch planAndWithThen(@Nonnull CandidateScan candidateScan, @Nullable ThenKeyExpression indexExpr, @Nonnull List<KeyExpression> indexChildren, @Nonnull List<QueryComponent> filters, @Nullable KeyExpression sort) {
        AbstractAndWithThenPlanner andWithThenPlanner = candidateScan.index != null && candidateScan.index.getType().equals("multidimensional") ? new MultidimensionalAndWithThenPlanner(candidateScan, indexExpr, indexChildren, filters, sort) : new AndWithThenPlanner(candidateScan, indexExpr, indexChildren, filters, sort);
        return ((AbstractAndWithThenPlanner)andWithThenPlanner).plan();
    }

    @Nullable
    private ScoredMatch planAndWithNesting(@Nonnull CandidateScan candidateScan, @Nonnull NestingKeyExpression indexExpr, @Nonnull AndComponent filter, @Nullable KeyExpression sort) {
        FieldKeyExpression parent = indexExpr.getParent();
        if (parent.getFanType() == KeyExpression.FanType.None) {
            ArrayList<QueryComponent> nestedFilters = new ArrayList<QueryComponent>();
            ArrayList<QueryComponent> remainingFilters = new ArrayList<QueryComponent>();
            for (QueryComponent filterChild : filter.getChildren()) {
                QueryComponent filterComponent = candidateScan.planContext.rankComparisons.planComparisonSubstitute(filterChild);
                if (filterComponent instanceof NestedField) {
                    NestedField nestedField = (NestedField)filterComponent;
                    if (parent.getFieldName().equals(nestedField.getFieldName())) {
                        nestedFilters.add(nestedField.getChild());
                        continue;
                    }
                }
                remainingFilters.add(filterChild);
            }
            if (nestedFilters.size() > 1) {
                NestedField nestedAnd = new NestedField(parent.getFieldName(), Query.and(nestedFilters));
                ScoredMatch match = this.planNestedField(candidateScan, indexExpr, nestedAnd, sort);
                if (match != null) {
                    if (remainingFilters.isEmpty()) {
                        return match;
                    }
                    return (ScoredMatch)match.withUnsatisfiedFilters(remainingFilters);
                }
                return null;
            }
        }
        ArrayList<QueryComponent> unsatisfiedFilters = new ArrayList<QueryComponent>(filter.getChildren());
        for (QueryComponent filterChild : filter.getChildren()) {
            NestedField nestedField;
            ScoredMatch match;
            QueryComponent filterComponent = candidateScan.planContext.rankComparisons.planComparisonSubstitute(filterChild);
            if (!(filterComponent instanceof NestedField) || (match = this.planNestedField(candidateScan, indexExpr, nestedField = (NestedField)filterComponent, sort)) == null) continue;
            unsatisfiedFilters.remove(filterChild);
            return (ScoredMatch)match.withUnsatisfiedFilters(unsatisfiedFilters);
        }
        return null;
    }

    @Nullable
    private ScoredMatch planFieldWithComparison(@Nonnull CandidateScan candidateScan, @Nonnull KeyExpression indexExpr, @Nonnull FieldWithComparison singleField, @Nullable KeyExpression sort, boolean fullKey) {
        Comparisons.Comparison comparison = singleField.getComparison();
        ComparisonRanges comparisonRanges = ComparisonRanges.tryFrom(comparison);
        if (comparisonRanges == null) {
            return null;
        }
        if (indexExpr instanceof FieldKeyExpression) {
            FieldKeyExpression field = (FieldKeyExpression)indexExpr;
            if (Objects.equals(singleField.getFieldName(), field.getFieldName())) {
                if (sort != null) {
                    FieldKeyExpression sortField;
                    if (sort instanceof FieldKeyExpression && Objects.equals((sortField = (FieldKeyExpression)sort).getFieldName(), field.getFieldName())) {
                        return new ScoredMatch(1, comparisonRanges, Collections.emptyList(), false, fullKey);
                    }
                } else {
                    return new ScoredMatch(1, comparisonRanges, Collections.emptyList(), false, false);
                }
            }
            return null;
        }
        if (indexExpr instanceof ThenKeyExpression) {
            ThenKeyExpression then = (ThenKeyExpression)indexExpr;
            if (!(sort != null && !sort.equals(then.getChildren().get(0)) || then.createsDuplicates() || then.getChildren().get(0) instanceof RecordTypeKeyExpression)) {
                return this.planFieldWithComparison(candidateScan, then.getChildren().get(0), singleField, sort, false);
            }
            return this.planAndWithThen(candidateScan, then, Collections.singletonList(singleField), sort);
        }
        return null;
    }

    @Nullable
    private ScoredMatch planQueryKeyExpressionWithComparison(@Nonnull CandidateScan candidateScan, @Nonnull KeyExpression indexExpr, @Nonnull QueryKeyExpressionWithComparison queryKeyExpressionWithComparison, @Nullable KeyExpression sort) {
        if (indexExpr.equals(queryKeyExpressionWithComparison.getKeyExpression()) && (sort == null || sort.equals(indexExpr))) {
            Comparisons.Comparison comparison = queryKeyExpressionWithComparison.getComparison();
            ComparisonRanges comparisonRanges = ComparisonRanges.tryFrom(comparison);
            if (comparisonRanges == null) {
                return null;
            }
            boolean strictlySorted = sort != null;
            return new ScoredMatch(1, comparisonRanges, Collections.emptyList(), false, strictlySorted);
        }
        if (indexExpr instanceof ThenKeyExpression) {
            return this.planAndWithThen(candidateScan, (ThenKeyExpression)indexExpr, Collections.singletonList(queryKeyExpressionWithComparison), sort);
        }
        return null;
    }

    @Nullable
    private ScoredMatch planQueryKeyExpressionWithOneOfComparison(@Nonnull CandidateScan candidateScan, @Nonnull KeyExpression indexExpr, @Nonnull QueryKeyExpressionWithOneOfComparison queryKeyExpressionWithOneOfComparison, @Nullable KeyExpression sort) {
        if (indexExpr.equals(queryKeyExpressionWithOneOfComparison.getKeyExpression()) && (sort == null || sort.equals(indexExpr))) {
            Comparisons.Comparison comparison = queryKeyExpressionWithOneOfComparison.getComparison();
            ComparisonRanges comparisonRanges = ComparisonRanges.tryFrom(comparison);
            if (comparisonRanges == null) {
                return null;
            }
            boolean strictlySorted = sort != null;
            return new ScoredMatch(1, comparisonRanges, Collections.emptyList(), false, strictlySorted);
        }
        if (indexExpr instanceof ThenKeyExpression) {
            return this.planAndWithThen(candidateScan, (ThenKeyExpression)indexExpr, Collections.singletonList(queryKeyExpressionWithOneOfComparison), sort);
        }
        return null;
    }

    @Nullable
    private ScoredPlan planSortOnly(@Nonnull CandidateScan candidateScan, @Nonnull KeyExpression indexExpr, @Nullable KeyExpression sort) {
        FieldKeyExpression sortField;
        if (sort == null) {
            return null;
        }
        if (sort instanceof FieldKeyExpression && (sortField = (FieldKeyExpression)sort).getFanType() == KeyExpression.FanType.Concatenate) {
            throw new KeyExpression.InvalidExpressionException("Sorting by concatenate not supported");
        }
        if (sort.isPrefixKey(indexExpr)) {
            boolean strictlySorted = sort.equals(indexExpr) || candidateScan.index != null && candidateScan.index.isUnique() && sort.getColumnSize() >= candidateScan.index.getColumnSize();
            return new ScoredPlan(0, this.valueScan(candidateScan, null, strictlySorted), Collections.emptyList(), indexExpr.createsDuplicates(), strictlySorted);
        }
        return null;
    }

    @Nonnull
    protected Set<String> getPossibleTypes(@Nonnull Index index) {
        Collection<RecordType> recordTypes = this.metaData.recordTypesForIndex(index);
        if (recordTypes.size() == 1) {
            RecordType singleRecordType = recordTypes.iterator().next();
            return Collections.singleton(singleRecordType.getName());
        }
        return recordTypes.stream().map(RecordType::getName).collect(Collectors.toSet());
    }

    @Nonnull
    protected RecordQueryPlan addTypeFilterIfNeeded(@Nonnull CandidateScan candidateScan, @Nonnull RecordQueryPlan plan, @Nonnull Set<String> possibleTypes) {
        Collection<String> allowedTypes = candidateScan.planContext.query.getRecordTypes();
        if (!allowedTypes.isEmpty() && !allowedTypes.containsAll(possibleTypes)) {
            return new RecordQueryTypeFilterPlan(plan, allowedTypes);
        }
        return plan;
    }

    @Nullable
    private ScoredMatch planVersion(@Nonnull CandidateScan candidateScan, @Nonnull KeyExpression indexExpr, @Nonnull QueryRecordFunctionWithComparison filter, @Nullable KeyExpression sort) {
        if (indexExpr instanceof VersionKeyExpression) {
            if (sort == null || sort.equals(VersionKeyExpression.VERSION)) {
                Comparisons.Comparison comparison = filter.getComparison();
                ComparisonRanges comparisonRanges = ComparisonRanges.tryFrom(comparison);
                return new ScoredMatch(1, comparisonRanges == null ? new ComparisonRanges() : comparisonRanges, Collections.emptyList());
            }
        } else if (indexExpr instanceof ThenKeyExpression) {
            ThenKeyExpression then = (ThenKeyExpression)indexExpr;
            if (sort == null) {
                return this.planVersion(candidateScan, then.getChildren().get(0), filter, null);
            }
            return this.planAndWithThen(candidateScan, then, Collections.singletonList(filter), sort);
        }
        return null;
    }

    @Nullable
    private ScoredPlan planRank(@Nonnull CandidateScan candidateScan, @Nonnull Index index, @Nonnull GroupingKeyExpression indexExpr, @Nonnull QueryComponent filter) {
        if (filter instanceof QueryRecordFunctionWithComparison) {
            QueryRecordFunctionWithComparison filterComparison = (QueryRecordFunctionWithComparison)filter;
            RankComparisons.RankComparison rankComparison = candidateScan.planContext.rankComparisons.getPlanComparison(filterComparison);
            if (rankComparison != null && rankComparison.getIndex() == index && RankComparisons.matchesSort(indexExpr, candidateScan.planContext.query.getSort())) {
                ScanComparisons scanComparisons = rankComparison.getScanComparisons();
                RecordQueryPlan scan = this.rankScan(candidateScan, filterComparison, scanComparisons);
                boolean createsDuplicates = RankComparisons.createsDuplicates(index, indexExpr);
                return new ScoredPlan(scan, Collections.emptyList(), Collections.emptyList(), this.computeSargedComparisons(scan), 1, createsDuplicates, scan.isStrictlySorted(), false, Collections.singleton(rankComparison));
            }
        } else if (filter instanceof AndComponent) {
            return this.planRankWithAnd(candidateScan, index, indexExpr, (AndComponent)filter);
        }
        return null;
    }

    @Nullable
    private ScoredPlan planRankWithAnd(@Nonnull CandidateScan candidateScan, @Nonnull Index index, @Nonnull GroupingKeyExpression indexExpr, @Nonnull AndComponent and) {
        List filters = and.getChildren();
        for (QueryComponent filter : filters) {
            QueryRecordFunctionWithComparison filterComparison;
            RankComparisons.RankComparison rankComparison;
            if (!(filter instanceof QueryRecordFunctionWithComparison) || (rankComparison = candidateScan.planContext.rankComparisons.getPlanComparison(filterComparison = (QueryRecordFunctionWithComparison)filter)) == null || rankComparison.getIndex() != index || !RankComparisons.matchesSort(indexExpr, candidateScan.planContext.query.getSort())) continue;
            ScanComparisons scanComparisons = rankComparison.getScanComparisons();
            HashSet<RankComparisons.RankComparison> includedRankComparisons = new HashSet<RankComparisons.RankComparison>();
            includedRankComparisons.add(rankComparison);
            ArrayList<QueryComponent> unsatisfiedFilters = new ArrayList<QueryComponent>(filters);
            unsatisfiedFilters.remove(filter);
            unsatisfiedFilters.removeAll(rankComparison.getGroupFilters());
            for (int i = 0; i < unsatisfiedFilters.size(); ++i) {
                ScanComparisons mergedScanComparisons;
                QueryRecordFunctionWithComparison otherComparison;
                RankComparisons.RankComparison otherRank;
                QueryComponent otherFilter = (QueryComponent)unsatisfiedFilters.get(i);
                if (!(otherFilter instanceof QueryRecordFunctionWithComparison) || (otherRank = candidateScan.planContext.rankComparisons.getPlanComparison(otherComparison = (QueryRecordFunctionWithComparison)otherFilter)) == null || (mergedScanComparisons = scanComparisons.merge(otherRank.getScanComparisons())) == null) continue;
                scanComparisons = mergedScanComparisons;
                includedRankComparisons.add(otherRank);
                unsatisfiedFilters.remove(i--);
            }
            RecordQueryPlan scan = this.rankScan(candidateScan, filterComparison, scanComparisons);
            boolean createsDuplicates = RankComparisons.createsDuplicates(index, indexExpr);
            return new ScoredPlan(scan, (List<QueryComponent>)unsatisfiedFilters, Collections.emptyList(), this.computeSargedComparisons(scan), indexExpr.getColumnSize(), createsDuplicates, scan.isStrictlySorted(), false, (Set<RankComparisons.RankComparison>)includedRankComparisons);
        }
        return null;
    }

    @Nullable
    protected ScoredPlan planOther(@Nonnull CandidateScan candidateScan, @Nonnull Index index, @Nonnull QueryComponent filter, @Nullable KeyExpression sort, boolean sortReverse, @Nullable KeyExpression commonPrimaryKey) {
        if (this.indexTypes.getTextTypes().contains(index.getType())) {
            return this.planText(candidateScan, index, filter, sort, sortReverse);
        }
        return null;
    }

    @Nullable
    private ScoredPlan planText(@Nonnull CandidateScan candidateScan, @Nonnull Index index, @Nonnull QueryComponent filter, @Nullable KeyExpression sort, boolean sortReverse) {
        Comparisons.TextContainsAllPrefixesComparison textComparison;
        if (sort != null) {
            return null;
        }
        FilterSatisfiedMask filterMask = FilterSatisfiedMask.of(filter);
        TextScan scan = TextScanPlanner.getScanForQuery(index, filter, false, filterMask);
        if (scan == null) {
            return null;
        }
        RecordQueryPlan plan = new RecordQueryTextIndexPlan(index.getName(), scan, candidateScan.reverse);
        Set<String> possibleTypes = this.getPossibleTypes(index);
        plan = this.addTypeFilterIfNeeded(candidateScan, plan, possibleTypes);
        if (scan.getTextComparison() instanceof Comparisons.TextContainsAllPrefixesComparison && (textComparison = (Comparisons.TextContainsAllPrefixesComparison)scan.getTextComparison()).isStrict()) {
            plan = new RecordQueryFilterPlan(plan, filter);
            filterMask.setSatisfied(true);
        }
        return new ScoredPlan(plan, filterMask.getUnsatisfiedFilters(), Collections.emptyList(), this.computeSargedComparisons(plan), 10, scan.createsDuplicates(), plan.isStrictlySorted(), false, null);
    }

    @Nonnull
    private RecordQueryPlan planScan(@Nonnull CandidateScan candidateScan, @Nonnull IndexScanParameters indexScanParameters, boolean strictlySorted) {
        RecordQueryPlan plan;
        Set<String> possibleTypes;
        if (candidateScan.index == null) {
            Verify.verify(indexScanParameters instanceof IndexScanComparisons);
            ScanComparisons scanComparisons = ((IndexScanComparisons)indexScanParameters).getComparisons();
            possibleTypes = this.primaryKeyHasRecordTypePrefix && RecordTypeKeyComparison.hasRecordTypeKeyComparison(scanComparisons) ? RecordTypeKeyComparison.recordTypeKeyComparisonTypes(scanComparisons) : this.metaData.getRecordTypes().keySet();
            if (this.avoidScanPlan(candidateScan.planContext)) {
                throw new RecordCoreException("cannot create scan plan for a synthetic record type", new Object[0]);
            }
            plan = new RecordQueryScanPlan(possibleTypes, new Type.Any(), candidateScan.planContext.commonPrimaryKey, scanComparisons, candidateScan.reverse, strictlySorted);
        } else {
            RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords = this.resolveFetchIndexRecords(candidateScan.getPlanContext());
            IndexFetchMethod indexFetchMethod = fetchIndexRecords == RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY ? this.getConfiguration().getIndexFetchMethod() : IndexFetchMethod.SCAN_AND_FETCH;
            plan = new RecordQueryIndexPlan(candidateScan.index.getName(), candidateScan.planContext.commonPrimaryKey, indexScanParameters, indexFetchMethod, fetchIndexRecords, candidateScan.reverse, strictlySorted);
            possibleTypes = this.getPossibleTypes(candidateScan.index);
        }
        plan = this.addTypeFilterIfNeeded(candidateScan, plan, possibleTypes);
        return plan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean avoidScanPlan(@Nonnull PlanContext planContext) {
        Collection<String> queriedRecordTypes = planContext.query.getRecordTypes();
        Set<String> syntheticRecordTypes = this.metaData.getSyntheticRecordTypes().keySet();
        if (queriedRecordTypes.isEmpty()) return false;
        if (!queriedRecordTypes.stream().anyMatch(syntheticRecordTypes::contains)) return false;
        return true;
    }

    @Nonnull
    protected RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords resolveFetchIndexRecords(@Nonnull PlanContext planContext) {
        Collection<String> queriedRecordTypes = planContext.query.getRecordTypes();
        Set<String> syntheticRecordTypes = this.metaData.getSyntheticRecordTypes().keySet();
        Set<String> regularRecordTypes = this.metaData.getRecordTypes().keySet();
        if (!syntheticRecordTypes.isEmpty()) {
            if (queriedRecordTypes.isEmpty()) {
                return RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY;
            }
            if (syntheticRecordTypes.containsAll(queriedRecordTypes)) {
                return RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.SYNTHETIC_CONSTITUENTS;
            }
            if (regularRecordTypes.containsAll(queriedRecordTypes)) {
                return RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY;
            }
            throw new RecordCoreException("cannot mix regular and synthetic record types in query", new Object[0]);
        }
        return RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY;
    }

    @Nonnull
    private RecordQueryPlan valueScan(@Nonnull CandidateScan candidateScan, @Nullable ScanComparisons scanComparisons, boolean strictlySorted) {
        IndexScanType scanType = candidateScan.index != null && this.configuration.valueIndexOverScanNeeded(candidateScan.index.getName()) ? IndexScanType.BY_VALUE_OVER_SCAN : IndexScanType.BY_VALUE;
        return this.planScan(candidateScan, IndexScanComparisons.byValue(scanComparisons, scanType), strictlySorted);
    }

    @Nonnull
    private RecordQueryPlan rankScan(@Nonnull CandidateScan candidateScan, @Nonnull QueryRecordFunctionWithComparison rank, @Nonnull ScanComparisons scanComparisons) {
        IndexScanComparisons scanParameters = "time_window_rank".equals(rank.getFunction().getName()) ? new TimeWindowScanComparisons(((TimeWindowRecordFunction)rank.getFunction()).getTimeWindow(), scanComparisons) : new IndexScanComparisons(IndexScanType.BY_RANK, scanComparisons);
        return this.planScan(candidateScan, scanParameters, false);
    }

    @Nullable
    private ScoredPlan planOr(@Nonnull PlanContext planContext, @Nonnull OrComponent filter) {
        ScoredPlan orderedUnionPlan;
        if (filter.getChildren().isEmpty()) {
            return null;
        }
        ArrayList<ScoredPlan> subplans = new ArrayList<ScoredPlan>(filter.getChildren().size());
        boolean allHaveOrderingKey = true;
        RecordQueryPlan commonFilteredBasePlan = null;
        boolean allHaveSameBasePlan = true;
        for (QueryComponent subfilter : filter.getChildren()) {
            ScoredPlan subplan2 = this.planFilter(planContext, subfilter, true);
            if (subplan2 == null) {
                return null;
            }
            if (subplan2.planOrderingKey == null) {
                allHaveOrderingKey = false;
            }
            RecordQueryPlan filteredBasePlan = subplan2.getPlan() instanceof RecordQueryFilterPlan ? ((RecordQueryFilterPlan)subplan2.getPlan()).getInnerPlan() : null;
            if (subplans.isEmpty()) {
                commonFilteredBasePlan = filteredBasePlan;
                allHaveSameBasePlan = filteredBasePlan != null;
            } else if (allHaveSameBasePlan && !Objects.equals(filteredBasePlan, commonFilteredBasePlan)) {
                allHaveSameBasePlan = false;
            }
            subplans.add(subplan2);
        }
        if (allHaveSameBasePlan) {
            RecordQueryFilterPlan combinedOrFilter = new RecordQueryFilterPlan(commonFilteredBasePlan, new OrComponent(subplans.stream().map(subplan -> ((RecordQueryFilterPlan)subplan.getPlan()).getConjunctedFilter()).collect(Collectors.toList())));
            ScoredPlan firstSubPlan = (ScoredPlan)subplans.get(0);
            return new ScoredPlan(combinedOrFilter, Collections.emptyList(), Collections.emptyList(), Collections.emptySet(), firstSubPlan.score, firstSubPlan.createsDuplicates, firstSubPlan.isStrictlySorted, false, (Set<RankComparisons.RankComparison>)firstSubPlan.includedRankComparisons);
        }
        if (allHaveOrderingKey && (orderedUnionPlan = this.planOrderedUnion(planContext, subplans)) != null) {
            return orderedUnionPlan;
        }
        ScoredPlan unorderedUnionPlan = this.planUnorderedUnion(planContext, subplans);
        if (unorderedUnionPlan != null) {
            return this.planRemoveDuplicates(planContext, unorderedUnionPlan);
        }
        return null;
    }

    @Nullable
    private ScoredPlan planOrderedUnion(@Nonnull PlanContext planContext, @Nonnull List<ScoredPlan> subplans) {
        KeyExpression candidateKey;
        KeyExpression sort = planContext.query.getSort();
        boolean candidateOnly = false;
        if (this.configuration.shouldOmitPrimaryKeyInUnionOrderingKey() || planContext.commonPrimaryKey == null) {
            candidateKey = sort;
        } else if (sort == null) {
            candidateKey = PlanOrderingKey.candidateContainingPrimaryKey(subplans, planContext.commonPrimaryKey);
        } else {
            candidateKey = this.getKeyForMerge(sort, planContext.commonPrimaryKey);
            candidateOnly = true;
        }
        KeyExpression comparisonKey = PlanOrderingKey.mergedComparisonKey(subplans, candidateKey, candidateOnly);
        if (comparisonKey == null) {
            return null;
        }
        boolean reverse = subplans.get(0).getPlan().isReverse();
        boolean anyDuplicates = false;
        Set<RankComparisons.RankComparison> includedRankComparisons = null;
        ArrayList<RecordQueryPlan> childPlans = new ArrayList<RecordQueryPlan>(subplans.size());
        for (ScoredPlan subplan : subplans) {
            if (subplan.getPlan().isReverse() != reverse) {
                return null;
            }
            childPlans.add(subplan.getPlan());
            anyDuplicates |= subplan.createsDuplicates;
            includedRankComparisons = this.mergeRankComparisons(includedRankComparisons, subplan.includedRankComparisons);
        }
        boolean showComparisonKey = !comparisonKey.equals(planContext.commonPrimaryKey);
        RecordQueryUnionOnKeyExpressionPlan unionPlan = RecordQueryUnionPlan.from(childPlans, comparisonKey, showComparisonKey);
        if (unionPlan.getComplexity() > this.configuration.getComplexityThreshold()) {
            throw new RecordQueryPlanComplexityException(unionPlan).addLogInfo(new Object[]{LogMessageKeys.COMPLEXITY, unionPlan.getComplexity()}).addLogInfo(new Object[]{LogMessageKeys.MAX_COMPLEXITY, this.configuration.getComplexityThreshold()});
        }
        int score = this.getConfiguration().shouldAttemptFailedInJoinAsOr() ? 0 : 1;
        return new ScoredPlan(unionPlan, Collections.emptyList(), Collections.emptyList(), Collections.emptySet(), score, anyDuplicates, false, false, includedRankComparisons);
    }

    @Nullable
    private ScoredPlan planUnorderedUnion(@Nonnull PlanContext planContext, @Nonnull List<ScoredPlan> subplans) {
        KeyExpression sort = planContext.query.getSort();
        if (sort != null) {
            return null;
        }
        ArrayList<RecordQueryPlan> childPlans = new ArrayList<RecordQueryPlan>(subplans.size());
        Set<RankComparisons.RankComparison> includedRankComparisons = null;
        for (ScoredPlan subplan : subplans) {
            childPlans.add(subplan.getPlan());
            includedRankComparisons = this.mergeRankComparisons(includedRankComparisons, subplan.includedRankComparisons);
        }
        RecordQueryUnorderedUnionPlan unionPlan = RecordQueryUnorderedUnionPlan.from(childPlans);
        if (unionPlan.getComplexity() > this.configuration.getComplexityThreshold()) {
            throw new RecordQueryPlanComplexityException(unionPlan).addLogInfo(new Object[]{LogMessageKeys.COMPLEXITY, unionPlan.getComplexity()}).addLogInfo(new Object[]{LogMessageKeys.MAX_COMPLEXITY, this.configuration.getComplexityThreshold()});
        }
        return new ScoredPlan(unionPlan, Collections.emptyList(), Collections.emptyList(), Collections.emptySet(), 1, true, false, false, includedRankComparisons);
    }

    @Nullable
    private Set<RankComparisons.RankComparison> mergeRankComparisons(@Nullable Set<RankComparisons.RankComparison> into, @Nullable Set<RankComparisons.RankComparison> additional) {
        if (additional != null) {
            if (into == null) {
                return new HashSet<RankComparisons.RankComparison>(additional);
            }
            into.addAll(additional);
            return into;
        }
        return into;
    }

    @Nonnull
    private KeyExpression getKeyForMerge(@Nullable KeyExpression sort, @Nonnull KeyExpression candidateKey) {
        if (sort == null || sort.isPrefixKey(candidateKey)) {
            return candidateKey;
        }
        if (candidateKey.isPrefixKey(sort)) {
            return sort;
        }
        return this.concatWithoutDuplicates(sort, candidateKey);
    }

    private ThenKeyExpression concatWithoutDuplicates(@Nullable KeyExpression expr1, @Nonnull KeyExpression expr2) {
        ArrayList<KeyExpression> children = new ArrayList<KeyExpression>(2);
        if (expr1 instanceof ThenKeyExpression) {
            children.addAll(((ThenKeyExpression)expr1).getChildren());
        } else {
            children.add(expr1);
        }
        if (expr2 instanceof ThenKeyExpression) {
            for (KeyExpression child : ((ThenKeyExpression)expr2).getChildren()) {
                if (children.contains(child)) continue;
                children.add(child);
            }
        } else if (!children.contains(expr2)) {
            children.add(expr2);
        }
        return new ThenKeyExpression(children);
    }

    @Nonnull
    private QueryComponent normalizeAndOr(AndComponent and) {
        if (and.getChildren().size() == 2) {
            QueryComponent child1 = (QueryComponent)and.getChildren().get(0);
            QueryComponent child2 = (QueryComponent)and.getChildren().get(1);
            if (child1 instanceof OrComponent && Query.isSingleFieldComparison(child2)) {
                return OrComponent.from(this.distributeAnd(Collections.singletonList(child2), ((OrComponent)child1).getChildren()));
            }
            if (child2 instanceof OrComponent && Query.isSingleFieldComparison(child1)) {
                return OrComponent.from(this.distributeAnd(Collections.singletonList(child1), ((OrComponent)child2).getChildren()));
            }
        }
        return and;
    }

    private QueryComponent normalizeAndOrForInAsOr(@Nonnull QueryComponent component) {
        if (!(component instanceof AndComponent)) {
            return component;
        }
        AndComponent and = (AndComponent)component;
        AndOrComponent singleOrChild = null;
        ArrayList<QueryComponent> otherChildren = new ArrayList<QueryComponent>();
        for (QueryComponent child : and.getChildren()) {
            if (child instanceof OrComponent) {
                if (singleOrChild == null) {
                    singleOrChild = (OrComponent)child;
                    continue;
                }
                return and;
            }
            if (Query.isSingleFieldComparison(child)) {
                otherChildren.add(child);
                continue;
            }
            return and;
        }
        if (singleOrChild == null) {
            return and;
        }
        return OrComponent.from(this.distributeAnd(otherChildren, singleOrChild.getChildren()));
    }

    private List<QueryComponent> distributeAnd(List<QueryComponent> predicatesToDistribute, List<QueryComponent> children) {
        ArrayList<QueryComponent> distributed = new ArrayList<QueryComponent>();
        for (QueryComponent child : children) {
            ArrayList<QueryComponent> conjuncts = new ArrayList<QueryComponent>(2);
            conjuncts.addAll(predicatesToDistribute);
            if (child instanceof AndComponent) {
                conjuncts.addAll(((AndComponent)child).getChildren());
            } else {
                conjuncts.add(child);
            }
            AndComponent cchild = AndComponent.from(conjuncts);
            distributed.add(cchild);
        }
        return distributed;
    }

    @Nonnull
    private RecordQueryPlan tryToConvertToCoveringPlan(@Nonnull PlanContext planContext, @Nonnull RecordQueryPlan chosenPlan) {
        if (planContext.query.getRequiredResults() == null) {
            return chosenPlan;
        }
        HashSet<KeyExpression> resultFields = new HashSet<KeyExpression>(planContext.query.getRequiredResults().size());
        for (KeyExpression resultField : planContext.query.getRequiredResults()) {
            resultFields.addAll(resultField.normalizeKeyForPositions());
        }
        RecordQueryPlan withoutFetch = RecordQueryPlannerSubstitutionVisitor.removeIndexFetch(this.metaData, this.indexTypes, planContext.commonPrimaryKey, chosenPlan = chosenPlan.accept(new UnorderedPrimaryKeyDistinctVisitor(this.metaData, this.indexTypes, planContext.commonPrimaryKey)), resultFields);
        return withoutFetch == null ? chosenPlan : withoutFetch;
    }

    @Nullable
    public RecordQueryCoveringIndexPlan planCoveringAggregateIndex(@Nonnull RecordQuery query, @Nonnull String indexName) {
        Index index = this.metaData.getIndex(indexName);
        KeyExpression indexExpr = index.getRootExpression();
        if (indexExpr instanceof GroupingKeyExpression) {
            String permutedSizeOption;
            indexExpr = ((GroupingKeyExpression)indexExpr).getGroupingSubKey();
            if (("permuted_max".equals(index.getType()) || "permuted_min".equals(index.getType())) && (permutedSizeOption = index.getOption("permutedSize")) != null) {
                int permutedSize = Integer.parseInt(permutedSizeOption);
                indexExpr = Key.Expressions.concat(indexExpr.getSubKey(0, indexExpr.getColumnSize() - permutedSize), ((GroupingKeyExpression)index.getRootExpression()).getGroupedSubKey(), indexExpr.getSubKey(indexExpr.getColumnSize() - permutedSize, indexExpr.getColumnSize()));
            }
        } else {
            indexExpr = EmptyKeyExpression.EMPTY;
        }
        return this.planCoveringAggregateIndex(query, index, indexExpr);
    }

    @Nullable
    public RecordQueryCoveringIndexPlan planCoveringAggregateIndex(@Nonnull RecordQuery query, @Nonnull Index index, @Nonnull KeyExpression indexExpr) {
        Collection<RecordType> recordTypes = this.metaData.recordTypesForIndex(index);
        if (recordTypes.size() != 1) {
            return null;
        }
        RecordType recordType = recordTypes.iterator().next();
        PlanContext planContext = this.getPlanContext(query);
        planContext.rankComparisons = new RankComparisons(query.getFilter(), planContext.indexes);
        planContext.allowDuplicates = true;
        CandidateScan candidateScan = new CandidateScan(planContext, index, query.isSortReverse());
        ScoredPlan scoredPlan = this.matchToPlan(candidateScan, this.matchCandidateScan(candidateScan, indexExpr, BooleanNormalizer.forConfiguration(this.configuration).normalizeIfPossible(query.getFilter()), query.getSort()));
        if (scoredPlan == null || !scoredPlan.unsatisfiedFilters.isEmpty() || !(scoredPlan.getPlan() instanceof RecordQueryIndexPlan)) {
            return null;
        }
        IndexKeyValueToPartialRecord.Builder builder = IndexKeyValueToPartialRecord.newBuilder(recordType);
        List<KeyExpression> keyFields = indexExpr.normalizeKeyForPositions();
        List<KeyExpression> valueFields = Collections.emptyList();
        for (KeyExpression resultField : query.getRequiredResults()) {
            if (RecordQueryPlanner.addCoveringField(resultField, builder, keyFields, valueFields)) continue;
            return null;
        }
        builder.addRequiredMessageFields();
        if (!builder.isValid(true)) {
            return null;
        }
        RecordQueryIndexPlan plan = (RecordQueryIndexPlan)scoredPlan.getPlan();
        IndexScanComparisons scanParameters = new IndexScanComparisons(IndexScanType.BY_GROUP, plan.getScanComparisons());
        plan = new RecordQueryIndexPlan(plan.getIndexName(), scanParameters, plan.isReverse());
        return new RecordQueryCoveringIndexPlan(plan, recordType.getName(), AvailableFields.NO_FIELDS, builder.build());
    }

    private static boolean addCoveringField(@Nonnull KeyExpression requiredExpr, @Nonnull IndexKeyValueToPartialRecord.Builder builder, @Nonnull List<KeyExpression> keyFields, @Nonnull List<KeyExpression> valueFields) {
        int index;
        IndexKeyValueToPartialRecord.TupleSource source;
        int i = RecordQueryPlanner.keyFieldPosition(requiredExpr, keyFields);
        if (i >= 0) {
            source = IndexKeyValueToPartialRecord.TupleSource.KEY;
            index = i;
        } else {
            i = valueFields.indexOf(requiredExpr);
            if (i >= 0) {
                source = IndexKeyValueToPartialRecord.TupleSource.VALUE;
                index = i;
            } else {
                return false;
            }
        }
        return AvailableFields.addCoveringField(requiredExpr, AvailableFields.FieldData.ofUnconditional(source, ImmutableIntArray.of(index)), builder);
    }

    private static int keyFieldPosition(@Nonnull KeyExpression requiredExpr, @Nonnull List<KeyExpression> keyFields) {
        int position = 0;
        for (KeyExpression keyField : keyFields) {
            if (keyField.equals(requiredExpr)) {
                return position;
            }
            position += keyField.getColumnSize();
        }
        return -1;
    }

    private static class PlanContext {
        @Nonnull
        final RecordQuery query;
        @Nonnull
        final List<Index> indexes;
        @Nullable
        final KeyExpression commonPrimaryKey;
        RankComparisons rankComparisons;
        boolean allowDuplicates;

        public PlanContext(@Nonnull RecordQuery query, @Nonnull List<Index> indexes, @Nullable KeyExpression commonPrimaryKey) {
            this.query = query;
            this.indexes = indexes;
            this.commonPrimaryKey = commonPrimaryKey;
        }
    }

    protected static class CandidateScan {
        @Nonnull
        final PlanContext planContext;
        @Nullable
        final Index index;
        final boolean reverse;

        public CandidateScan(@Nonnull PlanContext planContext, @Nullable Index index, boolean reverse) {
            this.planContext = planContext;
            this.index = index;
            this.reverse = reverse;
        }

        @Nonnull
        public PlanContext getPlanContext() {
            return this.planContext;
        }

        @Nullable
        public Index getIndex() {
            return this.index;
        }

        public boolean isReverse() {
            return this.reverse;
        }
    }

    protected static class ScoredPlan
    extends ScoredInfo<RecordQueryPlan, ScoredPlan> {
        public ScoredPlan(int score, @Nonnull RecordQueryPlan plan) {
            this(score, plan, Collections.emptyList());
        }

        public ScoredPlan(int score, @Nonnull RecordQueryPlan plan, @Nonnull List<QueryComponent> unsatisfiedFilters) {
            this(score, plan, unsatisfiedFilters, false, false);
        }

        public ScoredPlan(int score, @Nonnull RecordQueryPlan plan, @Nonnull List<QueryComponent> unsatisfiedFilters, boolean createsDuplicates, boolean isStrictlySorted) {
            this(plan, unsatisfiedFilters, Collections.emptyList(), Collections.emptySet(), score, createsDuplicates, isStrictlySorted, false, (Set<RankComparisons.RankComparison>)null);
        }

        public ScoredPlan(@Nonnull RecordQueryPlan plan, @Nonnull List<QueryComponent> unsatisfiedFilters, @Nonnull List<QueryComponent> indexFilters, @Nonnull Set<Comparisons.Comparison> sargedComparisons, int score, boolean createsDuplicates, boolean isStrictlySorted, boolean flowsAllRequiredFields, @Nullable Set<RankComparisons.RankComparison> includedRankComparisons) {
            super(plan, unsatisfiedFilters, indexFilters, sargedComparisons, score, createsDuplicates, isStrictlySorted, flowsAllRequiredFields, includedRankComparisons);
        }

        @Override
        protected ScoredPlan getThis() {
            return this;
        }

        @Nonnull
        public RecordQueryPlan getPlan() {
            return (RecordQueryPlan)this.info;
        }

        @Override
        protected ScoredPlan with(@Nonnull RecordQueryPlan plan, @Nonnull List<QueryComponent> unsatisfiedFilters, @Nonnull List<QueryComponent> indexFilters, @Nonnull Set<Comparisons.Comparison> sargedComparisons, int score, boolean createsDuplicates, boolean isStrictlySorted, boolean flowsAllRequiredFields, @Nullable Set<RankComparisons.RankComparison> includedRankComparisons) {
            return new ScoredPlan(plan, unsatisfiedFilters, indexFilters, sargedComparisons, score, createsDuplicates, isStrictlySorted, flowsAllRequiredFields, includedRankComparisons);
        }
    }

    private static final class PlanWithInExtractor {
        @Nonnull
        private final ScoredPlan plan;
        @Nonnull
        private final InExtractor inExtractor;

        PlanWithInExtractor(@Nonnull ScoredPlan plan, @Nonnull InExtractor inExtractor) {
            this.plan = plan;
            this.inExtractor = inExtractor;
        }
    }

    protected static class ScoredMatch
    extends ScoredInfo<ComparisonRanges, ScoredMatch> {
        public ScoredMatch(int score, @Nonnull ComparisonRanges comparisonRanges) {
            this(score, comparisonRanges, Collections.emptyList());
        }

        public ScoredMatch(int score, @Nonnull ComparisonRanges comparisonRanges, @Nonnull List<QueryComponent> unsatisfiedFilters) {
            this(score, comparisonRanges, unsatisfiedFilters, false, false);
        }

        public ScoredMatch(int score, @Nonnull ComparisonRanges comparisonRanges, @Nonnull List<QueryComponent> unsatisfiedFilters, boolean createsDuplicates, boolean isStrictlySorted) {
            this(comparisonRanges, unsatisfiedFilters, Collections.emptyList(), Collections.emptySet(), score, createsDuplicates, isStrictlySorted, false, (Set<RankComparisons.RankComparison>)null);
        }

        public ScoredMatch(@Nonnull ComparisonRanges comparisonRanges, @Nonnull List<QueryComponent> unsatisfiedFilters, @Nonnull List<QueryComponent> indexFilters, @Nonnull Set<Comparisons.Comparison> sargedComparisons, int score, boolean createsDuplicates, boolean isStrictlySorted, boolean flowsAllRequiredFields, @Nullable Set<RankComparisons.RankComparison> includedRankComparisons) {
            super(comparisonRanges, unsatisfiedFilters, indexFilters, sargedComparisons, score, createsDuplicates, isStrictlySorted, flowsAllRequiredFields, includedRankComparisons);
        }

        @Override
        protected ScoredMatch getThis() {
            return this;
        }

        @Nonnull
        public ComparisonRanges getComparisonRanges() {
            return (ComparisonRanges)this.info;
        }

        @Override
        protected ScoredMatch with(@Nonnull ComparisonRanges comparisonRanges, @Nonnull List<QueryComponent> unsatisfiedFilters, @Nonnull List<QueryComponent> indexFilters, @Nonnull Set<Comparisons.Comparison> sargedComparisons, int score, boolean createsDuplicates, boolean isStrictlySorted, boolean flowsAllRequiredFields, @Nullable Set<RankComparisons.RankComparison> includedRankComparisons) {
            return new ScoredMatch(comparisonRanges, unsatisfiedFilters, indexFilters, sargedComparisons, score, createsDuplicates, isStrictlySorted, flowsAllRequiredFields, includedRankComparisons);
        }

        @Nonnull
        public ScoredPlan asScoredPlan(@Nonnull RecordQueryPlan recordQueryPlan) {
            return new ScoredPlan(recordQueryPlan, (List<QueryComponent>)this.unsatisfiedFilters, (List<QueryComponent>)this.indexFilters, (Set<Comparisons.Comparison>)this.sargedComparisons, this.score, this.createsDuplicates, this.isStrictlySorted, this.flowsAllRequiredFields, (Set<RankComparisons.RankComparison>)this.includedRankComparisons);
        }
    }

    protected static abstract class ScoredInfo<T, S extends ScoredInfo<T, S>> {
        final int score;
        @Nonnull
        final T info;
        @Nonnull
        final List<QueryComponent> unsatisfiedFilters;
        @Nonnull
        final List<QueryComponent> indexFilters;
        @Nonnull
        final Set<Comparisons.Comparison> sargedComparisons;
        @Nonnull
        private final Supplier<Set<String>> sargedInBindingsSupplier;
        final boolean createsDuplicates;
        final boolean isStrictlySorted;
        final boolean flowsAllRequiredFields;
        @Nullable
        final Set<RankComparisons.RankComparison> includedRankComparisons;
        @Nullable
        PlanOrderingKey planOrderingKey;

        public ScoredInfo(@Nonnull T info, @Nonnull List<QueryComponent> unsatisfiedFilters, @Nonnull List<QueryComponent> indexFilters, @Nonnull Set<Comparisons.Comparison> sargedComparisons, int score, boolean createsDuplicates, boolean isStrictlySorted, boolean flowsAllRequiredFields, @Nullable Set<RankComparisons.RankComparison> includedRankComparisons) {
            this.score = score;
            this.info = info;
            this.unsatisfiedFilters = unsatisfiedFilters;
            this.indexFilters = indexFilters;
            this.sargedComparisons = sargedComparisons;
            this.sargedInBindingsSupplier = Suppliers.memoize(this::computeSargedInBindings);
            this.flowsAllRequiredFields = flowsAllRequiredFields;
            this.createsDuplicates = createsDuplicates;
            this.includedRankComparisons = includedRankComparisons;
            this.isStrictlySorted = isStrictlySorted;
        }

        public int getNumResiduals() {
            return this.unsatisfiedFilters.size();
        }

        public int getNumIndexFilters() {
            return this.indexFilters.size();
        }

        public int getNumNonSargables() {
            return this.getNumResiduals() + this.indexFilters.size();
        }

        public List<QueryComponent> combineNonSargables() {
            return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.unsatisfiedFilters)).addAll(this.indexFilters)).build();
        }

        protected abstract S getThis();

        protected abstract S with(@Nonnull T var1, @Nonnull List<QueryComponent> var2, @Nonnull List<QueryComponent> var3, @Nonnull Set<Comparisons.Comparison> var4, int var5, boolean var6, boolean var7, boolean var8, @Nullable Set<RankComparisons.RankComparison> var9);

        @Nonnull
        public S withInfo(@Nonnull T newInfo) {
            return this.with(newInfo, this.unsatisfiedFilters, this.indexFilters, this.sargedComparisons, this.score, this.createsDuplicates, this.isStrictlySorted, this.flowsAllRequiredFields, this.includedRankComparisons);
        }

        @Nonnull
        public S withScore(int newScore) {
            if (newScore == this.score) {
                return this.getThis();
            }
            return this.with(this.info, this.unsatisfiedFilters, this.indexFilters, this.sargedComparisons, newScore, this.createsDuplicates, this.isStrictlySorted, this.flowsAllRequiredFields, this.includedRankComparisons);
        }

        public Set<String> getSargedInBindings() {
            return this.sargedInBindingsSupplier.get();
        }

        private Set<String> computeSargedInBindings() {
            return this.sargedComparisons.stream().filter(comparison -> comparison.getType() == Comparisons.Type.EQUALS && comparison instanceof Comparisons.ParameterComparison).map(comparison -> (Comparisons.ParameterComparison)comparison).filter(parameterComparison -> Bindings.Internal.IN.isOfType(parameterComparison.getParameter())).map(Comparisons.ParameterComparisonBase::getParameter).collect(ImmutableSet.toImmutableSet());
        }

        @Nonnull
        public S withUnsatisfiedFilters(@Nonnull List<QueryComponent> newFilters) {
            return this.with(this.info, newFilters, this.indexFilters, this.sargedComparisons, this.score, this.createsDuplicates, this.isStrictlySorted, this.flowsAllRequiredFields, this.includedRankComparisons);
        }

        @Nonnull
        public S withIndexFilters(@Nonnull List<QueryComponent> newIndexFilters) {
            return this.with(this.info, this.unsatisfiedFilters, newIndexFilters, this.sargedComparisons, this.score, this.createsDuplicates, this.isStrictlySorted, this.flowsAllRequiredFields, this.includedRankComparisons);
        }

        @Nonnull
        public S withAdditionalIndexFilters(@Nonnull List<QueryComponent> additionalIndexFilters) {
            ArrayList<QueryComponent> newIndexFilters = Lists.newArrayList();
            newIndexFilters.addAll(this.indexFilters);
            newIndexFilters.addAll(additionalIndexFilters);
            return this.with(this.info, this.unsatisfiedFilters, newIndexFilters, this.sargedComparisons, this.score, this.createsDuplicates, this.isStrictlySorted, this.flowsAllRequiredFields, this.includedRankComparisons);
        }

        @Nonnull
        public S withResidualFilterAndSargedComparisons(@Nonnull List<QueryComponent> newUnsatisfiedFilters, @Nonnull Set<Comparisons.Comparison> sargedComparisons, boolean flowsAllRequiredFields) {
            return this.withFiltersAndSargedComparisons(newUnsatisfiedFilters, Collections.emptyList(), sargedComparisons, flowsAllRequiredFields);
        }

        @Nonnull
        public S withFiltersAndSargedComparisons(@Nonnull List<QueryComponent> newUnsatisfiedFilters, @Nonnull List<QueryComponent> newIndexFilters, @Nonnull Set<Comparisons.Comparison> sargedComparisons, boolean flowsAllRequiredFields) {
            return this.with(this.info, newUnsatisfiedFilters, newIndexFilters, sargedComparisons, this.score, this.createsDuplicates, this.isStrictlySorted, flowsAllRequiredFields, this.includedRankComparisons);
        }

        public S withSargedComparisons(@Nonnull Set<Comparisons.Comparison> sargedComparisons) {
            return this.with(this.info, this.unsatisfiedFilters, this.indexFilters, sargedComparisons, this.score, this.createsDuplicates, this.isStrictlySorted, this.flowsAllRequiredFields, this.includedRankComparisons);
        }

        @Nonnull
        public S withCreatesDuplicates(boolean newCreatesDuplicates) {
            if (this.createsDuplicates == newCreatesDuplicates) {
                return this.getThis();
            }
            return this.with(this.info, this.unsatisfiedFilters, this.indexFilters, this.sargedComparisons, this.score, newCreatesDuplicates, this.isStrictlySorted, this.flowsAllRequiredFields, this.includedRankComparisons);
        }
    }

    private class MultidimensionalAndWithThenPlanner
    extends AbstractAndWithThenPlanner {
        @Nonnull
        private final ComparisonRanges comparisons;

        @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="maybe https://github.com/spotbugs/spotbugs/issues/616?")
        private MultidimensionalAndWithThenPlanner(@Nullable CandidateScan candidateScan, @Nonnull ThenKeyExpression indexExpr, @Nonnull List<KeyExpression> indexChildren, @Nullable List<QueryComponent> filters, KeyExpression sort) {
            super(candidateScan, indexExpr, indexChildren, filters, sort);
            this.comparisons = new ComparisonRanges();
        }

        @Override
        @Nullable
        public ScoredMatch plan() {
            this.setupPlanState();
            if (!this.unsatisfiedSorts.isEmpty()) {
                return null;
            }
            boolean matchedNonEqualities = false;
            boolean strictlySorted = true;
            int childColumns = 0;
            for (KeyExpression child : this.indexChildren) {
                int childColumnSize = child.getColumnSize();
                this.planChild(child);
                int uncommittedComparisonRangesSize = this.comparisons.uncommittedComparisonRangesSize();
                if (uncommittedComparisonRangesSize < childColumnSize) {
                    this.comparisons.addEmptyRanges(childColumnSize - uncommittedComparisonRangesSize);
                }
                if (!this.comparisons.isEqualities() || !this.foundCompleteComparison) {
                    matchedNonEqualities = true;
                }
                if (matchedNonEqualities && strictlySorted && (this.candidateScan.index == null || !this.candidateScan.index.isUnique() || childColumns < this.candidateScan.index.getColumnSize())) {
                    strictlySorted = false;
                }
                childColumns += childColumnSize;
                this.comparisons.commitAndAdvance();
            }
            if (this.comparisons.isEmpty()) {
                return null;
            }
            boolean createsDuplicates = false;
            if (this.candidateScan.index != null) {
                if (!this.candidateScan.planContext.allowDuplicates) {
                    createsDuplicates = this.candidateScan.index.getRootExpression().createsDuplicates();
                }
                if (createsDuplicates && this.indexExpr != null && this.indexExpr.createsDuplicatesAfter(this.comparisons.size())) {
                    return null;
                }
            }
            return new ScoredMatch(this.comparisons.totalSize(), this.comparisons, this.unsatisfiedFilters, createsDuplicates, strictlySorted);
        }

        @Override
        protected void setupPlanState() {
            super.setupPlanState();
            this.comparisons.clear();
        }

        @Override
        protected int getEqualitySize() {
            return this.comparisons.getEqualitiesSize();
        }

        @Override
        protected boolean planNestedFieldOrComponentChild(@Nonnull KeyExpression child, @Nonnull QueryComponent filterChild, @Nonnull Function<KeyExpression, ScoredMatch> maybeSortedMatch) {
            ScoredMatch scoredMatch = maybeSortedMatch.apply(null);
            if (scoredMatch != null) {
                ComparisonRanges nextComparisonRanges = scoredMatch.getComparisonRanges();
                if (!this.comparisons.isUncommitedComparisonRangesEqualities() && nextComparisonRanges.getEqualitiesSize() > 0) {
                    throw new Query.InvalidExpressionException("Two nested fields in the same and clause, combine them into one");
                }
                Objects.requireNonNull(nextComparisonRanges);
                this.unsatisfiedFilters.remove(filterChild);
                this.unsatisfiedFilters.addAll(scoredMatch.unsatisfiedFilters);
                this.comparisons.addAll(nextComparisonRanges);
                if (nextComparisonRanges.isEqualities()) {
                    this.foundComparison = true;
                    this.foundCompleteComparison = nextComparisonRanges.getEqualitiesSize() == child.getColumnSize();
                }
                return true;
            }
            return false;
        }

        @Override
        protected boolean addToComparisons(@Nonnull Comparisons.Comparison comparison) {
            switch (ScanComparisons.getComparisonType(comparison)) {
                case EQUALITY: {
                    this.comparisons.addEqualityComparison(comparison);
                    this.foundComparison = true;
                    return true;
                }
                case INEQUALITY: {
                    this.comparisons.addInequalityComparison(comparison);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected void addedComparison(@Nonnull KeyExpression child, @Nonnull QueryComponent filterChild) {
            this.unsatisfiedFilters.remove(filterChild);
            if (this.foundComparison) {
                this.foundCompleteComparison = true;
            }
        }
    }

    private class AndWithThenPlanner
    extends AbstractAndWithThenPlanner {
        @Nonnull
        private final ScanComparisons.Builder comparisons;

        @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="maybe https://github.com/spotbugs/spotbugs/issues/616?")
        public AndWithThenPlanner(@Nonnull CandidateScan candidateScan, @Nonnull ThenKeyExpression indexExpr, @Nullable AndComponent filter, KeyExpression sort) {
            this(candidateScan, indexExpr, filter.getChildren(), sort);
        }

        @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="maybe https://github.com/spotbugs/spotbugs/issues/616?")
        public AndWithThenPlanner(@Nonnull CandidateScan candidateScan, @Nonnull ThenKeyExpression indexExpr, @Nullable List<QueryComponent> filters, KeyExpression sort) {
            this(candidateScan, indexExpr, indexExpr.getChildren(), filters, sort);
        }

        @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE", "NP_NONNULL_PARAM_VIOLATION"}, justification="maybe https://github.com/spotbugs/spotbugs/issues/616?")
        public AndWithThenPlanner(@Nonnull CandidateScan candidateScan, @Nonnull List<KeyExpression> indexChildren, @Nullable AndComponent filter, KeyExpression sort) {
            this(candidateScan, null, indexChildren, filter.getChildren(), sort);
        }

        @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="maybe https://github.com/spotbugs/spotbugs/issues/616?")
        private AndWithThenPlanner(@Nullable CandidateScan candidateScan, @Nonnull ThenKeyExpression indexExpr, @Nonnull List<KeyExpression> indexChildren, @Nullable List<QueryComponent> filters, KeyExpression sort) {
            super(candidateScan, indexExpr, indexChildren, filters, sort);
            this.comparisons = new ScanComparisons.Builder();
        }

        @Override
        @Nullable
        public ScoredMatch plan() {
            this.setupPlanState();
            boolean doneComparing = false;
            boolean strictlySorted = true;
            int childColumns = 0;
            for (KeyExpression child : this.indexChildren) {
                if (!doneComparing) {
                    this.planChild(child);
                    if (!this.comparisons.isEquality() || !this.foundCompleteComparison) {
                        doneComparing = true;
                    }
                }
                if (doneComparing) {
                    if (this.unsatisfiedSorts.isEmpty()) {
                        if (this.candidateScan.index != null && this.candidateScan.index.isUnique() && childColumns >= this.candidateScan.index.getColumnSize()) break;
                        strictlySorted = false;
                        break;
                    }
                    if (!this.nextSortSatisfied(child, childColumns)) break;
                }
                childColumns += child.getColumnSize();
            }
            if (!this.unsatisfiedSorts.isEmpty()) {
                return null;
            }
            if (this.comparisons.isEmpty()) {
                return null;
            }
            boolean createsDuplicates = false;
            if (this.candidateScan.index != null) {
                if (!this.candidateScan.planContext.allowDuplicates) {
                    createsDuplicates = this.candidateScan.index.getRootExpression().createsDuplicates();
                }
                if (createsDuplicates && this.indexExpr != null && this.indexExpr.createsDuplicatesAfter(this.comparisons.size())) {
                    return null;
                }
            }
            ComparisonRanges comparisonRanges = ComparisonRanges.from(this.comparisons.build());
            return new ScoredMatch(this.comparisons.totalSize(), comparisonRanges, this.unsatisfiedFilters, createsDuplicates, strictlySorted);
        }

        @Override
        protected void setupPlanState() {
            super.setupPlanState();
            this.comparisons.clear();
        }

        @Override
        protected int getEqualitySize() {
            return this.comparisons.getEqualitySize();
        }

        @Override
        protected boolean planNestedFieldOrComponentChild(@Nonnull KeyExpression child, @Nonnull QueryComponent filterChild, @Nonnull Function<KeyExpression, ScoredMatch> maybeSortedMatch) {
            ScoredMatch scoredMatch = maybeSortedMatch.apply(null);
            if (scoredMatch != null) {
                ScanComparisons nextComparisons = scoredMatch.getComparisonRanges().toScanComparisons();
                if (!this.comparisons.isEquality() && nextComparisons.getEqualitySize() > 0) {
                    throw new Query.InvalidExpressionException("Two nested fields in the same and clause, combine them into one");
                }
                if (!this.unsatisfiedSorts.isEmpty() && !nextComparisons.isEquality()) {
                    scoredMatch = maybeSortedMatch.apply((KeyExpression)this.unsatisfiedSorts.get(0));
                    ScanComparisons scanComparisons = nextComparisons = scoredMatch == null ? null : scoredMatch.getComparisonRanges().toScanComparisons();
                }
                if (scoredMatch != null) {
                    this.unsatisfiedFilters.remove(filterChild);
                    this.unsatisfiedFilters.addAll(scoredMatch.unsatisfiedFilters);
                    this.comparisons.addAll(nextComparisons);
                    if (nextComparisons.isEquality()) {
                        this.foundComparison = true;
                        this.foundCompleteComparison = nextComparisons.getEqualitySize() == child.getColumnSize();
                        this.satisfyEqualitySort(child);
                    }
                    return true;
                }
            }
            return false;
        }

        private void satisfyEqualitySort(@Nonnull KeyExpression child) {
            while (this.unsatisfiedSorts.remove(child)) {
            }
        }

        private boolean nextSortSatisfied(@Nonnull KeyExpression child, int childColumns) {
            if (this.unsatisfiedSorts.isEmpty()) {
                return false;
            }
            if (child.equals(this.unsatisfiedSorts.get(0))) {
                this.unsatisfiedSorts.remove(0);
                return true;
            }
            int childSize = child.getColumnSize();
            if (childSize > 1) {
                List<KeyExpression> flattenedChildren = child.normalizeKeyForPositions();
                int childEqualityOffset = this.comparisons.getEqualitySize() - childColumns;
                int remainingChildren = flattenedChildren.size() - childEqualityOffset;
                if (remainingChildren > 0) {
                    for (int i = 0; i < remainingChildren; ++i) {
                        if (!flattenedChildren.get(childEqualityOffset + i).equals(this.unsatisfiedSorts.get(0))) {
                            return false;
                        }
                        this.unsatisfiedSorts.remove(0);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        protected boolean addToComparisons(@Nonnull Comparisons.Comparison comparison) {
            switch (ScanComparisons.getComparisonType(comparison)) {
                case EQUALITY: {
                    if (!this.comparisons.isEquality()) break;
                    this.comparisons.addEqualityComparison(comparison);
                    this.foundComparison = true;
                    return true;
                }
                case INEQUALITY: {
                    this.comparisons.addInequalityComparison(comparison);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected void addedComparison(@Nonnull KeyExpression child, @Nonnull QueryComponent filterChild) {
            this.unsatisfiedFilters.remove(filterChild);
            if (this.foundComparison) {
                this.foundCompleteComparison = true;
                this.satisfyEqualitySort(child);
            }
        }
    }

    private abstract class AbstractAndWithThenPlanner {
        @Nullable
        protected final ThenKeyExpression indexExpr;
        @Nonnull
        protected final List<KeyExpression> indexChildren;
        @Nonnull
        protected final List<QueryComponent> filters;
        @Nullable
        protected final KeyExpression sort;
        @Nonnull
        protected final CandidateScan candidateScan;
        @Nonnull
        protected final List<QueryComponent> unsatisfiedFilters;
        @Nonnull
        protected final List<KeyExpression> unsatisfiedSorts;
        protected boolean foundComparison;
        protected boolean foundCompleteComparison;

        @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="maybe https://github.com/spotbugs/spotbugs/issues/616?")
        protected AbstractAndWithThenPlanner(@Nullable CandidateScan candidateScan, @Nonnull ThenKeyExpression indexExpr, @Nonnull List<KeyExpression> indexChildren, @Nullable List<QueryComponent> filters, KeyExpression sort) {
            this.indexExpr = indexExpr;
            this.indexChildren = indexChildren;
            this.filters = filters;
            this.sort = sort;
            this.candidateScan = candidateScan;
            this.unsatisfiedFilters = new ArrayList<QueryComponent>();
            this.unsatisfiedSorts = new ArrayList<KeyExpression>();
        }

        @Nullable
        public abstract ScoredMatch plan();

        protected void setupPlanState() {
            this.unsatisfiedFilters.clear();
            this.unsatisfiedFilters.addAll(this.filters);
            this.unsatisfiedSorts.clear();
            if (this.sort != null) {
                KeyExpression sortKey = this.sort;
                if (sortKey instanceof GroupingKeyExpression) {
                    sortKey = ((GroupingKeyExpression)sortKey).getWholeKey();
                }
                if (sortKey instanceof ThenKeyExpression) {
                    ThenKeyExpression sortThen = (ThenKeyExpression)sortKey;
                    this.unsatisfiedSorts.addAll(sortThen.getChildren());
                } else {
                    this.unsatisfiedSorts.add(sortKey);
                }
            }
        }

        protected void planChild(@Nonnull KeyExpression child) {
            NestingKeyExpression nestingKey;
            FieldKeyExpression parent;
            this.foundComparison = false;
            this.foundCompleteComparison = false;
            if (child instanceof RecordTypeKeyExpression) {
                if (this.candidateScan.planContext.query.getRecordTypes().size() == 1) {
                    RecordTypeKeyComparison recordTypeKeyComparison = new RecordTypeKeyComparison(this.candidateScan.planContext.query.getRecordTypes().iterator().next());
                    this.addToComparisons(recordTypeKeyComparison.getComparison());
                    this.foundCompleteComparison = true;
                }
                return;
            }
            if (child instanceof NestingKeyExpression && this.filters.size() > 1 && child.getColumnSize() > 1 && (parent = (nestingKey = (NestingKeyExpression)child).getParent()).getFanType() == KeyExpression.FanType.None) {
                ArrayList<NestedField> nestedFilters = new ArrayList<NestedField>();
                ArrayList<QueryComponent> nestedChildren = new ArrayList<QueryComponent>();
                for (QueryComponent filterChild : this.filters) {
                    if (!(filterChild instanceof NestedField)) continue;
                    NestedField nestedField = (NestedField)filterChild;
                    if (!parent.getFieldName().equals(nestedField.getFieldName())) continue;
                    nestedFilters.add(nestedField);
                    nestedChildren.add(nestedField.getChild());
                }
                if (nestedFilters.size() > 1) {
                    NestedField nestedAnd = new NestedField(parent.getFieldName(), Query.and(nestedChildren));
                    ArrayList<QueryComponent> saveUnsatisfiedFilters = new ArrayList<QueryComponent>(this.unsatisfiedFilters);
                    this.unsatisfiedFilters.removeAll(nestedFilters);
                    this.unsatisfiedFilters.add(nestedAnd);
                    if (this.planNestedFieldChild(child, nestedAnd, nestedAnd)) {
                        return;
                    }
                    this.unsatisfiedFilters.clear();
                    this.unsatisfiedFilters.addAll(saveUnsatisfiedFilters);
                }
            }
            for (QueryComponent filterChild : this.filters) {
                QueryComponent filterComponent = this.candidateScan.planContext.rankComparisons.planComparisonSubstitute(filterChild);
                if (filterComponent instanceof FieldWithComparison) {
                    this.planWithComparisonChild(child, (FieldWithComparison)filterComponent, filterChild);
                } else if (filterComponent instanceof NestedField) {
                    this.planNestedFieldChild(child, (NestedField)filterComponent, filterChild);
                } else if (filterComponent instanceof OneOfThemWithComponent) {
                    this.planOneOfThemWithComponentChild(child, (OneOfThemWithComponent)filterComponent, filterChild);
                } else if (filterComponent instanceof OneOfThemWithComparison) {
                    this.planOneOfThemWithComparisonChild(child, (OneOfThemWithComparison)filterComponent, filterChild);
                } else if (filterComponent instanceof QueryRecordFunctionWithComparison && "version".equals(((QueryRecordFunctionWithComparison)filterComponent).getFunction().getName())) {
                    this.planWithVersionComparisonChild(child, (QueryRecordFunctionWithComparison)filterComponent, filterChild);
                } else if (filterComponent instanceof QueryKeyExpressionWithComparison) {
                    this.planWithComparisonChild(child, (QueryKeyExpressionWithComparison)filterComponent, filterChild);
                } else if (filterComponent instanceof QueryKeyExpressionWithOneOfComparison) {
                    this.planOneOfThemWithComparisonChild(child, (QueryKeyExpressionWithOneOfComparison)filterComponent, filterChild);
                }
                if (!this.foundComparison) continue;
                break;
            }
        }

        private boolean planNestedFieldChild(@Nonnull KeyExpression child, @Nonnull NestedField filterField, @Nonnull QueryComponent filterChild) {
            return this.planNestedFieldOrComponentChild(child, filterChild, maybeSort -> RecordQueryPlanner.this.planNestedField(this.candidateScan, child, filterField, (KeyExpression)maybeSort));
        }

        private boolean planOneOfThemWithComponentChild(@Nonnull KeyExpression child, @Nonnull OneOfThemWithComponent oneOfThemWithComponent, @Nonnull QueryComponent filterChild) {
            return this.planNestedFieldOrComponentChild(child, filterChild, maybeSort -> RecordQueryPlanner.this.planOneOfThemWithComponent(this.candidateScan, child, oneOfThemWithComponent, (KeyExpression)maybeSort));
        }

        protected abstract boolean planNestedFieldOrComponentChild(@Nonnull KeyExpression var1, @Nonnull QueryComponent var2, @Nonnull Function<KeyExpression, ScoredMatch> var3);

        protected abstract int getEqualitySize();

        private void planWithComparisonChild(@Nonnull KeyExpression child, @Nonnull FieldWithComparison field, @Nonnull QueryComponent filterChild) {
            OrderFunctionKeyExpression indexOrderedField;
            if (child instanceof FieldKeyExpression) {
                FieldKeyExpression indexField = (FieldKeyExpression)child;
                if (Objects.equals(field.getFieldName(), indexField.getFieldName()) && this.addToComparisons(field.getComparison())) {
                    this.addedComparison(child, filterChild);
                }
            } else if (child instanceof OrderFunctionKeyExpression && (indexOrderedField = (OrderFunctionKeyExpression)child).getArguments() instanceof FieldKeyExpression) {
                OrderQueryKeyExpression orderedExpression;
                Pair<Comparisons.Comparison, Comparisons.Comparison> adjustedComparisons;
                FieldKeyExpression indexField = (FieldKeyExpression)indexOrderedField.getArguments();
                if (Objects.equals(field.getFieldName(), indexField.getFieldName()) && (adjustedComparisons = (orderedExpression = new OrderQueryKeyExpression(indexOrderedField)).adjustComparison(field.getComparison())) != null && this.addToComparisons(adjustedComparisons.getLeft())) {
                    if (adjustedComparisons.getRight() != null) {
                        this.addToComparisons(adjustedComparisons.getRight());
                    }
                    this.addedComparison(child, filterChild);
                }
            }
        }

        private void planWithComparisonChild(@Nonnull KeyExpression child, @Nonnull QueryKeyExpressionWithComparison queryKeyExpression, @Nonnull QueryComponent filterChild) {
            if (child.equals(queryKeyExpression.getKeyExpression()) && this.addToComparisons(queryKeyExpression.getComparison())) {
                this.addedComparison(child, filterChild);
            }
        }

        private void planOneOfThemWithComparisonChild(@Nonnull KeyExpression child, @Nonnull OneOfThemWithComparison oneOfThem, @Nonnull QueryComponent filterChild) {
            if (child instanceof FieldKeyExpression) {
                FieldKeyExpression indexField = (FieldKeyExpression)child;
                if (Objects.equals(oneOfThem.getFieldName(), indexField.getFieldName()) && indexField.getFanType() == KeyExpression.FanType.FanOut && this.addToComparisons(oneOfThem.getComparison())) {
                    this.addedComparison(child, filterChild);
                }
            }
        }

        private void planOneOfThemWithComparisonChild(@Nonnull KeyExpression child, @Nonnull QueryKeyExpressionWithOneOfComparison queryKeyExpression, @Nonnull QueryComponent filterChild) {
            if (child.equals(queryKeyExpression.getKeyExpression()) && this.addToComparisons(queryKeyExpression.getComparison())) {
                this.addedComparison(child, filterChild);
            }
        }

        private void planWithVersionComparisonChild(@Nonnull KeyExpression child, @Nonnull QueryRecordFunctionWithComparison filter, @Nonnull QueryComponent filterChild) {
            if (child instanceof VersionKeyExpression && this.addToComparisons(filter.getComparison())) {
                this.addedComparison(child, filterChild);
            }
        }

        protected abstract boolean addToComparisons(@Nonnull Comparisons.Comparison var1);

        protected abstract void addedComparison(@Nonnull KeyExpression var1, @Nonnull QueryComponent var2);
    }
}

