/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexFetchMethod;
import com.apple.foundationdb.record.RecordPlannerConfigurationProto;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.PlannerRule;
import com.apple.foundationdb.record.query.plan.cascades.PlanningRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.RewritingRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.serialization.PlanSerialization;
import com.apple.foundationdb.record.query.plan.sorting.RecordQueryPlannerSortConfiguration;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public class RecordQueryPlannerConfiguration {
    @Nonnull
    private static final BiMap<QueryPlanner.IndexScanPreference, RecordPlannerConfigurationProto.PlannerConfiguration.IndexScanPreference> SCAN_PREFERENCE_BI_MAP = PlanSerialization.protoEnumBiMap(QueryPlanner.IndexScanPreference.class, RecordPlannerConfigurationProto.PlannerConfiguration.IndexScanPreference.class);
    @Nonnull
    private static final BiMap<IndexFetchMethod, RecordPlannerConfigurationProto.PlannerConfiguration.IndexFetchMethod> FETCH_METHOD_BI_MAP = PlanSerialization.protoEnumBiMap(IndexFetchMethod.class, RecordPlannerConfigurationProto.PlannerConfiguration.IndexFetchMethod.class);
    @Nonnull
    private static final RecordQueryPlannerConfiguration DEFAULT_PLANNER_CONFIGURATION = RecordQueryPlannerConfiguration.builder().build();
    private static final long ATTEMPT_FAILED_IN_JOIN_AS_OR_MASK = 1L;
    private static final long CHECK_FOR_DUPLICATE_CONDITIONS_MASK = 2L;
    private static final long DEFER_FETCH_AFTER_UNION_AND_INTERSECTION_MASK = 4L;
    private static final long DEFER_FETCH_AFTER_IN_JOIN_AND_IN_UNION_MASK = 8L;
    private static final long OMIT_PRIMARY_KEY_IN_UNION_ORDERING_KEY_MASK = 16L;
    private static final long OPTIMIZE_FOR_INDEX_FILTERS_MASK = 32L;
    private static final long OPTIMIZE_FOR_REQUIRED_RESULTS_MASK = 64L;
    private static final long DONT_USE_FULL_KEY_FOR_VALUE_INDEX_MASK = 128L;
    private static final long DONT_DEFER_CROSS_PRODUCTS_MASK = 256L;
    private static final long PLAN_OTHER_ATTEMPT_FULL_FILTER_MASK = 512L;
    private static final long NORMALIZE_NESTED_FIELDS_MASK = 1024L;
    private static final long OMIT_PRIMARY_KEY_IN_ORDERING_KEY_FOR_IN_UNION_MASK = 2048L;
    @Nonnull
    private final RecordPlannerConfigurationProto.PlannerConfiguration proto;
    @Nonnull
    private final QueryPlanner.IndexScanPreference indexScanPreference;
    @Nonnull
    private final IndexFetchMethod indexFetchMethod;
    @Nonnull
    private final Set<String> disabledTransformationRules;
    @Nonnull
    private final Set<String> valueIndexesOverScanNeeded;
    @Nullable
    private final RecordQueryPlannerSortConfiguration sortConfiguration;

    private RecordQueryPlannerConfiguration(@Nonnull RecordPlannerConfigurationProto.PlannerConfiguration proto, @Nullable RecordQueryPlannerSortConfiguration sortConfiguration) {
        this.proto = proto;
        this.indexScanPreference = (QueryPlanner.IndexScanPreference)((Object)SCAN_PREFERENCE_BI_MAP.inverse().get(proto.getIndexScanPreference()));
        this.indexFetchMethod = (IndexFetchMethod)((Object)FETCH_METHOD_BI_MAP.inverse().get(proto.getIndexFetchMethod()));
        this.disabledTransformationRules = ImmutableSet.copyOf(proto.getDisabledTransformationRulesList());
        this.valueIndexesOverScanNeeded = ImmutableSet.copyOf(proto.getValueIndexesOverScanNeededList());
        this.sortConfiguration = sortConfiguration;
    }

    private boolean flagSet(long mask) {
        return (this.proto.getFlags() & mask) != 0L;
    }

    @Nonnull
    public QueryPlanner.IndexScanPreference getIndexScanPreference() {
        return this.indexScanPreference;
    }

    public boolean shouldAttemptFailedInJoinAsOr() {
        return this.flagSet(1L);
    }

    public boolean shouldAttemptFailedInJoinAsUnion() {
        return this.getAttemptFailedInJoinAsUnionMaxSize() > 0;
    }

    public int getAttemptFailedInJoinAsUnionMaxSize() {
        return this.proto.getAttemptFailedInJoinAsUnionMaxSize();
    }

    public int getComplexityThreshold() {
        return this.proto.hasComplexityThreshold() ? this.proto.getComplexityThreshold() : 3000;
    }

    public boolean shouldCheckForDuplicateConditions() {
        return this.flagSet(2L);
    }

    public boolean shouldDeferFetchAfterUnionAndIntersection() {
        return this.flagSet(4L);
    }

    public boolean shouldDeferFetchAfterInJoinAndInUnion() {
        return this.flagSet(8L);
    }

    public boolean shouldOmitPrimaryKeyInUnionOrderingKey() {
        return this.flagSet(16L);
    }

    public boolean shouldOmitPrimaryKeyInOrderingKeyForInUnion() {
        return this.flagSet(2048L);
    }

    public boolean shouldOptimizeForIndexFilters() {
        return this.flagSet(32L);
    }

    public boolean shouldOptimizeForRequiredResults() {
        return this.flagSet(64L);
    }

    public int getMaxTaskQueueSize() {
        return this.proto.getMaxTaskQueueSize();
    }

    public int getMaxTotalTaskCount() {
        return this.proto.getMaxTotalTaskCount();
    }

    public boolean shouldUseFullKeyForValueIndex() {
        return !this.flagSet(128L);
    }

    public int getMaxNumMatchesPerRuleCall() {
        return this.proto.getMaxNumMatchesPerRuleCall();
    }

    @Nullable
    public RecordQueryPlannerSortConfiguration getSortConfiguration() {
        return this.sortConfiguration;
    }

    public boolean isRuleEnabled(@Nonnull PlannerRule<?, ?> rule) {
        return !this.disabledTransformationRules.contains(rule.getClass().getSimpleName());
    }

    @Nonnull
    public Set<String> getDisabledTransformationRules() {
        return this.disabledTransformationRules;
    }

    public boolean shouldDeferCrossProducts() {
        return !this.flagSet(256L);
    }

    @Nonnull
    public IndexFetchMethod getIndexFetchMethod() {
        return this.indexFetchMethod;
    }

    public boolean valueIndexOverScanNeeded(@Nonnull String indexName) {
        return this.valueIndexesOverScanNeeded.contains(indexName);
    }

    public boolean shouldPlanOtherAttemptWholeFilter() {
        return this.flagSet(512L);
    }

    public int getMaxNumReplansForInToJoin() {
        return this.proto.getMaxNumReplansForInToJoin();
    }

    public int getMaxNumReplansForInUnion() {
        return this.proto.hasMaxNumReplansForInUnion() ? this.proto.getMaxNumReplansForInUnion() : -1;
    }

    public int getOrToUnionMaxNumConjuncts() {
        return this.proto.hasOrToUnionMaxNumConjuncts() ? this.proto.getOrToUnionMaxNumConjuncts() : 9;
    }

    public boolean shouldNormalizeNestedFields() {
        return this.flagSet(1024L);
    }

    @Nonnull
    public RecordPlannerConfigurationProto.PlannerConfiguration toProto() {
        return this.proto;
    }

    @Nonnull
    public Builder asBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static RecordQueryPlannerConfiguration defaultPlannerConfiguration() {
        return DEFAULT_PLANNER_CONFIGURATION;
    }

    @Nonnull
    public static RecordQueryPlannerConfiguration fromProto(@Nonnull RecordPlannerConfigurationProto.PlannerConfiguration proto) {
        RecordQueryPlannerSortConfiguration sortConfiguration = proto.hasSortConfiguration() ? RecordQueryPlannerSortConfiguration.fromProto(proto.getSortConfiguration()) : null;
        return new RecordQueryPlannerConfiguration(proto, sortConfiguration);
    }

    public static class Builder {
        @Nonnull
        private final RecordPlannerConfigurationProto.PlannerConfiguration.Builder protoBuilder;
        @Nullable
        private RecordQueryPlannerSortConfiguration sortConfiguration;
        private long flags;

        public Builder(@Nonnull RecordQueryPlannerConfiguration configuration) {
            this.protoBuilder = configuration.toProto().toBuilder();
            this.sortConfiguration = configuration.sortConfiguration;
            this.flags = this.protoBuilder.getFlags();
        }

        public Builder() {
            this.protoBuilder = RecordPlannerConfigurationProto.PlannerConfiguration.newBuilder();
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setIndexScanPreference(@Nonnull QueryPlanner.IndexScanPreference indexScanPreference) {
            this.protoBuilder.setIndexScanPreference((RecordPlannerConfigurationProto.PlannerConfiguration.IndexScanPreference)SCAN_PREFERENCE_BI_MAP.get((Object)indexScanPreference));
            return this;
        }

        private void updateFlags(boolean value, long mask) {
            this.flags = value ? this.flags | mask : this.flags & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setAttemptFailedInJoinAsOr(boolean attemptFailedInJoinAsOr) {
            this.updateFlags(attemptFailedInJoinAsOr, 1L);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setAttemptFailedInJoinAsUnionMaxSize(int attemptFailedInJoinAsUnionMaxSize) {
            this.protoBuilder.setAttemptFailedInJoinAsUnionMaxSize(attemptFailedInJoinAsUnionMaxSize);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setComplexityThreshold(int complexityThreshold) {
            this.protoBuilder.setComplexityThreshold(complexityThreshold);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setCheckForDuplicateConditions(boolean checkForDuplicateConditions) {
            this.updateFlags(checkForDuplicateConditions, 2L);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setDeferFetchAfterUnionAndIntersection(boolean deferFetchAfterUnionAndIntersection) {
            this.updateFlags(deferFetchAfterUnionAndIntersection, 4L);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setDeferFetchAfterInJoinAndInUnion(boolean deferFetchAfterInJoinAndInUnion) {
            this.updateFlags(deferFetchAfterInJoinAndInUnion, 8L);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setOmitPrimaryKeyInUnionOrderingKey(boolean omitPrimaryKeyInUnionOrderingKey) {
            this.updateFlags(omitPrimaryKeyInUnionOrderingKey, 16L);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setOmitPrimaryKeyInOrderingKeyForInUnion(boolean omitPrimaryKeyInOrderingKeyForInUnion) {
            this.updateFlags(omitPrimaryKeyInOrderingKeyForInUnion, 2048L);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setOptimizeForIndexFilters(boolean optimizeForIndexFilters) {
            this.updateFlags(optimizeForIndexFilters, 32L);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setOptimizeForRequiredResults(boolean optimizeForRequiredResults) {
            this.updateFlags(optimizeForRequiredResults, 64L);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setMaxTaskQueueSize(int maxTaskQueueSize) {
            this.protoBuilder.setMaxTaskQueueSize(maxTaskQueueSize);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setMaxTotalTaskCount(int maxTotalTaskCount) {
            this.protoBuilder.setMaxTotalTaskCount(maxTotalTaskCount);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setUseFullKeyForValueIndex(boolean useFullKeyForValueIndex) {
            this.updateFlags(!useFullKeyForValueIndex, 128L);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setMaxNumMatchesPerRuleCall(int maxNumMatchesPerRuleCall) {
            this.protoBuilder.setMaxNumMatchesPerRuleCall(maxNumMatchesPerRuleCall);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setSortConfiguration(@Nullable RecordQueryPlannerSortConfiguration sortConfiguration) {
            if (sortConfiguration == null) {
                this.protoBuilder.clearSortConfiguration();
            } else {
                this.protoBuilder.setSortConfiguration(sortConfiguration.toProto());
            }
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setAllowNonIndexSort(boolean allowNonIndexSort) {
            this.setSortConfiguration(allowNonIndexSort ? RecordQueryPlannerSortConfiguration.getDefaultInstance() : null);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setDisabledTransformationRules(@Nonnull Set<Class<? extends CascadesRule<?>>> disabledTransformationRules) {
            this.protoBuilder.clearDisabledTransformationRules();
            for (Class<CascadesRule<?>> rule : disabledTransformationRules) {
                this.protoBuilder.addDisabledTransformationRules(rule.getSimpleName());
            }
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setDisabledTransformationRuleNames(@Nonnull Set<String> disabledTransformationRuleNames, @Nonnull PlanningRuleSet planningRuleSet) {
            this.protoBuilder.clearDisabledTransformationRules().addAllDisabledTransformationRules(disabledTransformationRuleNames);
            return this;
        }

        @Nonnull
        @API(value=API.Status.EXPERIMENTAL)
        @CanIgnoreReturnValue
        public Builder disableRewritingRules() {
            for (CascadesRule<? extends RelationalExpression> rule : RewritingRuleSet.OPTIONAL_RULES) {
                this.disableTransformationRule(rule.getClass());
            }
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder disableTransformationRule(@Nonnull Class<? extends CascadesRule<?>> ruleClass) {
            this.protoBuilder.addDisabledTransformationRules(ruleClass.getSimpleName());
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setDeferCrossProducts(boolean deferCrossProducts) {
            this.updateFlags(!deferCrossProducts, 256L);
            return this;
        }

        @Nonnull
        @API(value=API.Status.EXPERIMENTAL)
        @CanIgnoreReturnValue
        public Builder setIndexFetchMethod(@Nonnull IndexFetchMethod indexFetchMethod) {
            this.protoBuilder.setIndexFetchMethod((RecordPlannerConfigurationProto.PlannerConfiguration.IndexFetchMethod)FETCH_METHOD_BI_MAP.get((Object)indexFetchMethod));
            return this;
        }

        @Nonnull
        @API(value=API.Status.EXPERIMENTAL)
        @CanIgnoreReturnValue
        public Builder addValueIndexOverScanNeeded(@Nonnull String indexName) {
            this.protoBuilder.addValueIndexesOverScanNeeded(indexName);
            return this;
        }

        @Nonnull
        @API(value=API.Status.EXPERIMENTAL)
        @CanIgnoreReturnValue
        public Builder setPlanOtherAttemptWholeFilter(boolean planOtherAttemptWholeFilter) {
            this.updateFlags(planOtherAttemptWholeFilter, 512L);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setMaxNumReplansForInToJoin(int maxNumReplansForInToJoin) {
            this.protoBuilder.setMaxNumReplansForInToJoin(maxNumReplansForInToJoin);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setMaxNumReplansForInUnion(int maxNumReplansForInUnion) {
            this.protoBuilder.setMaxNumReplansForInUnion(maxNumReplansForInUnion);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setOrToUnionMaxNumConjuncts(int orToUnionMaxNumConjuncts) {
            this.protoBuilder.setOrToUnionMaxNumConjuncts(orToUnionMaxNumConjuncts);
            return this;
        }

        @Nonnull
        @CanIgnoreReturnValue
        public Builder setNormalizeNestedFields(boolean normalizeNestedFields) {
            this.updateFlags(normalizeNestedFields, 1024L);
            return this;
        }

        public RecordQueryPlannerConfiguration build() {
            if (this.protoBuilder.getFlags() != this.flags) {
                this.protoBuilder.setFlags(this.flags);
            }
            return new RecordQueryPlannerConfiguration(this.protoBuilder.build(), this.sortConfiguration);
        }
    }
}

