/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EndpointType;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.planprotos.PScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordVersion;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.BindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.CollectionMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.Extractor;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PlannerBindings;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.PrimitiveMatchers;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.structure.TypedMatcherWithExtractAndDownstream;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.protobuf.ByteString;
import com.google.protobuf.Internal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class ScanComparisons
implements PlanHashable,
Correlated<ScanComparisons>,
PlanSerializable {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Scan-Comparisons");
    @Nonnull
    protected final List<Comparisons.Comparison> equalityComparisons;
    @Nonnull
    protected final Set<Comparisons.Comparison> inequalityComparisons;
    public static final ScanComparisons EMPTY = new ScanComparisons(Collections.emptyList(), Collections.emptySet());

    public ScanComparisons(@Nonnull List<Comparisons.Comparison> equalityComparisons, @Nonnull Set<Comparisons.Comparison> inequalityComparisons) {
        ScanComparisons.checkComparisonTypes(equalityComparisons, ComparisonType.EQUALITY);
        ScanComparisons.checkComparisonTypes(inequalityComparisons, ComparisonType.INEQUALITY);
        this.equalityComparisons = equalityComparisons;
        this.inequalityComparisons = inequalityComparisons;
    }

    private static void checkComparisonTypes(@Nonnull Iterable<Comparisons.Comparison> comparisons, @Nonnull ComparisonType comparisonType) {
        for (Comparisons.Comparison comparison : comparisons) {
            if (ScanComparisons.getComparisonType(comparison) == comparisonType) continue;
            throw new RecordCoreException("wrong comparison type for " + String.valueOf(comparison) + ", required " + String.valueOf((Object)comparisonType), new Object[0]);
        }
    }

    @Nonnull
    public List<Comparisons.Comparison> getEqualityComparisons() {
        return this.equalityComparisons;
    }

    @Nonnull
    public Set<Comparisons.Comparison> getInequalityComparisons() {
        return this.inequalityComparisons;
    }

    public int getEqualitySize() {
        return this.equalityComparisons.size();
    }

    public int size() {
        int result = this.equalityComparisons.size();
        if (!this.inequalityComparisons.isEmpty()) {
            ++result;
        }
        return result;
    }

    public int totalSize() {
        return this.equalityComparisons.size() + this.inequalityComparisons.size();
    }

    public boolean isEmpty() {
        return this.equalityComparisons.isEmpty() && this.inequalityComparisons.isEmpty();
    }

    public boolean isEquality() {
        return this.inequalityComparisons.isEmpty();
    }

    @Nonnull
    public static ComparisonType getComparisonType(@Nonnull Comparisons.Comparison comparison) {
        switch (comparison.getType()) {
            case EQUALS: 
            case IS_NULL: {
                return ComparisonType.EQUALITY;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUALS: 
            case STARTS_WITH: 
            case NOT_NULL: 
            case SORT: {
                return ComparisonType.INEQUALITY;
            }
        }
        return ComparisonType.NONE;
    }

    @Nullable
    public static ScanComparisons from(@Nonnull Comparisons.Comparison comparison) {
        switch (ScanComparisons.getComparisonType(comparison)) {
            case EQUALITY: {
                return new ScanComparisons(Collections.singletonList(comparison), Collections.emptySet());
            }
            case INEQUALITY: {
                return new ScanComparisons(Collections.emptyList(), Collections.singleton(comparison));
            }
        }
        return null;
    }

    @Nullable
    public ScanComparisons merge(@Nonnull ScanComparisons other) {
        if (this.equalityComparisons.equals(other.equalityComparisons)) {
            HashSet<Comparisons.Comparison> comparisons = new HashSet<Comparisons.Comparison>(this.inequalityComparisons);
            comparisons.addAll(other.inequalityComparisons);
            return new ScanComparisons(this.equalityComparisons, comparisons);
        }
        return null;
    }

    @Nullable
    public ScanComparisons append(@Nonnull ScanComparisons other) {
        if (this.isEquality()) {
            if (other.equalityComparisons.isEmpty()) {
                return new ScanComparisons(this.equalityComparisons, other.inequalityComparisons);
            }
            ArrayList<Comparisons.Comparison> comparisons = new ArrayList<Comparisons.Comparison>(this.equalityComparisons);
            comparisons.addAll(other.equalityComparisons);
            return new ScanComparisons(comparisons, other.inequalityComparisons);
        }
        return null;
    }

    @Nonnull
    public TupleRange toTupleRange() {
        return this.toTupleRange(null, null);
    }

    @Nonnull
    public TupleRange toTupleRange(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
        Comparisons.Comparison inequalityComparison;
        if (this.isEmpty()) {
            return TupleRange.ALL;
        }
        ArrayList<Object> items = new ArrayList<Object>(this.equalityComparisons.size());
        for (Comparisons.Comparison comparison : this.equalityComparisons) {
            ScanComparisons.addComparandToList(items, comparison, store, context);
        }
        Tuple baseTuple = Tuple.fromList(items);
        if (this.inequalityComparisons.isEmpty()) {
            return TupleRange.allOf(baseTuple);
        }
        if (this.inequalityComparisons.size() == 1 && (inequalityComparison = this.inequalityComparisons.iterator().next()).getType() == Comparisons.Type.STARTS_WITH) {
            Tuple startTuple = baseTuple.addObject(ScanComparisons.toTupleItem(inequalityComparison.getComparand(store, context)));
            return new TupleRange(startTuple, startTuple, EndpointType.PREFIX_STRING, EndpointType.PREFIX_STRING);
        }
        InequalityRangeCombiner rangeCombiner = new InequalityRangeCombiner(store, context, baseTuple, this.inequalityComparisons);
        return rangeCombiner.toTupleRange();
    }

    @Nullable
    public TupleRange toTupleRangeWithoutContext() {
        try {
            return this.toTupleRange();
        }
        catch (Comparisons.EvaluationContextRequiredException ex) {
            return null;
        }
    }

    protected static void addComparandToList(@Nonnull List<Object> items, @Nonnull Comparisons.Comparison comparison, @Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context) {
        if (comparison.hasMultiColumnComparand()) {
            items.addAll(((Tuple)comparison.getComparand(store, context)).getItems());
        } else {
            items.add(ScanComparisons.toTupleItem(comparison.getComparand(store, context)));
        }
    }

    public static Object toTupleItem(@Nullable Object item) {
        if (item instanceof ByteString) {
            return ((ByteString)item).toByteArray();
        }
        if (item instanceof Internal.EnumLite) {
            return ((Internal.EnumLite)item).getNumber();
        }
        if (item instanceof FDBRecordVersion) {
            return ((FDBRecordVersion)item).toVersionstamp();
        }
        return item;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        this.equalityComparisons.forEach(comparison -> resultBuilder.addAll(comparison.getCorrelatedTo()));
        this.inequalityComparisons.forEach(comparison -> resultBuilder.addAll(comparison.getCorrelatedTo()));
        return resultBuilder.build();
    }

    @Override
    @Nonnull
    public ScanComparisons rebase(@Nonnull AliasMap translationMap) {
        return this.translateCorrelations(TranslationMap.rebaseWithAliasMap(translationMap), false);
    }

    @Override
    public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ScanComparisons that = (ScanComparisons)other;
        if (this.equalityComparisons.size() != that.equalityComparisons.size()) {
            return false;
        }
        if (this.inequalityComparisons.size() != that.inequalityComparisons.size()) {
            return false;
        }
        return Streams.zip(this.equalityComparisons.stream(), that.equalityComparisons.stream(), (a, b) -> a.semanticEquals(b, aliasMap)).allMatch(e -> e) && this.inequalityComparisons.stream().allMatch(thisComparison -> that.inequalityComparisons.stream().anyMatch(thatComparison -> thisComparison.semanticEquals(thatComparison, aliasMap)));
    }

    @Override
    public int semanticHashCode() {
        int equalityComparisonsHash = this.equalityComparisons.stream().map(Comparisons.Comparison::semanticHashCode).collect(ImmutableList.toImmutableList()).hashCode();
        int inequalityComparisonsHash = this.inequalityComparisons.stream().map(Comparisons.Comparison::semanticHashCode).collect(ImmutableSet.toImmutableSet()).hashCode();
        return Objects.hash(equalityComparisonsHash, inequalityComparisonsHash);
    }

    @Nonnull
    public ScanComparisons translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        boolean needsCopy = false;
        ImmutableList.Builder translatedEqualityComparisonsBuilder = ImmutableList.builder();
        for (Comparisons.Comparison comparison : this.equalityComparisons) {
            Comparisons.Comparison translatedComparison = comparison.translateCorrelations(translationMap, shouldSimplifyValues);
            translatedEqualityComparisonsBuilder.add(translatedComparison);
            if (translatedComparison == comparison) continue;
            needsCopy = true;
        }
        ImmutableSet.Builder translatedInequalityComparisonsBuilder = ImmutableSet.builder();
        for (Comparisons.Comparison comparison : this.inequalityComparisons) {
            Comparisons.Comparison translatedComparison = comparison.translateCorrelations(translationMap, shouldSimplifyValues);
            translatedInequalityComparisonsBuilder.add(translatedComparison);
            if (translatedComparison == comparison) continue;
            needsCopy = true;
        }
        if (needsCopy) {
            return this.withComparisons((List<Comparisons.Comparison>)((Object)translatedEqualityComparisonsBuilder.build()), (Set<Comparisons.Comparison>)((Object)translatedInequalityComparisonsBuilder.build()));
        }
        return this;
    }

    @Nonnull
    protected ScanComparisons withComparisons(@Nonnull List<Comparisons.Comparison> equalityComparisons, @Nonnull Set<Comparisons.Comparison> inequalityComparisons) {
        return new ScanComparisons(equalityComparisons, inequalityComparisons);
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object o) {
        return this.semanticEquals(o, AliasMap.emptyMap());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.planHash(mode, this.equalityComparisons) + PlanHashable.planHashUnordered(mode, this.inequalityComparisons);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.equalityComparisons, PlanHashable.planHashUnordered(mode, this.inequalityComparisons));
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Nonnull
    public ExplainTokensWithPrecedence explain() {
        ImmutableList.Builder explainTokensListBuilder = ImmutableList.builder();
        this.equalityComparisons.stream().map(Comparisons.Comparison::explain).map(ExplainTokensWithPrecedence::getExplainTokens).forEach(explainTokensListBuilder::add);
        if (!this.inequalityComparisons.isEmpty()) {
            ArrayList<Comparisons.Comparison> inequalityComparisonLists = Lists.newArrayList(this.inequalityComparisons);
            inequalityComparisonLists.sort(Comparator.comparing(Object::toString));
            explainTokensListBuilder.add(new ExplainTokens().addOpeningSquareBracket().addOptionalWhitespace().addSequence(() -> new ExplainTokens().addWhitespace().addToString("&&").addWhitespace(), () -> inequalityComparisonLists.stream().map(Comparisons.Comparison::explain).map(ExplainTokensWithPrecedence::getExplainTokens).iterator()).addOptionalWhitespace().addClosingSquareBracket());
        }
        return ExplainTokensWithPrecedence.of(new ExplainTokens().addOpeningSquareBracket().addOptionalWhitespace().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), explainTokensListBuilder.build()).addOptionalWhitespace().addClosingSquareBracket());
    }

    @Nonnull
    public String toString() {
        return this.explain().getExplainTokens().render(DefaultExplainFormatter.forDebugging()).toString();
    }

    @Override
    @Nonnull
    public PScanComparisons toProto(@Nonnull PlanSerializationContext serializationContext) {
        PScanComparisons.Builder builder = PScanComparisons.newBuilder();
        for (Comparisons.Comparison equalityComparison : this.equalityComparisons) {
            builder.addEqualityComparisons(equalityComparison.toComparisonProto(serializationContext));
        }
        for (Comparisons.Comparison inequalityComparison : this.inequalityComparisons) {
            builder.addInequalityComparisons(inequalityComparison.toComparisonProto(serializationContext));
        }
        return builder.build();
    }

    @Nonnull
    public static ScanComparisons fromProto(@Nonnull PlanSerializationContext serializationContext, @Nonnull PScanComparisons scanComparisonsProto) {
        ImmutableList.Builder equalityComparisonsBuilder = ImmutableList.builder();
        for (int i = 0; i < scanComparisonsProto.getEqualityComparisonsCount(); ++i) {
            equalityComparisonsBuilder.add(Comparisons.Comparison.fromComparisonProto(serializationContext, scanComparisonsProto.getEqualityComparisons(i)));
        }
        ImmutableSet.Builder inequalityComparisonsBuilder = ImmutableSet.builder();
        for (int i = 0; i < scanComparisonsProto.getInequalityComparisonsCount(); ++i) {
            inequalityComparisonsBuilder.add(Comparisons.Comparison.fromComparisonProto(serializationContext, scanComparisonsProto.getInequalityComparisons(i)));
        }
        return new ScanComparisons((List<Comparisons.Comparison>)((Object)equalityComparisonsBuilder.build()), (Set<Comparisons.Comparison>)((Object)inequalityComparisonsBuilder.build()));
    }

    @Nonnull
    public static BindingMatcher<ScanComparisons> range(@Nonnull String tupleString) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ScanComparisons.class, Extractor.of(scanComparisons -> {
            try {
                return scanComparisons.toTupleRange().toString();
            }
            catch (Comparisons.EvaluationContextRequiredException ex) {
                return scanComparisons.toString();
            }
        }, name -> "range(" + name + ")"), PrimitiveMatchers.equalsObject(tupleString));
    }

    @Nonnull
    public static BindingMatcher<ScanComparisons> unbounded() {
        return new TypedMatcher<ScanComparisons>(ScanComparisons.class){

            @Override
            @Nonnull
            public Stream<PlannerBindings> bindMatchesSafely(@Nonnull RecordQueryPlannerConfiguration plannerConfiguration, @Nonnull PlannerBindings outerBindings, @Nonnull ScanComparisons in) {
                return super.bindMatchesSafely(plannerConfiguration, outerBindings, in).flatMap(bindings -> {
                    if (in.isEmpty()) {
                        return Stream.of(bindings);
                    }
                    return Stream.empty();
                });
            }
        };
    }

    @Nonnull
    public static BindingMatcher<ScanComparisons> equalities(@Nonnull CollectionMatcher<Comparisons.Comparison> equalityComparisonsCollectionMatcher) {
        return TypedMatcherWithExtractAndDownstream.typedWithDownstream(ScanComparisons.class, Extractor.of(ScanComparisons::getEqualityComparisons, name -> "equalities(" + name + ")"), equalityComparisonsCollectionMatcher);
    }

    @Nonnull
    public static BindingMatcher<Comparisons.SimpleComparison> anySimpleComparison() {
        return TypedMatcher.typed(Comparisons.SimpleComparison.class);
    }

    @Nonnull
    public static BindingMatcher<Comparisons.ParameterComparison> anyParameterComparison() {
        return TypedMatcher.typed(Comparisons.ParameterComparison.class);
    }

    @Nonnull
    public static BindingMatcher<Comparisons.ValueComparison> anyValueComparison() {
        return TypedMatcher.typed(Comparisons.ValueComparison.class);
    }

    public static enum ComparisonType {
        EQUALITY,
        INEQUALITY,
        NONE;

    }

    private static class InequalityRangeCombiner {
        @Nullable
        FDBRecordStoreBase<?> store;
        @Nullable
        private final EvaluationContext context;
        @Nonnull
        private final Tuple baseTuple;
        private Object lowItem = null;
        private Object highItem = null;
        private EndpointType lowEndpoint;
        private EndpointType highEndpoint;
        private EndpointComparison hasLow = EndpointComparison.NONE;
        private EndpointComparison hasHigh = EndpointComparison.NONE;

        public InequalityRangeCombiner(@Nullable FDBRecordStoreBase<?> store, @Nullable EvaluationContext context, @Nonnull Tuple baseTuple, @Nonnull Set<Comparisons.Comparison> inequalityComparisons) {
            this.store = store;
            this.context = context;
            this.baseTuple = baseTuple;
            if (baseTuple.isEmpty()) {
                this.lowEndpoint = EndpointType.TREE_START;
                this.highEndpoint = EndpointType.TREE_END;
            } else {
                this.lowEndpoint = this.highEndpoint = EndpointType.RANGE_INCLUSIVE;
            }
            for (Comparisons.Comparison comparison : inequalityComparisons) {
                this.addComparison(comparison);
            }
        }

        public void addComparison(Comparisons.Comparison comparison) {
            Object comparand = comparison.getComparand(this.store, this.context);
            if (comparand == Comparisons.COMPARISON_SKIPPED_BINDING) {
                return;
            }
            EndpointComparison endpointComparison = comparison.hasMultiColumnComparand() ? EndpointComparison.MULTIPLE : EndpointComparison.VALUE;
            switch (comparison.getType()) {
                case GREATER_THAN: {
                    if (this.lowItem != null && Comparisons.compare(this.lowItem, comparand) > 0) break;
                    this.lowItem = comparand;
                    this.lowEndpoint = EndpointType.RANGE_EXCLUSIVE;
                    this.hasLow = endpointComparison;
                    break;
                }
                case GREATER_THAN_OR_EQUALS: {
                    if (this.lowItem != null && Comparisons.compare(this.lowItem, comparand) >= 0) break;
                    this.lowItem = comparand;
                    this.lowEndpoint = EndpointType.RANGE_INCLUSIVE;
                    this.hasLow = endpointComparison;
                    break;
                }
                case NOT_NULL: {
                    if (this.lowItem != null) break;
                    this.lowEndpoint = EndpointType.RANGE_EXCLUSIVE;
                    this.hasLow = endpointComparison;
                    break;
                }
                case LESS_THAN: {
                    if (this.highItem == null || Comparisons.compare(this.highItem, comparand) >= 0) {
                        this.highItem = comparand;
                        this.highEndpoint = EndpointType.RANGE_EXCLUSIVE;
                        this.hasHigh = endpointComparison;
                    }
                    if (this.lowItem != null) break;
                    this.lowEndpoint = EndpointType.RANGE_EXCLUSIVE;
                    this.hasLow = EndpointComparison.VALUE;
                    break;
                }
                case LESS_THAN_OR_EQUALS: {
                    if (this.highItem == null || Comparisons.compare(this.highItem, comparand) > 0) {
                        this.highItem = comparand;
                        this.highEndpoint = EndpointType.RANGE_INCLUSIVE;
                        this.hasHigh = endpointComparison;
                    }
                    if (this.lowItem != null) break;
                    this.lowEndpoint = EndpointType.RANGE_EXCLUSIVE;
                    this.hasLow = EndpointComparison.VALUE;
                    break;
                }
                default: {
                    throw new RecordCoreException("Unexpected inequality comparison " + String.valueOf(comparison), new Object[0]);
                }
            }
        }

        @Nullable
        private Tuple buildEndpointTuple(EndpointComparison hasItem, Object item) {
            switch (hasItem) {
                case VALUE: {
                    return this.baseTuple.addObject(ScanComparisons.toTupleItem(item));
                }
                case MULTIPLE: {
                    return this.baseTuple.addAll((Tuple)item);
                }
            }
            if (this.baseTuple.isEmpty()) {
                return null;
            }
            return this.baseTuple;
        }

        @Nonnull
        public TupleRange toTupleRange() {
            Tuple low = this.buildEndpointTuple(this.hasLow, this.lowItem);
            Tuple high = this.buildEndpointTuple(this.hasHigh, this.highItem);
            return new TupleRange(low, high, this.lowEndpoint, this.highEndpoint);
        }

        static enum EndpointComparison {
            NONE,
            VALUE,
            MULTIPLE;

        }
    }

    public static class Builder
    extends ScanComparisons {
        public Builder() {
            super(new ArrayList<Comparisons.Comparison>(), new HashSet<Comparisons.Comparison>());
        }

        public Builder clear() {
            this.equalityComparisons.clear();
            this.inequalityComparisons.clear();
            return this;
        }

        @Nonnull
        public Builder addEqualityComparison(@Nonnull Comparisons.Comparison comparison) {
            if (!this.inequalityComparisons.isEmpty()) {
                throw new RecordCoreException("Cannot add equality comparison after inequalities", new Object[0]);
            }
            this.equalityComparisons.add(comparison);
            return this;
        }

        @Nonnull
        public Builder addInequalityComparison(@Nonnull Comparisons.Comparison comparison) {
            this.inequalityComparisons.add(comparison);
            return this;
        }

        @Nonnull
        @API(value=API.Status.EXPERIMENTAL)
        public Builder addComparisonRange(@Nonnull ComparisonRange comparisonRange) {
            if (comparisonRange.isEquality()) {
                this.addEqualityComparison(comparisonRange.getEqualityComparison());
            } else if (comparisonRange.isInequality()) {
                for (Comparisons.Comparison comparison : comparisonRange.getInequalityComparisons()) {
                    if (comparison.getType().equals((Object)Comparisons.Type.SORT)) continue;
                    this.inequalityComparisons.add(comparison);
                }
            }
            return this;
        }

        @Nonnull
        public Builder addAll(@Nonnull ScanComparisons other) {
            this.equalityComparisons.addAll(other.equalityComparisons);
            this.inequalityComparisons.addAll(other.inequalityComparisons);
            return this;
        }

        @Nonnull
        public Builder addAll(@Nonnull List<Comparisons.Comparison> newEqualityComparisons, @Nonnull Set<Comparisons.Comparison> newInequalityComparisons) {
            this.equalityComparisons.addAll(newEqualityComparisons);
            this.inequalityComparisons.addAll(newInequalityComparisons);
            return this;
        }

        @Override
        @Nonnull
        protected Builder withComparisons(@Nonnull List<Comparisons.Comparison> equalityComparisons, @Nonnull Set<Comparisons.Comparison> inequalityComparisons) {
            return new Builder().addAll(equalityComparisons, inequalityComparisons);
        }

        @Nonnull
        public ScanComparisons build() {
            return new ScanComparisons(this.equalityComparisons, this.inequalityComparisons);
        }
    }
}

