/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.common.text.TextTokenizer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.IntersectionCursor;
import com.apple.foundationdb.record.provider.foundationdb.cursors.IntersectionMultiCursor;
import com.apple.foundationdb.record.provider.foundationdb.cursors.ProbableIntersectionCursor;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnionCursor;
import com.apple.foundationdb.record.provider.foundationdb.cursors.UnorderedUnionCursor;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextIndexMaintainer;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class TextScan
implements PlanHashable {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Text-Scan");
    @Nonnull
    private static final Set<StoreTimer.Count> inCounts = ImmutableSet.of(FDBStoreTimer.Counts.QUERY_FILTER_GIVEN, FDBStoreTimer.Counts.QUERY_TEXT_FILTER_PLAN_GIVEN);
    @Nonnull
    private static final Set<StoreTimer.Event> duringEvents = Collections.singleton(FDBStoreTimer.Events.QUERY_TEXT_FILTER);
    @Nonnull
    private static final Set<StoreTimer.Count> successCounts = ImmutableSet.of(FDBStoreTimer.Counts.QUERY_FILTER_PASSED, FDBStoreTimer.Counts.QUERY_TEXT_FILTER_PLAN_PASSED);
    @Nonnull
    private static final Set<StoreTimer.Count> failureCounts = Collections.singleton(FDBStoreTimer.Counts.QUERY_DISCARDED);
    @Nonnull
    private final Index index;
    @Nullable
    private final ScanComparisons groupingComparisons;
    @Nonnull
    private final Comparisons.TextComparison textComparison;
    @Nullable
    private final ScanComparisons suffixComparisons;

    public TextScan(@Nonnull Index index, @Nullable ScanComparisons groupingComparisons, @Nonnull Comparisons.TextComparison textComparison, @Nullable ScanComparisons suffixComparisons) {
        this.index = index;
        this.groupingComparisons = groupingComparisons;
        this.textComparison = textComparison;
        this.suffixComparisons = suffixComparisons;
    }

    private List<String> getTokenList(@Nonnull FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context, boolean removeStopWords) {
        List<String> tokenList;
        Object comparand = this.textComparison.getComparand(store, context);
        if (comparand instanceof List) {
            tokenList = ((List)comparand).stream().map(Object::toString).collect(Collectors.toList());
        } else if (comparand instanceof String) {
            TextTokenizer tokenizer = TextIndexMaintainer.getTokenizer(this.index);
            int tokenizerVersion = TextIndexMaintainer.getIndexTokenizerVersion(this.index);
            tokenList = tokenizer.tokenizeToList((String)comparand, tokenizerVersion, TextTokenizer.TokenizerMode.QUERY);
        } else {
            throw new RecordCoreException("Comparand for text query of incompatible type: " + String.valueOf(comparand == null ? "null" : comparand.getClass()), new Object[0]);
        }
        if (removeStopWords && tokenList.contains("")) {
            tokenList = tokenList.stream().filter(s2 -> !s2.isEmpty()).collect(Collectors.toList());
        }
        return tokenList;
    }

    private List<String> getTokenList(@Nonnull FDBRecordStoreBase<?> store, @Nonnull EvaluationContext context) {
        return this.getTokenList(store, context, true);
    }

    @Nonnull
    private static Function<IndexEntry, List<Object>> suffixComparisonKeyFunction(int firstEntries) {
        return indexEntry -> {
            Tuple key = indexEntry.getKey();
            return TupleHelpers.subTuple(key, firstEntries, key.size()).getItems();
        };
    }

    @Nonnull
    public <M extends Message> RecordCursor<IndexEntry> scan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        Tuple prefix = this.groupingComparisons != null ? this.groupingComparisons.toTupleRange(store, context).getHigh() : null;
        TupleRange suffix = this.suffixComparisons != null ? this.suffixComparisons.toTupleRange(store, context) : null;
        List<String> tokenList = this.getTokenList(store, context);
        return this.scan(store, context, prefix, suffix, this.index, tokenList, continuation, scanProperties);
    }

    @Nonnull
    private <M extends Message> RecordCursor<IndexEntry> scan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable Tuple prefix, @Nullable TupleRange suffix, @Nonnull Index index, @Nonnull List<String> tokenList, @Nullable byte[] continuation, @Nonnull ScanProperties scanProperties) {
        Function<List, Boolean> predicate;
        if (tokenList.isEmpty()) {
            return RecordCursor.empty();
        }
        int prefixEntries = 1 + (prefix != null ? prefix.size() : 0);
        Comparisons.Type comparisonType = this.textComparison.getType();
        if (comparisonType.equals((Object)Comparisons.Type.TEXT_CONTAINS_PREFIX) || tokenList.size() == 1 && (comparisonType.equals((Object)Comparisons.Type.TEXT_CONTAINS_ALL_PREFIXES) || comparisonType.equals((Object)Comparisons.Type.TEXT_CONTAINS_ANY_PREFIX))) {
            if (tokenList.size() != 1) {
                throw new RecordCoreException("text prefix comparison included " + tokenList.size() + " comparands instead of one", new Object[0]);
            }
            return this.scanTokenPrefix(store, tokenList.get(0), prefix, suffix, index, scanProperties).apply(continuation);
        }
        if (tokenList.size() == 1) {
            return this.scanToken(store, tokenList.get(0), prefix, suffix, index, scanProperties).apply(continuation);
        }
        if (comparisonType.equals((Object)Comparisons.Type.TEXT_CONTAINS_ALL)) {
            ScanProperties childScanProperties = scanProperties.with(ExecuteProperties::clearSkipAndLimit);
            List intersectionChildren = tokenList.stream().map(token -> this.scanToken(store, (String)token, prefix, suffix, index, childScanProperties)).collect(Collectors.toList());
            return IntersectionCursor.create(TextScan.suffixComparisonKeyFunction(prefixEntries), scanProperties.isReverse(), intersectionChildren, continuation, store.getTimer()).skip(scanProperties.getExecuteProperties().getSkip()).limitRowsTo(scanProperties.getExecuteProperties().getReturnedRowLimit());
        }
        if (comparisonType.equals((Object)Comparisons.Type.TEXT_CONTAINS_ALL_PREFIXES)) {
            Comparisons.TextContainsAllPrefixesComparison allPrefixesComparison = (Comparisons.TextContainsAllPrefixesComparison)this.textComparison;
            ScanProperties childScanProperties = scanProperties.with(ExecuteProperties::clearSkipAndLimit);
            List intersectionChildren = tokenList.stream().map(token -> this.scanTokenPrefix(store, (String)token, prefix, suffix, index, childScanProperties)).collect(Collectors.toList());
            return ProbableIntersectionCursor.create(TextScan.suffixComparisonKeyFunction(prefixEntries), intersectionChildren, allPrefixesComparison.getExpectedRecords(), allPrefixesComparison.getFalsePositivePercentage(), continuation, store.getTimer()).skip(scanProperties.getExecuteProperties().getSkip()).limitRowsTo(scanProperties.getExecuteProperties().getReturnedRowLimit());
        }
        if (comparisonType.equals((Object)Comparisons.Type.TEXT_CONTAINS_ANY)) {
            ScanProperties childScanProperties = scanProperties.with(ExecuteProperties::clearSkipAndAdjustLimit);
            List unionChildren = tokenList.stream().map(token -> this.scanToken(store, (String)token, prefix, suffix, index, childScanProperties)).collect(Collectors.toList());
            return UnionCursor.create(TextScan.suffixComparisonKeyFunction(prefixEntries), scanProperties.isReverse(), unionChildren, continuation, store.getTimer()).skip(scanProperties.getExecuteProperties().getSkip()).limitRowsTo(scanProperties.getExecuteProperties().getReturnedRowLimit());
        }
        if (comparisonType.equals((Object)Comparisons.Type.TEXT_CONTAINS_ANY_PREFIX)) {
            ScanProperties childScanProperties = scanProperties.with(ExecuteProperties::clearSkipAndAdjustLimit);
            List unionChildren = tokenList.stream().map(token -> this.scanTokenPrefix(store, (String)token, prefix, suffix, index, childScanProperties)).collect(Collectors.toList());
            return UnorderedUnionCursor.create(unionChildren, continuation, store.getTimer()).skip(scanProperties.getExecuteProperties().getSkip()).limitRowsTo(scanProperties.getExecuteProperties().getReturnedRowLimit());
        }
        if (comparisonType.equals((Object)Comparisons.Type.TEXT_CONTAINS_ALL_WITHIN) && this.textComparison instanceof Comparisons.TextWithMaxDistanceComparison) {
            int maxDistance = ((Comparisons.TextWithMaxDistanceComparison)this.textComparison).getMaxDistance();
            predicate = entries -> TextScan.entriesContainAllWithin(entries, maxDistance);
        } else if (comparisonType.equals((Object)Comparisons.Type.TEXT_CONTAINS_PHRASE)) {
            List<String> tokensWithStopWords = this.getTokenList(store, context, false);
            predicate = entries -> TextScan.entriesContainPhrase(entries, tokensWithStopWords);
        } else {
            throw new RecordCoreException("unsupported comparison type for text query: " + String.valueOf((Object)comparisonType), new Object[0]);
        }
        ScanProperties childScanProperties = scanProperties.with(ExecuteProperties::clearSkipAndLimit);
        List intersectionChildren = tokenList.stream().map(token -> this.scanToken(store, (String)token, prefix, suffix, index, childScanProperties)).collect(Collectors.toList());
        IntersectionMultiCursor<IndexEntry> intersectionCursor = IntersectionMultiCursor.create(TextScan.suffixComparisonKeyFunction(prefixEntries), scanProperties.isReverse(), intersectionChildren, continuation, store.getTimer());
        return intersectionCursor.filterInstrumented(predicate, (StoreTimer)store.getTimer(), inCounts, duringEvents, successCounts, failureCounts).map(indexEntries -> (IndexEntry)indexEntries.get(0)).skip(scanProperties.getExecuteProperties().getSkip()).limitRowsTo(scanProperties.getExecuteProperties().getReturnedRowLimit());
    }

    @Nonnull
    private static List<List<Integer>> getPositionsLists(@Nonnull List<IndexEntry> entries) {
        ArrayList<List<Integer>> positionLists = new ArrayList<List<Integer>>(entries.size());
        for (IndexEntry entry : entries) {
            positionLists.add((List)entry.getValue().get(0));
        }
        return positionLists;
    }

    @Nullable
    private static Boolean entriesContainAllWithin(@Nonnull List<IndexEntry> entries, int maxDistance) {
        if (entries.isEmpty()) {
            return null;
        }
        List<List<Integer>> positionLists = TextScan.getPositionsLists(entries);
        if (positionLists.stream().anyMatch(List::isEmpty) && (positionLists = positionLists.stream().filter(list -> !list.isEmpty()).collect(Collectors.toList())).isEmpty()) {
            return Boolean.TRUE;
        }
        PriorityQueue<NonnullPair> minQueue = new PriorityQueue<NonnullPair>(positionLists.size(), Comparator.comparingInt(Pair::getLeft));
        int max = Integer.MIN_VALUE;
        for (List<Integer> positionList : positionLists) {
            Iterator<Integer> positionIterator = positionList.iterator();
            int value = positionIterator.next();
            max = Math.max(max, value);
            minQueue.add(NonnullPair.of(value, positionIterator));
        }
        while (true) {
            NonnullPair minElem;
            int min2;
            if (max - (min2 = ((Integer)(minElem = minQueue.poll()).getLeft()).intValue()) <= maxDistance) {
                return Boolean.TRUE;
            }
            Iterator minIterator = (Iterator)minElem.getRight();
            if (!minIterator.hasNext()) break;
            int nextValue = (Integer)minIterator.next();
            max = Math.max(max, nextValue);
            minQueue.add(NonnullPair.of(nextValue, minIterator));
        }
        return Boolean.FALSE;
    }

    @Nonnull
    private static List<List<Integer>> getPositionListsAndDeltas(@Nonnull List<IndexEntry> entries, @Nonnull List<String> tokensWithStopWords, @Nonnull List<Integer> deltas) {
        List<List<Integer>> positionLists = TextScan.getPositionsLists(entries);
        if (tokensWithStopWords.contains("") || positionLists.stream().anyMatch(List::isEmpty)) {
            ArrayList<List<Integer>> newPositionLists = new ArrayList<List<Integer>>(positionLists.size());
            Iterator<List<Integer>> positionListIterator = positionLists.iterator();
            int currentDelta = 1;
            for (String token : tokensWithStopWords) {
                if (token.isEmpty()) {
                    ++currentDelta;
                    continue;
                }
                List<Integer> nextPositionList = positionListIterator.next();
                if (nextPositionList.isEmpty()) {
                    ++currentDelta;
                    continue;
                }
                newPositionLists.add(nextPositionList);
                deltas.add(currentDelta);
                currentDelta = 1;
            }
            positionLists = newPositionLists;
        } else {
            for (int i = 0; i < positionLists.size(); ++i) {
                deltas.add(1);
            }
        }
        return positionLists;
    }

    @Nullable
    private static Boolean entriesContainPhrase(@Nonnull List<IndexEntry> entries, @Nonnull List<String> tokensWithStopWords) {
        if (entries.isEmpty()) {
            return null;
        }
        ArrayList<Integer> deltas = new ArrayList<Integer>(entries.size());
        List<List<Integer>> positionLists = TextScan.getPositionListsAndDeltas(entries, tokensWithStopWords, deltas);
        if (positionLists.isEmpty()) {
            return Boolean.TRUE;
        }
        ArrayList<Integer> currentValues = new ArrayList<Integer>(entries.size());
        ArrayList<Iterator<Integer>> positionIterators = new ArrayList<Iterator<Integer>>(entries.size());
        for (List<Integer> positionList : positionLists) {
            Iterator<Integer> positionIterator = positionList.iterator();
            currentValues.add(positionIterator.next());
            positionIterators.add(positionIterator);
        }
        while (true) {
            int expectedPosition = (Integer)currentValues.get(0);
            boolean allMatched = true;
            for (int i = 1; i < currentValues.size(); ++i) {
                expectedPosition += ((Integer)deltas.get(i)).intValue();
                int currentValue = (Integer)currentValues.get(i);
                Iterator positionIterator = (Iterator)positionIterators.get(i);
                while (currentValue < expectedPosition && positionIterator.hasNext()) {
                    currentValue = (Integer)positionIterator.next();
                }
                if (currentValue < expectedPosition) {
                    return Boolean.FALSE;
                }
                currentValues.set(i, currentValue);
                if (currentValue <= expectedPosition) continue;
                allMatched = false;
                break;
            }
            if (allMatched) {
                return Boolean.TRUE;
            }
            Iterator firstPositionIterator = (Iterator)positionIterators.get(0);
            if (!firstPositionIterator.hasNext()) break;
            currentValues.set(0, (Integer)firstPositionIterator.next());
        }
        return Boolean.FALSE;
    }

    @Nonnull
    private <M extends Message> Function<byte[], RecordCursor<IndexEntry>> scanTokenPrefix(@Nonnull FDBRecordStoreBase<M> store, @Nonnull String token, @Nullable Tuple prefix, @Nullable TupleRange suffix, @Nonnull Index index, @Nonnull ScanProperties scanProperties) {
        if (suffix != null) {
            throw new RecordCoreException("text prefix comparison included inequality scan comparison", new Object[0]);
        }
        return continuation -> {
            TupleRange scanRange = TupleRange.prefixedBy(token);
            if (prefix != null) {
                scanRange = scanRange.prepend(prefix);
            }
            return store.scanIndex(index, IndexScanType.BY_TEXT_TOKEN, scanRange, (byte[])continuation, scanProperties);
        };
    }

    @Nonnull
    private <M extends Message> Function<byte[], RecordCursor<IndexEntry>> scanToken(@Nonnull FDBRecordStoreBase<M> store, @Nonnull String token, @Nullable Tuple prefix, @Nullable TupleRange suffix, @Nonnull Index index, @Nonnull ScanProperties scanProperties) {
        return continuation -> {
            TupleRange scanRange = suffix != null ? suffix.prepend(Tuple.from(token)) : TupleRange.allOf(Tuple.from(token));
            if (prefix != null) {
                scanRange = scanRange.prepend(prefix);
            }
            return store.scanIndex(index, IndexScanType.BY_TEXT_TOKEN, scanRange, (byte[])continuation, scanProperties);
        };
    }

    public boolean createsDuplicates() {
        return !this.textComparison.getType().isEquality() || this.index.getRootExpression().createsDuplicates();
    }

    @Nonnull
    public Index getIndex() {
        return this.index;
    }

    @Nullable
    public ScanComparisons getGroupingComparisons() {
        return this.groupingComparisons;
    }

    @Nonnull
    public Comparisons.TextComparison getTextComparison() {
        return this.textComparison;
    }

    @Nullable
    public ScanComparisons getSuffixComparisons() {
        return this.suffixComparisons;
    }

    @Nonnull
    public String toString() {
        return "TextScan(" + this.index.getName() + " " + String.valueOf(this.groupingComparisons) + ", " + String.valueOf(this.textComparison) + ", " + String.valueOf(this.suffixComparisons) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        TextScan that = (TextScan)o;
        return this.index.equals(that.index) && Objects.equals(this.groupingComparisons, that.groupingComparisons) && this.textComparison.equals(that.textComparison) && Objects.equals(this.suffixComparisons, that.suffixComparisons);
    }

    public int hashCode() {
        return Objects.hash(this.index.getName(), this.textComparison, this.groupingComparisons, this.suffixComparisons);
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.planHash(mode, this.textComparison, this.groupingComparisons, this.suffixComparisons) + this.index.getName().hashCode();
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.index.getName(), this.textComparison, this.groupingComparisons, this.suffixComparisons);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }
}

