/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.bitmap;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordStoreState;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexAggregateFunctionCall;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexAggregateGroupKeys;
import com.apple.foundationdb.record.provider.foundationdb.IndexFunctionHelper;
import com.apple.foundationdb.record.query.IndexQueryabilityFilter;
import com.apple.foundationdb.record.query.QueryToKeyMatcher;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.AndOrComponent;
import com.apple.foundationdb.record.query.expressions.ComponentWithComparison;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.NotComponent;
import com.apple.foundationdb.record.query.expressions.OrComponent;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.expressions.QueryKeyExpressionWithComparison;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.RecordQueryPlanner;
import com.apple.foundationdb.record.query.plan.bitmap.ComposedBitmapIndexQueryPlan;
import com.apple.foundationdb.record.query.plan.planning.FilterSatisfiedMask;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ComposedBitmapIndexAggregate {
    @Nonnull
    private final Node root;

    ComposedBitmapIndexAggregate(@Nonnull Node root) {
        this.root = root;
    }

    @Nonnull
    public static Optional<RecordQueryPlan> tryPlan(@Nonnull RecordQueryPlanner planner, @Nonnull RecordQuery query, @Nonnull IndexAggregateFunctionCall indexAggregateFunctionCall, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter) {
        if (query.getFilter() == null || query.getSort() != null) {
            return Optional.empty();
        }
        return ComposedBitmapIndexAggregate.tryBuild(planner, query.getRecordTypes(), indexAggregateFunctionCall, query.getFilter(), indexQueryabilityFilter).flatMap(p -> p.tryPlan(planner, query.toBuilder()));
    }

    @Nonnull
    public Optional<RecordQueryPlan> tryPlan(@Nonnull RecordQueryPlanner planner, @Nonnull RecordQuery.Builder queryBuilder) {
        ArrayList<RecordQueryCoveringIndexPlan> indexScans = new ArrayList<RecordQueryCoveringIndexPlan>();
        IdentityHashMap<IndexNode, ComposedBitmapIndexQueryPlan.IndexComposer> indexComposers = new IdentityHashMap<IndexNode, ComposedBitmapIndexQueryPlan.IndexComposer>();
        ComposedBitmapIndexQueryPlan.ComposerBase composer = this.plan(this.root, queryBuilder, planner, indexScans, indexComposers);
        if (composer == null || indexScans.isEmpty()) {
            return Optional.empty();
        }
        if (indexScans.size() == 1) {
            if (composer instanceof ComposedBitmapIndexQueryPlan.IndexComposer) {
                return Optional.ofNullable((RecordQueryPlan)indexScans.get(0));
            }
            return Optional.empty();
        }
        return Optional.of(new ComposedBitmapIndexQueryPlan(indexScans, composer));
    }

    @Nonnull
    public static Optional<ComposedBitmapIndexAggregate> tryBuild(@Nonnull QueryPlanner planner, @Nonnull Collection<String> recordTypeNames, @Nonnull IndexAggregateFunctionCall indexAggregateFunctionCall, @Nonnull QueryComponent filter, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter) {
        ArrayList<QueryComponent> commonFilters = new ArrayList<QueryComponent>();
        ArrayList<QueryComponent> indexFilters = new ArrayList<QueryComponent>();
        if (!ComposedBitmapIndexAggregate.separateGroupFilters(filter, indexAggregateFunctionCall, commonFilters, indexFilters) || indexFilters.isEmpty()) {
            return Optional.empty();
        }
        Builder builder = new Builder(planner, recordTypeNames, commonFilters, indexAggregateFunctionCall);
        return builder.tryBuild(indexFilters.size() > 1 ? Query.and(indexFilters) : (QueryComponent)indexFilters.get(0), indexQueryabilityFilter, Collections.emptyList()).map(ComposedBitmapIndexAggregate::new);
    }

    private static boolean separateGroupFilters(@Nonnull QueryComponent filter, @Nonnull IndexAggregateFunctionCall indexAggregateFunctionCall, @Nonnull List<QueryComponent> commonFilters, @Nonnull List<QueryComponent> indexFilters) {
        QueryToKeyMatcher matcher = new QueryToKeyMatcher(filter);
        FilterSatisfiedMask filterMask = FilterSatisfiedMask.of(filter);
        QueryToKeyMatcher.Match match = matcher.matchesCoveringKey(indexAggregateFunctionCall.getGroupingKeyExpression().getGroupingSubKey(), filterMask);
        if (match.getType() != QueryToKeyMatcher.MatchType.EQUALITY) {
            return false;
        }
        matcher.matchesCoveringKey(indexAggregateFunctionCall.getGroupedExpression(), filterMask);
        if (filterMask.allSatisfied()) {
            return false;
        }
        for (FilterSatisfiedMask child : filterMask.getChildren()) {
            if (child.allSatisfied()) {
                commonFilters.add(child.getFilter());
                continue;
            }
            indexFilters.add(child.getFilter());
        }
        return true;
    }

    @Nullable
    private ComposedBitmapIndexQueryPlan.ComposerBase plan(@Nonnull Node node, @Nonnull RecordQuery.Builder queryBuilder, @Nonnull RecordQueryPlanner planner, @Nonnull List<RecordQueryCoveringIndexPlan> indexScans, @Nonnull Map<IndexNode, ComposedBitmapIndexQueryPlan.IndexComposer> indexComposers) {
        if (node instanceof OperatorNode) {
            OperatorNode operatorNode = (OperatorNode)node;
            ArrayList<ComposedBitmapIndexQueryPlan.ComposerBase> children = new ArrayList<ComposedBitmapIndexQueryPlan.ComposerBase>();
            for (Node n : operatorNode.operands) {
                ComposedBitmapIndexQueryPlan.ComposerBase plan = this.plan(n, queryBuilder, planner, indexScans, indexComposers);
                if (plan == null) {
                    return null;
                }
                children.add(plan);
            }
            switch (operatorNode.operator) {
                case AND: {
                    return new ComposedBitmapIndexQueryPlan.AndComposer(children);
                }
                case OR: {
                    return new ComposedBitmapIndexQueryPlan.OrComposer(children);
                }
                case NOT: {
                    return new ComposedBitmapIndexQueryPlan.NotComposer((ComposedBitmapIndexQueryPlan.ComposerBase)children.get(0));
                }
            }
            throw new IllegalArgumentException("Unknown operator node: " + String.valueOf(node));
        }
        if (node instanceof IndexNode) {
            return indexComposers.computeIfAbsent((IndexNode)node, indexNode -> {
                queryBuilder.setFilter(indexNode.filter);
                Index index = planner.getRecordMetaData().getIndex(indexNode.indexName);
                KeyExpression wholeKey = ((GroupingKeyExpression)index.getRootExpression()).getWholeKey();
                RecordQueryCoveringIndexPlan indexScan = planner.planCoveringAggregateIndex(queryBuilder.build(), index, wholeKey);
                if (indexScan == null) {
                    return null;
                }
                int position = indexScans.size();
                indexScans.add(indexScan);
                return new ComposedBitmapIndexQueryPlan.IndexComposer(position);
            });
        }
        throw new IllegalArgumentException("Unknown node type: " + String.valueOf(node));
    }

    static class Node {
        Node() {
        }
    }

    static class Builder {
        @Nonnull
        private final QueryPlanner planner;
        @Nonnull
        private final Collection<String> recordTypeNames;
        @Nonnull
        private final List<QueryComponent> groupFilters;
        @Nonnull
        private final IndexAggregateFunctionCall indexAggregateFunctionCall;
        @Nullable
        private Map<KeyExpression, Index> bitmapIndexes;
        @Nullable
        private Map<QueryComponent, IndexNode> indexNodes;

        Builder(@Nonnull QueryPlanner planner, @Nonnull Collection<String> recordTypeNames, @Nonnull List<QueryComponent> groupFilters, @Nonnull IndexAggregateFunctionCall indexAggregateFunctionCall) {
            this.planner = planner;
            this.recordTypeNames = recordTypeNames;
            this.groupFilters = groupFilters;
            this.indexAggregateFunctionCall = indexAggregateFunctionCall;
        }

        @Nonnull
        Optional<Node> tryBuild(@Nonnull QueryComponent indexFilter, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter, @Nonnull List<String> prefixFields) {
            if (indexFilter instanceof NestedField) {
                ArrayList<String> newPrefix = new ArrayList<String>(prefixFields.size() + 1);
                newPrefix.addAll(prefixFields);
                newPrefix.add(((NestedField)indexFilter).getFieldName());
                return this.tryBuild(((NestedField)indexFilter).getChild(), indexQueryabilityFilter, newPrefix);
            }
            if (indexFilter instanceof ComponentWithComparison) {
                return this.indexScan(indexFilter, indexQueryabilityFilter, prefixFields);
            }
            if (indexFilter instanceof AndOrComponent) {
                AndOrComponent andOrComponent = (AndOrComponent)indexFilter;
                ArrayList<Node> childNodes = new ArrayList<Node>(andOrComponent.getChildren().size());
                for (QueryComponent child : andOrComponent.getChildren()) {
                    Optional<Node> childNode2 = this.tryBuild(child, indexQueryabilityFilter, prefixFields);
                    if (!childNode2.isPresent()) {
                        return Optional.empty();
                    }
                    childNodes.add(childNode2.get());
                }
                OperatorNode.Operator operator = indexFilter instanceof OrComponent ? OperatorNode.Operator.OR : OperatorNode.Operator.AND;
                return Optional.of(new OperatorNode(operator, childNodes));
            }
            if (indexFilter instanceof NotComponent) {
                return this.tryBuild(((NotComponent)indexFilter).getChild(), indexQueryabilityFilter, prefixFields).map(childNode -> new OperatorNode(OperatorNode.Operator.NOT, Collections.singletonList(childNode)));
            }
            return Optional.empty();
        }

        @Nonnull
        Optional<Node> indexScan(@Nonnull QueryComponent indexFilter, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter, @Nonnull List<String> prefixFields) {
            ThenKeyExpression splicedKey;
            GroupingKeyExpression fullKey;
            Index index;
            int groupedCount;
            QueryComponent filterWithParents;
            IndexNode existing;
            if (this.bitmapIndexes == null) {
                this.bitmapIndexes = this.findBitmapIndexes(this.indexAggregateFunctionCall.getFunctionName(), indexQueryabilityFilter);
                if (this.bitmapIndexes.isEmpty()) {
                    return Optional.empty();
                }
                this.indexNodes = new HashMap<QueryComponent, IndexNode>();
            }
            if ((existing = this.indexNodes.get(filterWithParents = Builder.rebuildNestedComponent(indexFilter, prefixFields))) != null) {
                return Optional.of(existing);
            }
            KeyExpression indexKey = Builder.getKeyForQueryComponent(indexFilter, prefixFields);
            if (indexKey == null) {
                return Optional.empty();
            }
            GroupingKeyExpression groupKey = this.indexAggregateFunctionCall.getGroupingKeyExpression();
            int afterSpliceCount = groupedCount = groupKey.getGroupedCount();
            if (groupKey.getWholeKey() instanceof ThenKeyExpression) {
                List<KeyExpression> thenChildren = ((ThenKeyExpression)groupKey.getWholeKey()).getChildren();
                int childPosition = thenChildren.size();
                for (afterSpliceCount = 0; afterSpliceCount < groupedCount; afterSpliceCount += thenChildren.get(--childPosition).getColumnSize()) {
                }
            }
            if ((index = this.bitmapIndexes.get(fullKey = (splicedKey = this.insertKey(indexKey, groupKey, afterSpliceCount)).group(groupedCount))) == null) {
                return Optional.empty();
            }
            QueryComponent fullFilter = Builder.andFilters(this.groupFilters, filterWithParents);
            GroupingKeyExpression fullOperand = new GroupingKeyExpression(fullKey.getWholeKey(), 0);
            return IndexAggregateGroupKeys.conditionsToGroupKeys(fullOperand, fullFilter).map(groupKeys -> {
                IndexNode indexNode = new IndexNode(fullFilter, (IndexAggregateGroupKeys)groupKeys, index.getName());
                this.indexNodes.put(indexFilter, indexNode);
                return indexNode;
            });
        }

        @Nonnull
        private static QueryComponent rebuildNestedComponent(@Nonnull QueryComponent childFilter, @Nonnull List<String> prefixFields) {
            QueryComponent filter = childFilter;
            for (int nestIndex = prefixFields.size() - 1; nestIndex >= 0; --nestIndex) {
                filter = new NestedField(prefixFields.get(nestIndex), filter);
            }
            return filter;
        }

        @Nullable
        private static KeyExpression getKeyForQueryComponent(@Nonnull QueryComponent indexFilter, @Nonnull List<String> prefixFields) {
            KeyExpression key;
            if (indexFilter instanceof FieldWithComparison) {
                key = Key.Expressions.field(((FieldWithComparison)indexFilter).getFieldName());
            } else if (indexFilter instanceof QueryKeyExpressionWithComparison) {
                key = ((QueryKeyExpressionWithComparison)indexFilter).getKeyExpression();
            } else {
                return null;
            }
            for (int nestIndex = prefixFields.size() - 1; nestIndex >= 0; --nestIndex) {
                key = Key.Expressions.field(prefixFields.get(nestIndex)).nest(key);
            }
            return key;
        }

        @Nonnull
        private ThenKeyExpression insertKey(@Nonnull KeyExpression indexKey, @Nonnull GroupingKeyExpression groupKey, int position) {
            ThenKeyExpression splicedKey;
            int wholeCount = groupKey.getColumnSize();
            int groupedCount = groupKey.getGroupedCount();
            if (position == groupedCount) {
                splicedKey = Key.Expressions.concat(groupKey.getGroupingSubKey(), indexKey, groupKey.getGroupedSubKey());
            } else {
                KeyExpression wholeKey = groupKey.getWholeKey();
                int splicePoint = wholeCount - position;
                splicedKey = splicePoint == 0 ? Key.Expressions.concat(indexKey, wholeKey, new KeyExpression[0]) : Key.Expressions.concat(wholeKey.getSubKey(0, splicePoint), indexKey, wholeKey.getSubKey(splicePoint, wholeCount));
            }
            return splicedKey;
        }

        private static QueryComponent andFilters(@Nonnull List<QueryComponent> groupFilters, @Nonnull QueryComponent indexFilter) {
            QueryComponent fullFilter;
            if (groupFilters.isEmpty()) {
                fullFilter = indexFilter;
            } else {
                ArrayList<QueryComponent> allFilters = new ArrayList<QueryComponent>(groupFilters.size() + 1);
                allFilters.addAll(groupFilters);
                allFilters.add(indexFilter);
                fullFilter = Query.and(allFilters);
            }
            return fullFilter;
        }

        @Nonnull
        Map<KeyExpression, Index> findBitmapIndexes(@Nonnull String aggregateFunction, @Nonnull IndexQueryabilityFilter indexQueryabilityFilter) {
            if (!"bitmap_value".equals(aggregateFunction)) {
                return Collections.emptyMap();
            }
            String indexType = "bitmap_value";
            RecordStoreState recordStoreState = this.planner.getRecordStoreState();
            return IndexFunctionHelper.indexesForRecordTypes(this.planner.getRecordMetaData(), this.recordTypeNames).filter(index -> index.getType().equals(indexType)).filter(recordStoreState::isReadable).filter(indexQueryabilityFilter::isQueryable).collect(Collectors.toMap(Index::getRootExpression, Function.identity()));
        }
    }

    static class OperatorNode
    extends Node {
        @Nonnull
        private final Operator operator;
        @Nonnull
        private final List<Node> operands;

        OperatorNode(@Nonnull Operator operator, @Nonnull List<Node> operands) {
            this.operator = operator;
            this.operands = operands;
        }

        static enum Operator {
            AND,
            OR,
            NOT;

        }
    }

    static class IndexNode
    extends Node {
        @Nonnull
        private final QueryComponent filter;
        @Nonnull
        private final IndexAggregateGroupKeys groupKeys;
        @Nonnull
        private final String indexName;

        IndexNode(@Nonnull QueryComponent filter, @Nonnull IndexAggregateGroupKeys groupKeys, @Nonnull String indexName) {
            this.filter = filter;
            this.groupKeys = groupKeys;
            this.indexName = indexName;
        }
    }
}

