/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.bitmap;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorEndContinuation;
import com.apple.foundationdb.record.RecordCursorProto;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursorContinuation;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
class ComposedBitmapIndexContinuation
extends MergeCursorContinuation<RecordCursorProto.ComposedBitmapIndexContinuation.Builder, RecordCursorContinuation> {
    @Nonnull
    private static final RecordCursorProto.ComposedBitmapIndexContinuation.CursorState EXHAUSTED_PROTO = RecordCursorProto.ComposedBitmapIndexContinuation.CursorState.newBuilder().setExhausted(true).build();
    @Nonnull
    private static final RecordCursorProto.ComposedBitmapIndexContinuation.CursorState START_PROTO = RecordCursorProto.ComposedBitmapIndexContinuation.CursorState.newBuilder().setExhausted(false).build();

    protected ComposedBitmapIndexContinuation(@Nonnull List<RecordCursorContinuation> continuations, @Nullable Message originalProto) {
        super(continuations, originalProto);
    }

    @Override
    protected void setFirstChild(@Nonnull RecordCursorProto.ComposedBitmapIndexContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        this.addChild(builder, continuation);
    }

    @Override
    protected void setSecondChild(@Nonnull RecordCursorProto.ComposedBitmapIndexContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        this.addChild(builder, continuation);
    }

    @Override
    protected void addOtherChild(@Nonnull RecordCursorProto.ComposedBitmapIndexContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        this.addChild(builder, continuation);
    }

    private void addChild(@Nonnull RecordCursorProto.ComposedBitmapIndexContinuation.Builder builder, @Nonnull RecordCursorContinuation continuation) {
        ByteString asBytes;
        RecordCursorProto.ComposedBitmapIndexContinuation.CursorState cursorState = continuation.isEnd() ? EXHAUSTED_PROTO : ((asBytes = continuation.toByteString()).isEmpty() ? START_PROTO : RecordCursorProto.ComposedBitmapIndexContinuation.CursorState.newBuilder().setContinuation(asBytes).build());
        builder.addChildState(cursorState);
    }

    @Override
    @Nonnull
    protected RecordCursorProto.ComposedBitmapIndexContinuation.Builder newProtoBuilder() {
        return RecordCursorProto.ComposedBitmapIndexContinuation.newBuilder();
    }

    @Override
    public boolean isEnd() {
        return this.getContinuations().stream().allMatch(RecordCursorContinuation::isEnd);
    }

    public RecordCursorContinuation getContinuation(int i) {
        return (RecordCursorContinuation)this.getContinuations().get(i);
    }

    @Nonnull
    static ComposedBitmapIndexContinuation from(@Nullable byte[] bytes, int numberOfChildren) {
        if (bytes == null) {
            return new ComposedBitmapIndexContinuation(Collections.nCopies(numberOfChildren, RecordCursorStartContinuation.START), null);
        }
        try {
            return ComposedBitmapIndexContinuation.from(RecordCursorProto.ComposedBitmapIndexContinuation.parseFrom(bytes), numberOfChildren);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException("invalid continuation", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(bytes)});
        }
        catch (RecordCoreArgumentException ex) {
            throw ex.addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(bytes)});
        }
    }

    @Nonnull
    static ComposedBitmapIndexContinuation from(@Nonnull RecordCursorProto.ComposedBitmapIndexContinuation parsed, int numberOfChildren) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RecordCursorProto.ComposedBitmapIndexContinuation.CursorState state : parsed.getChildStateList()) {
            if (state.hasContinuation()) {
                builder.add(ByteArrayContinuation.fromNullable(state.getContinuation().toByteArray()));
                continue;
            }
            if (state.getExhausted()) {
                builder.add(RecordCursorEndContinuation.END);
                continue;
            }
            builder.add(RecordCursorStartContinuation.START);
        }
        ImmutableCollection children = builder.build();
        if (children.size() != numberOfChildren) {
            throw new RecordCoreArgumentException("invalid continuation (expected continuation count does not match read)", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED_CHILD_COUNT, numberOfChildren}).addLogInfo(new Object[]{LogMessageKeys.READ_CHILD_COUNT, children.size()});
        }
        return new ComposedBitmapIndexContinuation((List<RecordCursorContinuation>)((Object)children), (Message)parsed);
    }
}

