/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.bitmap;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursor;
import com.apple.foundationdb.record.provider.foundationdb.cursors.MergeCursorState;
import com.apple.foundationdb.record.query.plan.bitmap.ComposedBitmapIndexContinuation;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
class ComposedBitmapIndexCursor
extends MergeCursor<IndexEntry, IndexEntry, MergeCursorState<IndexEntry>> {
    @Nonnull
    private final Composer composer;

    protected ComposedBitmapIndexCursor(@Nonnull List<MergeCursorState<IndexEntry>> cursorStates, @Nullable FDBStoreTimer timer, @Nonnull Composer composer) {
        super(cursorStates, timer);
        this.composer = composer;
    }

    @Override
    @Nonnull
    protected CompletableFuture<List<MergeCursorState<IndexEntry>>> computeNextResultStates() {
        List cursorStates = this.getCursorStates();
        return ComposedBitmapIndexCursor.whenAll(cursorStates).thenApply(vignore -> {
            boolean anyHasNext = false;
            for (MergeCursorState cursorState : cursorStates) {
                if (cursorState.getResult().hasNext()) {
                    anyHasNext = true;
                    continue;
                }
                if (!cursorState.getResult().getNoNextReason().isLimitReached()) continue;
                return Collections.emptyList();
            }
            if (anyHasNext) {
                ArrayList<MergeCursorState> resultStates = new ArrayList<MergeCursorState>();
                long nextPosition = Long.MAX_VALUE;
                for (MergeCursorState cursorState : cursorStates) {
                    if (!cursorState.getResult().hasNext()) continue;
                    IndexEntry indexEntry = (IndexEntry)cursorState.getResult().get();
                    Tuple indexKey = indexEntry.getKey();
                    long position = indexKey.getLong(indexKey.size() - 1);
                    if (nextPosition > position) {
                        resultStates.clear();
                        nextPosition = position;
                    }
                    if (nextPosition != position) continue;
                    resultStates.add(cursorState);
                }
                return resultStates;
            }
            return Collections.emptyList();
        });
    }

    @Override
    @Nonnull
    protected IndexEntry getNextResult(@Nonnull List<MergeCursorState<IndexEntry>> resultStates) {
        List cursorStates = this.getCursorStates();
        IndexEntry firstEntry = resultStates.get(0).getResult().get();
        int size = firstEntry.getValue().getBytes(0).length;
        ArrayList<byte[]> bitmaps = new ArrayList<byte[]>(cursorStates.size());
        for (MergeCursorState cursorState : cursorStates) {
            if (resultStates.contains(cursorState)) {
                byte[] bitmap = ((IndexEntry)cursorState.getResult().get()).getValue().getBytes(0);
                if (bitmap.length != size) {
                    throw new RecordCoreException("Index bitmaps are not all the same size", new Object[0]);
                }
                bitmaps.add(bitmap);
                continue;
            }
            bitmaps.add(null);
        }
        byte[] composed = this.composer.compose(bitmaps, size);
        return new IndexEntry(firstEntry.getIndex(), firstEntry.getKey(), Tuple.fromList(Collections.singletonList(composed)));
    }

    @Override
    @Nonnull
    protected RecordCursor.NoNextReason mergeNoNextReasons() {
        return ComposedBitmapIndexCursor.getStrongestNoNextReason(this.getCursorStates());
    }

    @Override
    @Nonnull
    protected RecordCursorContinuation getContinuationObject() {
        return new ComposedBitmapIndexContinuation(this.getChildContinuations(), null);
    }

    @Nonnull
    public static ComposedBitmapIndexCursor create(@Nonnull List<Function<byte[], RecordCursor<IndexEntry>>> cursorFunctions, @Nonnull Composer composer, @Nullable byte[] byteContinuation, @Nullable FDBStoreTimer timer) {
        if (cursorFunctions.size() < 2) {
            throw new RecordCoreArgumentException("not enough child cursors provided to ComposedBitmapIndexCursor", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.CHILD_COUNT, cursorFunctions.size()});
        }
        ArrayList<MergeCursorState<IndexEntry>> cursorStates = new ArrayList<MergeCursorState<IndexEntry>>(cursorFunctions.size());
        ComposedBitmapIndexContinuation continuation = ComposedBitmapIndexContinuation.from(byteContinuation, cursorFunctions.size());
        int i = 0;
        for (Function function : cursorFunctions) {
            cursorStates.add(MergeCursorState.from(function, continuation.getContinuation(i)));
            ++i;
        }
        return new ComposedBitmapIndexCursor(cursorStates, timer, composer);
    }

    @FunctionalInterface
    public static interface Composer {
        @Nullable
        public byte[] compose(@Nonnull List<byte[]> var1, int var2);
    }
}

