/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.bitmap;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.ObjectPlanHash;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.planprotos.PRecordQueryPlan;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.bitmap.ComposedBitmapIndexCursor;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.QueryPlan;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithNoChildren;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ComposedBitmapIndexQueryPlan
extends AbstractRelationalExpressionWithoutChildren
implements RecordQueryPlanWithNoChildren {
    private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Composed-Bitmap-Index-Query-Plan");
    @Nonnull
    private final List<RecordQueryCoveringIndexPlan> indexPlans;
    @Nonnull
    private final ComposerBase composer;

    ComposedBitmapIndexQueryPlan(@Nonnull List<RecordQueryCoveringIndexPlan> indexPlans, @Nonnull ComposerBase composer) {
        this.indexPlans = indexPlans;
        this.composer = composer;
    }

    @Nonnull
    public List<RecordQueryCoveringIndexPlan> getIndexPlans() {
        return this.indexPlans;
    }

    @Nonnull
    public ComposerBase getComposer() {
        return this.composer;
    }

    @Override
    @Nonnull
    public <M extends Message> RecordCursor<QueryResult> executePlan(@Nonnull FDBRecordStoreBase<M> store, @Nonnull EvaluationContext context, @Nullable byte[] continuation, @Nonnull ExecuteProperties executeProperties) {
        ExecuteProperties scanExecuteProperties = executeProperties.getSkip() > 0 ? executeProperties.clearSkipAndAdjustLimit() : executeProperties;
        List<Function<byte[], RecordCursor<IndexEntry>>> cursorFunctions = this.indexPlans.stream().map(RecordQueryCoveringIndexPlan::getIndexPlan).map(scan -> childContinuation -> scan.executeEntries(store, context, (byte[])childContinuation, scanExecuteProperties)).collect(Collectors.toList());
        return ComposedBitmapIndexCursor.create(cursorFunctions, this.composer, continuation, store.getTimer()).filter(indexEntry -> indexEntry.getValue().get(0) != null).map(this.indexPlans.get(0).indexEntryToQueriedRecord(store)).map(QueryResult::fromQueriedRecord);
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    @Override
    public boolean hasRecordScan() {
        return false;
    }

    @Override
    public boolean hasFullRecordScan() {
        return false;
    }

    @Override
    public boolean hasIndexScan(@Nonnull String indexName) {
        return this.indexPlans.stream().anyMatch(p -> p.hasIndexScan(indexName));
    }

    @Override
    @Nonnull
    public Set<String> getUsedIndexes() {
        return this.indexPlans.stream().map(QueryPlan::getUsedIndexes).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public boolean hasLoadBykeys() {
        return false;
    }

    @Override
    @Nonnull
    public AvailableFields getAvailableFields() {
        return AvailableFields.ALL_FIELDS;
    }

    @Override
    public void logPlanStructure(StoreTimer timer) {
        timer.increment(FDBStoreTimer.Counts.PLAN_COMPOSED_BITMAP_INDEX);
        for (RecordQueryPlan recordQueryPlan : this.indexPlans) {
            recordQueryPlan.logPlanStructure(timer);
        }
    }

    @Override
    public int getComplexity() {
        int complexity = 1;
        for (RecordQueryPlan recordQueryPlan : this.indexPlans) {
            complexity += recordQueryPlan.getComplexity();
        }
        return complexity;
    }

    @Override
    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        switch (mode.getKind()) {
            case LEGACY: {
                return PlanHashable.planHash(mode, this.indexPlans) + this.composer.planHash(mode);
            }
            case FOR_CONTINUATION: {
                return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.indexPlans, this.composer);
            }
        }
        throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.OperatorNodeWithInfo(this, NodeInfo.COMPOSED_BITMAP_OPERATOR), childGraphs);
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.indexPlans.stream().map(Correlated::getCorrelatedTo).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public ComposedBitmapIndexQueryPlan translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        if (translationMap.definesOnlyIdentities()) {
            return this;
        }
        ImmutableList.Builder translatedIndexPlansBuilder = ImmutableList.builder();
        for (RecordQueryCoveringIndexPlan indexPlan : this.indexPlans) {
            RelationalExpression translatedIndexPlan = indexPlan.translateCorrelations(translationMap, shouldSimplifyValues, (List)translatedQuantifiers);
            translatedIndexPlansBuilder.add(translatedIndexPlan);
        }
        return new ComposedBitmapIndexQueryPlan((List<RecordQueryCoveringIndexPlan>)((Object)translatedIndexPlansBuilder.build()), this.composer);
    }

    @Override
    public boolean canBeMinimized() {
        return this.indexPlans.stream().anyMatch(RecordQueryCoveringIndexPlan::canBeMinimized);
    }

    @Override
    @Nonnull
    public RecordQueryPlan minimize(@Nonnull List<Quantifier.Physical> newQuantifiers) {
        Verify.verify(newQuantifiers.isEmpty());
        ImmutableList.Builder minimizedIndexPlansBuilder = ImmutableList.builder();
        for (RecordQueryCoveringIndexPlan indexPlan : this.indexPlans) {
            if (indexPlan.canBeMinimized()) {
                minimizedIndexPlansBuilder.add(indexPlan.minimize((List)newQuantifiers));
                continue;
            }
            minimizedIndexPlansBuilder.add(indexPlan);
        }
        return new ComposedBitmapIndexQueryPlan((List<RecordQueryCoveringIndexPlan>)((Object)minimizedIndexPlansBuilder.build()), this.composer);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression other, @Nonnull AliasMap equivalences) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ComposedBitmapIndexQueryPlan that = (ComposedBitmapIndexQueryPlan)other;
        if (!this.composer.equals(that.composer)) {
            return false;
        }
        List<RecordQueryCoveringIndexPlan> otherIndexPlans = that.indexPlans;
        if (this.indexPlans.size() != otherIndexPlans.size()) {
            return false;
        }
        for (int i = 0; i < this.indexPlans.size(); ++i) {
            if (this.indexPlans.get(i).equalsWithoutChildren(otherIndexPlans.get(i), equivalences)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.indexPlans, this.composer);
    }

    public boolean equals(Object other) {
        return this.structuralEquals(other);
    }

    public int hashCode() {
        return this.structuralHashCode();
    }

    public String toString() {
        return this.composer.toString(this.indexPlans);
    }

    @Override
    @Nonnull
    public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }

    @Override
    @Nonnull
    public PRecordQueryPlan toRecordQueryPlanProto(@Nonnull PlanSerializationContext serializationContext) {
        throw new RecordCoreException("serialization of this plan is not supported", new Object[0]);
    }

    public static abstract class ComposerBase
    implements ComposedBitmapIndexCursor.Composer,
    PlanHashable {
        @Nonnull
        abstract String toString(@Nullable List<?> var1);

        public String toString() {
            return this.toString(null);
        }
    }

    static class NotComposer
    extends ComposerBase {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Not-Composer");
        @Nonnull
        private final ComposerBase child;

        NotComposer(@Nonnull ComposerBase child) {
            this.child = child;
        }

        @Override
        @Nonnull
        String toString(@Nullable List<?> sources) {
            return "BITNOT " + this.child.toString(sources);
        }

        @Override
        @Nullable
        public byte[] compose(@Nonnull List<byte[]> bitmaps, int size) {
            byte[] operand = this.child.compose(bitmaps, size);
            byte[] result = new byte[size];
            if (operand == null) {
                Arrays.fill(result, (byte)-1);
            } else {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = ~operand[i];
                }
            }
            return result;
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.child.planHash(mode);
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.child);
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotComposer that = (NotComposer)o;
            return this.child.equals(that.child);
        }

        public int hashCode() {
            return this.child.hashCode();
        }
    }

    static class XorComposer
    extends OperatorComposer {
        public XorComposer(@Nonnull List<ComposerBase> children) {
            super(children);
        }

        @Override
        @Nonnull
        String operator() {
            return "BITXOR";
        }

        @Override
        @Nullable
        byte[] operate(@Nonnull List<byte[]> operands, @Nonnull byte[] result) {
            boolean first = true;
            boolean empty = true;
            for (byte[] operand : operands) {
                if (operand == null) continue;
                if (first) {
                    System.arraycopy(operand, 0, result, 0, result.length);
                    first = false;
                    empty = false;
                    continue;
                }
                empty = true;
                for (int j = 0; j < result.length; ++j) {
                    byte b;
                    result[j] = b = (byte)(result[j] ^ operand[j]);
                    if (!empty || b == 0) continue;
                    empty = false;
                }
            }
            return empty ? null : result;
        }
    }

    static class OrComposer
    extends OperatorComposer {
        public OrComposer(@Nonnull List<ComposerBase> children) {
            super(children);
        }

        @Override
        @Nonnull
        String operator() {
            return "BITOR";
        }

        @Override
        @Nullable
        byte[] operate(@Nonnull List<byte[]> operands, @Nonnull byte[] result) {
            boolean first = true;
            boolean empty = true;
            for (byte[] operand : operands) {
                if (operand == null) continue;
                if (first) {
                    System.arraycopy(operand, 0, result, 0, result.length);
                    first = false;
                    empty = false;
                    continue;
                }
                empty = true;
                for (int j = 0; j < result.length; ++j) {
                    byte b;
                    result[j] = b = (byte)(result[j] | operand[j]);
                    if (!empty || b == 0) continue;
                    empty = false;
                }
            }
            return empty ? null : result;
        }
    }

    static class AndComposer
    extends OperatorComposer {
        public AndComposer(@Nonnull List<ComposerBase> children) {
            super(children);
        }

        @Override
        @Nonnull
        String operator() {
            return "BITAND";
        }

        @Override
        @Nullable
        byte[] operate(@Nonnull List<byte[]> operands, @Nonnull byte[] result) {
            boolean first = true;
            boolean empty = true;
            for (byte[] operand : operands) {
                if (operand == null) {
                    return null;
                }
                if (first) {
                    System.arraycopy(operand, 0, result, 0, result.length);
                    first = false;
                    empty = false;
                    continue;
                }
                empty = true;
                for (int j = 0; j < result.length; ++j) {
                    byte b;
                    result[j] = b = (byte)(result[j] & operand[j]);
                    if (!empty || b == 0) continue;
                    empty = false;
                }
            }
            return empty ? null : result;
        }
    }

    static abstract class OperatorComposer
    extends ComposerBase {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Operator-Composer");
        @Nonnull
        private final List<ComposerBase> children;

        OperatorComposer(@Nonnull List<ComposerBase> children) {
            this.children = children;
        }

        @Nonnull
        abstract String operator();

        @Override
        @Nonnull
        String toString(@Nullable List<?> sources) {
            return this.children.stream().map(child -> child.toString(sources)).collect(Collectors.joining(" " + this.operator() + " "));
        }

        @Override
        @Nullable
        public byte[] compose(@Nonnull List<byte[]> bitmaps, int size) {
            ArrayList<byte[]> operands = new ArrayList<byte[]>(this.children.size());
            for (ComposerBase child : this.children) {
                operands.add(child.compose(bitmaps, size));
            }
            return this.operate(operands, new byte[size]);
        }

        @Nullable
        abstract byte[] operate(@Nonnull List<byte[]> var1, @Nonnull byte[] var2);

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return PlanHashable.planHash(mode, this.children) + this.operator().hashCode();
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.children, this.operator());
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorComposer that = (OperatorComposer)o;
            return this.children.equals(that.children) && this.operator().equals(that.operator());
        }

        public int hashCode() {
            return Objects.hash(this.children) + this.operator().hashCode();
        }
    }

    static class IndexComposer
    extends ComposerBase {
        private static final ObjectPlanHash BASE_HASH = new ObjectPlanHash("Index-Composer");
        private final int position;

        IndexComposer(int position) {
            this.position = position;
        }

        @Override
        @Nonnull
        String toString(@Nullable List<?> sources) {
            if (sources == null) {
                return "[" + this.position + "]";
            }
            return sources.get(this.position).toString();
        }

        @Override
        @Nullable
        public byte[] compose(@Nonnull List<byte[]> bitmaps, int size) {
            return bitmaps.get(this.position);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
            switch (mode.getKind()) {
                case LEGACY: {
                    return this.position;
                }
                case FOR_CONTINUATION: {
                    return PlanHashable.objectsPlanHash(mode, BASE_HASH, this.position);
                }
            }
            throw new UnsupportedOperationException("Hash kind " + String.valueOf((Object)mode.getKind()) + " is not supported");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexComposer that = (IndexComposer)o;
            return this.position == that.position;
        }

        public int hashCode() {
            return Objects.hash(this.position);
        }
    }
}

