/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.plan.cascades.AggregateIndexMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.BuiltInFunction;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.IndexPredicateExpansion;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.expressions.GroupByExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.MatchableSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.RangeConstraints;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.ArithmeticValue;
import com.apple.foundationdb.record.query.plan.cascades.values.CountValue;
import com.apple.foundationdb.record.query.plan.cascades.values.EmptyValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.IndexOnlyAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.NumericAggregationValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.Values;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AggregateIndexExpansionVisitor
extends KeyExpressionExpansionVisitor
implements ExpansionVisitor<KeyExpressionExpansionVisitor.VisitorState> {
    @Nonnull
    static final Supplier<Map<String, BuiltInFunction<? extends Value>>> aggregateMap = Suppliers.memoize(AggregateIndexExpansionVisitor::computeAggregateMap);
    @Nonnull
    static final Supplier<Map<String, BuiltInFunction<? extends Value>>> rollUpAggregateMap = Suppliers.memoize(AggregateIndexExpansionVisitor::computeRollUpAggregateMap);
    @Nonnull
    protected final Index index;
    @Nonnull
    private final Collection<RecordType> recordTypes;
    @Nonnull
    protected final GroupingKeyExpression groupingKeyExpression;
    private final int columnPermutations;

    public AggregateIndexExpansionVisitor(@Nonnull Index index, @Nonnull Collection<RecordType> recordTypes) {
        Preconditions.checkArgument(AggregateIndexExpansionVisitor.supportsAggregateIndexType(index.getType()), "Unsupported index aggregate type %s", (Object)index.getType());
        Preconditions.checkArgument(index.getRootExpression() instanceof GroupingKeyExpression);
        this.index = index;
        this.groupingKeyExpression = (GroupingKeyExpression)index.getRootExpression();
        this.recordTypes = recordTypes;
        String permutationOption = index.getOption("permutedSize");
        this.columnPermutations = permutationOption == null ? 0 : Integer.parseInt(permutationOption);
    }

    public boolean isPermuted() {
        return "permuted_max".equals(this.index.getType()) || "permuted_min".equals(this.index.getType());
    }

    @Override
    @Nonnull
    public MatchCandidate expand(@Nonnull Supplier<Quantifier.ForEach> baseQuantifierSupplier, @Nullable KeyExpression ignored, boolean isReverse) {
        Verify.verify(ignored == null);
        Quantifier.ForEach baseQuantifier = baseQuantifierSupplier.get();
        GraphExpansion baseExpansion = this.constructBaseExpansion(baseQuantifier);
        NonnullPair<Quantifier, List<Placeholder>> selectWhereQunAndPlaceholders = this.constructSelectWhereAndPlaceholders(baseQuantifier, baseExpansion);
        Quantifier selectWhereQun = selectWhereQunAndPlaceholders.getLeft();
        List<Placeholder> selectWherePlaceholders = selectWhereQunAndPlaceholders.getRight();
        NonnullPair<Quantifier, List<Placeholder>> groupByQunAndPlaceholders = this.constructGroupBy(selectWhereQun, baseExpansion);
        Quantifier groupByQun = groupByQunAndPlaceholders.getLeft();
        List<Placeholder> groupByPlaceholders = groupByQunAndPlaceholders.getRight();
        ImmutableCollection placeholders = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(selectWherePlaceholders)).addAll(groupByPlaceholders)).build();
        ConstructSelectHavingResult constructSelectHavingResult = this.constructSelectHaving(groupByQun, (List<Placeholder>)((Object)placeholders));
        SelectExpression selectHaving = constructSelectHavingResult.getSelectExpression();
        List<CorrelationIdentifier> placeHolderAliases = constructSelectHavingResult.getPlaceholderAliases();
        Reference maybeWithSort = placeHolderAliases.isEmpty() ? Reference.initialOf((RelationalExpression)selectHaving) : Reference.initialOf((RelationalExpression)new MatchableSortExpression(placeHolderAliases, isReverse, selectHaving));
        Traversal traversal = Traversal.withRoot(maybeWithSort);
        return new AggregateIndexMatchCandidate(this.index, traversal, placeHolderAliases, this.recordTypes, baseQuantifier.getFlowedObjectType(), groupByQun.getRangesOver().get().getResultValue(), selectHaving);
    }

    @Nonnull
    private GraphExpansion constructBaseExpansion(@Nonnull Quantifier.ForEach baseQuantifier) {
        KeyExpressionExpansionVisitor.VisitorState state = KeyExpressionExpansionVisitor.VisitorState.of(Lists.newArrayList(), Lists.newArrayList(), baseQuantifier, ImmutableList.of(), this.groupingKeyExpression.getGroupingCount(), 0, false, false);
        return this.pop(this.groupingKeyExpression.getWholeKey().expand(this.push(state)));
    }

    @Nonnull
    private NonnullPair<Quantifier, List<Placeholder>> constructSelectWhereAndPlaceholders(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull GraphExpansion baseExpansion) {
        ImmutableList.Builder allExpansionsBuilder = ImmutableList.builder();
        allExpansionsBuilder.add(GraphExpansion.ofQuantifier(baseQuantifier));
        if (this.index.hasPredicate()) {
            QueryPredicate filteredIndexPredicate = Objects.requireNonNull(this.index.getPredicate()).toPredicate(baseQuantifier.getFlowedObjectValue());
            Optional<Multimap<Value, RangeConstraints>> valueRangesMaybe = IndexPredicateExpansion.dnfPredicateToRanges(filteredIndexPredicate);
            GraphExpansion.Builder predicateExpansionBuilder = GraphExpansion.builder();
            if (valueRangesMaybe.isEmpty()) {
                allExpansionsBuilder.add(GraphExpansion.ofPredicate(filteredIndexPredicate));
            } else {
                Multimap<Value, RangeConstraints> valueRanges = valueRangesMaybe.get();
                for (Value value : valueRanges.keySet()) {
                    Optional<Placeholder> maybePlaceholder = baseExpansion.getPlaceholders().stream().filter(existingPlaceholder -> existingPlaceholder.getValue().semanticEquals((Object)value, AliasMap.emptyMap())).findFirst();
                    if (maybePlaceholder.isEmpty()) {
                        predicateExpansionBuilder.addPredicate(PredicateWithValueAndRanges.ofRanges(value, ImmutableSet.copyOf(valueRanges.get(value))));
                        continue;
                    }
                    predicateExpansionBuilder.addPlaceholder(maybePlaceholder.get().withExtraRanges(ImmutableSet.copyOf(valueRanges.get(value))));
                }
            }
            allExpansionsBuilder.add(predicateExpansionBuilder.build());
        }
        GraphExpansion.Builder builder = GraphExpansion.builder();
        Stream.concat(Stream.of(baseQuantifier), baseExpansion.getQuantifiers().stream()).forEach(qun -> {
            QuantifiedObjectValue quantifiedValue = QuantifiedObjectValue.of(qun.getAlias(), qun.getFlowedObjectType());
            builder.addResultColumn(Column.unnamedOf(quantifiedValue));
        });
        builder.addAllPlaceholders(baseExpansion.getPlaceholders());
        builder.addAllPredicates(baseExpansion.getPredicates());
        builder.addAllQuantifiers(baseExpansion.getQuantifiers());
        allExpansionsBuilder.add(builder.build());
        return NonnullPair.of(Quantifier.forEach(Reference.initialOf((RelationalExpression)GraphExpansion.ofOthers((List<GraphExpansion>)((Object)allExpansionsBuilder.build())).buildSelect())), baseExpansion.getPlaceholders());
    }

    @Nonnull
    protected NonnullPair<Quantifier, List<Placeholder>> constructGroupBy(@Nonnull Quantifier selectWhereQun, @Nonnull GraphExpansion baseExpansion) {
        Value argument;
        EmptyValue groupedValue;
        if (this.groupingKeyExpression.getGroupedCount() > 1) {
            throw new UnsupportedOperationException("aggregate index is expected to contain exactly one aggregation, however it contains " + this.groupingKeyExpression.getGroupedCount() + " aggregations");
        }
        Value value = groupedValue = this.groupingKeyExpression.getGroupedCount() == 0 ? EmptyValue.empty() : baseExpansion.getResultColumns().get(this.groupingKeyExpression.getGroupingCount()).getValue();
        if (groupedValue instanceof EmptyValue) {
            argument = RecordConstructorValue.ofColumns(ImmutableList.of());
        } else if (groupedValue instanceof FieldValue || groupedValue instanceof ArithmeticValue) {
            AliasMap aliasMap = AliasMap.identitiesFor(Sets.union(selectWhereQun.getCorrelatedTo(), groupedValue.getCorrelatedTo()));
            Map<Value, Value> result = selectWhereQun.getRangesOver().get().getResultValue().pullUp(List.of(groupedValue), EvaluationContext.empty(), aliasMap, ImmutableSet.of(), selectWhereQun.getAlias());
            if (!result.containsKey(groupedValue)) {
                throw new RecordCoreException("could not pull grouped value " + String.valueOf(groupedValue), new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, groupedValue});
            }
            argument = result.get(groupedValue);
        } else {
            throw new RecordCoreException("unable to plan group by with non-field value", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, groupedValue});
        }
        AggregateValue aggregateValue = AggregateIndexExpansionVisitor.aggregateValue(this.index, argument).orElseThrow(() -> new RecordCoreException("unknown aggregation type", new Object[0]));
        ImmutableList groupingValues = baseExpansion.getResultColumns().subList(0, this.groupingKeyExpression.getGroupingCount()).stream().map(Column::getValue).collect(ImmutableList.toImmutableList());
        Value selectQunValue = selectWhereQun.getRangesOver().get().getResultValue();
        AliasMap aliasMap = AliasMap.identitiesFor(Sets.union(selectQunValue.getCorrelatedTo(), groupingValues.stream().flatMap(v -> v.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet())));
        Map<Value, Value> pulledUpGroupingValuesMap = selectQunValue.pullUp(groupingValues, EvaluationContext.empty(), aliasMap, ImmutableSet.of(), selectWhereQun.getAlias());
        ImmutableList pulledUpGroupingValues = groupingValues.stream().map(groupingValue -> {
            if (!pulledUpGroupingValuesMap.containsKey(groupingValue)) {
                throw new RecordCoreException("could not pull grouping value " + String.valueOf(groupingValue), new Object[0]).addLogInfo(new Object[]{LogMessageKeys.VALUE, groupingValue});
            }
            return (Value)pulledUpGroupingValuesMap.get(groupingValue);
        }).collect(ImmutableList.toImmutableList());
        RecordConstructorValue groupingColsValue = RecordConstructorValue.ofUnnamed(pulledUpGroupingValues);
        GroupByExpression groupByExpression = new GroupByExpression(groupingColsValue.getResultType().getFields().isEmpty() ? null : groupingColsValue, RecordConstructorValue.ofUnnamed(ImmutableList.of(aggregateValue)), GroupByExpression::nestedResults, selectWhereQun);
        Reference groupByReference = Reference.initialOf((RelationalExpression)groupByExpression);
        Quantifier.ForEach groupByQuantifier = Quantifier.forEach(groupByReference);
        return NonnullPair.of(groupByQuantifier, ImmutableList.of());
    }

    @Nonnull
    private ConstructSelectHavingResult constructSelectHaving(@Nonnull Quantifier groupByQun, @Nonnull List<Placeholder> selectWherePlaceholders) {
        ImmutableCollection finalPlaceholders;
        List<Object> groupingValues;
        RelationalExpression rangesOverExpression = groupByQun.getRangesOver().get();
        Verify.verify(rangesOverExpression instanceof GroupByExpression);
        GroupByExpression groupByExpression = (GroupByExpression)rangesOverExpression;
        FieldValue groupingValueReference = groupByExpression.getGroupingValue() == null ? null : FieldValue.ofOrdinalNumber(groupByQun.getFlowedObjectValue(), 0);
        FieldValue aggregateValueReference = FieldValue.ofOrdinalNumberAndFuseIfPossible(FieldValue.ofOrdinalNumber(groupByQun.getFlowedObjectValue(), groupingValueReference == null ? 0 : 1), 0);
        ImmutableList.Builder placeholderAliases = ImmutableList.builder();
        GraphExpansion.Builder selectHavingGraphExpansionBuilder = GraphExpansion.builder().addQuantifier(groupByQun);
        List<Object> list = groupingValues = groupingValueReference == null ? ImmutableList.of() : Values.deconstructRecord(groupingValueReference);
        if (groupingValueReference != null) {
            int i = 0;
            for (Value value : groupingValues) {
                FieldValue field = (FieldValue)value;
                Placeholder placeholder = value.asPlaceholder(selectWherePlaceholders.get(i++).getParameterAlias());
                placeholderAliases.add(placeholder.getParameterAlias());
                selectHavingGraphExpansionBuilder.addResultColumn(Column.unnamedOf(field)).addPlaceholder(placeholder).addPredicate(placeholder);
            }
        }
        selectHavingGraphExpansionBuilder.addResultColumn(Column.unnamedOf(aggregateValueReference));
        if (this.isPermuted()) {
            Placeholder placeholder = Placeholder.newInstanceWithoutRanges(aggregateValueReference, AggregateIndexExpansionVisitor.newParameterAlias());
            placeholderAliases.add(placeholder.getParameterAlias());
            selectHavingGraphExpansionBuilder.addPlaceholder(placeholder).addPredicate(placeholder);
            if (this.columnPermutations > 0) {
                ImmutableCollection immutableCollection = placeholderAliases.build();
                finalPlaceholders = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)immutableCollection.subList(0, groupingValues.size() - this.columnPermutations))).add(placeholder.getParameterAlias())).addAll((Iterable)immutableCollection.subList(groupingValues.size() - this.columnPermutations, groupingValues.size()))).build();
            } else {
                finalPlaceholders = placeholderAliases.build();
            }
        } else {
            finalPlaceholders = placeholderAliases.build();
        }
        return new ConstructSelectHavingResult(selectHavingGraphExpansionBuilder.build().buildSelect(), (List<CorrelationIdentifier>)((Object)finalPlaceholders));
    }

    @API(value=API.Status.INTERNAL)
    public static boolean supportsAggregateIndexType(@Nonnull String indexType) {
        return "bitmap_value".equals(indexType) || aggregateMap.get().containsKey(indexType);
    }

    @Nonnull
    public static Optional<AggregateValue> aggregateValue(@Nonnull Index index, @Nonnull Value argument) {
        return Optional.of((AggregateValue)aggregateMap.get().get(index.getType()).encapsulate(ImmutableList.of(argument)));
    }

    @Nonnull
    private static Map<String, BuiltInFunction<? extends Value>> computeAggregateMap() {
        ImmutableMap.Builder<String, BuiltInFunction> mapBuilder = ImmutableMap.builder();
        mapBuilder.put("max_ever_long", new IndexOnlyAggregateValue.MaxEverFn());
        mapBuilder.put("min_ever_long", new IndexOnlyAggregateValue.MinEverFn());
        mapBuilder.put("max_ever_tuple", new IndexOnlyAggregateValue.MaxEverFn());
        mapBuilder.put("min_ever_tuple", new IndexOnlyAggregateValue.MinEverFn());
        mapBuilder.put("sum", new NumericAggregationValue.SumFn());
        mapBuilder.put("count", new CountValue.CountFn());
        mapBuilder.put("count_not_null", new CountValue.CountFn());
        mapBuilder.put("permuted_max", new NumericAggregationValue.MaxFn());
        mapBuilder.put("permuted_min", new NumericAggregationValue.MinFn());
        return mapBuilder.build();
    }

    public static boolean canBeRolledUp(@Nonnull String indexType) {
        return rollUpAggregateMap.get().containsKey(indexType);
    }

    @Nonnull
    public static Optional<AggregateValue> rollUpAggregateValueMaybe(@Nonnull String indexType, @Nonnull Value argument) {
        return Optional.ofNullable(rollUpAggregateMap.get().get(indexType)).map(fn -> (AggregateValue)fn.encapsulate(ImmutableList.of(argument)));
    }

    @Nonnull
    private static Map<String, BuiltInFunction<? extends Value>> computeRollUpAggregateMap() {
        ImmutableMap.Builder<String, BuiltInFunction> mapBuilder = ImmutableMap.builder();
        mapBuilder.put("max_ever_long", new NumericAggregationValue.MaxFn());
        mapBuilder.put("min_ever_long", new NumericAggregationValue.MinFn());
        mapBuilder.put("max_ever_tuple", new NumericAggregationValue.MaxFn());
        mapBuilder.put("min_ever_tuple", new NumericAggregationValue.MinFn());
        mapBuilder.put("sum", new NumericAggregationValue.SumFn());
        mapBuilder.put("count", new NumericAggregationValue.SumFn());
        mapBuilder.put("count_not_null", new NumericAggregationValue.SumFn());
        mapBuilder.put("permuted_max", new NumericAggregationValue.MaxFn());
        mapBuilder.put("permuted_min", new NumericAggregationValue.MinFn());
        return mapBuilder.build();
    }

    private static class ConstructSelectHavingResult {
        @Nonnull
        private final SelectExpression selectExpression;
        @Nonnull
        private final List<CorrelationIdentifier> placeholderAliases;

        private ConstructSelectHavingResult(@Nonnull SelectExpression selectExpression, @Nonnull List<CorrelationIdentifier> placeholderAliases) {
            this.selectExpression = selectExpression;
            this.placeholderAliases = placeholderAliases;
        }

        @Nonnull
        public SelectExpression getSelectExpression() {
            return this.selectExpression;
        }

        @Nonnull
        public List<CorrelationIdentifier> getPlaceholderAliases() {
            return this.placeholderAliases;
        }
    }
}

