/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AggregateIndexExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.WithBaseQuantifierMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.TypeRepository;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.Values;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.OrderingValueComputationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAggregateIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryStreamingAggregationPlan;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.ImmutableIntArray;
import com.google.protobuf.Descriptors;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AggregateIndexMatchCandidate
implements MatchCandidate,
WithBaseQuantifierMatchCandidate {
    @Nonnull
    private final Index index;
    @Nonnull
    private final Traversal traversal;
    @Nonnull
    private final List<CorrelationIdentifier> sargableAndOrderAliases;
    @Nonnull
    private final List<RecordType> recordTypes;
    @Nonnull
    private final Type baseType;
    @Nonnull
    private final Value groupByResultValue;
    @Nonnull
    private final SelectExpression selectHavingExpression;

    public AggregateIndexMatchCandidate(@Nonnull Index index, @Nonnull Traversal traversal, @Nonnull List<CorrelationIdentifier> sargableAndOrderAliases, @Nonnull Collection<RecordType> recordTypes, @Nonnull Type baseType, @Nonnull Value groupByResultValue, @Nonnull SelectExpression selectHavingExpression) {
        Preconditions.checkArgument(!recordTypes.isEmpty());
        this.index = index;
        this.traversal = traversal;
        this.sargableAndOrderAliases = sargableAndOrderAliases;
        this.recordTypes = ImmutableList.copyOf(recordTypes);
        this.baseType = baseType;
        this.groupByResultValue = groupByResultValue;
        this.selectHavingExpression = selectHavingExpression;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.index.getName();
    }

    @Override
    @Nonnull
    public Traversal getTraversal() {
        return this.traversal;
    }

    @Override
    @Nonnull
    public List<CorrelationIdentifier> getSargableAliases() {
        return this.sargableAndOrderAliases;
    }

    @Override
    @Nonnull
    public List<CorrelationIdentifier> getOrderingAliases() {
        return this.sargableAndOrderAliases;
    }

    @Override
    @Nonnull
    public KeyExpression getFullKeyExpression() {
        return this.index.getRootExpression();
    }

    public String toString() {
        return "AGG[" + this.getName() + "; " + this.index.getType() + "]";
    }

    @Override
    public boolean createsDuplicates() {
        return this.index.getRootExpression().createsDuplicates();
    }

    @Override
    public int getColumnSize() {
        return this.index.getColumnSize();
    }

    @Override
    public boolean isUnique() {
        return this.index.isUnique();
    }

    public boolean isPermuted() {
        return "permuted_max".equals(this.index.getType()) || "permuted_min".equals(this.index.getType());
    }

    private int getPermutedCount() {
        String permutedSizeOption = this.index.getOption("permutedSize");
        return permutedSizeOption == null ? 0 : Integer.parseInt(permutedSizeOption);
    }

    @Override
    @Nonnull
    public List<OrderingPart.MatchedOrderingPart> computeMatchedOrderingParts(@Nonnull MatchInfo matchInfo, @Nonnull List<CorrelationIdentifier> sortParameterIds, boolean isReverse) {
        MatchInfo.RegularMatchInfo regularMatchInfo = matchInfo.getRegularMatchInfo();
        Map<CorrelationIdentifier, ComparisonRange> parameterBindingMap = regularMatchInfo.getParameterBindingMap();
        List<KeyExpression> normalizedKeyExpressions = this.getFullKeyExpression().normalizeKeyForPositions();
        ImmutableList.Builder builder = ImmutableList.builder();
        List<CorrelationIdentifier> candidateParameterIds = this.getOrderingAliases();
        HashSet<Value> normalizedValues = Sets.newHashSetWithExpectedSize(normalizedKeyExpressions.size());
        Type selectHavingResultType = this.selectHavingExpression.getResultValue().getResultType();
        List<Value> deconstructedValues = Values.deconstructRecord(QuantifiedObjectValue.of(Quantifier.current(), selectHavingResultType));
        List<Value> rollUpToGroupingValues = regularMatchInfo.getRollUpToGroupingValues();
        int orderSize = rollUpToGroupingValues != null ? rollUpToGroupingValues.size() : sortParameterIds.size();
        for (int i = 0; i < orderSize; ++i) {
            CorrelationIdentifier parameterId = sortParameterIds.get(i);
            int ordinalInCandidate = candidateParameterIds.indexOf(parameterId);
            Verify.verify(ordinalInCandidate >= 0);
            int permutedIndex = this.indexWithPermutation(ordinalInCandidate);
            KeyExpression normalizedKeyExpression = normalizedKeyExpressions.get(permutedIndex);
            Objects.requireNonNull(parameterId);
            Objects.requireNonNull(normalizedKeyExpression);
            ComparisonRange comparisonRange = parameterBindingMap.get(parameterId);
            if (normalizedKeyExpression.createsDuplicates()) {
                if (comparisonRange == null || comparisonRange.getRangeType() != ComparisonRange.Type.EQUALITY) break;
                continue;
            }
            Value value = deconstructedValues.get(permutedIndex);
            if (!normalizedValues.add(value)) continue;
            OrderingPart.MatchedOrderingPart matchedOrderingPart = value.deriveOrderingPart(EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), (v, sortOrder) -> OrderingPart.MatchedOrderingPart.of(parameterId, v, comparisonRange, sortOrder), OrderingValueComputationRuleSet.usingMatchedOrderingParts());
            builder.add(matchedOrderingPart);
        }
        return builder.build();
    }

    private int indexWithPermutation(int i) {
        if (this.isPermuted()) {
            int permutedCount = this.getPermutedCount();
            GroupingKeyExpression groupingKeyExpression = (GroupingKeyExpression)this.index.getRootExpression();
            int groupingCount = groupingKeyExpression.getGroupingCount();
            int groupedCount = groupingKeyExpression.getGroupedCount();
            if (i < groupingCount - permutedCount) {
                return i;
            }
            if (i < groupingCount - permutedCount + groupedCount) {
                return i + permutedCount;
            }
            return i - groupedCount;
        }
        return i;
    }

    @Override
    @Nonnull
    public Ordering computeOrderingFromScanComparisons(@Nonnull ScanComparisons scanComparisons, boolean isReverse, boolean isDistinct) {
        ImmutableSetMultimap.Builder bindingMapBuilder = ImmutableSetMultimap.builder();
        int groupingCount = ((GroupingKeyExpression)this.index.getRootExpression()).getGroupingCount();
        if (!this.isPermuted() && groupingCount == 0) {
            return Ordering.empty();
        }
        Value selectHavingResultValue = this.selectHavingExpression.getResultValue();
        Type.Record selectHavingResultType = (Type.Record)selectHavingResultValue.getResultType();
        CorrelationIdentifier baseObjectAlias = Iterables.getOnlyElement(this.selectHavingExpression.getQuantifiers()).getAlias();
        QuantifiedObjectValue baseObjectValue = QuantifiedObjectValue.of(baseObjectAlias, selectHavingResultType);
        ImmutableList.Builder deconstructedValuesBuilder = ImmutableList.builder();
        for (Type.Record.Field field : selectHavingResultType.getFields()) {
            deconstructedValuesBuilder.add(FieldValue.ofFieldName(baseObjectValue, field.getFieldName()));
        }
        ImmutableCollection deconstructedValues = deconstructedValuesBuilder.build();
        AliasMap aliasMap = AliasMap.ofAliases(Iterables.getOnlyElement(selectHavingResultValue.getCorrelatedTo()), Quantifier.current());
        int orderingColumnCount = this.isPermuted() ? deconstructedValues.size() : groupingCount;
        List<Comparisons.Comparison> equalityComparisons = scanComparisons.getEqualityComparisons();
        HashSet<Value> seenValues = Sets.newHashSetWithExpectedSize(orderingColumnCount);
        for (int i = 0; i < equalityComparisons.size(); ++i) {
            int permutedIndex = this.indexWithPermutation(i);
            Comparisons.Comparison comparison = equalityComparisons.get(i);
            Value value = ((Value)deconstructedValues.get(permutedIndex)).rebase(aliasMap);
            Optional<NonnullPair<Value, Comparisons.Comparison>> simplifiedComparisonPairOptional = MatchCandidate.simplifyComparisonMaybe(value, comparison);
            if (simplifiedComparisonPairOptional.isEmpty()) continue;
            NonnullPair<Value, Comparisons.Comparison> simplifiedComparisonPair = simplifiedComparisonPairOptional.get();
            bindingMapBuilder.put(simplifiedComparisonPair.getLeft(), Ordering.Binding.fixed(simplifiedComparisonPair.getRight()));
            seenValues.add(simplifiedComparisonPair.getLeft());
        }
        ImmutableList.Builder orderingSequenceBuilder = ImmutableList.builder();
        for (int i = scanComparisons.getEqualitySize(); i < orderingColumnCount; ++i) {
            int permutedIndex = this.indexWithPermutation(i);
            Value normalizedValue = ((Value)deconstructedValues.get(permutedIndex)).rebase(aliasMap);
            OrderingPart.ProvidedOrderingPart providedOrderingPart = normalizedValue.deriveOrderingPart(EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), OrderingPart.ProvidedOrderingPart::new, OrderingValueComputationRuleSet.usingProvidedOrderingParts());
            Value providedOrderingValue = providedOrderingPart.getValue();
            if (seenValues.contains(providedOrderingValue)) continue;
            seenValues.add(providedOrderingValue);
            bindingMapBuilder.put(providedOrderingValue, Ordering.Binding.sorted(((OrderingPart.ProvidedSortOrder)providedOrderingPart.getSortOrder()).flipIfReverse(isReverse)));
            orderingSequenceBuilder.add(providedOrderingValue);
        }
        return Ordering.ofOrderingSequence((SetMultimap<Value, Ordering.Binding>)((Object)bindingMapBuilder.build()), (List<? extends Value>)((Object)orderingSequenceBuilder.build()), isDistinct);
    }

    @Override
    @Nullable
    public PullUp.UnificationPullUp prepareForUnification(@Nonnull PartialMatch partialMatch, @Nonnull CorrelationIdentifier topAlias, @Nonnull CorrelationIdentifier topCandidateAlias) {
        MatchInfo.RegularMatchInfo regularMatchInfo = partialMatch.getRegularMatchInfo();
        if (regularMatchInfo.getRollUpToGroupingValues() != null) {
            NonnullPair<List<Value>, Value> groupingAndAggregateAccessors = this.getGroupingAndAggregateAccessors(topCandidateAlias);
            List<Value> groupingAccessorValues = groupingAndAggregateAccessors.getLeft();
            Value aggregateAccessorValue = groupingAndAggregateAccessors.getRight();
            List<Type.Record.Field> allFields = ((Type.Record)this.selectHavingExpression.getResultValue().getResultType()).getFields();
            ImmutableList.Builder rollUpColumnsBuilder = ImmutableList.builder();
            int numGroupings = regularMatchInfo.getRollUpToGroupingValues().size();
            for (int i = 0; i < numGroupings; ++i) {
                Type.Record.Field field = allFields.get(i);
                rollUpColumnsBuilder.add(Column.of(field, groupingAccessorValues.get(i)));
            }
            rollUpColumnsBuilder.add(Column.of(allFields.get(allFields.size() - 1), aggregateAccessorValue));
            return PullUp.forUnification(topAlias, RecordConstructorValue.ofColumns(rollUpColumnsBuilder.build()), ImmutableSet.of(topCandidateAlias));
        }
        return null;
    }

    @Override
    @Nonnull
    public RecordQueryPlan toEquivalentPlan(@Nonnull PartialMatch partialMatch, @Nonnull PlanContext planContext, @Nonnull Memoizer memoizer, @Nonnull List<ComparisonRange> comparisonRanges, boolean reverseScanOrder) {
        Type.Record baseRecordType = Type.Record.fromFieldDescriptorsMap(RecordMetaData.getFieldDescriptorMapFromTypes(this.recordTypes));
        Value selectHavingResultValue = this.selectHavingExpression.getResultValue();
        Type.Record resultType = (Type.Record)selectHavingResultValue.getResultType();
        Descriptors.Descriptor messageDescriptor = Objects.requireNonNull(TypeRepository.newBuilder().addTypeIfNeeded(resultType).build().getMessageDescriptor(resultType));
        MatchInfo.RegularMatchInfo regularMatchInfo = partialMatch.getRegularMatchInfo();
        QueryPlanConstraint constraintMaybe = regularMatchInfo.getConstraint();
        IndexKeyValueToPartialRecord indexEntryConverter = this.createIndexEntryConverter(messageDescriptor);
        RecordQueryIndexPlan aggregateIndexScan = new RecordQueryIndexPlan(this.index.getName(), null, (IndexScanParameters)new IndexScanComparisons(IndexScanType.BY_GROUP, AggregateIndexMatchCandidate.toScanComparisons(comparisonRanges)), planContext.getPlannerConfiguration().getIndexFetchMethod(), RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY, reverseScanOrder, false, partialMatch.getMatchCandidate(), baseRecordType, QueryPlanConstraint.noConstraint());
        RecordQueryAggregateIndexPlan plan = new RecordQueryAggregateIndexPlan(aggregateIndexScan, this.recordTypes.get(0).getName(), indexEntryConverter, selectHavingResultValue, this.groupByResultValue, constraintMaybe);
        if (regularMatchInfo.getRollUpToGroupingValues() != null) {
            Reference aggregateIndexScanReference = memoizer.memoizePlan(plan);
            CorrelationIdentifier aggregateIndexScanAlias = Quantifier.uniqueId();
            NonnullPair<List<Value>, Value> groupingAndAggregateAccessors = this.getGroupingAndAggregateAccessors(this.getGroupingCount(), aggregateIndexScanAlias);
            List<Value> groupingAccessorValues = groupingAndAggregateAccessors.getLeft();
            Value aggregateAccessorValue = groupingAndAggregateAccessors.getRight();
            List<Type.Record.Field> allFields = resultType.getFields();
            ImmutableList.Builder rollUpGroupingColumnsBuilder = ImmutableList.builder();
            for (int i = 0; i < regularMatchInfo.getRollUpToGroupingValues().size(); ++i) {
                Type.Record.Field field = allFields.get(i);
                rollUpGroupingColumnsBuilder.add(Column.of(field, groupingAccessorValues.get(i)));
            }
            Optional<AggregateValue> rollUpAggregateValueOptional = AggregateIndexExpansionVisitor.rollUpAggregateValueMaybe(this.index.getType(), aggregateAccessorValue);
            Quantifier.Physical aggregateIndexScanQuantifier = Quantifier.physical(aggregateIndexScanReference, aggregateIndexScanAlias);
            return RecordQueryStreamingAggregationPlan.ofFlattened(aggregateIndexScanQuantifier, RecordConstructorValue.ofColumns(rollUpGroupingColumnsBuilder.build(), resultType.isNullable()), rollUpAggregateValueOptional.orElseThrow(() -> new RecordCoreException("unknown rollup operation", new Object[0])), RecordQueryStreamingAggregationPlan.SerializationMode.TO_NEW);
        }
        return plan;
    }

    @Override
    @Nonnull
    public List<RecordType> getQueriedRecordTypes() {
        return this.recordTypes;
    }

    protected int getGroupingCount() {
        int keyExpressionGroupingCount = ((GroupingKeyExpression)this.index.getRootExpression()).getGroupingCount();
        return "bitmap_value".equals(this.index.getType()) ? keyExpressionGroupingCount + 1 : keyExpressionGroupingCount;
    }

    @Nonnull
    public NonnullPair<List<Value>, Value> getGroupingAndAggregateAccessors(@Nonnull CorrelationIdentifier alias) {
        return this.getGroupingAndAggregateAccessors(this.getGroupingCount(), alias);
    }

    @Nonnull
    public NonnullPair<List<Value>, Value> getGroupingAndAggregateAccessors(int numGroupings, @Nonnull CorrelationIdentifier alias) {
        Value selectHavingResultValue = this.selectHavingExpression.getResultValue();
        Type.Record selectHavingResultType = (Type.Record)selectHavingResultValue.getResultType();
        QuantifiedObjectValue unbasedResultValue = QuantifiedObjectValue.of(alias, selectHavingResultType);
        List<Value> deconstructedRecord = Values.deconstructRecord(unbasedResultValue);
        Verify.verify(deconstructedRecord.size() > numGroupings);
        ImmutableList<Value> groupingAccessorValues = ImmutableList.copyOf(deconstructedRecord.subList(0, numGroupings));
        Value aggregateAccessorValue = deconstructedRecord.get(numGroupings);
        return NonnullPair.of(groupingAccessorValues, aggregateAccessorValue);
    }

    @Nonnull
    private IndexKeyValueToPartialRecord createIndexEntryConverter(@Nonnull Descriptors.Descriptor messageDescriptor) {
        Value selectHavingResultValue = this.selectHavingExpression.getResultValue();
        Type.Record selectHavingResultType = (Type.Record)selectHavingResultValue.getResultType();
        int groupingCount = this.getGroupingCount();
        Verify.verify(selectHavingResultType.getFields().size() >= groupingCount);
        CorrelationIdentifier baseObjectAlias = Iterables.getOnlyElement(this.selectHavingExpression.getQuantifiers()).getAlias();
        QuantifiedObjectValue baseObjectValue = QuantifiedObjectValue.of(baseObjectAlias, selectHavingResultType);
        IndexKeyValueToPartialRecord.Builder builder = IndexKeyValueToPartialRecord.newBuilder(messageDescriptor);
        if (this.isPermuted()) {
            this.addFieldsForPermutedIndexEntry(selectHavingResultType, baseObjectValue, groupingCount, builder);
        } else {
            this.addFieldsForNonPermutedIndexEntry(selectHavingResultType, baseObjectValue, groupingCount, builder);
        }
        if (!builder.isValid()) {
            throw new RecordCoreException("could not generate a covering index scan operator for index; Invalid mapping between index entries to partial record", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.INDEX_NAME, this.index.getName()});
        }
        return builder.build();
    }

    private void addFieldsForPermutedIndexEntry(@Nonnull Type.Record selectHavingResultType, @Nonnull Value baseObjectValue, int groupingCount, @Nonnull IndexKeyValueToPartialRecord.Builder builder) {
        List<Type.Record.Field> selectHavingResultFields = selectHavingResultType.getFields();
        int permutedCount = this.getPermutedCount();
        int groupedCount = this.getColumnSize() - groupingCount;
        for (int i = 0; i < selectHavingResultFields.size(); ++i) {
            Type.Record.Field field = selectHavingResultFields.get(i);
            int havingIndex = i >= groupingCount - permutedCount && i < groupingCount ? i + groupedCount : (i >= groupingCount ? i - permutedCount : i);
            AggregateIndexMatchCandidate.addCoveringField(builder, field, baseObjectValue, IndexKeyValueToPartialRecord.TupleSource.KEY, havingIndex);
        }
    }

    private void addFieldsForNonPermutedIndexEntry(@Nonnull Type.Record selectHavingResultType, @Nonnull Value baseObjectValue, int groupingCount, @Nonnull IndexKeyValueToPartialRecord.Builder builder) {
        Type.Record.Field field;
        int i;
        List<Type.Record.Field> selectHavingResultFields = selectHavingResultType.getFields();
        for (i = 0; i < groupingCount; ++i) {
            field = selectHavingResultFields.get(i);
            AggregateIndexMatchCandidate.addCoveringField(builder, field, baseObjectValue, IndexKeyValueToPartialRecord.TupleSource.KEY, i);
        }
        for (i = groupingCount; i < selectHavingResultFields.size(); ++i) {
            field = selectHavingResultFields.get(i);
            AggregateIndexMatchCandidate.addCoveringField(builder, field, baseObjectValue, IndexKeyValueToPartialRecord.TupleSource.VALUE, i - groupingCount);
        }
    }

    private static void addCoveringField(@Nonnull IndexKeyValueToPartialRecord.Builder builder, @Nonnull Type.Record.Field field, @Nonnull Value baseObjectValue, @Nonnull IndexKeyValueToPartialRecord.TupleSource tupleSource, int index) {
        String fieldName = field.getFieldName();
        FieldValue fieldValue = FieldValue.ofFieldName(baseObjectValue, fieldName);
        Optional<NonnullPair<FieldValue, Value>> extractFromIndexEntryPairOptional = fieldValue.extractFromIndexEntryMaybe(baseObjectValue, EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), tupleSource, ImmutableIntArray.of(index));
        Verify.verify(extractFromIndexEntryPairOptional.isPresent());
        NonnullPair<FieldValue, Value> extractFromIndexEntryPair = extractFromIndexEntryPairOptional.get();
        Value extractValue = extractFromIndexEntryPair.getRight();
        if (!builder.hasField(fieldName)) {
            builder.addField(fieldName, extractValue);
        }
    }

    @Nonnull
    private static ScanComparisons toScanComparisons(@Nonnull List<ComparisonRange> comparisonRanges) {
        ScanComparisons.Builder builder = new ScanComparisons.Builder();
        for (ComparisonRange comparisonRange : comparisonRanges) {
            builder.addComparisonRange(comparisonRange);
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public Type getBaseType() {
        return this.baseType;
    }
}

