/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.FindingMatcher;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.MatchPredicate;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.PredicatedMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AliasMap {
    @Nonnull
    private static final AliasMap EMPTY = new AliasMap(ImmutableBiMap.of(), true);
    @Nonnull
    private final ImmutableBiMap<CorrelationIdentifier, CorrelationIdentifier> map;
    private final boolean definesOnlyIdentities;

    private AliasMap(@Nonnull ImmutableBiMap<CorrelationIdentifier, CorrelationIdentifier> map, boolean definesOnlyIdentities) {
        this.definesOnlyIdentities = definesOnlyIdentities;
        this.map = map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasMap aliasMap = (AliasMap)o;
        return Objects.equals(this.map, aliasMap.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public String toString() {
        return this.map.toString();
    }

    public boolean containsSource(@Nullable CorrelationIdentifier alias) {
        return this.map.containsKey(alias);
    }

    public boolean containsTarget(@Nullable CorrelationIdentifier alias) {
        return this.map.containsValue(alias);
    }

    public boolean containsMapping(@Nullable CorrelationIdentifier source, @Nullable CorrelationIdentifier target) {
        return this.containsSource(source) && this.containsTarget(target) && this.getTargetOrThrow(source).equals(target);
    }

    @Nonnull
    public Set<CorrelationIdentifier> sources() {
        return this.map.keySet();
    }

    @Nonnull
    public Set<CorrelationIdentifier> targets() {
        return this.map.values();
    }

    public int size() {
        return this.map.size();
    }

    @Nonnull
    public Builder toBuilder() {
        return AliasMap.builder().putAll(this);
    }

    @Nonnull
    public Builder toBuilder(int expectedAdditionalElements) {
        return AliasMap.builder(expectedAdditionalElements).putAll(this);
    }

    @Nonnull
    public Set<Map.Entry<CorrelationIdentifier, CorrelationIdentifier>> entrySet() {
        return this.map.entrySet();
    }

    @Nullable
    public CorrelationIdentifier getSource(CorrelationIdentifier target) {
        return (CorrelationIdentifier)((ImmutableMap)((Object)this.map.inverse())).get(target);
    }

    @Nonnull
    public AliasMap inverse() {
        return new AliasMap((ImmutableBiMap<CorrelationIdentifier, CorrelationIdentifier>)this.map.inverse(), this.definesOnlyIdentities);
    }

    @Nonnull
    public CorrelationIdentifier getSourceOrDefault(@Nonnull CorrelationIdentifier target, @Nonnull CorrelationIdentifier defaultValue) {
        CorrelationIdentifier source = this.getSource(target);
        if (source == null) {
            return defaultValue;
        }
        return source;
    }

    @Nonnull
    public CorrelationIdentifier getSourceOrThrow(@Nonnull CorrelationIdentifier target) {
        CorrelationIdentifier source = this.getTarget(target);
        return Objects.requireNonNull(source);
    }

    @Nullable
    public CorrelationIdentifier getTarget(CorrelationIdentifier source) {
        return (CorrelationIdentifier)this.map.get(source);
    }

    @Nonnull
    public CorrelationIdentifier getTargetOrDefault(@Nullable CorrelationIdentifier source, @Nonnull CorrelationIdentifier defaultValue) {
        CorrelationIdentifier target = this.getTarget(source);
        if (target == null) {
            return defaultValue;
        }
        return target;
    }

    @Nonnull
    public CorrelationIdentifier getTargetOrThrow(@Nullable CorrelationIdentifier source) {
        CorrelationIdentifier target = this.getTarget(source);
        return Objects.requireNonNull(target);
    }

    public void forEachMapping(@Nonnull BiConsumer<CorrelationIdentifier, CorrelationIdentifier> action) {
        for (CorrelationIdentifier source : this.sources()) {
            action.accept(source, Objects.requireNonNull(this.getTarget(source)));
        }
    }

    @Nonnull
    public AliasMap filterMappings(@Nonnull BiPredicate<CorrelationIdentifier, CorrelationIdentifier> predicate) {
        Builder builder = AliasMap.builder(this.size());
        for (CorrelationIdentifier source : this.sources()) {
            CorrelationIdentifier target;
            if (!predicate.test(source, target = Objects.requireNonNull(this.getTarget(source)))) continue;
            builder.put(source, target);
        }
        return builder.build();
    }

    @Nonnull
    public AliasMap compose(@Nonnull AliasMap other) {
        Builder builder = AliasMap.builder(this.size() + other.size());
        this.map.forEach((source, target) -> builder.put((CorrelationIdentifier)source, other.getTargetOrDefault((CorrelationIdentifier)target, (CorrelationIdentifier)target)));
        other.forEachMapping((source, target) -> {
            if (!this.containsTarget((CorrelationIdentifier)source)) {
                Preconditions.checkArgument(!this.containsSource((CorrelationIdentifier)source), "conflicting mapping");
                builder.put((CorrelationIdentifier)source, (CorrelationIdentifier)target);
            }
        });
        return builder.build();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean isCompatible(@Nonnull AliasMap other) {
        for (CorrelationIdentifier otherSource : other.sources()) {
            CorrelationIdentifier otherTarget = Objects.requireNonNull(other.getTarget(otherSource));
            if (!(this.containsSource(otherSource) ? !otherTarget.equals(this.getTarget(otherSource)) : this.containsTarget(otherTarget))) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public AliasMap combine(@Nonnull AliasMap other) {
        return this.combineMaybe(other).orElseThrow(() -> new IllegalArgumentException("duplicate mapping"));
    }

    @Nonnull
    public Optional<AliasMap> combineMaybe(@Nonnull AliasMap other) {
        Builder builder = AliasMap.builder(this.size() + other.size());
        for (CorrelationIdentifier otherSource : other.sources()) {
            CorrelationIdentifier otherTarget = Objects.requireNonNull(other.getTarget(otherSource));
            if (this.containsSource(otherSource) ? !otherTarget.equals(this.getTarget(otherSource)) : this.containsTarget(otherTarget)) {
                return Optional.empty();
            }
            builder.put(otherSource, otherTarget);
        }
        this.map.forEach(builder::put);
        return Optional.of(builder.build());
    }

    public boolean definesOnlyIdentities() {
        return this.definesOnlyIdentities;
    }

    public Iterable<AliasMap> findCompleteMatches(@Nonnull Set<CorrelationIdentifier> aliases, @Nonnull Function<CorrelationIdentifier, Set<CorrelationIdentifier>> dependsOnFn, @Nonnull Set<CorrelationIdentifier> otherAliases, @Nonnull Function<CorrelationIdentifier, Set<CorrelationIdentifier>> otherDependsOnFn, @Nonnull MatchPredicate<CorrelationIdentifier> matchPredicate) {
        return this.matcher(aliases, dependsOnFn, otherAliases, otherDependsOnFn, matchPredicate).findCompleteMatches();
    }

    public Iterable<AliasMap> findMatches(@Nonnull Set<CorrelationIdentifier> aliases, @Nonnull Function<CorrelationIdentifier, Set<CorrelationIdentifier>> dependsOnFn, @Nonnull Set<CorrelationIdentifier> otherAliases, @Nonnull Function<CorrelationIdentifier, Set<CorrelationIdentifier>> otherDependsOnFn, @Nonnull MatchPredicate<CorrelationIdentifier> matchPredicate) {
        return this.matcher(aliases, dependsOnFn, otherAliases, otherDependsOnFn, matchPredicate).findMatches();
    }

    private PredicatedMatcher matcher(@Nonnull Set<CorrelationIdentifier> aliases, @Nonnull Function<CorrelationIdentifier, Set<CorrelationIdentifier>> dependsOnFn, @Nonnull Set<CorrelationIdentifier> otherAliases, @Nonnull Function<CorrelationIdentifier, Set<CorrelationIdentifier>> otherDependsOnFn, @Nonnull MatchPredicate<CorrelationIdentifier> matchPredicate) {
        return FindingMatcher.onAliases(this, aliases, dependsOnFn, otherAliases, otherDependsOnFn, matchPredicate);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(int expectedSize) {
        return new Builder(expectedSize);
    }

    @Nonnull
    public static AliasMap emptyMap() {
        return EMPTY;
    }

    @Nonnull
    public static AliasMap ofAliases(@Nonnull CorrelationIdentifier source, @Nonnull CorrelationIdentifier target) {
        return new AliasMap(ImmutableBiMap.of(source, target), source.equals(target));
    }

    @Nonnull
    public static AliasMap copyOf(@Nonnull Map<CorrelationIdentifier, CorrelationIdentifier> map) {
        boolean definesOnlyIdentities = map.entrySet().stream().allMatch(entry -> ((CorrelationIdentifier)entry.getKey()).equals(entry.getValue()));
        return new AliasMap(ImmutableBiMap.copyOf(map), definesOnlyIdentities);
    }

    @Nonnull
    public static AliasMap identitiesFor(Set<CorrelationIdentifier> aliases) {
        return AliasMap.builder(aliases.size()).identitiesFor(aliases).build();
    }

    @Nonnull
    public static AliasMap zip(@Nonnull List<CorrelationIdentifier> left, @Nonnull List<CorrelationIdentifier> right) {
        return AliasMap.builder(left.size()).zip(left, right).build();
    }

    public static class Builder {
        private final HashBiMap<CorrelationIdentifier, CorrelationIdentifier> map;

        private Builder() {
            this.map = HashBiMap.create();
        }

        private Builder(int expectedSize) {
            this.map = HashBiMap.create(expectedSize);
        }

        @Nonnull
        public Builder put(@Nonnull CorrelationIdentifier source, @Nonnull CorrelationIdentifier target) {
            this.map.put(source, target);
            return this;
        }

        @Nonnull
        public Builder putAll(@Nonnull AliasMap other) {
            other.sources().forEach(source -> this.put((CorrelationIdentifier)source, Objects.requireNonNull(other.getTarget((CorrelationIdentifier)source))));
            return this;
        }

        @Nonnull
        public Builder identitiesFor(Set<CorrelationIdentifier> aliases) {
            aliases.forEach(id -> this.put((CorrelationIdentifier)id, (CorrelationIdentifier)id));
            return this;
        }

        @Nonnull
        public Builder zip(@Nonnull List<CorrelationIdentifier> left, @Nonnull List<CorrelationIdentifier> right) {
            int size = left.size();
            Verify.verify(size == right.size());
            return this.zip(left, right, size);
        }

        @Nonnull
        public Builder zip(@Nonnull List<CorrelationIdentifier> left, @Nonnull List<CorrelationIdentifier> right, int limitExclusive) {
            for (int i = 0; i < limitExclusive; ++i) {
                CorrelationIdentifier leftId = left.get(i);
                this.put(leftId, right.get(i));
            }
            return this;
        }

        @Nonnull
        public AliasMap build() {
            if (this.map.isEmpty()) {
                return AliasMap.emptyMap();
            }
            return AliasMap.copyOf(this.map);
        }
    }
}

